/*
 * Decompiled with CFR 0.152.
 */
package gregtech.worldgen.center;

import gregapi.block.metatype.BlockMetaType;
import gregapi.code.HashSetNoNulls;
import gregapi.data.CS;
import gregapi.util.UT;
import gregapi.util.WD;
import gregapi.worldgen.WorldgenObject;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class WorldgenStreets
extends WorldgenObject {
    public int mHeight = this.getConfigFile().get((Object)this.mCategory, "Height", (long)this.getConfigFile().get((Object)"worldgenerator.streets", "Height", (long)(WD.waterLevel() + 4)));

    @SafeVarargs
    public WorldgenStreets(String aName, boolean aDefault, List<WorldgenObject> ... aLists) {
        super(aName, CS.ConfigsGT.WORLDGEN.get((Object)"worldgenerator.streets", "Enabled", aDefault), aLists);
        CS.GENERATE_STREETS = this.mEnabled;
    }

    @Override
    public boolean enabled(World aWorld, int aDimType) {
        return CS.GENERATE_STREETS && aWorld.field_73011_w.field_76574_g == 0;
    }

    @Override
    public boolean generate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        if (aMinX == -16 || aMinX == 0) {
            if (aMinZ == -16 || aMinZ == 0) {
                int j;
                for (int i = -32; i < 32; ++i) {
                    for (j = -32; j < 32; ++j) {
                        int k;
                        for (k = 2; k < 64; ++k) {
                            aWorld.func_147465_d(i, this.mHeight + k, j, CS.NB, 0, 0);
                        }
                        for (k = 1; k < this.mHeight; ++k) {
                            aWorld.func_147465_d(i, k, j, (Block)CS.BlocksGT.Concrete, 8, 0);
                        }
                        aWorld.func_147465_d(i, this.mHeight - 1, j, (Block)CS.BlocksGT.Concrete, 8, 0);
                        if (i <= -29 || j <= -29 || i >= 28 || j >= 28) {
                            if (UT.Code.inside(-12L, 11L, i) || UT.Code.inside(-12L, 11L, j)) {
                                aWorld.func_147465_d(i, this.mHeight, j, (Block)CS.BlocksGT.Asphalt, i == -31 || j == -31 || i == 30 || j == 30 ? 15 : 8, 0);
                                aWorld.func_147465_d(i, this.mHeight + 1, j, CS.NB, 0, 0);
                                continue;
                            }
                            aWorld.func_147465_d(i, this.mHeight, j, (Block)CS.BlocksGT.Concrete, 8, 0);
                            if (!(CS.GENERATE_BIOMES || i != -32 && j != -32 && i != 31 && j != 31 || CS.GENERATE_NEXUS && i >= 0 && i != 31 && j == -32 || CS.GENERATE_TESTING && j <= 0 && i == 31 && j != -32)) {
                                aWorld.func_147465_d(i, this.mHeight + 1, j, (Block)(WD.even(i, 1, j) ? CS.BlocksGT.CFoam : CS.BlocksGT.Concrete), 7, 0);
                                aWorld.func_147465_d(i, this.mHeight + 2, j, (Block)(WD.even(i, 2, j) ? CS.BlocksGT.CFoam : CS.BlocksGT.Concrete), 7, 0);
                                aWorld.func_147465_d(i, this.mHeight + 3, j, (Block)(WD.even(i, 3, j) ? CS.BlocksGT.CFoam : CS.BlocksGT.Concrete), 7, 0);
                                aWorld.func_147465_d(i, this.mHeight + 4, j, (Block)(WD.even(i, 4, j) ? CS.BlocksGT.CFoam : CS.BlocksGT.Concrete), 7, 0);
                                aWorld.func_147465_d(i, this.mHeight + 5, j, (Block)(WD.even(i, 5, j) ? CS.BlocksGT.CFoam : CS.BlocksGT.Concrete), 7, 0);
                                continue;
                            }
                            aWorld.func_147465_d(i, this.mHeight + 1, j, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[0], 7, 0);
                            continue;
                        }
                        if (UT.Code.inside(-12L, 11L, i) && UT.Code.inside(-12L, 11L, j)) {
                            aWorld.func_147465_d(i, this.mHeight, j, (Block)CS.BlocksGT.Concrete, 8, 0);
                            aWorld.func_147465_d(i, this.mHeight + 1, j, (Block)(UT.Code.inside(-11L, 10L, i) && UT.Code.inside(-11L, 10L, j) ? CS.BlocksGT.Concrete : CS.BlocksGT.CFoam), 7, 0);
                            continue;
                        }
                        aWorld.func_147465_d(i, this.mHeight, j, (Block)CS.BlocksGT.Asphalt, 8, 0);
                        aWorld.func_147465_d(i, this.mHeight + 1, j, CS.NB, 0, 0);
                    }
                }
                aWorld.func_147465_d(-32, this.mHeight + 1, -1, (Block)CS.BlocksGT.Concrete, 4, 0);
                aWorld.func_147465_d(-31, this.mHeight + 1, -1, (Block)CS.BlocksGT.Concrete, 4, 0);
                aWorld.func_147465_d(-32, this.mHeight + 1, 0, (Block)CS.BlocksGT.Concrete, 4, 0);
                aWorld.func_147465_d(-31, this.mHeight + 1, 0, (Block)CS.BlocksGT.Concrete, 4, 0);
                aWorld.func_147465_d(-32, this.mHeight + 2, -1, (Block)CS.BlocksGT.Concrete, 4, 0);
                aWorld.func_147465_d(-31, this.mHeight + 2, -1, (Block)CS.BlocksGT.Concrete, 4, 0);
                aWorld.func_147465_d(-32, this.mHeight + 2, 0, (Block)CS.BlocksGT.Concrete, 4, 0);
                aWorld.func_147465_d(-31, this.mHeight + 2, 0, (Block)CS.BlocksGT.Concrete, 4, 0);
                aWorld.func_147465_d(-32, this.mHeight + 3, -1, (Block)CS.BlocksGT.Concrete, 4, 0);
                aWorld.func_147465_d(-31, this.mHeight + 3, -1, (Block)CS.BlocksGT.Concrete, 4, 0);
                aWorld.func_147465_d(-32, this.mHeight + 3, 0, (Block)CS.BlocksGT.Concrete, 4, 0);
                aWorld.func_147465_d(-31, this.mHeight + 3, 0, (Block)CS.BlocksGT.Concrete, 4, 0);
                aWorld.func_147465_d(-32, this.mHeight + 4, -1, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[0], 7, 0);
                aWorld.func_147465_d(-31, this.mHeight + 4, -1, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[0], 7, 0);
                aWorld.func_147465_d(-32, this.mHeight + 4, 0, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[0], 7, 0);
                aWorld.func_147465_d(-31, this.mHeight + 4, 0, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[0], 7, 0);
                aWorld.func_147465_d(-32, this.mHeight + 1, -2, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[3], 15, 0);
                aWorld.func_147465_d(-31, this.mHeight + 1, -2, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[3], 1, 0);
                aWorld.func_147465_d(-30, this.mHeight + 1, -1, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[4], 15, 0);
                aWorld.func_147465_d(-30, this.mHeight + 1, 0, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[4], 1, 0);
                aWorld.func_147465_d(-31, this.mHeight + 1, 1, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[2], 15, 0);
                aWorld.func_147465_d(-32, this.mHeight + 1, 1, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[2], 1, 0);
                try {
                    WD.sign(aWorld, -30, this.mHeight + 3, 0, (byte)5, 0L, UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-4096, 95)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-3584, 95)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-3072, 95)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-2560, 95)));
                    WD.sign(aWorld, -30, this.mHeight + 2, 0, (byte)5, 0L, UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-2048, 95)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-1536, 95)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-1024, 95)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-512, 95)));
                    WD.sign(aWorld, -30, this.mHeight + 3, -1, (byte)5, 0L, UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-4096, -96)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-3584, -96)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-3072, -96)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-2560, -96)));
                    WD.sign(aWorld, -30, this.mHeight + 2, -1, (byte)5, 0L, UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-2048, -96)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-1536, -96)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-1024, -96)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-512, -96)));
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
                aWorld.func_147465_d(31, this.mHeight + 1, -1, (Block)CS.BlocksGT.Concrete, 1, 0);
                aWorld.func_147465_d(30, this.mHeight + 1, -1, (Block)CS.BlocksGT.Concrete, 1, 0);
                aWorld.func_147465_d(31, this.mHeight + 1, 0, (Block)CS.BlocksGT.Concrete, 1, 0);
                aWorld.func_147465_d(30, this.mHeight + 1, 0, (Block)CS.BlocksGT.Concrete, 1, 0);
                aWorld.func_147465_d(31, this.mHeight + 2, -1, (Block)CS.BlocksGT.Concrete, 1, 0);
                aWorld.func_147465_d(30, this.mHeight + 2, -1, (Block)CS.BlocksGT.Concrete, 1, 0);
                aWorld.func_147465_d(31, this.mHeight + 2, 0, (Block)CS.BlocksGT.Concrete, 1, 0);
                aWorld.func_147465_d(30, this.mHeight + 2, 0, (Block)CS.BlocksGT.Concrete, 1, 0);
                aWorld.func_147465_d(31, this.mHeight + 3, -1, (Block)CS.BlocksGT.Concrete, 1, 0);
                aWorld.func_147465_d(30, this.mHeight + 3, -1, (Block)CS.BlocksGT.Concrete, 1, 0);
                aWorld.func_147465_d(31, this.mHeight + 3, 0, (Block)CS.BlocksGT.Concrete, 1, 0);
                aWorld.func_147465_d(30, this.mHeight + 3, 0, (Block)CS.BlocksGT.Concrete, 1, 0);
                aWorld.func_147465_d(31, this.mHeight + 4, -1, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[0], 7, 0);
                aWorld.func_147465_d(30, this.mHeight + 4, -1, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[0], 7, 0);
                aWorld.func_147465_d(31, this.mHeight + 4, 0, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[0], 7, 0);
                aWorld.func_147465_d(30, this.mHeight + 4, 0, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[0], 7, 0);
                aWorld.func_147465_d(31, this.mHeight + 1, -2, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[3], 1, 0);
                aWorld.func_147465_d(30, this.mHeight + 1, -2, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[3], 15, 0);
                aWorld.func_147465_d(29, this.mHeight + 1, -1, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[5], 1, 0);
                aWorld.func_147465_d(29, this.mHeight + 1, 0, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[5], 15, 0);
                aWorld.func_147465_d(30, this.mHeight + 1, 1, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[2], 1, 0);
                aWorld.func_147465_d(31, this.mHeight + 1, 1, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[2], 15, 0);
                try {
                    WD.sign(aWorld, 29, this.mHeight + 3, 0, (byte)4, 0L, UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(4095, 95)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(3583, 95)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(3071, 95)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(2559, 95)));
                    WD.sign(aWorld, 29, this.mHeight + 2, 0, (byte)4, 0L, UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(2047, 95)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(1535, 95)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(1023, 95)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(511, 95)));
                    WD.sign(aWorld, 29, this.mHeight + 3, -1, (byte)4, 0L, UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(4095, -96)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(3583, -96)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(3071, -96)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(2559, -96)));
                    WD.sign(aWorld, 29, this.mHeight + 2, -1, (byte)4, 0L, UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(2047, -96)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(1535, -96)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(1023, -96)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(511, -96)));
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
                aWorld.func_147465_d(-1, this.mHeight + 1, -32, (Block)CS.BlocksGT.Concrete, 11, 0);
                aWorld.func_147465_d(-1, this.mHeight + 1, -31, (Block)CS.BlocksGT.Concrete, 11, 0);
                aWorld.func_147465_d(0, this.mHeight + 1, -32, (Block)CS.BlocksGT.Concrete, 11, 0);
                aWorld.func_147465_d(0, this.mHeight + 1, -31, (Block)CS.BlocksGT.Concrete, 11, 0);
                aWorld.func_147465_d(-1, this.mHeight + 2, -32, (Block)CS.BlocksGT.Concrete, 11, 0);
                aWorld.func_147465_d(-1, this.mHeight + 2, -31, (Block)CS.BlocksGT.Concrete, 11, 0);
                aWorld.func_147465_d(0, this.mHeight + 2, -32, (Block)CS.BlocksGT.Concrete, 11, 0);
                aWorld.func_147465_d(0, this.mHeight + 2, -31, (Block)CS.BlocksGT.Concrete, 11, 0);
                aWorld.func_147465_d(-1, this.mHeight + 3, -32, (Block)CS.BlocksGT.Concrete, 11, 0);
                aWorld.func_147465_d(-1, this.mHeight + 3, -31, (Block)CS.BlocksGT.Concrete, 11, 0);
                aWorld.func_147465_d(0, this.mHeight + 3, -32, (Block)CS.BlocksGT.Concrete, 11, 0);
                aWorld.func_147465_d(0, this.mHeight + 3, -31, (Block)CS.BlocksGT.Concrete, 11, 0);
                aWorld.func_147465_d(-1, this.mHeight + 4, -32, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[0], 7, 0);
                aWorld.func_147465_d(-1, this.mHeight + 4, -31, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[0], 7, 0);
                aWorld.func_147465_d(0, this.mHeight + 4, -32, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[0], 7, 0);
                aWorld.func_147465_d(0, this.mHeight + 4, -31, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[0], 7, 0);
                aWorld.func_147465_d(-2, this.mHeight + 1, -32, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[5], 15, 0);
                aWorld.func_147465_d(-2, this.mHeight + 1, -31, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[5], 1, 0);
                aWorld.func_147465_d(-1, this.mHeight + 1, -30, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[2], 15, 0);
                aWorld.func_147465_d(0, this.mHeight + 1, -30, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[2], 1, 0);
                aWorld.func_147465_d(1, this.mHeight + 1, -31, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[4], 15, 0);
                aWorld.func_147465_d(1, this.mHeight + 1, -32, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[4], 1, 0);
                try {
                    WD.sign(aWorld, 0, this.mHeight + 3, -30, (byte)3, 0L, UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(95, -4096)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(95, -3584)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(95, -3072)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(95, -2560)));
                    WD.sign(aWorld, 0, this.mHeight + 2, -30, (byte)3, 0L, UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(95, -2048)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(95, -1536)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(95, -1024)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(95, -512)));
                    WD.sign(aWorld, -1, this.mHeight + 3, -30, (byte)3, 0L, UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-96, -4096)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-96, -3584)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-96, -3072)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-96, -2560)));
                    WD.sign(aWorld, -1, this.mHeight + 2, -30, (byte)3, 0L, UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-96, -2048)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-96, -1536)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-96, -1024)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-96, -512)));
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
                aWorld.func_147465_d(-1, this.mHeight + 1, 31, (Block)CS.BlocksGT.Concrete, 2, 0);
                aWorld.func_147465_d(-1, this.mHeight + 1, 30, (Block)CS.BlocksGT.Concrete, 2, 0);
                aWorld.func_147465_d(0, this.mHeight + 1, 31, (Block)CS.BlocksGT.Concrete, 2, 0);
                aWorld.func_147465_d(0, this.mHeight + 1, 30, (Block)CS.BlocksGT.Concrete, 2, 0);
                aWorld.func_147465_d(-1, this.mHeight + 2, 31, (Block)CS.BlocksGT.Concrete, 2, 0);
                aWorld.func_147465_d(-1, this.mHeight + 2, 30, (Block)CS.BlocksGT.Concrete, 2, 0);
                aWorld.func_147465_d(0, this.mHeight + 2, 31, (Block)CS.BlocksGT.Concrete, 2, 0);
                aWorld.func_147465_d(0, this.mHeight + 2, 30, (Block)CS.BlocksGT.Concrete, 2, 0);
                aWorld.func_147465_d(-1, this.mHeight + 3, 31, (Block)CS.BlocksGT.Concrete, 2, 0);
                aWorld.func_147465_d(-1, this.mHeight + 3, 30, (Block)CS.BlocksGT.Concrete, 2, 0);
                aWorld.func_147465_d(0, this.mHeight + 3, 31, (Block)CS.BlocksGT.Concrete, 2, 0);
                aWorld.func_147465_d(0, this.mHeight + 3, 30, (Block)CS.BlocksGT.Concrete, 2, 0);
                aWorld.func_147465_d(-1, this.mHeight + 4, 31, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[0], 7, 0);
                aWorld.func_147465_d(-1, this.mHeight + 4, 30, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[0], 7, 0);
                aWorld.func_147465_d(0, this.mHeight + 4, 31, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[0], 7, 0);
                aWorld.func_147465_d(0, this.mHeight + 4, 30, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[0], 7, 0);
                aWorld.func_147465_d(-2, this.mHeight + 1, 31, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[5], 1, 0);
                aWorld.func_147465_d(-2, this.mHeight + 1, 30, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[5], 15, 0);
                aWorld.func_147465_d(-1, this.mHeight + 1, 29, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[3], 1, 0);
                aWorld.func_147465_d(0, this.mHeight + 1, 29, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[3], 15, 0);
                aWorld.func_147465_d(1, this.mHeight + 1, 30, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[4], 1, 0);
                aWorld.func_147465_d(1, this.mHeight + 1, 31, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[4], 15, 0);
                try {
                    WD.sign(aWorld, 0, this.mHeight + 3, 29, (byte)2, 0L, UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(95, 4095)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(95, 3583)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(95, 3071)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(95, 2559)));
                    WD.sign(aWorld, 0, this.mHeight + 2, 29, (byte)2, 0L, UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(95, 2047)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(95, 1535)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(95, 1023)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(95, 511)));
                    WD.sign(aWorld, -1, this.mHeight + 3, 29, (byte)2, 0L, UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-96, 4095)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-96, 3583)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-96, 3071)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-96, 2559)));
                    WD.sign(aWorld, -1, this.mHeight + 2, 29, (byte)2, 0L, UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-96, 2047)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-96, 1535)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-96, 1023)), UT.Code.stringValidate(aWorld.field_73011_w.field_76578_c.func_76935_a(-96, 511)));
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
                if (CS.GENERATE_BEACON) {
                    int i;
                    for (i = -5; i < 5; ++i) {
                        for (j = -5; j < 5; ++j) {
                            WD.set(aWorld, i, this.mHeight - 3, j, Blocks.field_150339_S, 0L, 0L);
                        }
                    }
                    for (i = -4; i < 4; ++i) {
                        for (j = -4; j < 4; ++j) {
                            WD.set(aWorld, i, this.mHeight - 2, j, Blocks.field_150339_S, 0L, 0L);
                        }
                    }
                    for (i = -3; i < 3; ++i) {
                        for (j = -3; j < 3; ++j) {
                            WD.set(aWorld, i, this.mHeight - 1, j, Blocks.field_150339_S, 0L, 0L);
                        }
                    }
                    for (i = -2; i < 2; ++i) {
                        for (j = -2; j < 2; ++j) {
                            WD.set(aWorld, i, this.mHeight, j, Blocks.field_150339_S, 0L, 0L);
                        }
                    }
                    WD.set(aWorld, -1, this.mHeight + 1, -1, (Block)Blocks.field_150461_bJ, 0L, 3L);
                    TileEntity tTileEntity = WD.te(aWorld, -1, this.mHeight + 1, -1, true);
                    if (tTileEntity instanceof TileEntityBeacon) {
                        NBTTagCompound tNBT = UT.NBT.make();
                        tTileEntity.func_145841_b(tNBT);
                        tNBT.func_74768_a("Primary", Potion.field_76424_c.field_76415_H);
                        tNBT.func_74768_a("Secondary", Potion.field_76424_c.field_76415_H);
                        tNBT.func_74768_a("Levels", 4);
                        tTileEntity.func_145839_a(tNBT);
                    }
                    WD.set(aWorld, -1, this.mHeight + 1, 0, (Block)Blocks.field_150461_bJ, 0L, 3L);
                    tTileEntity = WD.te(aWorld, -1, this.mHeight + 1, 0, true);
                    if (tTileEntity instanceof TileEntityBeacon) {
                        NBTTagCompound tNBT = UT.NBT.make();
                        tTileEntity.func_145841_b(tNBT);
                        tNBT.func_74768_a("Primary", Potion.field_76422_e.field_76415_H);
                        tNBT.func_74768_a("Secondary", Potion.field_76422_e.field_76415_H);
                        tNBT.func_74768_a("Levels", 4);
                        tTileEntity.func_145839_a(tNBT);
                    }
                    WD.set(aWorld, 0, this.mHeight + 1, -1, (Block)Blocks.field_150461_bJ, 0L, 3L);
                    tTileEntity = WD.te(aWorld, 0, this.mHeight + 1, -1, true);
                    if (tTileEntity instanceof TileEntityBeacon) {
                        NBTTagCompound tNBT = UT.NBT.make();
                        tTileEntity.func_145841_b(tNBT);
                        tNBT.func_74768_a("Primary", Potion.field_76420_g.field_76415_H);
                        tNBT.func_74768_a("Secondary", Potion.field_76420_g.field_76415_H);
                        tNBT.func_74768_a("Levels", 4);
                        tTileEntity.func_145839_a(tNBT);
                    }
                    WD.set(aWorld, 0, this.mHeight + 1, 0, (Block)Blocks.field_150461_bJ, 0L, 3L);
                    tTileEntity = WD.te(aWorld, 0, this.mHeight + 1, 0, true);
                    if (tTileEntity instanceof TileEntityBeacon) {
                        NBTTagCompound tNBT = UT.NBT.make();
                        tTileEntity.func_145841_b(tNBT);
                        tNBT.func_74768_a("Primary", Potion.field_76429_m.field_76415_H);
                        tNBT.func_74768_a("Secondary", Potion.field_76428_l.field_76415_H);
                        tNBT.func_74768_a("Levels", 4);
                        tTileEntity.func_145839_a(tNBT);
                    }
                }
                aWorld.func_72950_A(0, this.mHeight + 5, 0);
                return true;
            }
            if (aMinZ < -96 || aMinZ > 80) {
                aWorld.func_147465_d(aMinX - 32, 255, aMinZ - 32, CS.NB, 0, 0);
                aWorld.func_147465_d(aMinX - 32, 255, aMinZ + 32, CS.NB, 0, 0);
                aWorld.func_147465_d(aMinX + 32, 255, aMinZ - 32, CS.NB, 0, 0);
                aWorld.func_147465_d(aMinX + 32, 255, aMinZ + 32, CS.NB, 0, 0);
                int tOpaqueCount = 0;
                for (int i = -16; i < 16; ++i) {
                    for (int j = 0; j < 16; ++j) {
                        Block tBlock = aWorld.func_147439_a(i, this.mHeight + 9, aMinZ + j);
                        if (!tBlock.func_149688_o().func_76224_d() && !WD.anywater(tBlock) && (!WD.opq(tBlock) || tBlock.func_149688_o() == Material.field_151575_d || tBlock.isWood((IBlockAccess)aWorld, i, this.mHeight + 9, aMinZ + j) || tBlock.isLeaves((IBlockAccess)aWorld, i, this.mHeight + 9, aMinZ + j)) || tOpaqueCount++ <= 128) continue;
                        return this.generateRoadX(aWorld, aMinZ, false, false, true, false, false);
                    }
                }
                aBiomeNames = new HashSetNoNulls<String>(aBiomeNames);
                for (int i = aMinZ; i <= aMaxZ; ++i) {
                    int k;
                    int n = k = aMinZ < 0 ? 16 : 0;
                    for (int j = aMinZ < 0 ? 0 : -16; j < k; ++j) {
                        BiomeGenBase tBiome = aWorld.func_72807_a(j, i);
                        if (tBiome == null) continue;
                        aBiomeNames.add(tBiome.field_76791_y);
                    }
                }
                for (String tName : aBiomeNames) {
                    if (!CS.BIOMES_INFINITE_WATER.contains(tName)) continue;
                    return this.generateRoadX(aWorld, aMinZ, false, true, false, true, true);
                }
                return this.generateRoadX(aWorld, aMinZ, true, true, false, false, true);
            }
            return aMinZ != -32 && aMinZ != 16 && this.generateRoadX(aWorld, aMinZ, false, false, false, true, !CS.GENERATE_BIOMES);
        }
        if (aMinZ == -16 || aMinZ == 0) {
            if (aMinX < -96 || aMinX > 80) {
                aWorld.func_147465_d(aMinX - 32, 255, aMinZ - 32, CS.NB, 0, 0);
                aWorld.func_147465_d(aMinX - 32, 255, aMinZ + 32, CS.NB, 0, 0);
                aWorld.func_147465_d(aMinX + 32, 255, aMinZ - 32, CS.NB, 0, 0);
                aWorld.func_147465_d(aMinX + 32, 255, aMinZ + 32, CS.NB, 0, 0);
                int tOpaqueCount = 0;
                for (int i = -16; i < 16; ++i) {
                    for (int j = 0; j < 16; ++j) {
                        Block tBlock = aWorld.func_147439_a(aMinX + j, this.mHeight + 9, i);
                        if (!tBlock.func_149688_o().func_76224_d() && !WD.anywater(tBlock) && (!WD.opq(tBlock) || tBlock.func_149688_o() == Material.field_151575_d || tBlock.isWood((IBlockAccess)aWorld, aMinX + j, this.mHeight + 9, i) || tBlock.isLeaves((IBlockAccess)aWorld, aMinX + j, this.mHeight + 9, i)) || tOpaqueCount++ <= 128) continue;
                        return this.generateRoadZ(aWorld, aMinX, false, false, true, false, false);
                    }
                }
                aBiomeNames = new HashSetNoNulls<String>(aBiomeNames);
                for (int i = aMinX; i <= aMaxX; ++i) {
                    int k;
                    int n = k = aMinZ < 0 ? 16 : 0;
                    for (int j = aMinZ < 0 ? 0 : -16; j < k; ++j) {
                        BiomeGenBase tBiome = aWorld.func_72807_a(i, j);
                        if (tBiome == null) continue;
                        aBiomeNames.add(tBiome.field_76791_y);
                    }
                }
                for (String tName : aBiomeNames) {
                    if (!CS.BIOMES_INFINITE_WATER.contains(tName)) continue;
                    return this.generateRoadZ(aWorld, aMinX, false, true, false, true, true);
                }
                return this.generateRoadZ(aWorld, aMinX, true, true, false, false, true);
            }
            return aMinX != -32 && aMinX != 16 && this.generateRoadZ(aWorld, aMinX, false, false, false, true, !CS.GENERATE_BIOMES);
        }
        return false;
    }

    public final boolean generateRoadX(World aWorld, int aMinZ, boolean aLand, boolean aKillSky, boolean aTunnel, boolean aBridge, boolean aSideWalls) {
        int j;
        int i;
        for (i = 0; i < 16; ++i) {
            int k;
            int j2;
            if (aLand) {
                for (j2 = this.mHeight + 1; j2 > 0 && !WD.opq(aWorld, -13, j2, aMinZ + i, true, true); --j2) {
                    WD.set(aWorld, -13, j2, aMinZ + i, Blocks.field_150351_n, 1L, 0L, true);
                }
                for (j2 = this.mHeight + 1; j2 > 0 && !WD.opq(aWorld, 12, j2, aMinZ + i, true, true); --j2) {
                    WD.set(aWorld, 12, j2, aMinZ + i, Blocks.field_150351_n, 1L, 0L, true);
                }
                for (j2 = this.mHeight; j2 > 0 && !WD.opq(aWorld, -14, j2, aMinZ + i, true, true); --j2) {
                    WD.set(aWorld, -14, j2, aMinZ + i, Blocks.field_150351_n, 1L, 0L, true);
                }
                for (j2 = this.mHeight; j2 > 0 && !WD.opq(aWorld, 13, j2, aMinZ + i, true, true); --j2) {
                    WD.set(aWorld, 13, j2, aMinZ + i, Blocks.field_150351_n, 1L, 0L, true);
                }
                for (j2 = this.mHeight - 1; j2 > 0 && !WD.opq(aWorld, -15, j2, aMinZ + i, true, true); --j2) {
                    WD.set(aWorld, -15, j2, aMinZ + i, Blocks.field_150351_n, 1L, 0L, true);
                }
                for (j2 = this.mHeight - 1; j2 > 0 && !WD.opq(aWorld, 14, j2, aMinZ + i, true, true); --j2) {
                    WD.set(aWorld, 14, j2, aMinZ + i, Blocks.field_150351_n, 1L, 0L, true);
                }
                for (j2 = this.mHeight - 2; j2 > 0 && !WD.opq(aWorld, -16, j2, aMinZ + i, true, true); --j2) {
                    WD.set(aWorld, -16, j2, aMinZ + i, Blocks.field_150351_n, 1L, 0L, true);
                }
                for (j2 = this.mHeight - 2; j2 > 0 && !WD.opq(aWorld, 15, j2, aMinZ + i, true, true); --j2) {
                    WD.set(aWorld, 15, j2, aMinZ + i, Blocks.field_150351_n, 1L, 0L, true);
                }
            }
            if (aTunnel) {
                for (j2 = -12; j2 < 12; ++j2) {
                    aWorld.func_147465_d(j2, this.mHeight + 7, aMinZ + i, (Block)CS.BlocksGT.Concrete, 15, 0);
                }
                for (j2 = 0; j2 < 7; ++j2) {
                    aWorld.func_147465_d(-13, this.mHeight + j2, aMinZ + i, (Block)CS.BlocksGT.Concrete, j2 == 3 ? 7 : 15, 0);
                    aWorld.func_147465_d(12, this.mHeight + j2, aMinZ + i, (Block)CS.BlocksGT.Concrete, j2 == 3 ? 7 : 15, 0);
                }
            }
            if (aBridge) {
                WD.set(aWorld, -13, this.mHeight, aMinZ + i, CS.BlocksGT.Concrete, 8L, 0L, true);
                WD.set(aWorld, 12, this.mHeight, aMinZ + i, CS.BlocksGT.Concrete, 8L, 0L, true);
                aWorld.func_147465_d(-13, this.mHeight + 1, aMinZ + i, (Block)CS.BlocksGT.Concrete, 8, 0);
                aWorld.func_147465_d(12, this.mHeight + 1, aMinZ + i, (Block)CS.BlocksGT.Concrete, 8, 0);
            }
            if (aKillSky) {
                for (j2 = -13; j2 < 13; ++j2) {
                    for (k = 2; k < 64; ++k) {
                        aWorld.func_147465_d(j2, this.mHeight + k, aMinZ + i, CS.NB, 0, 0);
                    }
                }
            } else {
                for (j2 = -12; j2 < 12; ++j2) {
                    for (k = 2; k < 7; ++k) {
                        aWorld.func_147465_d(j2, this.mHeight + k, aMinZ + i, CS.NB, 0, 0);
                    }
                }
            }
            for (j2 = -12; j2 < 2; ++j2) {
                aWorld.func_147465_d(j2, this.mHeight + 1, aMinZ + i, CS.NB, 0, 0);
                if (aLand) {
                    WD.set(aWorld, j2, this.mHeight - 2, aMinZ + i, Blocks.field_150347_e, 0L, 0L, true);
                    aWorld.func_147465_d(j2, this.mHeight - 1, aMinZ + i, Blocks.field_150351_n, 1, 0);
                    for (k = this.mHeight - 3; k > 0 && !WD.opq(aWorld, j2, k, aMinZ + i, true, true); --k) {
                        WD.set(aWorld, j2, k, aMinZ + i, Blocks.field_150347_e, 0L, 0L, true);
                    }
                    continue;
                }
                WD.set(aWorld, j2, this.mHeight - 1, aMinZ + i, CS.BlocksGT.Concrete, 8L, 0L, true);
            }
            for (j2 = 1; j2 < 12; ++j2) {
                aWorld.func_147465_d(j2, this.mHeight + 1, aMinZ + i, CS.NB, 0, 0);
                if (aLand) {
                    WD.set(aWorld, j2, this.mHeight - 2, aMinZ + i, Blocks.field_150347_e, 0L, 0L, true);
                    aWorld.func_147465_d(j2, this.mHeight - 1, aMinZ + i, Blocks.field_150351_n, 1, 0);
                    for (k = this.mHeight - 3; k > 0 && !WD.opq(aWorld, j2, k, aMinZ + i, true, true); --k) {
                        WD.set(aWorld, j2, k, aMinZ + i, Blocks.field_150347_e, 0L, 0L, true);
                    }
                    continue;
                }
                WD.set(aWorld, j2, this.mHeight - 1, aMinZ + i, CS.BlocksGT.Concrete, 8L, 0L, true);
            }
            aWorld.func_147465_d(-12, this.mHeight, aMinZ + i, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(-12, this.mHeight + 1, aMinZ + i, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[4], 7, 0);
            aWorld.func_147465_d(-11, this.mHeight, aMinZ + i, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(-11, this.mHeight + 1, aMinZ + i, (Block)CS.BlocksGT.RailRoad, 0, 0);
            aWorld.func_147465_d(-10, this.mHeight, aMinZ + i, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(-9, this.mHeight, aMinZ + i, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(-8, this.mHeight, aMinZ + i, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(-7, this.mHeight, aMinZ + i, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(-7, this.mHeight + 1, aMinZ + i, (Block)CS.BlocksGT.RailRoad, (i + 2) / 4 % 2 == 0 ? 8 : 0, 0);
            aWorld.func_147465_d(-6, this.mHeight, aMinZ + i, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(-5, this.mHeight, aMinZ + i, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(-4, this.mHeight, aMinZ + i, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(-3, this.mHeight, aMinZ + i, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(-3, this.mHeight + 1, aMinZ + i, (Block)CS.BlocksGT.RailRoad, 0, 0);
            aWorld.func_147465_d(-2, this.mHeight, aMinZ + i, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(-2, this.mHeight + 1, aMinZ + i, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[5], 7, 0);
            if (aLand) {
                WD.set(aWorld, -1, this.mHeight - 1, aMinZ + i, Blocks.field_150347_e, 0L, 0L, true);
                WD.set(aWorld, -1, this.mHeight, aMinZ + i, Blocks.field_150351_n, 1L, 0L, false);
                WD.set(aWorld, -1, this.mHeight + 1, aMinZ + i, Blocks.field_150351_n, 1L, 0L, false);
                WD.set(aWorld, 0, this.mHeight - 1, aMinZ + i, Blocks.field_150347_e, 0L, 0L, true);
                WD.set(aWorld, 0, this.mHeight, aMinZ + i, Blocks.field_150351_n, 1L, 0L, false);
                WD.set(aWorld, 0, this.mHeight + 1, aMinZ + i, Blocks.field_150351_n, 1L, 0L, false);
                for (j2 = this.mHeight - 2; j2 > 0 && !WD.opq(aWorld, -1, j2, aMinZ + i, true, true); --j2) {
                    WD.set(aWorld, -1, j2, aMinZ + i, Blocks.field_150347_e, 0L, 0L, true);
                }
                for (j2 = this.mHeight - 2; j2 > 0 && !WD.opq(aWorld, 0, j2, aMinZ + i, true, true); --j2) {
                    WD.set(aWorld, 0, j2, aMinZ + i, Blocks.field_150347_e, 0L, 0L, true);
                }
            } else {
                WD.set(aWorld, -1, this.mHeight - 1, aMinZ + i, CS.BlocksGT.Concrete, 8L, 0L, true);
                WD.set(aWorld, -1, this.mHeight, aMinZ + i, CS.BlocksGT.Concrete, 8L, 0L, false);
                WD.set(aWorld, -1, this.mHeight + 1, aMinZ + i, CS.BlocksGT.Concrete, 8L, 0L, false);
                WD.set(aWorld, 0, this.mHeight - 1, aMinZ + i, CS.BlocksGT.Concrete, 8L, 0L, true);
                WD.set(aWorld, 0, this.mHeight, aMinZ + i, CS.BlocksGT.Concrete, 8L, 0L, false);
                WD.set(aWorld, 0, this.mHeight + 1, aMinZ + i, CS.BlocksGT.Concrete, 8L, 0L, false);
            }
            aWorld.func_147465_d(1, this.mHeight, aMinZ + i, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(1, this.mHeight + 1, aMinZ + i, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[4], 7, 0);
            aWorld.func_147465_d(2, this.mHeight, aMinZ + i, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(2, this.mHeight + 1, aMinZ + i, (Block)CS.BlocksGT.RailRoad, 0, 0);
            aWorld.func_147465_d(3, this.mHeight, aMinZ + i, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(4, this.mHeight, aMinZ + i, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(5, this.mHeight, aMinZ + i, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(6, this.mHeight, aMinZ + i, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(6, this.mHeight + 1, aMinZ + i, (Block)CS.BlocksGT.RailRoad, (i + 2) / 4 % 2 == 0 ? 8 : 0, 0);
            aWorld.func_147465_d(7, this.mHeight, aMinZ + i, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(8, this.mHeight, aMinZ + i, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(9, this.mHeight, aMinZ + i, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(10, this.mHeight, aMinZ + i, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(10, this.mHeight + 1, aMinZ + i, (Block)CS.BlocksGT.RailRoad, 0, 0);
            aWorld.func_147465_d(11, this.mHeight, aMinZ + i, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(11, this.mHeight + 1, aMinZ + i, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[5], 7, 0);
        }
        if (aTunnel) {
            aWorld.func_147465_d(-13, this.mHeight + 3, aMinZ + 1, Blocks.field_150426_aN, 0, 0);
            aWorld.func_147465_d(12, this.mHeight + 3, aMinZ + 1, Blocks.field_150426_aN, 0, 0);
            aWorld.func_147465_d(-13, this.mHeight + 3, aMinZ + 6, Blocks.field_150426_aN, 0, 0);
            aWorld.func_147465_d(12, this.mHeight + 3, aMinZ + 6, Blocks.field_150426_aN, 0, 0);
            aWorld.func_147465_d(-13, this.mHeight + 3, aMinZ + 9, Blocks.field_150426_aN, 0, 0);
            aWorld.func_147465_d(12, this.mHeight + 3, aMinZ + 9, Blocks.field_150426_aN, 0, 0);
            aWorld.func_147465_d(-13, this.mHeight + 3, aMinZ + 14, Blocks.field_150426_aN, 0, 0);
            aWorld.func_147465_d(12, this.mHeight + 3, aMinZ + 14, Blocks.field_150426_aN, 0, 0);
        }
        if (aSideWalls) {
            int k;
            for (i = 0; i < 8; ++i) {
                Block tBlock = WD.block(aWorld, 13, this.mHeight + 4, aMinZ + i, true);
                if (!tBlock.func_149688_o().func_76224_d() && !WD.opq(tBlock)) continue;
                for (j = 0; j < 8; ++j) {
                    for (k = 2; k < 6; ++k) {
                        WD.set(aWorld, 12, this.mHeight + k, aMinZ + j, WD.even(0, k, j) ? CS.BlocksGT.CFoam : CS.BlocksGT.Concrete, 7L, 0L, true);
                    }
                }
                break;
            }
            for (i = 0; i < 8; ++i) {
                Block tBlock = WD.block(aWorld, -14, this.mHeight + 4, aMinZ + i, true);
                if (!tBlock.func_149688_o().func_76224_d() && !WD.opq(tBlock)) continue;
                for (j = 0; j < 8; ++j) {
                    for (k = 2; k < 6; ++k) {
                        WD.set(aWorld, -13, this.mHeight + k, aMinZ + j, WD.even(1, k, j) ? CS.BlocksGT.CFoam : CS.BlocksGT.Concrete, 7L, 0L, true);
                    }
                }
                break;
            }
            for (i = 8; i < 16; ++i) {
                Block tBlock = WD.block(aWorld, 13, this.mHeight + 4, aMinZ + i, true);
                if (!tBlock.func_149688_o().func_76224_d() && !WD.opq(tBlock)) continue;
                for (j = 8; j < 16; ++j) {
                    for (k = 2; k < 6; ++k) {
                        WD.set(aWorld, 12, this.mHeight + k, aMinZ + j, WD.even(0, k, j) ? CS.BlocksGT.CFoam : CS.BlocksGT.Concrete, 7L, 0L, true);
                    }
                }
                break;
            }
            for (i = 8; i < 16; ++i) {
                Block tBlock = WD.block(aWorld, -14, this.mHeight + 4, aMinZ + i, true);
                if (!tBlock.func_149688_o().func_76224_d() && !WD.opq(tBlock)) continue;
                for (j = 8; j < 16; ++j) {
                    for (k = 2; k < 6; ++k) {
                        WD.set(aWorld, -13, this.mHeight + k, aMinZ + j, WD.even(1, k, j) ? CS.BlocksGT.CFoam : CS.BlocksGT.Concrete, 7L, 0L, true);
                    }
                }
                break;
            }
        }
        if (aMinZ >> 9 != aMinZ - 16 >> 9) {
            for (i = 5; i < 11; ++i) {
                for (int j3 = 1; j3 < 6; ++j3) {
                    WD.set(aWorld, -13, this.mHeight + j3, aMinZ + i, CS.BlocksGT.Concrete, i == 5 || i == 10 || j3 == 1 || j3 == 5 ? (aTunnel ? 0L : 15L) : (aMinZ < 0 ? 11L : 2L), 0L, j3 == 1);
                    WD.set(aWorld, 12, this.mHeight + j3, aMinZ + i, CS.BlocksGT.Concrete, i == 5 || i == 10 || j3 == 1 || j3 == 5 ? (aTunnel ? 0L : 15L) : (aMinZ < 0 ? 11L : 2L), 0L, j3 == 1);
                }
            }
            WD.sign(aWorld, -12, this.mHeight + 3, aMinZ + 7, (byte)5, 0L, "", "X: -1", "Z: " + (aMinZ - 16 >> 9), "");
            WD.sign(aWorld, -12, this.mHeight + 3, aMinZ + 8, (byte)5, 0L, "", "X: -1", "Z: " + (aMinZ >> 9), "");
            WD.sign(aWorld, 11, this.mHeight + 3, aMinZ + 7, (byte)4, 0L, "", "X: 0", "Z: " + (aMinZ - 16 >> 9), "");
            WD.sign(aWorld, 11, this.mHeight + 3, aMinZ + 8, (byte)4, 0L, "", "X: 0", "Z: " + (aMinZ >> 9), "");
            aWorld.func_147465_d(-13, this.mHeight + 1, aMinZ + 5, Blocks.field_150426_aN, 0, 0);
            aWorld.func_147465_d(-13, this.mHeight + 1, aMinZ + 10, Blocks.field_150426_aN, 0, 0);
            aWorld.func_147465_d(-13, this.mHeight + 5, aMinZ + 5, Blocks.field_150426_aN, 0, 0);
            aWorld.func_147465_d(-13, this.mHeight + 5, aMinZ + 10, Blocks.field_150426_aN, 0, 0);
            aWorld.func_147465_d(12, this.mHeight + 1, aMinZ + 5, Blocks.field_150426_aN, 0, 0);
            aWorld.func_147465_d(12, this.mHeight + 1, aMinZ + 10, Blocks.field_150426_aN, 0, 0);
            aWorld.func_147465_d(12, this.mHeight + 5, aMinZ + 5, Blocks.field_150426_aN, 0, 0);
            aWorld.func_147465_d(12, this.mHeight + 5, aMinZ + 10, Blocks.field_150426_aN, 0, 0);
        }
        if (aMinZ >> 9 != aMinZ + 16 >> 9) {
            aWorld.func_147465_d(-2, this.mHeight + 1, aMinZ + 0, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[5], 15, 0);
            aWorld.func_147465_d(-2, this.mHeight + 1, aMinZ + 1, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[5], 1, 0);
            aWorld.func_147465_d(-2, this.mHeight + 1, aMinZ + 2, CS.NB, 0, 0);
            aWorld.func_147465_d(-1, this.mHeight + 1, aMinZ + 2, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[2], 15, 0);
            aWorld.func_147465_d(0, this.mHeight + 1, aMinZ + 2, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[2], 1, 0);
            aWorld.func_147465_d(1, this.mHeight + 1, aMinZ + 2, CS.NB, 0, 0);
            aWorld.func_147465_d(1, this.mHeight + 1, aMinZ + 1, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[4], 15, 0);
            aWorld.func_147465_d(1, this.mHeight + 1, aMinZ + 0, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[4], 1, 0);
            for (i = 2; i < 14; ++i) {
                aWorld.func_147465_d(-1, this.mHeight, aMinZ + i, (Block)CS.BlocksGT.Asphalt, 8, 0);
                aWorld.func_147465_d(0, this.mHeight, aMinZ + i, (Block)CS.BlocksGT.Asphalt, 8, 0);
            }
            for (i = 3; i < 13; ++i) {
                aWorld.func_147465_d(-2, this.mHeight + 1, aMinZ + i, CS.NB, 0, 0);
                aWorld.func_147465_d(-1, this.mHeight + 1, aMinZ + i, CS.NB, 0, 0);
                aWorld.func_147465_d(0, this.mHeight + 1, aMinZ + i, CS.NB, 0, 0);
                aWorld.func_147465_d(1, this.mHeight + 1, aMinZ + i, CS.NB, 0, 0);
            }
            aWorld.func_147465_d(-2, this.mHeight + 1, aMinZ + 15, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[5], 1, 0);
            aWorld.func_147465_d(-2, this.mHeight + 1, aMinZ + 14, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[5], 15, 0);
            aWorld.func_147465_d(-2, this.mHeight + 1, aMinZ + 13, CS.NB, 0, 0);
            aWorld.func_147465_d(-1, this.mHeight + 1, aMinZ + 13, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[3], 1, 0);
            aWorld.func_147465_d(0, this.mHeight + 1, aMinZ + 13, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[3], 15, 0);
            aWorld.func_147465_d(1, this.mHeight + 1, aMinZ + 13, CS.NB, 0, 0);
            aWorld.func_147465_d(1, this.mHeight + 1, aMinZ + 14, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[4], 1, 0);
            aWorld.func_147465_d(1, this.mHeight + 1, aMinZ + 15, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[4], 15, 0);
            if (aTunnel) {
                for (i = 0; i < 7; ++i) {
                    aWorld.func_147465_d(-1, this.mHeight + i, aMinZ + 0, (Block)CS.BlocksGT.Concrete, i == 3 ? 7 : 15, 0);
                    aWorld.func_147465_d(-1, this.mHeight + i, aMinZ + 1, (Block)CS.BlocksGT.Concrete, i == 3 ? 7 : 15, 0);
                    aWorld.func_147465_d(0, this.mHeight + i, aMinZ + 0, (Block)CS.BlocksGT.Concrete, i == 3 ? 7 : 15, 0);
                    aWorld.func_147465_d(0, this.mHeight + i, aMinZ + 1, (Block)CS.BlocksGT.Concrete, i == 3 ? 7 : 15, 0);
                    aWorld.func_147465_d(-1, this.mHeight + i, aMinZ + 14, (Block)CS.BlocksGT.Concrete, i == 3 ? 7 : 15, 0);
                    aWorld.func_147465_d(-1, this.mHeight + i, aMinZ + 15, (Block)CS.BlocksGT.Concrete, i == 3 ? 7 : 15, 0);
                    aWorld.func_147465_d(0, this.mHeight + i, aMinZ + 14, (Block)CS.BlocksGT.Concrete, i == 3 ? 7 : 15, 0);
                    aWorld.func_147465_d(0, this.mHeight + i, aMinZ + 15, (Block)CS.BlocksGT.Concrete, i == 3 ? 7 : 15, 0);
                }
            }
        } else if (aTunnel) {
            for (i = 0; i < 7; ++i) {
                aWorld.func_147465_d(-1, this.mHeight + i, aMinZ + 7, (Block)CS.BlocksGT.Concrete, i == 3 ? 7 : 15, 0);
                aWorld.func_147465_d(-1, this.mHeight + i, aMinZ + 8, (Block)CS.BlocksGT.Concrete, i == 3 ? 7 : 15, 0);
                aWorld.func_147465_d(0, this.mHeight + i, aMinZ + 7, (Block)CS.BlocksGT.Concrete, i == 3 ? 7 : 15, 0);
                aWorld.func_147465_d(0, this.mHeight + i, aMinZ + 8, (Block)CS.BlocksGT.Concrete, i == 3 ? 7 : 15, 0);
            }
        }
        if (aBridge) {
            int k;
            for (i = 6; i <= 9; ++i) {
                int j4;
                for (j4 = -9; j4 <= -6; ++j4) {
                    aWorld.func_147465_d(j4, this.mHeight - 2, aMinZ + i, (Block)CS.BlocksGT.Concrete, 7, 0);
                    aWorld.func_147465_d(j4, this.mHeight - 3, aMinZ + i, (Block)CS.BlocksGT.Concrete, 7, 0);
                }
                for (j4 = 5; j4 <= 8; ++j4) {
                    aWorld.func_147465_d(j4, this.mHeight - 2, aMinZ + i, (Block)CS.BlocksGT.Concrete, 7, 0);
                    aWorld.func_147465_d(j4, this.mHeight - 3, aMinZ + i, (Block)CS.BlocksGT.Concrete, 7, 0);
                }
            }
            for (k = this.mHeight - 4; k > 0; --k) {
                if (!(WD.opq(aWorld, -10, k, aMinZ + 10, true, true) && WD.opq(aWorld, -5, k, aMinZ + 10, true, true) && WD.opq(aWorld, -10, k, aMinZ + 5, true, true) && WD.opq(aWorld, -5, k, aMinZ + 5, true, true))) {
                    aWorld.func_147465_d(-7, k, aMinZ + 7, (Block)CS.BlocksGT.Concrete, 8, 0);
                    aWorld.func_147465_d(-8, k, aMinZ + 8, (Block)CS.BlocksGT.Concrete, 8, 0);
                    aWorld.func_147465_d(-7, k, aMinZ + 8, (Block)CS.BlocksGT.Concrete, 8, 0);
                    aWorld.func_147465_d(-8, k, aMinZ + 7, (Block)CS.BlocksGT.Concrete, 8, 0);
                    continue;
                }
                for (int i2 = 6; i2 <= 9; ++i2) {
                    for (j = -9; j <= -6; ++j) {
                        if (k > -3) {
                            aWorld.func_147465_d(j, k + 3, aMinZ + i2, (Block)CS.BlocksGT.Concrete, 7, 0);
                        }
                        if (k > -2) {
                            aWorld.func_147465_d(j, k + 2, aMinZ + i2, (Block)CS.BlocksGT.Concrete, 7, 0);
                        }
                        if (k > -1) {
                            aWorld.func_147465_d(j, k + 1, aMinZ + i2, (Block)CS.BlocksGT.Concrete, 7, 0);
                        }
                        if (k > 0) {
                            aWorld.func_147465_d(j, k, aMinZ + i2, (Block)CS.BlocksGT.Concrete, 7, 0);
                        }
                        if (k > 1) {
                            aWorld.func_147465_d(j, k - 1, aMinZ + i2, (Block)CS.BlocksGT.Concrete, 7, 0);
                        }
                        if (k > 2) {
                            aWorld.func_147465_d(j, k - 2, aMinZ + i2, (Block)CS.BlocksGT.Concrete, 7, 0);
                        }
                        if (k <= 3) continue;
                        aWorld.func_147465_d(j, k - 3, aMinZ + i2, (Block)CS.BlocksGT.Concrete, 7, 0);
                    }
                }
                break;
            }
            for (k = this.mHeight - 4; k > 0; --k) {
                if (!(WD.opq(aWorld, 9, k, aMinZ + 10, true, true) && WD.opq(aWorld, 4, k, aMinZ + 10, true, true) && WD.opq(aWorld, 9, k, aMinZ + 5, true, true) && WD.opq(aWorld, 4, k, aMinZ + 5, true, true))) {
                    aWorld.func_147465_d(6, k, aMinZ + 7, (Block)CS.BlocksGT.Concrete, 8, 0);
                    aWorld.func_147465_d(7, k, aMinZ + 8, (Block)CS.BlocksGT.Concrete, 8, 0);
                    aWorld.func_147465_d(6, k, aMinZ + 8, (Block)CS.BlocksGT.Concrete, 8, 0);
                    aWorld.func_147465_d(7, k, aMinZ + 7, (Block)CS.BlocksGT.Concrete, 8, 0);
                    continue;
                }
                for (int i3 = 6; i3 <= 9; ++i3) {
                    for (j = 5; j <= 8; ++j) {
                        if (k > -3) {
                            aWorld.func_147465_d(j, k + 3, aMinZ + i3, (Block)CS.BlocksGT.Concrete, 7, 0);
                        }
                        if (k > -2) {
                            aWorld.func_147465_d(j, k + 2, aMinZ + i3, (Block)CS.BlocksGT.Concrete, 7, 0);
                        }
                        if (k > -1) {
                            aWorld.func_147465_d(j, k + 1, aMinZ + i3, (Block)CS.BlocksGT.Concrete, 7, 0);
                        }
                        if (k > 0) {
                            aWorld.func_147465_d(j, k, aMinZ + i3, (Block)CS.BlocksGT.Concrete, 7, 0);
                        }
                        if (k > 1) {
                            aWorld.func_147465_d(j, k - 1, aMinZ + i3, (Block)CS.BlocksGT.Concrete, 7, 0);
                        }
                        if (k > 2) {
                            aWorld.func_147465_d(j, k - 2, aMinZ + i3, (Block)CS.BlocksGT.Concrete, 7, 0);
                        }
                        if (k <= 3) continue;
                        aWorld.func_147465_d(j, k - 3, aMinZ + i3, (Block)CS.BlocksGT.Concrete, 7, 0);
                    }
                }
                break;
            }
        }
        for (EntityLivingBase tEntity : aWorld.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)-16.0, (double)this.mHeight, (double)aMinZ, (double)16.0, (double)(this.mHeight + 8), (double)(aMinZ + 16)))) {
            if (tEntity instanceof EntityPlayer) continue;
            tEntity.func_70106_y();
        }
        return true;
    }

    public final boolean generateRoadZ(World aWorld, int aMinX, boolean aLand, boolean aKillSky, boolean aTunnel, boolean aBridge, boolean aSideWalls) {
        int j;
        int i;
        for (i = 0; i < 16; ++i) {
            int k;
            int j2;
            if (aLand) {
                for (j2 = this.mHeight + 1; j2 > 0 && !WD.opq(aWorld, aMinX + i, j2, -13, true, true); --j2) {
                    WD.set(aWorld, aMinX + i, j2, -13, Blocks.field_150351_n, 1L, 0L, true);
                }
                for (j2 = this.mHeight + 1; j2 > 0 && !WD.opq(aWorld, aMinX + i, j2, 12, true, true); --j2) {
                    WD.set(aWorld, aMinX + i, j2, 12, Blocks.field_150351_n, 1L, 0L, true);
                }
                for (j2 = this.mHeight; j2 > 0 && !WD.opq(aWorld, aMinX + i, j2, -14, true, true); --j2) {
                    WD.set(aWorld, aMinX + i, j2, -14, Blocks.field_150351_n, 1L, 0L, true);
                }
                for (j2 = this.mHeight; j2 > 0 && !WD.opq(aWorld, aMinX + i, j2, 13, true, true); --j2) {
                    WD.set(aWorld, aMinX + i, j2, 13, Blocks.field_150351_n, 1L, 0L, true);
                }
                for (j2 = this.mHeight - 1; j2 > 0 && !WD.opq(aWorld, aMinX + i, j2, -15, true, true); --j2) {
                    WD.set(aWorld, aMinX + i, j2, -15, Blocks.field_150351_n, 1L, 0L, true);
                }
                for (j2 = this.mHeight - 1; j2 > 0 && !WD.opq(aWorld, aMinX + i, j2, 14, true, true); --j2) {
                    WD.set(aWorld, aMinX + i, j2, 14, Blocks.field_150351_n, 1L, 0L, true);
                }
                for (j2 = this.mHeight - 2; j2 > 0 && !WD.opq(aWorld, aMinX + i, j2, -16, true, true); --j2) {
                    WD.set(aWorld, aMinX + i, j2, -16, Blocks.field_150351_n, 1L, 0L, true);
                }
                for (j2 = this.mHeight - 2; j2 > 0 && !WD.opq(aWorld, aMinX + i, j2, 15, true, true); --j2) {
                    WD.set(aWorld, aMinX + i, j2, 15, Blocks.field_150351_n, 1L, 0L, true);
                }
            }
            if (aTunnel) {
                for (j2 = -12; j2 < 12; ++j2) {
                    aWorld.func_147465_d(aMinX + i, this.mHeight + 7, j2, (Block)CS.BlocksGT.Concrete, 15, 0);
                }
                for (j2 = 0; j2 < 7; ++j2) {
                    aWorld.func_147465_d(aMinX + i, this.mHeight + j2, -13, (Block)CS.BlocksGT.Concrete, j2 == 3 ? 7 : 15, 0);
                    aWorld.func_147465_d(aMinX + i, this.mHeight + j2, 12, (Block)CS.BlocksGT.Concrete, j2 == 3 ? 7 : 15, 0);
                }
            }
            if (aBridge) {
                WD.set(aWorld, aMinX + i, this.mHeight, -13, CS.BlocksGT.Concrete, 8L, 0L, true);
                WD.set(aWorld, aMinX + i, this.mHeight, 12, CS.BlocksGT.Concrete, 8L, 0L, true);
                aWorld.func_147465_d(aMinX + i, this.mHeight + 1, -13, (Block)CS.BlocksGT.Concrete, 8, 0);
                aWorld.func_147465_d(aMinX + i, this.mHeight + 1, 12, (Block)CS.BlocksGT.Concrete, 8, 0);
            }
            if (aKillSky) {
                for (j2 = -13; j2 < 13; ++j2) {
                    for (k = 2; k < 32; ++k) {
                        aWorld.func_147465_d(aMinX + i, this.mHeight + k, j2, CS.NB, 0, 0);
                    }
                }
            } else {
                for (j2 = -12; j2 < 12; ++j2) {
                    for (k = 2; k < 7; ++k) {
                        aWorld.func_147465_d(aMinX + i, this.mHeight + k, j2, CS.NB, 0, 0);
                    }
                }
            }
            for (j2 = -12; j2 < 2; ++j2) {
                aWorld.func_147465_d(aMinX + i, this.mHeight + 1, j2, CS.NB, 0, 0);
                if (aLand) {
                    WD.set(aWorld, aMinX + i, this.mHeight - 2, j2, Blocks.field_150347_e, 0L, 0L, true);
                    aWorld.func_147465_d(aMinX + i, this.mHeight - 1, j2, Blocks.field_150351_n, 1, 0);
                    for (k = this.mHeight - 3; k > 0 && !WD.opq(aWorld, aMinX + i, k, j2, true, true); --k) {
                        WD.set(aWorld, aMinX + i, k, j2, Blocks.field_150347_e, 0L, 0L, true);
                    }
                    continue;
                }
                WD.set(aWorld, aMinX + i, this.mHeight - 1, j2, CS.BlocksGT.Concrete, 8L, 0L, true);
            }
            for (j2 = 1; j2 < 12; ++j2) {
                aWorld.func_147465_d(aMinX + i, this.mHeight + 1, j2, CS.NB, 0, 0);
                if (aLand) {
                    WD.set(aWorld, aMinX + i, this.mHeight - 2, j2, Blocks.field_150347_e, 0L, 0L, true);
                    aWorld.func_147465_d(aMinX + i, this.mHeight - 1, j2, Blocks.field_150351_n, 1, 0);
                    for (k = this.mHeight - 3; k > 0 && !WD.opq(aWorld, aMinX + i, k, j2, true, true); --k) {
                        WD.set(aWorld, aMinX + i, k, j2, Blocks.field_150347_e, 0L, 0L, true);
                    }
                    continue;
                }
                WD.set(aWorld, aMinX + i, this.mHeight - 1, j2, CS.BlocksGT.Concrete, 8L, 0L, true);
            }
            aWorld.func_147465_d(aMinX + i, this.mHeight, -12, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight + 1, -12, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[2], 7, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight, -11, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight + 1, -11, (Block)CS.BlocksGT.RailRoad, 1, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight, -10, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight, -9, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight, -8, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight, -7, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight + 1, -7, (Block)CS.BlocksGT.RailRoad, (i + 2) / 4 % 2 == 0 ? 9 : 1, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight, -6, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight, -5, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight, -4, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight, -3, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight + 1, -3, (Block)CS.BlocksGT.RailRoad, 1, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight, -2, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight + 1, -2, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[3], 7, 0);
            if (aLand) {
                WD.set(aWorld, aMinX + i, this.mHeight - 1, -1, Blocks.field_150347_e, 0L, 0L, true);
                WD.set(aWorld, aMinX + i, this.mHeight, -1, Blocks.field_150351_n, 1L, 0L, false);
                WD.set(aWorld, aMinX + i, this.mHeight + 1, -1, Blocks.field_150351_n, 1L, 0L, false);
                WD.set(aWorld, aMinX + i, this.mHeight - 1, 0, Blocks.field_150347_e, 0L, 0L, true);
                WD.set(aWorld, aMinX + i, this.mHeight, 0, Blocks.field_150351_n, 1L, 0L, false);
                WD.set(aWorld, aMinX + i, this.mHeight + 1, 0, Blocks.field_150351_n, 1L, 0L, false);
                for (j2 = this.mHeight - 2; j2 > 0 && !WD.opq(aWorld, aMinX + i, j2, -1, true, true); --j2) {
                    WD.set(aWorld, aMinX + i, j2, -1, Blocks.field_150347_e, 0L, 0L, true);
                }
                for (j2 = this.mHeight - 2; j2 > 0 && !WD.opq(aWorld, aMinX + i, j2, 0, true, true); --j2) {
                    WD.set(aWorld, aMinX + i, j2, 0, Blocks.field_150347_e, 0L, 0L, true);
                }
            } else {
                WD.set(aWorld, aMinX + i, this.mHeight - 1, -1, CS.BlocksGT.Concrete, 8L, 0L, true);
                WD.set(aWorld, aMinX + i, this.mHeight, -1, CS.BlocksGT.Concrete, 8L, 0L, false);
                WD.set(aWorld, aMinX + i, this.mHeight + 1, -1, CS.BlocksGT.Concrete, 8L, 0L, false);
                WD.set(aWorld, aMinX + i, this.mHeight - 1, 0, CS.BlocksGT.Concrete, 8L, 0L, true);
                WD.set(aWorld, aMinX + i, this.mHeight, 0, CS.BlocksGT.Concrete, 8L, 0L, false);
                WD.set(aWorld, aMinX + i, this.mHeight + 1, 0, CS.BlocksGT.Concrete, 8L, 0L, false);
            }
            aWorld.func_147465_d(aMinX + i, this.mHeight, 1, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight + 1, 1, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[2], 7, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight, 2, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight + 1, 2, (Block)CS.BlocksGT.RailRoad, 1, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight, 3, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight, 4, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight, 5, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight, 6, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight + 1, 6, (Block)CS.BlocksGT.RailRoad, (i + 2) / 4 % 2 == 0 ? 9 : 1, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight, 7, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight, 8, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight, 9, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight, 10, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight + 1, 10, (Block)CS.BlocksGT.RailRoad, 1, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight, 11, (Block)CS.BlocksGT.Asphalt, 8, 0);
            aWorld.func_147465_d(aMinX + i, this.mHeight + 1, 11, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[3], 7, 0);
        }
        if (aTunnel) {
            aWorld.func_147465_d(aMinX + 1, this.mHeight + 3, -13, Blocks.field_150426_aN, 0, 0);
            aWorld.func_147465_d(aMinX + 1, this.mHeight + 3, 12, Blocks.field_150426_aN, 0, 0);
            aWorld.func_147465_d(aMinX + 6, this.mHeight + 3, -13, Blocks.field_150426_aN, 0, 0);
            aWorld.func_147465_d(aMinX + 6, this.mHeight + 3, 12, Blocks.field_150426_aN, 0, 0);
            aWorld.func_147465_d(aMinX + 9, this.mHeight + 3, -13, Blocks.field_150426_aN, 0, 0);
            aWorld.func_147465_d(aMinX + 9, this.mHeight + 3, 12, Blocks.field_150426_aN, 0, 0);
            aWorld.func_147465_d(aMinX + 14, this.mHeight + 3, -13, Blocks.field_150426_aN, 0, 0);
            aWorld.func_147465_d(aMinX + 14, this.mHeight + 3, 12, Blocks.field_150426_aN, 0, 0);
        }
        if (aSideWalls) {
            int k;
            for (i = 0; i < 8; ++i) {
                Block tBlock = WD.block(aWorld, aMinX + i, this.mHeight + 4, 13, true);
                if (!tBlock.func_149688_o().func_76224_d() && !WD.opq(tBlock)) continue;
                for (j = 0; j < 8; ++j) {
                    for (k = 2; k < 6; ++k) {
                        WD.set(aWorld, aMinX + j, this.mHeight + k, 12, WD.even(0, k, j) ? CS.BlocksGT.CFoam : CS.BlocksGT.Concrete, 7L, 0L, true);
                    }
                }
                break;
            }
            for (i = 0; i < 8; ++i) {
                Block tBlock = WD.block(aWorld, aMinX + i, this.mHeight + 4, -14, true);
                if (!tBlock.func_149688_o().func_76224_d() && !WD.opq(tBlock)) continue;
                for (j = 0; j < 8; ++j) {
                    for (k = 2; k < 6; ++k) {
                        WD.set(aWorld, aMinX + j, this.mHeight + k, -13, WD.even(1, k, j) ? CS.BlocksGT.CFoam : CS.BlocksGT.Concrete, 7L, 0L, true);
                    }
                }
                break;
            }
            for (i = 8; i < 16; ++i) {
                Block tBlock = WD.block(aWorld, aMinX + i, this.mHeight + 4, 13, true);
                if (!tBlock.func_149688_o().func_76224_d() && !WD.opq(tBlock)) continue;
                for (j = 8; j < 16; ++j) {
                    for (k = 2; k < 6; ++k) {
                        WD.set(aWorld, aMinX + j, this.mHeight + k, 12, WD.even(0, k, j) ? CS.BlocksGT.CFoam : CS.BlocksGT.Concrete, 7L, 0L, true);
                    }
                }
                break;
            }
            for (i = 8; i < 16; ++i) {
                Block tBlock = WD.block(aWorld, aMinX + i, this.mHeight + 4, -14, true);
                if (!tBlock.func_149688_o().func_76224_d() && !WD.opq(tBlock)) continue;
                for (j = 8; j < 16; ++j) {
                    for (k = 2; k < 6; ++k) {
                        WD.set(aWorld, aMinX + j, this.mHeight + k, -13, WD.even(1, k, j) ? CS.BlocksGT.CFoam : CS.BlocksGT.Concrete, 7L, 0L, true);
                    }
                }
                break;
            }
        }
        if (aMinX >> 9 != aMinX - 16 >> 9) {
            for (i = 5; i < 11; ++i) {
                for (int j3 = 1; j3 < 6; ++j3) {
                    WD.set(aWorld, aMinX + i, this.mHeight + j3, -13, CS.BlocksGT.Concrete, i == 5 || i == 10 || j3 == 1 || j3 == 5 ? (aTunnel ? 0L : 15L) : (aMinX < 0 ? 4L : 1L), 0L, j3 == 1);
                    WD.set(aWorld, aMinX + i, this.mHeight + j3, 12, CS.BlocksGT.Concrete, i == 5 || i == 10 || j3 == 1 || j3 == 5 ? (aTunnel ? 0L : 15L) : (aMinX < 0 ? 4L : 1L), 0L, j3 == 1);
                }
            }
            WD.sign(aWorld, aMinX + 7, this.mHeight + 3, -12, (byte)3, 0L, "", "X: " + (aMinX - 16 >> 9), "Z: -1", "");
            WD.sign(aWorld, aMinX + 8, this.mHeight + 3, -12, (byte)3, 0L, "", "X: " + (aMinX >> 9), "Z: -1", "");
            WD.sign(aWorld, aMinX + 7, this.mHeight + 3, 11, (byte)2, 0L, "", "X: " + (aMinX - 16 >> 9), "Z: 0", "");
            WD.sign(aWorld, aMinX + 8, this.mHeight + 3, 11, (byte)2, 0L, "", "X: " + (aMinX >> 9), "Z: 0", "");
            aWorld.func_147465_d(aMinX + 5, this.mHeight + 1, -13, Blocks.field_150426_aN, 0, 0);
            aWorld.func_147465_d(aMinX + 10, this.mHeight + 1, -13, Blocks.field_150426_aN, 0, 0);
            aWorld.func_147465_d(aMinX + 5, this.mHeight + 5, -13, Blocks.field_150426_aN, 0, 0);
            aWorld.func_147465_d(aMinX + 10, this.mHeight + 5, -13, Blocks.field_150426_aN, 0, 0);
            aWorld.func_147465_d(aMinX + 5, this.mHeight + 1, 12, Blocks.field_150426_aN, 0, 0);
            aWorld.func_147465_d(aMinX + 10, this.mHeight + 1, 12, Blocks.field_150426_aN, 0, 0);
            aWorld.func_147465_d(aMinX + 5, this.mHeight + 5, 12, Blocks.field_150426_aN, 0, 0);
            aWorld.func_147465_d(aMinX + 10, this.mHeight + 5, 12, Blocks.field_150426_aN, 0, 0);
        }
        if (aMinX >> 9 != aMinX + 16 >> 9) {
            aWorld.func_147465_d(aMinX + 0, this.mHeight + 1, -2, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[3], 15, 0);
            aWorld.func_147465_d(aMinX + 1, this.mHeight + 1, -2, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[3], 1, 0);
            aWorld.func_147465_d(aMinX + 2, this.mHeight + 1, -2, CS.NB, 0, 0);
            aWorld.func_147465_d(aMinX + 2, this.mHeight + 1, -1, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[4], 15, 0);
            aWorld.func_147465_d(aMinX + 2, this.mHeight + 1, 0, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[4], 1, 0);
            aWorld.func_147465_d(aMinX + 2, this.mHeight + 1, 1, CS.NB, 0, 0);
            aWorld.func_147465_d(aMinX + 1, this.mHeight + 1, 1, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[2], 15, 0);
            aWorld.func_147465_d(aMinX + 0, this.mHeight + 1, 1, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[2], 1, 0);
            for (i = 2; i < 14; ++i) {
                aWorld.func_147465_d(aMinX + i, this.mHeight, -1, (Block)CS.BlocksGT.Asphalt, 8, 0);
                aWorld.func_147465_d(aMinX + i, this.mHeight, 0, (Block)CS.BlocksGT.Asphalt, 8, 0);
            }
            for (i = 3; i < 13; ++i) {
                aWorld.func_147465_d(aMinX + i, this.mHeight + 1, -2, CS.NB, 0, 0);
                aWorld.func_147465_d(aMinX + i, this.mHeight + 1, -1, CS.NB, 0, 0);
                aWorld.func_147465_d(aMinX + i, this.mHeight + 1, 0, CS.NB, 0, 0);
                aWorld.func_147465_d(aMinX + i, this.mHeight + 1, 1, CS.NB, 0, 0);
            }
            aWorld.func_147465_d(aMinX + 15, this.mHeight + 1, -2, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[3], 1, 0);
            aWorld.func_147465_d(aMinX + 14, this.mHeight + 1, -2, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[3], 15, 0);
            aWorld.func_147465_d(aMinX + 13, this.mHeight + 1, -2, CS.NB, 0, 0);
            aWorld.func_147465_d(aMinX + 13, this.mHeight + 1, -1, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[5], 1, 0);
            aWorld.func_147465_d(aMinX + 13, this.mHeight + 1, 0, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[5], 15, 0);
            aWorld.func_147465_d(aMinX + 13, this.mHeight + 1, 1, CS.NB, 0, 0);
            aWorld.func_147465_d(aMinX + 14, this.mHeight + 1, 1, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[2], 1, 0);
            aWorld.func_147465_d(aMinX + 15, this.mHeight + 1, 1, (Block)((BlockMetaType)CS.BlocksGT.CFoam).mSlabs[2], 15, 0);
            if (aTunnel) {
                for (i = 0; i < 7; ++i) {
                    aWorld.func_147465_d(aMinX + 0, this.mHeight + i, -1, (Block)CS.BlocksGT.Concrete, i == 3 ? 7 : 15, 0);
                    aWorld.func_147465_d(aMinX + 0, this.mHeight + i, 0, (Block)CS.BlocksGT.Concrete, i == 3 ? 7 : 15, 0);
                    aWorld.func_147465_d(aMinX + 1, this.mHeight + i, -1, (Block)CS.BlocksGT.Concrete, i == 3 ? 7 : 15, 0);
                    aWorld.func_147465_d(aMinX + 1, this.mHeight + i, 0, (Block)CS.BlocksGT.Concrete, i == 3 ? 7 : 15, 0);
                    aWorld.func_147465_d(aMinX + 14, this.mHeight + i, -1, (Block)CS.BlocksGT.Concrete, i == 3 ? 7 : 15, 0);
                    aWorld.func_147465_d(aMinX + 14, this.mHeight + i, 0, (Block)CS.BlocksGT.Concrete, i == 3 ? 7 : 15, 0);
                    aWorld.func_147465_d(aMinX + 15, this.mHeight + i, -1, (Block)CS.BlocksGT.Concrete, i == 3 ? 7 : 15, 0);
                    aWorld.func_147465_d(aMinX + 15, this.mHeight + i, 0, (Block)CS.BlocksGT.Concrete, i == 3 ? 7 : 15, 0);
                }
            }
        } else if (aTunnel) {
            for (i = 0; i < 7; ++i) {
                aWorld.func_147465_d(aMinX + 7, this.mHeight + i, -1, (Block)CS.BlocksGT.Concrete, i == 3 ? 7 : 15, 0);
                aWorld.func_147465_d(aMinX + 7, this.mHeight + i, 0, (Block)CS.BlocksGT.Concrete, i == 3 ? 7 : 15, 0);
                aWorld.func_147465_d(aMinX + 8, this.mHeight + i, -1, (Block)CS.BlocksGT.Concrete, i == 3 ? 7 : 15, 0);
                aWorld.func_147465_d(aMinX + 8, this.mHeight + i, 0, (Block)CS.BlocksGT.Concrete, i == 3 ? 7 : 15, 0);
            }
        }
        if (aBridge) {
            int k;
            for (i = 6; i <= 9; ++i) {
                int j4;
                for (j4 = -9; j4 <= -6; ++j4) {
                    aWorld.func_147465_d(aMinX + i, this.mHeight - 2, j4, (Block)CS.BlocksGT.Concrete, 7, 0);
                    aWorld.func_147465_d(aMinX + i, this.mHeight - 3, j4, (Block)CS.BlocksGT.Concrete, 7, 0);
                }
                for (j4 = 5; j4 <= 8; ++j4) {
                    aWorld.func_147465_d(aMinX + i, this.mHeight - 2, j4, (Block)CS.BlocksGT.Concrete, 7, 0);
                    aWorld.func_147465_d(aMinX + i, this.mHeight - 3, j4, (Block)CS.BlocksGT.Concrete, 7, 0);
                }
            }
            for (k = this.mHeight - 4; k > 0; --k) {
                if (!(WD.opq(aWorld, aMinX + 10, k, -10, true, true) && WD.opq(aWorld, aMinX + 10, k, -5, true, true) && WD.opq(aWorld, aMinX + 5, k, -10, true, true) && WD.opq(aWorld, aMinX + 5, k, -5, true, true))) {
                    aWorld.func_147465_d(aMinX + 7, k, -7, (Block)CS.BlocksGT.Concrete, 8, 0);
                    aWorld.func_147465_d(aMinX + 8, k, -8, (Block)CS.BlocksGT.Concrete, 8, 0);
                    aWorld.func_147465_d(aMinX + 7, k, -8, (Block)CS.BlocksGT.Concrete, 8, 0);
                    aWorld.func_147465_d(aMinX + 8, k, -7, (Block)CS.BlocksGT.Concrete, 8, 0);
                    continue;
                }
                for (int i2 = 6; i2 <= 9; ++i2) {
                    for (j = -9; j <= -6; ++j) {
                        if (k > -3) {
                            aWorld.func_147465_d(aMinX + i2, k + 3, j, (Block)CS.BlocksGT.Concrete, 7, 0);
                        }
                        if (k > -2) {
                            aWorld.func_147465_d(aMinX + i2, k + 2, j, (Block)CS.BlocksGT.Concrete, 7, 0);
                        }
                        if (k > -1) {
                            aWorld.func_147465_d(aMinX + i2, k + 1, j, (Block)CS.BlocksGT.Concrete, 7, 0);
                        }
                        if (k > 0) {
                            aWorld.func_147465_d(aMinX + i2, k, j, (Block)CS.BlocksGT.Concrete, 7, 0);
                        }
                        if (k > 1) {
                            aWorld.func_147465_d(aMinX + i2, k - 1, j, (Block)CS.BlocksGT.Concrete, 7, 0);
                        }
                        if (k > 2) {
                            aWorld.func_147465_d(aMinX + i2, k - 2, j, (Block)CS.BlocksGT.Concrete, 7, 0);
                        }
                        if (k <= 3) continue;
                        aWorld.func_147465_d(aMinX + i2, k - 3, j, (Block)CS.BlocksGT.Concrete, 7, 0);
                    }
                }
                break;
            }
            for (k = this.mHeight - 4; k > 0; --k) {
                if (!(WD.opq(aWorld, aMinX + 10, k, 9, true, true) && WD.opq(aWorld, aMinX + 10, k, 4, true, true) && WD.opq(aWorld, aMinX + 5, k, 9, true, true) && WD.opq(aWorld, aMinX + 5, k, 4, true, true))) {
                    aWorld.func_147465_d(aMinX + 7, k, 6, (Block)CS.BlocksGT.Concrete, 8, 0);
                    aWorld.func_147465_d(aMinX + 8, k, 7, (Block)CS.BlocksGT.Concrete, 8, 0);
                    aWorld.func_147465_d(aMinX + 7, k, 7, (Block)CS.BlocksGT.Concrete, 8, 0);
                    aWorld.func_147465_d(aMinX + 8, k, 6, (Block)CS.BlocksGT.Concrete, 8, 0);
                    continue;
                }
                for (int i3 = 6; i3 <= 9; ++i3) {
                    for (j = 5; j <= 8; ++j) {
                        if (k > -3) {
                            aWorld.func_147465_d(aMinX + i3, k + 3, j, (Block)CS.BlocksGT.Concrete, 7, 0);
                        }
                        if (k > -2) {
                            aWorld.func_147465_d(aMinX + i3, k + 2, j, (Block)CS.BlocksGT.Concrete, 7, 0);
                        }
                        if (k > -1) {
                            aWorld.func_147465_d(aMinX + i3, k + 1, j, (Block)CS.BlocksGT.Concrete, 7, 0);
                        }
                        if (k > 0) {
                            aWorld.func_147465_d(aMinX + i3, k, j, (Block)CS.BlocksGT.Concrete, 7, 0);
                        }
                        if (k > 1) {
                            aWorld.func_147465_d(aMinX + i3, k - 1, j, (Block)CS.BlocksGT.Concrete, 7, 0);
                        }
                        if (k > 2) {
                            aWorld.func_147465_d(aMinX + i3, k - 2, j, (Block)CS.BlocksGT.Concrete, 7, 0);
                        }
                        if (k <= 3) continue;
                        aWorld.func_147465_d(aMinX + i3, k - 3, j, (Block)CS.BlocksGT.Concrete, 7, 0);
                    }
                }
                break;
            }
        }
        for (EntityLivingBase tEntity : aWorld.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)aMinX, (double)this.mHeight, (double)-16.0, (double)(aMinX + 16), (double)(this.mHeight + 8), (double)16.0))) {
            if (tEntity instanceof EntityPlayer) continue;
            tEntity.func_70106_y();
        }
        return true;
    }
}

