/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.BI;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.MT;
import gregapi.data.RM;
import gregapi.data.TD;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.old.Textures;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.render.BlockTextureCopied;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class MultiTileEntitySiftingTable
extends TileEntityBase07Paintable
implements IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool,
IMultiTileEntity.IMTE_AddToolTips {
    public short mDisplayedInput = 0;
    public short mDisplayedOutput = 0;
    public short oDisplayedInput = (short)-1;
    public short oDisplayedOutput = (short)-1;
    public byte mState = 0;
    public byte oState = 0;
    public byte mClickCount = 0;
    public Recipe.RecipeMap mRecipes = RM.Sifting;
    public Recipe mLastRecipe = null;
    public static IIconContainer sTextureLegs = new Textures.BlockIcons.CustomIcon("machines/tools/sifting_table/colored/legs");
    public static IIconContainer sTextureGrid = new Textures.BlockIcons.CustomIcon("machines/tools/sifting_table/colored/grid");
    public static IIconContainer sTextureBorder = new Textures.BlockIcons.CustomIcon("machines/tools/sifting_table/colored/border");
    public static IIconContainer sTexturePlate = new Textures.BlockIcons.CustomIcon("machines/tools/sifting_table/colored/plate");
    public static IIconContainer sOverlayLegs = new Textures.BlockIcons.CustomIcon("machines/tools/sifting_table/overlay/legs");
    public static IIconContainer sOverlayGrid = new Textures.BlockIcons.CustomIcon("machines/tools/sifting_table/overlay/grid");
    public static IIconContainer sOverlayBorder = new Textures.BlockIcons.CustomIcon("machines/tools/sifting_table/overlay/border");
    public static IIconContainer sOverlayPlate = new Textures.BlockIcons.CustomIcon("machines/tools/sifting_table/overlay/plate");
    private ITexture mTextureLegs;
    private ITexture mTextureGrid;
    private ITexture mTextureBorder;
    private ITexture mTexturePlate;
    private ITexture mTextureInput;
    private ITexture mTextureOutput;
    private static final int[] ACCESSIBLE_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.state")) {
            this.mState = aNBT.func_74771_c("gt.state");
        }
        if (aNBT.func_74764_b("gt.progress")) {
            this.mClickCount = aNBT.func_74771_c("gt.progress");
        }
        if (aNBT.func_74764_b("gt.recipemap")) {
            this.mRecipes = Recipe.RecipeMap.RECIPE_MAPS.get(aNBT.func_74779_i("gt.recipemap"));
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        aNBT.func_74774_a("gt.state", this.mState);
        aNBT.func_74774_a("gt.progress", this.mClickCount);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes") + ": " + LH.Chat.WHITE + LH.get(this.mRecipes.mNameInternal));
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes.sifter.usage"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.interact") + " (" + LH.get("gt.lang.face.top") + ")");
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            this.mDisplayedInput = 0;
            this.mDisplayedOutput = 0;
            this.mState = (byte)(this.mState & ~CS.B[0]);
            ItemStack tStack = this.slot(0);
            if (ST.valid(tStack)) {
                OreDictItemData tData;
                this.mState = (byte)(this.mState | CS.B[0]);
                this.mDisplayedInput = ST.equal(tStack, Blocks.field_150346_d, 0L) ? (short)-2 : (ST.equal(tStack, Blocks.field_150346_d, 1L) ? (short)-3 : (ST.equal(tStack, Blocks.field_150346_d, 2L) ? (short)-4 : (ST.equal(tStack, (Block)Blocks.field_150349_c, 32767L) ? (short)-7 : (ST.equal(tStack, (Block)CS.BlocksGT.Grass, 32767L) ? (short)-7 : (ST.equal(tStack, (Block)Blocks.field_150391_bh, 32767L) ? (short)-8 : (ST.equal(tStack, (Block)CS.BlocksGT.Diggables, 0L) ? (short)-10 : (IL.AETHER_Grass_Enchanted_Vanilla.equal(tStack, true, true) ? (short)-7 : (IL.AETHER_Grass_Enchanted.equal(tStack, true, true) ? (short)-7 : (IL.AETHER_Grass.equal(tStack, true, true) ? (short)-7 : (IL.AETHER_Dirt.equal(tStack, true, true) ? (short)-2 : (IL.AETHER_Sand.equal(tStack, true, true) ? (short)-5 : (IL.RH_Sand_Magnetite.equal(tStack, false, true) ? (short)-11 : (IL.RH_Sand_Magnetite.equal(tStack, true, true) ? (short)-5 : (IL.TROPIC_Sand_Black.equal(tStack, false, true) ? (short)-11 : (IL.TROPIC_Sand_Black.equal(tStack, true, true) ? (short)-5 : (IL.PFAA_Sands.equal(tStack, true, true) ? (short)-11 : (IL.NePl_SoulSoil.equal(tStack, true, true) ? (short)-9 : (IL.NeLi_SoulSoil.equal(tStack, true, true) ? (short)-9 : (IL.NeLi_Gravel.equal(tStack, true, true) ? (short)-11 : (IL.EtFu_Gravel.equal(tStack, false, true) ? (short)-1 : (IL.EtFu_Dirt.equal(tStack, false, true) ? (short)-3 : (IL.BTL_Mud.equal(tStack, false, true) ? (short)-10 : (IL.ERE_Mud.equal(tStack, false, true) ? (short)-10 : (IL.BoP_Mud.equal(tStack, false, true) ? (short)-10 : (IL.BoP_Quicksand.equal(tStack, false, true) ? (short)-5 : (IL.BoP_Sand_Hard.equal(tStack, false, true) ? (short)-5 : (IL.BoP_Grass_Endstone.equal(tStack, false, true) ? (short)-7 : (IL.BoP_Grass_Loamy.equal(tStack, false, true) ? (short)-7 : (IL.BoP_Grass_Long.equal(tStack, false, true) ? (short)-7 : (IL.BoP_Grass_Netherrack.equal(tStack, false, true) ? (short)-7 : (IL.BoP_Grass_Origin.equal(tStack, false, true) ? (short)-7 : (IL.BoP_Grass_Sandy.equal(tStack, false, true) ? (short)-7 : (IL.BoP_Grass_Silty.equal(tStack, false, true) ? (short)-7 : (IL.BoP_Grass_Smoldering.equal(tStack, false, true) ? (short)-7 : (IL.BoP_Coarse_Loamy.equal(tStack, false, true) ? (short)-3 : (IL.BoP_Coarse_Sandy.equal(tStack, false, true) ? (short)-3 : (IL.BoP_Coarse_Silty.equal(tStack, false, true) ? (short)-3 : (IL.BoP_Dirt_Hard.equal(tStack, false, true) ? (short)-3 : (IL.BoP_Dirt_Dried.equal(tStack, false, true) ? (short)-3 : (IL.BoP_Dirt_Loamy.equal(tStack, false, true) ? (short)-2 : (IL.BoP_Dirt_Sandy.equal(tStack, false, true) ? (short)-2 : (IL.BoP_Dirt_Silty.equal(tStack, false, true) ? (short)-2 : (IL.EB_Dirt_Alfisol.equal(tStack, false, true) ? (short)-2 : (IL.EB_Dirt_Andisol.equal(tStack, false, true) ? (short)-2 : (IL.EB_Dirt_Gelisol.equal(tStack, false, true) ? (short)-2 : (IL.EB_Dirt_Histosol.equal(tStack, false, true) ? (short)-2 : (IL.EB_Dirt_Inceptisol.equal(tStack, false, true) ? (short)-2 : (IL.EB_Dirt_Mollisol.equal(tStack, false, true) ? (short)-2 : (IL.EB_Dirt_Oxisol.equal(tStack, false, true) ? (short)-2 : (IL.EB_Grass_Alfisol.equal(tStack, false, true) ? (short)-7 : (IL.EB_Grass_Andisol.equal(tStack, false, true) ? (short)-7 : (IL.EB_Grass_Gelisol.equal(tStack, false, true) ? (short)-7 : (IL.EB_Grass_Histosol.equal(tStack, false, true) ? (short)-7 : (IL.EB_Grass_Inceptisol.equal(tStack, false, true) ? (short)-7 : (IL.EB_Grass_Mollisol.equal(tStack, false, true) ? (short)-7 : (IL.EB_Grass_Oxisol.equal(tStack, false, true) ? (short)-7 : (IL.Salt_Dirt_1.equal(tStack, false, true) ? (short)-2 : (IL.Salt_Dirt_2.equal(tStack, false, true) ? (short)-2 : (IL.Salt_Dirt_3.equal(tStack, false, true) ? (short)-2 : (IL.Salt_Grass.equal(tStack, false, true) ? (short)-7 : ((tData = OM.data_(tStack)) == null || tData.mMaterial == null ? (short)-1 : tData.mMaterial.mMaterial.mID)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))));
            }
            this.mState = (byte)(this.mState & ~CS.B[1]);
            for (int i = 1; i < 13; ++i) {
                tStack = this.slot(i);
                if (!ST.valid(tStack)) continue;
                this.mState = (byte)(this.mState | CS.B[1]);
                if (ST.equal(tStack, Blocks.field_150346_d, 0L)) {
                    this.mDisplayedOutput = (short)-2;
                    break;
                }
                if (ST.equal(tStack, Blocks.field_150346_d, 1L)) {
                    this.mDisplayedOutput = (short)-3;
                    break;
                }
                if (ST.equal(tStack, Blocks.field_150346_d, 2L)) {
                    this.mDisplayedOutput = (short)-4;
                    break;
                }
                if (ST.equal(tStack, (Block)Blocks.field_150349_c, 32767L)) {
                    this.mDisplayedOutput = (short)-7;
                    break;
                }
                if (ST.equal(tStack, (Block)CS.BlocksGT.Grass, 32767L)) {
                    this.mDisplayedOutput = (short)-7;
                    break;
                }
                if (ST.equal(tStack, (Block)Blocks.field_150391_bh, 32767L)) {
                    this.mDisplayedOutput = (short)-8;
                    break;
                }
                if (ST.equal(tStack, (Block)CS.BlocksGT.Diggables, 0L)) {
                    this.mDisplayedOutput = (short)-10;
                    break;
                }
                if (IL.AETHER_Grass_Enchanted_Vanilla.equal(tStack, true, true)) {
                    this.mDisplayedOutput = (short)-7;
                    break;
                }
                if (IL.AETHER_Grass_Enchanted.equal(tStack, true, true)) {
                    this.mDisplayedOutput = (short)-7;
                    break;
                }
                if (IL.AETHER_Grass.equal(tStack, true, true)) {
                    this.mDisplayedOutput = (short)-7;
                    break;
                }
                if (IL.AETHER_Dirt.equal(tStack, true, true)) {
                    this.mDisplayedOutput = (short)-2;
                    break;
                }
                if (IL.AETHER_Sand.equal(tStack, true, true)) {
                    this.mDisplayedOutput = (short)-5;
                    break;
                }
                if (IL.RH_Sand_Magnetite.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-11;
                    break;
                }
                if (IL.RH_Sand_Magnetite.equal(tStack, true, true)) {
                    this.mDisplayedOutput = (short)-5;
                    break;
                }
                if (IL.TROPIC_Sand_Black.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-11;
                    break;
                }
                if (IL.TROPIC_Sand_Black.equal(tStack, true, true)) {
                    this.mDisplayedOutput = (short)-5;
                    break;
                }
                if (IL.PFAA_Sands.equal(tStack, true, true)) {
                    this.mDisplayedOutput = (short)-11;
                    break;
                }
                if (IL.NePl_SoulSoil.equal(tStack, true, true)) {
                    this.mDisplayedOutput = (short)-9;
                    break;
                }
                if (IL.NeLi_SoulSoil.equal(tStack, true, true)) {
                    this.mDisplayedOutput = (short)-9;
                    break;
                }
                if (IL.NeLi_Gravel.equal(tStack, true, true)) {
                    this.mDisplayedOutput = (short)-11;
                    break;
                }
                if (IL.EtFu_Gravel.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-1;
                    break;
                }
                if (IL.EtFu_Dirt.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-3;
                    break;
                }
                if (IL.BTL_Mud.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-10;
                    break;
                }
                if (IL.ERE_Mud.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-10;
                    break;
                }
                if (IL.BoP_Mud.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-10;
                    break;
                }
                if (IL.BoP_Quicksand.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-5;
                    break;
                }
                if (IL.BoP_Sand_Hard.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-5;
                    break;
                }
                if (IL.BoP_Grass_Endstone.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-7;
                    break;
                }
                if (IL.BoP_Grass_Loamy.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-7;
                    break;
                }
                if (IL.BoP_Grass_Long.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-7;
                    break;
                }
                if (IL.BoP_Grass_Netherrack.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-7;
                    break;
                }
                if (IL.BoP_Grass_Origin.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-7;
                    break;
                }
                if (IL.BoP_Grass_Sandy.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-7;
                    break;
                }
                if (IL.BoP_Grass_Silty.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-7;
                    break;
                }
                if (IL.BoP_Grass_Smoldering.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-7;
                    break;
                }
                if (IL.BoP_Coarse_Loamy.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-3;
                    break;
                }
                if (IL.BoP_Coarse_Sandy.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-3;
                    break;
                }
                if (IL.BoP_Coarse_Silty.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-3;
                    break;
                }
                if (IL.BoP_Dirt_Hard.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-3;
                    break;
                }
                if (IL.BoP_Dirt_Dried.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-3;
                    break;
                }
                if (IL.BoP_Dirt_Loamy.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-2;
                    break;
                }
                if (IL.BoP_Dirt_Sandy.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-2;
                    break;
                }
                if (IL.BoP_Dirt_Silty.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-2;
                    break;
                }
                if (IL.EB_Dirt_Alfisol.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-2;
                    break;
                }
                if (IL.EB_Dirt_Andisol.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-2;
                    break;
                }
                if (IL.EB_Dirt_Gelisol.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-2;
                    break;
                }
                if (IL.EB_Dirt_Histosol.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-2;
                    break;
                }
                if (IL.EB_Dirt_Inceptisol.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-2;
                    break;
                }
                if (IL.EB_Dirt_Mollisol.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-2;
                    break;
                }
                if (IL.EB_Dirt_Oxisol.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-2;
                    break;
                }
                if (IL.EB_Grass_Alfisol.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-7;
                    break;
                }
                if (IL.EB_Grass_Andisol.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-7;
                    break;
                }
                if (IL.EB_Grass_Gelisol.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-7;
                    break;
                }
                if (IL.EB_Grass_Histosol.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-7;
                    break;
                }
                if (IL.EB_Grass_Inceptisol.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-7;
                    break;
                }
                if (IL.EB_Grass_Mollisol.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-7;
                    break;
                }
                if (IL.EB_Grass_Oxisol.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-7;
                    break;
                }
                if (IL.Salt_Dirt_1.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-2;
                    break;
                }
                if (IL.Salt_Dirt_2.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-2;
                    break;
                }
                if (IL.Salt_Dirt_3.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-2;
                    break;
                }
                if (IL.Salt_Grass.equal(tStack, false, true)) {
                    this.mDisplayedOutput = (short)-7;
                    break;
                }
                OreDictItemData tData = OM.data_(tStack);
                if (tData == null || tData.mMaterial == null) {
                    this.mDisplayedOutput = (short)-1;
                    break;
                }
                this.mDisplayedOutput = tData.mMaterial.mMaterial.mID;
                break;
            }
            if (aTimer % 5L == 0L && (this.mState & CS.B[2]) != 0) {
                this.mState = (byte)(this.mState & ~CS.B[2]);
                block1: for (EntityPlayer tPlayer : UT.Entities.getPlayersWithLastTarget(this)) {
                    this.mState = (byte)(this.mState | CS.B[2]);
                    boolean temp = true;
                    for (int i = 1; i < 13; ++i) {
                        if (!this.slotHas(i)) continue;
                        temp = false;
                        break;
                    }
                    ItemStack aStack = this.slot(0);
                    if (!temp || (this.mClickCount = UT.Code.bind7(this.mClickCount + UT.Entities.pot1Haste(tPlayer))) < 4 * UT.Entities.pot2Fatique(tPlayer) && !UT.Entities.hasInfiniteItems(tPlayer)) continue;
                    this.mClickCount = 0;
                    Recipe tRecipe = this.mRecipes.findRecipe((IHasWorldAndCoords)this, this.mLastRecipe, false, CS.V[1], null, CS.ZL_FS, aStack);
                    if (tRecipe == null) {
                        for (int i = 1; i < 13; ++i) {
                            if (!this.addStackToSlot(i, aStack)) continue;
                            this.slotKill(0);
                            continue block1;
                        }
                        continue;
                    }
                    if (tRecipe.mCanBeBuffered) {
                        this.mLastRecipe = tRecipe;
                    }
                    if (!tRecipe.isRecipeInputEqual(true, false, CS.ZL_FS, ST.array(aStack))) continue;
                    if (aStack.field_77994_a <= 0) {
                        this.slotKill(0);
                    }
                    ItemStack[] tOutputs = tRecipe.getOutputs();
                    int j = Math.min(tOutputs.length, 12);
                    for (int i = 0; i < j; ++i) {
                        this.addStackToSlot(i + 1, tOutputs[i]);
                    }
                    UT.Entities.exhaust(tPlayer, (double)tRecipe.getAbsoluteTotalPower() / 1000.0);
                    tPlayer.func_71038_i();
                    this.updateInventory();
                    this.updateAdjacentInventories();
                }
            }
        } else if (aTimer % 5L == 0L && this.mDisplayedInput != 0 && (this.mState & CS.B[2]) != 0) {
            UT.Sounds.play("dig.sand", 5, 1.0f, 1.0f, this.getCoords());
        }
    }

    @Override
    public boolean attachCoversFirst(byte aSide) {
        return false;
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        float[] tCoords;
        if (this.isServerSide()) {
            if (CS.SIDES_TOP[aSide]) {
                float[] tCoords2 = UT.Code.getFacingCoordsClicked(aSide, aHitX, aHitY, aHitZ);
                if (tCoords2[0] <= CS.PX_P[2] && tCoords2[1] <= CS.PX_P[2]) {
                    return true;
                }
                if (this.slotHas(0)) {
                    this.mState = (byte)(this.mState | CS.B[2]);
                } else {
                    this.mClickCount = 0;
                    if (this.canInsertItem2(0, aPlayer.field_71071_by.func_70448_g(), aSide)) {
                        ST.move((IInventory)aPlayer.field_71071_by, this, aPlayer.field_71071_by.field_70461_c, 0);
                    }
                }
            } else {
                for (int i = 1; i < 13; ++i) {
                    ST.give((Entity)aPlayer, this.slotTake(i), false, this.field_145850_b, (double)this.field_145851_c + 0.5, this.field_145848_d + 1, (double)this.field_145849_e + 0.5);
                }
            }
        } else if (CS.SIDES_TOP[aSide] && (tCoords = UT.Code.getFacingCoordsClicked(aSide, aHitX, aHitY, aHitZ))[0] <= CS.PX_P[2] && tCoords[1] <= CS.PX_P[2]) {
            this.mRecipes.openNEI();
            return true;
        }
        return true;
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return super.onTickCheck(aTimer) || this.mState != this.oState || this.mDisplayedOutput != this.oDisplayedOutput || this.mDisplayedInput != this.oDisplayedInput;
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oState = this.mState;
        this.oDisplayedInput = this.mDisplayedInput;
        this.oDisplayedOutput = this.mDisplayedOutput;
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        if (aSendAll) {
            return this.getClientDataPacketByteArray(aSendAll, this.mState, UT.Code.toByteS(this.mDisplayedOutput, 0), UT.Code.toByteS(this.mDisplayedOutput, 1), UT.Code.toByteS(this.mDisplayedInput, 0), UT.Code.toByteS(this.mDisplayedInput, 1), (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa));
        }
        if (this.mDisplayedInput != this.oDisplayedInput) {
            return this.getClientDataPacketByteArray(aSendAll, this.mState, UT.Code.toByteS(this.mDisplayedOutput, 0), UT.Code.toByteS(this.mDisplayedOutput, 1), UT.Code.toByteS(this.mDisplayedInput, 0), UT.Code.toByteS(this.mDisplayedInput, 1));
        }
        if (this.mDisplayedOutput != this.oDisplayedOutput) {
            return this.getClientDataPacketByteArray(aSendAll, this.mState, UT.Code.toByteS(this.mDisplayedOutput, 0), UT.Code.toByteS(this.mDisplayedOutput, 1));
        }
        return this.getClientDataPacketByte(aSendAll, this.mState);
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        this.mState = aData[0];
        if (aData.length > 2) {
            this.mDisplayedOutput = UT.Code.combine(aData[1], aData[2]);
        }
        if (aData.length > 4) {
            this.mDisplayedInput = UT.Code.combine(aData[3], aData[4]);
        }
        if (aData.length > 7) {
            this.mRGBa = UT.Code.getRGBInt(new short[]{UT.Code.unsignB(aData[5]), UT.Code.unsignB(aData[6]), UT.Code.unsignB(aData[7])});
        }
        return true;
    }

    @Override
    public void setVisualData(byte aData) {
        this.mState = aData;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        boolean tGlow = this.mMaterial.contains(TD.Properties.GLOWING);
        this.mTextureLegs = BlockTextureMulti.get(BlockTextureDefault.get(sTextureLegs, this.mRGBa, false, tGlow, false, false), BlockTextureDefault.get(sOverlayLegs));
        this.mTextureGrid = BlockTextureMulti.get(BlockTextureDefault.get(sTextureGrid, this.mRGBa, false, tGlow, false, false), BlockTextureDefault.get(sOverlayGrid));
        this.mTextureBorder = BlockTextureMulti.get(BlockTextureDefault.get(sTextureBorder, this.mRGBa, false, tGlow, false, false), BlockTextureDefault.get(sOverlayBorder));
        this.mTexturePlate = BlockTextureMulti.get(BlockTextureDefault.get(sTexturePlate, this.mRGBa, false, tGlow, false, false), BlockTextureDefault.get(sOverlayPlate));
        this.mTextureInput = MT.NULL.getTextureDust();
        this.mTextureOutput = MT.NULL.getTextureDust();
        if (this.mDisplayedInput != 0) {
            if (UT.Code.exists(this.mDisplayedInput, OreDictMaterial.MATERIAL_ARRAY)) {
                this.mTextureInput = OreDictMaterial.MATERIAL_ARRAY[this.mDisplayedInput].getTextureDust();
            } else if (this.mDisplayedInput < 0) {
                switch (this.mDisplayedInput) {
                    case -1: {
                        this.mTextureInput = BlockTextureCopied.get(Blocks.field_150351_n, 6, 0);
                        break;
                    }
                    case -2: {
                        this.mTextureInput = BlockTextureCopied.get(Blocks.field_150346_d, 6, 0);
                        break;
                    }
                    case -3: {
                        this.mTextureInput = BlockTextureCopied.get(Blocks.field_150346_d, 6, 1);
                        break;
                    }
                    case -4: {
                        this.mTextureInput = BlockTextureCopied.get(Blocks.field_150346_d, 6, 2);
                        break;
                    }
                    case -5: {
                        this.mTextureInput = BlockTextureCopied.get((Block)Blocks.field_150354_m, 6, 0);
                        break;
                    }
                    case -6: {
                        this.mTextureInput = BlockTextureCopied.get((Block)Blocks.field_150354_m, 6, 1);
                        break;
                    }
                    case -7: {
                        this.mTextureInput = BlockTextureCopied.get((Block)Blocks.field_150349_c, 6, 0, new short[]{106, 170, 64, 255}, false, false, false);
                        break;
                    }
                    case -8: {
                        this.mTextureInput = BlockTextureCopied.get((Block)Blocks.field_150391_bh, 6, 0);
                        break;
                    }
                    case -9: {
                        this.mTextureInput = BlockTextureCopied.get(Blocks.field_150425_aM, 6, 0);
                        break;
                    }
                    case -10: {
                        this.mTextureInput = BlockTextureCopied.get(CS.BlocksGT.Diggables, 6, 0);
                        break;
                    }
                    case -11: {
                        this.mTextureInput = BlockTextureCopied.get(CS.BlocksGT.Sands, 6, 0);
                    }
                }
            }
        }
        if (this.mDisplayedOutput != 0) {
            if (UT.Code.exists(this.mDisplayedOutput, OreDictMaterial.MATERIAL_ARRAY)) {
                this.mTextureOutput = OreDictMaterial.MATERIAL_ARRAY[this.mDisplayedOutput].getTextureDust();
            } else if (this.mDisplayedOutput < 0) {
                switch (this.mDisplayedOutput) {
                    case -1: {
                        this.mTextureOutput = BlockTextureCopied.get(Blocks.field_150351_n, 6, 0);
                        break;
                    }
                    case -2: {
                        this.mTextureOutput = BlockTextureCopied.get(Blocks.field_150346_d, 6, 0);
                        break;
                    }
                    case -3: {
                        this.mTextureOutput = BlockTextureCopied.get(Blocks.field_150346_d, 6, 1);
                        break;
                    }
                    case -4: {
                        this.mTextureOutput = BlockTextureCopied.get(Blocks.field_150346_d, 6, 2);
                        break;
                    }
                    case -5: {
                        this.mTextureOutput = BlockTextureCopied.get((Block)Blocks.field_150354_m, 6, 0);
                        break;
                    }
                    case -6: {
                        this.mTextureOutput = BlockTextureCopied.get((Block)Blocks.field_150354_m, 6, 1);
                        break;
                    }
                    case -7: {
                        this.mTextureOutput = BlockTextureCopied.get((Block)Blocks.field_150349_c, 6, 0, new short[]{106, 170, 64, 255}, false, false, false);
                        break;
                    }
                    case -8: {
                        this.mTextureOutput = BlockTextureCopied.get((Block)Blocks.field_150391_bh, 6, 0);
                        break;
                    }
                    case -9: {
                        this.mTextureOutput = BlockTextureCopied.get(Blocks.field_150425_aM, 6, 0);
                        break;
                    }
                    case -10: {
                        this.mTextureOutput = BlockTextureCopied.get(CS.BlocksGT.Diggables, 6, 0);
                        break;
                    }
                    case -11: {
                        this.mTextureOutput = BlockTextureCopied.get(CS.BlocksGT.Sands, 6, 0);
                    }
                }
            }
        }
        return 9;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[14], CS.PX_P[13], CS.PX_N[14]);
                return true;
            }
            case 1: {
                this.box(aBlock, CS.PX_P[14], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_P[13], CS.PX_N[14]);
                return true;
            }
            case 2: {
                this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[14], CS.PX_N[14], CS.PX_P[13], CS.PX_N[0]);
                return true;
            }
            case 3: {
                this.box(aBlock, CS.PX_P[14], CS.PX_P[0], CS.PX_P[14], CS.PX_N[0], CS.PX_P[13], CS.PX_N[0]);
                return true;
            }
            case 4: {
                this.box(aBlock, CS.PX_P[0], CS.PX_P[10], CS.PX_P[0], CS.PX_N[0], CS.PX_P[12], CS.PX_N[0]);
                return true;
            }
            case 5: {
                this.box(aBlock, CS.PX_N[0] - 1.0E-4f, CS.PX_P[12], CS.PX_N[0] - 1.0E-4f, CS.PX_P[0] + 1.0E-4f, CS.PX_P[10], CS.PX_P[0] + 1.0E-4f);
                return true;
            }
            case 6: {
                this.box(aBlock, CS.PX_P[0], CS.PX_P[2], CS.PX_P[0], CS.PX_N[0], CS.PX_P[5], CS.PX_N[0]);
                return true;
            }
            case 7: {
                this.box(aBlock, CS.PX_P[2], CS.PX_P[10] - 1.0E-4f, CS.PX_P[2], CS.PX_N[2], CS.PX_P[this.mDisplayedInput < 0 ? 16 : 14], CS.PX_N[2]);
                return true;
            }
            case 8: {
                this.box(aBlock, CS.PX_P[2], CS.PX_P[5], CS.PX_P[2], CS.PX_N[2], CS.PX_P[8], CS.PX_N[2]);
                return true;
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (aRenderPass == 0) {
            return CS.SIDES_TOP[aSide] ? BlockTextureMulti.get(this.mTextureLegs, BI.nei()) : this.mTextureLegs;
        }
        if (aRenderPass < 4) {
            return this.mTextureLegs;
        }
        if (aRenderPass < 6) {
            return CS.SIDES_VERTICAL[aSide] ? this.mTextureGrid : this.mTextureBorder;
        }
        return aRenderPass == 6 ? this.mTexturePlate : (aRenderPass == 7 ? ((this.mState & CS.B[0]) != 0 ? this.mTextureInput : null) : ((this.mState & CS.B[1]) != 0 ? (CS.SIDES_TOP_HORIZONTAL[aSide] ? this.mTextureOutput : null) : null));
    }

    @Override
    public int getLightOpacity() {
        return 3;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.box(CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[4], CS.PX_N[0]);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return this.box(CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[4], CS.PX_N[0]);
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[4], CS.PX_N[0]);
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return CS.SIDES_VERTICAL[aSide] ? 1.0f : 0.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return CS.SIDES_VERTICAL[aSide] ? 1.0f : 0.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return CS.SIDES_TOP[aSide] ? CS.PX_N[4] : 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return false;
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return false;
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return false;
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[13];
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return ACCESSIBLE_SLOTS;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        return aSlot == 0 && this.mRecipes != null && this.mRecipes.containsInput(aStack, (IHasWorldAndCoords)this, CS.NI);
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return aSlot != 0;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.sifter.table";
    }
}

