/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.render.BlockTextureDefault;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase11AttachmentSmall;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.machines.ITileEntityCrucible;
import gregapi.tileentity.machines.ITileEntityMold;
import gregapi.util.UT;
import gregapi.util.WD;
import gregtech.tileentity.tools.MultiTileEntityBathingPot;
import gregtech.tileentity.tools.MultiTileEntityMixingBowl;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.fluids.FluidStack;

public class MultiTileEntityFaucet
extends TileEntityBase11AttachmentSmall
implements ITileEntityMold {
    public static double HEAT_RESISTANCE_BONUS = 1.25;
    protected boolean mAcidProof = false;
    protected boolean mAutoPull = false;
    private ITexture mTexture;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.mode")) {
            this.mAutoPull = aNBT.func_74767_n("gt.mode");
        }
        if (aNBT.func_74764_b("gt.acidproof")) {
            this.mAcidProof = aNBT.func_74767_n("gt.acidproof");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.mode", this.mAutoPull);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.interact"));
        if (this.mAcidProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.acid"));
        }
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.meltdown") + " (" + this.getMoldMaxTemperature() + " K)");
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.monkey.wrench.to.toggle.auto.inputs"));
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide && (this.mAutoPull ? CS.SERVER_TIME % 20L == 5L : this.mBlockUpdated && this.hasRedstoneIncoming())) {
            DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(this.mFacing);
            if (tDelegator.mTileEntity instanceof ITileEntityCrucible) {
                ((ITileEntityCrucible)tDelegator.mTileEntity).fillMoldAtSide(this, tDelegator.mSideOfTileEntity, this.mFacing);
            }
        }
    }

    @Override
    public boolean isMoldInputSide(byte aSide) {
        return aSide == this.mFacing;
    }

    @Override
    public long getMoldMaxTemperature() {
        return (long)((double)this.mMaterial.mMeltingPoint * HEAT_RESISTANCE_BONUS);
    }

    @Override
    public long getMoldRequiredMaterialUnits() {
        DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity((byte)0);
        if (tDelegator.mTileEntity instanceof ITileEntityMold) {
            return ((ITileEntityMold)tDelegator.mTileEntity).getMoldRequiredMaterialUnits();
        }
        if (tDelegator.mTileEntity instanceof MultiTileEntityBathingPot || tDelegator.mTileEntity instanceof MultiTileEntityMixingBowl) {
            return 648648000L;
        }
        return 0L;
    }

    @Override
    public long fillMold(OreDictMaterialStack aMaterial, long aTemperature, byte aSide) {
        if (aSide != this.mFacing || aMaterial == null || aMaterial.mMaterial == null || !this.mAcidProof && aMaterial.mMaterial.contains(TD.Properties.ACID)) {
            return 0L;
        }
        if (aTemperature > this.getMoldMaxTemperature()) {
            UT.Sounds.send("random.fizz", this, false);
            this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)Blocks.field_150356_k, 1, 3);
        }
        DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity((byte)0);
        while (!(tDelegator.mY <= 0 || !(tDelegator.mTileEntity instanceof MultiTileEntityFaucet) && (tDelegator.mTileEntity instanceof MultiTileEntityBathingPot || tDelegator.mTileEntity instanceof MultiTileEntityMixingBowl || tDelegator.mTileEntity instanceof ITileEntityMold || WD.hasCollide(tDelegator.mWorld, tDelegator.mX, tDelegator.mY, tDelegator.mZ)))) {
            tDelegator = WD.te(tDelegator.mWorld, tDelegator.mX, tDelegator.mY - 1, tDelegator.mZ, (byte)1, false);
        }
        if (tDelegator.mTileEntity instanceof ITileEntityMold) {
            return ((ITileEntityMold)tDelegator.mTileEntity).fillMold(aMaterial, aTemperature, tDelegator.mSideOfTileEntity);
        }
        if (tDelegator.mTileEntity instanceof MultiTileEntityBathingPot || tDelegator.mTileEntity instanceof MultiTileEntityMixingBowl) {
            if (aMaterial.mAmount < 648648000L) {
                FluidStack tFluid = aMaterial.mMaterial.liquid(aMaterial.mAmount, false);
                if (FL.zero(tFluid)) {
                    return 0L;
                }
                if (FL.fillAll(tDelegator, tFluid, true)) {
                    return aMaterial.mAmount;
                }
            } else {
                FluidStack tFluid = aMaterial.mMaterial.liquid(648648000L, false);
                if (FL.zero(tFluid)) {
                    return 0L;
                }
                if (FL.fillAll(tDelegator, tFluid, true)) {
                    return 648648000L;
                }
            }
            return 0L;
        }
        return 0L;
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide()) {
            DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(this.mFacing);
            if (tDelegator.mTileEntity instanceof ITileEntityCrucible) {
                ((ITileEntityCrucible)tDelegator.mTileEntity).fillMoldAtSide(this, tDelegator.mSideOfTileEntity, this.mFacing);
            }
        }
        return true;
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        }
        if (aTool.equals("softhammer")) {
            this.mAutoPull = false;
            if (aChatReturn != null) {
                aChatReturn.add("Crucible Auto-Input: REDSTONE");
            }
            return 10000L;
        }
        if (aTool.equals("monkeywrench")) {
            boolean bl = this.mAutoPull = !this.mAutoPull;
            if (aChatReturn != null) {
                aChatReturn.add(this.mAutoPull ? "Crucible Auto-Input: AUTOMATIC" : "Crucible Auto-Input: REDSTONE");
            }
            return 10000L;
        }
        return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        this.mTexture = BlockTextureDefault.get(this.mMaterial, OP.blockSolid, UT.Code.getRGBaArray(this.mRGBa), this.mMaterial.contains(TD.Properties.GLOWING));
        return 3;
    }

    @Override
    public boolean usesRenderPass2(int aRenderPass, boolean[] aShouldSideBeRendered) {
        return true;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                switch (this.mFacing) {
                    case 2: {
                        this.box(aBlock, CS.PX_P[6], CS.PX_P[1], CS.PX_P[0], CS.PX_N[6], CS.PX_N[14], CS.PX_N[12]);
                        return true;
                    }
                    default: {
                        this.box(aBlock, CS.PX_P[6], CS.PX_P[1], CS.PX_P[12], CS.PX_N[6], CS.PX_N[14], CS.PX_N[0]);
                        return true;
                    }
                    case 4: {
                        this.box(aBlock, CS.PX_P[0], CS.PX_P[1], CS.PX_P[6], CS.PX_N[12], CS.PX_N[14], CS.PX_N[6]);
                        return true;
                    }
                    case 5: 
                }
                this.box(aBlock, CS.PX_P[12], CS.PX_P[1], CS.PX_P[6], CS.PX_N[0], CS.PX_N[14], CS.PX_N[6]);
                return true;
            }
            case 1: {
                switch (this.mFacing) {
                    case 2: {
                        this.box(aBlock, CS.PX_P[5], CS.PX_P[2], CS.PX_P[0], CS.PX_N[10], CS.PX_N[10], CS.PX_N[12]);
                        return true;
                    }
                    default: {
                        this.box(aBlock, CS.PX_P[5], CS.PX_P[2], CS.PX_P[12], CS.PX_N[10], CS.PX_N[10], CS.PX_N[0]);
                        return true;
                    }
                    case 4: {
                        this.box(aBlock, CS.PX_P[0], CS.PX_P[2], CS.PX_P[5], CS.PX_N[12], CS.PX_N[10], CS.PX_N[10]);
                        return true;
                    }
                    case 5: 
                }
                this.box(aBlock, CS.PX_P[12], CS.PX_P[2], CS.PX_P[5], CS.PX_N[0], CS.PX_N[10], CS.PX_N[10]);
                return true;
            }
            case 2: {
                switch (this.mFacing) {
                    case 2: {
                        this.box(aBlock, CS.PX_P[10], CS.PX_P[2], CS.PX_P[0], CS.PX_N[5], CS.PX_N[10], CS.PX_N[12]);
                        return true;
                    }
                    default: {
                        this.box(aBlock, CS.PX_P[10], CS.PX_P[2], CS.PX_P[12], CS.PX_N[5], CS.PX_N[10], CS.PX_N[0]);
                        return true;
                    }
                    case 4: {
                        this.box(aBlock, CS.PX_P[0], CS.PX_P[2], CS.PX_P[10], CS.PX_N[12], CS.PX_N[10], CS.PX_N[5]);
                        return true;
                    }
                    case 5: 
                }
                this.box(aBlock, CS.PX_P[12], CS.PX_P[2], CS.PX_P[10], CS.PX_N[0], CS.PX_N[10], CS.PX_N[5]);
                return true;
            }
        }
        return true;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aSide != this.mFacing || aShouldSideBeRendered[aSide] ? this.mTexture : null;
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        switch (this.mFacing) {
            case 2: {
                return this.box(CS.PX_P[5], CS.PX_P[1], CS.PX_P[0], CS.PX_N[5], CS.PX_N[10], CS.PX_N[12]);
            }
            default: {
                return this.box(CS.PX_P[5], CS.PX_P[1], CS.PX_P[12], CS.PX_N[5], CS.PX_N[10], CS.PX_N[0]);
            }
            case 4: {
                return this.box(CS.PX_P[0], CS.PX_P[1], CS.PX_P[5], CS.PX_N[12], CS.PX_N[10], CS.PX_N[5]);
            }
            case 5: 
        }
        return this.box(CS.PX_P[12], CS.PX_P[1], CS.PX_P[5], CS.PX_N[0], CS.PX_N[10], CS.PX_N[5]);
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        switch (this.mFacing) {
            case 2: {
                this.box(aBlock, CS.PX_P[5], CS.PX_P[1], CS.PX_P[0], CS.PX_N[5], CS.PX_N[10], CS.PX_N[12]);
                break;
            }
            default: {
                this.box(aBlock, CS.PX_P[5], CS.PX_P[1], CS.PX_P[12], CS.PX_N[5], CS.PX_N[10], CS.PX_N[0]);
                break;
            }
            case 4: {
                this.box(aBlock, CS.PX_P[0], CS.PX_P[1], CS.PX_P[5], CS.PX_N[12], CS.PX_N[10], CS.PX_N[5]);
                break;
            }
            case 5: {
                this.box(aBlock, CS.PX_P[12], CS.PX_P[1], CS.PX_P[5], CS.PX_N[0], CS.PX_N[10], CS.PX_N[5]);
            }
        }
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.smeltery.drain";
    }
}

