/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.sensors;

import gregapi.data.BI;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.render.IIconContainer;
import gregapi.tileentity.data.ITileEntityWeight;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.machines.MultiTileEntitySensorTE;
import gregapi.util.OM;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.tileentity.TileEntity;

public class MultiTileEntityWeightometerHeavy
extends MultiTileEntitySensorTE {
    public static final double MAX_WEIGHT;
    public static IIconContainer sTextureFront;
    public static IIconContainer sTextureBack;
    public static IIconContainer sTextureSide;
    public static IIconContainer sOverlayFront;
    public static IIconContainer sOverlayBack;
    public static IIconContainer sOverlaySide;

    @Override
    public String getSensorDescription() {
        return LH.get("gt.tooltip.sensor.heavyweightometer");
    }

    @Override
    public long getCurrentValue(DelegatorTileEntity<TileEntity> aDelegator) {
        double rWeightKG = 0.0;
        if (aDelegator.mTileEntity instanceof ITileEntityWeight) {
            rWeightKG = ((ITileEntityWeight)aDelegator.mTileEntity).getWeightValue(aDelegator.mSideOfTileEntity);
        } else if (aDelegator.mTileEntity instanceof IInventory) {
            if (aDelegator.mTileEntity instanceof ISidedInventory) {
                for (int i : ((ISidedInventory)aDelegator.mTileEntity).func_94128_d((int)aDelegator.mSideOfTileEntity)) {
                    if ((rWeightKG += OM.weight(((IInventory)aDelegator.mTileEntity).func_70301_a(i))) >= MAX_WEIGHT) break;
                }
            } else {
                int j = ((IInventory)aDelegator.mTileEntity).func_70302_i_();
                for (int i = 0; i < j && !((rWeightKG += OM.weight(((IInventory)aDelegator.mTileEntity).func_70301_a(i))) >= MAX_WEIGHT); ++i) {
                }
            }
        }
        if (rWeightKG >= MAX_WEIGHT) {
            rWeightKG = MAX_WEIGHT;
        }
        return (long)(rWeightKG / 1000.0);
    }

    @Override
    public long getCurrentMax(DelegatorTileEntity<TileEntity> aDelegator) {
        return CS.B[16] - 1;
    }

    @Override
    public short[] getSymbolColor() {
        return CS.CA_GRAY_192;
    }

    @Override
    public IIconContainer getSymbolIcon() {
        return BI.CHAR_TON;
    }

    @Override
    public IIconContainer getTextureFront() {
        return sTextureFront;
    }

    @Override
    public IIconContainer getTextureBack() {
        return sTextureBack;
    }

    @Override
    public IIconContainer getTextureSide() {
        return sTextureSide;
    }

    @Override
    public IIconContainer getOverlayFront() {
        return sOverlayFront;
    }

    @Override
    public IIconContainer getOverlayBack() {
        return sOverlayBack;
    }

    @Override
    public IIconContainer getOverlaySide() {
        return sOverlaySide;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.redstone.sensors.heavyweightometer";
    }

    static {
        LH.add("gt.tooltip.sensor.heavyweightometer", "Measures the weight of an Inventory (in Tons)");
        MAX_WEIGHT = (double)(CS.B[16] - 1) * 1000.0;
        sTextureFront = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/heavyweightometer/colored/front");
        sTextureBack = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/heavyweightometer/colored/back");
        sTextureSide = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/heavyweightometer/colored/side");
        sOverlayFront = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/heavyweightometer/overlay/front");
        sOverlayBack = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/heavyweightometer/overlay/back");
        sOverlaySide = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/heavyweightometer/overlay/side");
    }
}

