/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.portals;

import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.render.BlockTextureCopied;
import gregapi.render.ITexture;
import gregapi.util.ST;
import gregapi.util.WD;
import gregtech.tileentity.portals.MultiTileEntityMiniPortal;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class MultiTileEntityMiniPortalCW2Caveland
extends MultiTileEntityMiniPortal {
    public static List<MultiTileEntityMiniPortal> sListCW2Side = new ArrayListNoNulls<MultiTileEntityMiniPortal>();
    public static List<MultiTileEntityMiniPortal> sListWorldSide = new ArrayListNoNulls<MultiTileEntityMiniPortal>();
    public ITexture sCW2Portal = BlockTextureCopied.get(ST.block(MD.CW2, "caveland_portal", (Block)Blocks.field_150427_aO), 6, 0, CS.UNCOLOURED, false, true, true);
    public ITexture sCW2PortalFrame = BlockTextureCopied.get(Blocks.field_150341_Y, 6, 0);

    @Override
    public List<MultiTileEntityMiniPortal> getPortalListA() {
        return sListWorldSide;
    }

    @Override
    public List<MultiTileEntityMiniPortal> getPortalListB() {
        return sListCW2Side;
    }

    @Override
    public void addToolTips2(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.tileentity.portal.caveland.tooltip.1"));
        aList.add(LH.Chat.CYAN + LH.get("gt.tileentity.portal.caveland.tooltip.2"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.requirement.ignite.fire"));
    }

    @Override
    public void findTargetPortal() {
        block4: {
            block5: {
                this.mTarget = null;
                if (this.field_145850_b == null || !this.isServerSide()) break block4;
                if (this.field_145850_b.field_73011_w.field_76574_g != 0) break block5;
                long tShortestDistance = 16384L;
                for (MultiTileEntityMiniPortal tTarget : sListCW2Side) {
                    if (tTarget == this || tTarget.isDead()) continue;
                    long tXDifference = this.field_145851_c - tTarget.field_145851_c;
                    long tZDifference = this.field_145849_e - tTarget.field_145849_e;
                    long tTempDist = tXDifference * tXDifference + tZDifference * tZDifference;
                    if (tTempDist < tShortestDistance) {
                        tShortestDistance = tTempDist;
                        this.mTarget = tTarget;
                        continue;
                    }
                    if (tTempDist != tShortestDistance || this.mTarget != null && Math.abs(tTarget.field_145848_d - this.field_145848_d) >= Math.abs(this.mTarget.field_145848_d - this.field_145848_d)) continue;
                    this.mTarget = tTarget;
                }
                break block4;
            }
            if (!WD.dimCW2Caveland(this.field_145850_b)) break block4;
            long tShortestDistance = 16384L;
            for (MultiTileEntityMiniPortal tTarget : sListWorldSide) {
                if (tTarget == this || tTarget.isDead()) continue;
                long tXDifference = tTarget.field_145851_c - this.field_145851_c;
                long tZDifference = tTarget.field_145849_e - this.field_145849_e;
                long tTempDist = tXDifference * tXDifference + tZDifference * tZDifference;
                if (tTempDist < tShortestDistance) {
                    tShortestDistance = tTempDist;
                    this.mTarget = tTarget;
                    continue;
                }
                if (tTempDist != tShortestDistance || this.mTarget != null && Math.abs(tTarget.field_145848_d - this.field_145848_d) >= Math.abs(this.mTarget.field_145848_d - this.field_145848_d)) continue;
                this.mTarget = tTarget;
            }
        }
    }

    @Override
    public void addThisPortalToLists() {
        if (this.field_145850_b != null && this.isServerSide()) {
            if (this.field_145850_b.field_73011_w.field_76574_g == 0) {
                if (!sListWorldSide.contains(this)) {
                    sListWorldSide.add(this);
                }
                for (MultiTileEntityMiniPortal tPortal : sListCW2Side) {
                    tPortal.findTargetPortal();
                }
                this.findTargetPortal();
            } else if (WD.dimCW2Caveland(this.field_145850_b)) {
                if (!sListCW2Side.contains(this)) {
                    sListCW2Side.add(this);
                }
                for (MultiTileEntityMiniPortal tPortal : sListWorldSide) {
                    tPortal.findTargetPortal();
                }
                this.findTargetPortal();
            } else {
                this.setPortalInactive();
            }
        }
    }

    @Override
    public long onToolClick(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return super.onToolClick(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        }
        if (aTool.equals("igniter")) {
            if (this.mActive) {
                this.setPortalInactive();
            } else {
                this.setPortalActive();
            }
            if (this.mTarget != null && aChatReturn != null) {
                aChatReturn.add("X: " + this.mTarget.field_145851_c + "   Y: " + this.mTarget.field_145848_d + "   Z: " + this.mTarget.field_145849_e);
            }
            return 10000L;
        }
        if (aTool.equals("extinguisher")) {
            if (this.mActive) {
                this.setPortalInactive();
            }
            return 10000L;
        }
        return super.onToolClick(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public float getBlockHardness() {
        return Blocks.field_150341_Y.func_149712_f(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public float getExplosionResistance2() {
        return Blocks.field_150341_Y.func_149638_a(null);
    }

    @Override
    public ITexture getPortalTexture() {
        return this.sCW2Portal;
    }

    @Override
    public ITexture getFrameTexture() {
        return this.sCW2PortalFrame;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.portal.caveland";
    }

    static {
        LH.add("gt.tileentity.portal.caveland.tooltip.1", "Only works between Caveland and the Overworld!");
        LH.add("gt.tileentity.portal.caveland.tooltip.2", "Margin of Error to still work: 128 Meters.");
    }
}

