/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.inventories;

import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityKeyInteractable;
import gregapi.tileentity.inventories.MultiTileEntitySafe;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class MultiTileEntitySafeKeyLocked
extends MultiTileEntitySafe
implements ITileEntityKeyInteractable {
    public long mID = 0L;
    public boolean mOpened = false;
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/safes/keylocked/colored/front"), new Textures.BlockIcons.CustomIcon("machines/safes/keylocked/colored/back"), new Textures.BlockIcons.CustomIcon("machines/safes/keylocked/colored/side")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/safes/keylocked/overlay/front"), new Textures.BlockIcons.CustomIcon("machines/safes/keylocked/overlay/back"), new Textures.BlockIcons.CustomIcon("machines/safes/keylocked/overlay/side")};
    public static IIconContainer[] sColoredsOpen = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/safes/keylocked/colored_open/front"), new Textures.BlockIcons.CustomIcon("machines/safes/keylocked/colored_open/back"), new Textures.BlockIcons.CustomIcon("machines/safes/keylocked/colored_open/side")};
    public static IIconContainer[] sOverlaysOpen = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/safes/keylocked/overlay_open/front"), new Textures.BlockIcons.CustomIcon("machines/safes/keylocked/overlay_open/back"), new Textures.BlockIcons.CustomIcon("machines/safes/keylocked/overlay_open/side")};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.key")) {
            this.mID = aNBT.func_74763_f("gt.key");
        }
        if (aNBT.func_74764_b("gt.open")) {
            this.mOpened = aNBT.func_74767_n("gt.open");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.key", this.mID);
        UT.NBT.setBoolean(aNBT, "gt.open", this.mOpened);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.key.controlled"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public boolean allowInteraction(Entity aEntity) {
        return this.mOpened;
    }

    @Override
    public boolean useKey(EntityPlayer aPlayer, byte aSide, float hitX, float hitY, float hitZ, long ... aKeys) {
        if (aKeys.length <= 0 || !this.isServerSide()) {
            return false;
        }
        for (long tID : aKeys) {
            if (this.mID == 0L) {
                this.mID = tID;
            }
            if (this.mID == 0L || tID != this.mID) continue;
            this.mOpened = !this.mOpened;
            this.updateClientData();
            UT.Sounds.send("random.click", 1.0f, 0.25f, this, false);
            return true;
        }
        return false;
    }

    @Override
    public boolean canCloneKey(EntityPlayer aPlayer, byte aSide, float hitX, float hitY, float hitZ) {
        return this.mOpened && this.mID != 0L;
    }

    @Override
    public long getKeyID() {
        return this.mID;
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        return aSendAll ? this.getClientDataPacketByteArray(aSendAll, (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa), this.getDirectionData(), this.getVisualData()) : this.getClientDataPacketByte(aSendAll, this.getVisualData());
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        this.mRGBa = UT.Code.getRGBInt(new short[]{UT.Code.unsignB(aData[0]), UT.Code.unsignB(aData[1]), UT.Code.unsignB(aData[2])});
        this.setDirectionData(aData[3]);
        this.setVisualData(aData[4]);
        return true;
    }

    @Override
    public byte getVisualData() {
        return (byte)(this.mOpened ? 1 : 0);
    }

    @Override
    public void setVisualData(byte aData) {
        this.mOpened = aData != 0;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (!aShouldSideBeRendered[aSide]) {
            return null;
        }
        int aIndex = aSide == this.mFacing ? 0 : (aSide == CS.OPOS[this.mFacing] ? 1 : 2);
        return BlockTextureMulti.get(BlockTextureDefault.get((this.mOpened ? sColoredsOpen : sColoreds)[aIndex], this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)), BlockTextureDefault.get((this.mOpened ? sOverlaysOpen : sOverlays)[aIndex]));
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.safe.keylocked";
    }
}

