/*
 * Decompiled with CFR 0.152.
 */
package gregtech.blocks.stone;

import gregapi.block.BlockBaseMeta;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.old.Textures;
import gregapi.oredict.OreDictMaterial;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.WD;
import gregapi.worldgen.StoneLayer;
import gregapi.worldgen.StoneLayerOres;
import java.util.ArrayList;
import mods.railcraft.common.carts.EntityTunnelBore;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockRockOres
extends BlockBaseMeta {
    public static byte[] HARVEST_LEVELS = new byte[]{0, 0, 1, 1, 2, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0};
    public static int[] BURN_LEVELS = new int[]{30, 30, 0, 0, 0, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static float[] HARDNESS_LEVELS = new float[]{0.5f, 0.5f, 1.0f, 1.0f, 2.0f, 0.5f, 0.5f, 1.0f, 1.0f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f};
    public static OreDictMaterial[] ORE_MATERIALS = new OreDictMaterial[]{MT.Coal, MT.Lignite, MT.NaCl, MT.KCl, MT.OREMATS.Bauxite, MT.Oilshale, MT.Gypsum, MT.MilkyQuartz, MT.NetherQuartz, MT.NULL, MT.NULL, MT.NULL, MT.NULL, MT.NULL, MT.NULL, MT.NULL};

    public BlockRockOres(String aUnlocalised) {
        super(null, aUnlocalised, Material.field_151576_e, field_149769_e, 9L, Textures.BlockIcons.ROCK_ORES);
        LH.add(this.func_149739_a() + ".0", "Anthracite Coal");
        LH.add(this.func_149739_a() + ".1", "Lignite Coal");
        LH.add(this.func_149739_a() + ".2", "Salt");
        LH.add(this.func_149739_a() + ".3", "Sylvite");
        LH.add(this.func_149739_a() + ".4", "Bauxite");
        LH.add(this.func_149739_a() + ".5", "Oil Shale");
        LH.add(this.func_149739_a() + ".6", "Gypsum");
        LH.add(this.func_149739_a() + ".7", "Milky Quartz");
        LH.add(this.func_149739_a() + ".8", "Nether Quartz");
        for (int i = 0; i < this.maxMeta(); ++i) {
            OM.reg(ST.make(this, 1L, (long)i), OP.oreDense.dat(ORE_MATERIALS[i]));
        }
        if (CS.COMPAT_IC2 != null) {
            CS.COMPAT_IC2.valuable(this, 0, 1);
            CS.COMPAT_IC2.valuable(this, 1, 1);
            CS.COMPAT_IC2.valuable(this, 2, 1);
            CS.COMPAT_IC2.valuable(this, 3, 1);
            CS.COMPAT_IC2.valuable(this, 4, 2);
            CS.COMPAT_IC2.valuable(this, 5, 2);
            CS.COMPAT_IC2.valuable(this, 6, 1);
            CS.COMPAT_IC2.valuable(this, 7, 2);
            CS.COMPAT_IC2.valuable(this, 8, 2);
            CS.COMPAT_IC2.valuable(this, 9, 0);
            CS.COMPAT_IC2.valuable(this, 10, 0);
            CS.COMPAT_IC2.valuable(this, 11, 0);
            CS.COMPAT_IC2.valuable(this, 12, 0);
            CS.COMPAT_IC2.valuable(this, 13, 0);
            CS.COMPAT_IC2.valuable(this, 14, 0);
            CS.COMPAT_IC2.valuable(this, 15, 0);
        }
        CS.BlocksGT.drillableDynamite.add(this);
        CS.BlocksGT.harvestableJackhammer.add(this);
        StoneLayer.LAYERS.add(new StoneLayer((Block)this, 0L, ORE_MATERIALS[0], new StoneLayerOres[0]).setNoDeep());
        StoneLayer.LAYERS.add(new StoneLayer((Block)this, 1L, ORE_MATERIALS[1], new StoneLayerOres[0]).setNoDeep());
        StoneLayer.LAYERS.add(new StoneLayer((Block)this, 2L, ORE_MATERIALS[2], new StoneLayerOres[0]).setNoDeep());
        StoneLayer.LAYERS.add(new StoneLayer((Block)this, 3L, ORE_MATERIALS[3], new StoneLayerOres[0]).setNoDeep());
        StoneLayer.LAYERS.add(new StoneLayer((Block)this, 4L, ORE_MATERIALS[4], new StoneLayerOres[0]).setNoDeep());
        StoneLayer.LAYERS.add(new StoneLayer((Block)this, 5L, ORE_MATERIALS[5], new StoneLayerOres[0]).setNoDeep());
        StoneLayer.LAYERS.add(new StoneLayer((Block)this, 6L, ORE_MATERIALS[6], new StoneLayerOres[0]).setNoDeep());
        StoneLayer.LAYERS.add(new StoneLayer((Block)this, 7L, ORE_MATERIALS[7], new StoneLayerOres[0]).setNoDeep());
        if (MD.RC.mLoaded) {
            try {
                EntityTunnelBore.addMineableBlock((Block)this);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        if (CS.COMPAT_FR != null) {
            CS.COMPAT_FR.addToBackpacks("miner", ST.make(this, 1L, 32767L));
        }
    }

    public ArrayList<ItemStack> getDrops(World aWorld, int aX, int aY, int aZ, int aMeta, int aFortune) {
        return ST.arraylist(OP.oreRaw.mat(ORE_MATERIALS[aMeta], aFortune > 0 ? (long)(2 + CS.RNGSUS.nextInt(aFortune * 2 + 2)) : 2L));
    }

    public int getExpDrop(IBlockAccess aWorld, int aMeta, int aFortune) {
        return CS.RNGSUS.nextInt(8) == 0 ? 1 : 0;
    }

    @Override
    public boolean useGravity(byte aMeta) {
        return false;
    }

    @Override
    public boolean doesWalkSpeed(byte aMeta) {
        return false;
    }

    @Override
    public boolean doesPistonPush(byte aMeta) {
        return true;
    }

    @Override
    public boolean canSilkHarvest(byte aMeta) {
        return true;
    }

    @Override
    public boolean canCreatureSpawn(byte aMeta) {
        return true;
    }

    @Override
    public boolean isSealable(byte aMeta, byte aSide) {
        return false;
    }

    @Override
    public String getHarvestTool(int aMeta) {
        return "pickaxe";
    }

    @Override
    public int getHarvestLevel(int aMeta) {
        return HARVEST_LEVELS[aMeta];
    }

    @Override
    public int getFlammability(byte aMeta) {
        return BURN_LEVELS[aMeta];
    }

    @Override
    public int getFireSpreadSpeed(byte aMeta) {
        return 0;
    }

    @Override
    public float func_149712_f(World aWorld, int aX, int aY, int aZ) {
        return Blocks.field_150348_b.func_149712_f(aWorld, aX, aY, aZ) * HARDNESS_LEVELS[WD.meta((IBlockAccess)aWorld, aX, aY, aZ)];
    }

    @Override
    public float getExplosionResistance(byte aMeta) {
        return Blocks.field_150348_b.func_149638_a(null);
    }
}

