/*
 * Decompiled with CFR 0.152.
 */
package gregtech.asm;

import cpw.mods.fml.relauncher.FMLRelaunchLog;
import cpw.mods.fml.relauncher.IFMLCallHook;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import gregtech.asm.GT_ASM_Dummy;
import gregtech.asm.transformers.CoFHCore_CrashFix;
import gregtech.asm.transformers.CoFHLib_HashFix;
import gregtech.asm.transformers.ExtraUtils_FixThaumcraftAspects;
import gregtech.asm.transformers.MicroBlock_FixLoggerCrash;
import gregtech.asm.transformers.Minecraft_EmptyRecipeOptimization;
import gregtech.asm.transformers.Minecraft_Feature_CreeperSwellToward;
import gregtech.asm.transformers.Minecraft_IceHarvestMissingHookFix;
import gregtech.asm.transformers.Minecraft_LavaFlammableFix;
import gregtech.asm.transformers.Minecraft_RemoveCartSpeedCap;
import gregtech.asm.transformers.Minecraft_ZombieVillagerConversion;
import gregtech.asm.transformers.MultiPart_FixLoggerCrash;
import gregtech.asm.transformers.Railcraft_RemoveBoreSpam;
import gregtech.asm.transformers.Technomancy_ExtremelySlowLoadFix;
import gregtech.asm.transformers.Thaumcraft_AspectLagFix;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

@IFMLLoadingPlugin.Name(value="Greg-ASM\u00ae")
@IFMLLoadingPlugin.MCVersion(value="1.7.10")
@IFMLLoadingPlugin.SortingIndex(value=1000)
@IFMLLoadingPlugin.TransformerExclusions(value={"gregtech.asm"})
public class GT_ASM
implements IFMLLoadingPlugin {
    public static File location;
    public static ClassLoader classLoader;
    public static final Logger logger;

    public void injectData(Map<String, Object> data) {
        location = (File)data.get("coremodLocation");
        ASMConfig config = new ASMConfig((File)data.get("mcLocation"));
        LaunchClassLoader tClassLoader = (LaunchClassLoader)Thread.currentThread().getContextClassLoader();
        for (Map.Entry<String, Boolean> entry : config.transformers.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            String transformer = entry.getKey();
            FMLRelaunchLog.finer((String)"Registering transformer %s", (Object[])new Object[]{transformer});
            tClassLoader.registerTransformer(transformer);
        }
    }

    public String[] getASMTransformerClass() {
        return null;
    }

    public String getModContainerClass() {
        return GT_ASM_Dummy.class.getName();
    }

    public String getSetupClass() {
        return Setup.class.getName();
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public static String getPrettyPrintedOpCodes(ClassNode classNode) {
        PrinterClassVisitor printer = new PrinterClassVisitor();
        classNode.accept((ClassVisitor)printer);
        return printer.out_writer.toString();
    }

    public static void writePrettyPrintedOpCodesToFile(ClassNode classNode, String fileName) {
        try {
            new BufferedWriter(new FileWriter(fileName, true)).append(GT_ASM.getPrettyPrintedOpCodes(classNode)).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ClassNode makeNodes(byte[] aBasicClass) {
        ClassNode rClassNode = new ClassNode();
        ClassReader classReader = new ClassReader(aBasicClass);
        classReader.accept((ClassVisitor)rClassNode, 0);
        return rClassNode;
    }

    public static byte[] writeByteArray(ClassNode aClassNode) {
        ClassWriter rWriter = new ClassWriter(3);
        aClassNode.accept((ClassVisitor)rWriter);
        return rWriter.toByteArray();
    }

    public static byte[] writeByteArraySelfReferenceFixup(ClassNode aClassNode) {
        ClassWriter writer = new ClassWriter(3){

            protected String getCommonSuperClass(String type1, String type2) {
                Class<?> d;
                Class<?> c;
                try {
                    c = Class.forName(type1.replace('/', '.'), false, classLoader);
                    d = Class.forName(type2.replace('/', '.'), false, classLoader);
                }
                catch (Exception e) {
                    return "java/lang/Object";
                }
                if (c.isAssignableFrom(d)) {
                    return type1;
                }
                if (d.isAssignableFrom(c)) {
                    return type2;
                }
                if (c.isInterface() || d.isInterface()) {
                    return "java/lang/Object";
                }
                while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
                }
                return c.getName().replace('.', '/');
            }
        };
        aClassNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    static {
        logger = LogManager.getLogger((String)GT_ASM.class.getSimpleName());
    }

    static class PrinterClassVisitor
    extends ClassVisitor {
        public StringWriter out_writer = new StringWriter();

        public PrinterClassVisitor() {
            super(327680);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            this.out_writer.write("Method: " + name + desc + "\n");
            Textifier p = new Textifier(327680){

                public void visitMethodEnd() {
                    this.print(new PrintWriter(out_writer));
                }
            };
            return new TraceMethodVisitor((Printer)p);
        }
    }

    private static class ASMConfig {
        private boolean dirty = false;
        public LinkedHashMap<String, Boolean> transformers = new LinkedHashMap();

        public ASMConfig(File mclocation) {
            if (mclocation == null) {
                throw new RuntimeException("Failed to acquire `location` in GT6 CoreMod");
            }
            this.transformers.put(MultiPart_FixLoggerCrash.class.getName(), true);
            this.transformers.put(MicroBlock_FixLoggerCrash.class.getName(), true);
            this.transformers.put(CoFHCore_CrashFix.class.getName(), true);
            this.transformers.put(CoFHLib_HashFix.class.getName(), true);
            this.transformers.put(ExtraUtils_FixThaumcraftAspects.class.getName(), true);
            this.transformers.put(Minecraft_EmptyRecipeOptimization.class.getName(), true);
            this.transformers.put(Minecraft_Feature_CreeperSwellToward.class.getName(), true);
            this.transformers.put(Minecraft_IceHarvestMissingHookFix.class.getName(), true);
            this.transformers.put(Minecraft_LavaFlammableFix.class.getName(), true);
            this.transformers.put(Minecraft_RemoveCartSpeedCap.class.getName(), true);
            this.transformers.put(Minecraft_ZombieVillagerConversion.class.getName(), true);
            this.transformers.put(Railcraft_RemoveBoreSpam.class.getName(), true);
            this.transformers.put(Technomancy_ExtremelySlowLoadFix.class.getName(), true);
            this.transformers.put(Thaumcraft_AspectLagFix.class.getName(), true);
            mclocation = new File(mclocation, "/config/gregtech");
            mclocation.mkdirs();
            mclocation = new File(mclocation, "/asm.ini");
            if (!mclocation.exists()) {
                try {
                    PrintWriter out = new PrintWriter(mclocation);
                    this.outputConfig(out);
                    out.close();
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Unable to write GT6 ASM config file at: " + mclocation, e);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to write to GT6 ASM config file at: " + mclocation, e);
                }
            }
            try {
                BufferedReader in = new BufferedReader(new FileReader(mclocation));
                this.loadConfig(in);
                in.close();
                if (this.dirty) {
                    PrintWriter out = new PrintWriter(mclocation);
                    this.outputConfig(out);
                    out.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading GT6 ASM config file at: " + mclocation, e);
            }
        }

        private void outputConfig(Writer out) throws IOException {
            out.write("# ASM Transformers, `true` to enable, `false` to disable\n");
            for (Map.Entry<String, Boolean> entry : this.transformers.entrySet()) {
                out.write("transformer:" + entry.getKey() + " = " + entry.getValue() + "\n");
            }
        }

        private void loadConfig(BufferedReader in) throws IOException {
            String line;
            int lineno = 0;
            int transformersInserted = 0;
            while ((line = in.readLine()) != null) {
                line = line.trim();
                ++lineno;
                if (line.startsWith("transformer:")) {
                    boolean enabled;
                    String kw = line.substring(12);
                    String[] kwa = kw.split("=");
                    if (kwa.length != 2) {
                        throw new RuntimeException("Invalid Configuration entry in GT6 ASM configuration file, line " + lineno + ": " + line);
                    }
                    String classname = kwa[0].trim();
                    boolean bl = enabled = !kwa[1].contains("false");
                    if (this.transformers.containsKey(classname)) {
                        this.transformers.put(classname, enabled);
                        ++transformersInserted;
                        continue;
                    }
                    FMLRelaunchLog.warning((String)"Invalid configuration entry classname of %s at line %s", (Object[])new Object[]{classname, Integer.toString(lineno)});
                    this.dirty = true;
                    continue;
                }
                if (line.startsWith("#") || line.trim().equals("")) continue;
                this.dirty = true;
            }
            if (transformersInserted != this.transformers.size()) {
                this.dirty = true;
            }
        }
    }

    public static class Setup
    implements IFMLCallHook {
        public void injectData(Map<String, Object> data) {
            classLoader = (ClassLoader)data.get("classLoader");
        }

        public Void call() throws Exception {
            return null;
        }
    }
}

