/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.connectors;

import gregapi.GT_API_Proxy;
import gregapi.block.multitileentity.MultiTileEntityBlock;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.TagData;
import gregapi.cover.CoverData;
import gregapi.cover.covers.CoverFilterItem;
import gregapi.data.ANY;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.old.Textures;
import gregapi.oredict.OreDictManager;
import gregapi.oredict.OreDictMaterial;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityAdjacentInventoryUpdatable;
import gregapi.tileentity.ITileEntityQuickObstructionCheck;
import gregapi.tileentity.ITileEntityServerTickPre;
import gregapi.tileentity.connectors.ITileEntityItemPipe;
import gregapi.tileentity.connectors.TileEntityBase09Connector;
import gregapi.tileentity.connectors.TileEntityBase10ConnectorRendered;
import gregapi.tileentity.data.ITileEntityProgress;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.delegate.ITileEntityCanDelegate;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityHopper;

public class MultiTileEntityPipeItem
extends TileEntityBase10ConnectorRendered
implements ITileEntityQuickObstructionCheck,
ITileEntityProgress,
ITileEntityItemPipe,
ITileEntityServerTickPre {
    public long mTransferredItems = 0L;
    public long mStepSize = 1L;
    public byte mLastReceivedFrom = (byte)6;
    public byte oLastReceivedFrom = (byte)6;
    public byte mRenderType = 0;
    public byte mDisabledOutputs = 0;
    public byte mDisabledInputs = 0;
    public boolean mBlocking = false;
    private boolean mHasToAddTimer = true;
    protected int[] ACCESSIBLE_SLOTS;

    public static void addItemPipes(int aID, int aCreativeTabID, long aStepSize, int aInvSize, boolean aRecipe, boolean aBlocking, MultiTileEntityRegistry aRegistry, MultiTileEntityBlock aBlock, Class<? extends TileEntity> aClass, OreDictMaterial aMat) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3;
        Object[] objectArray4;
        Object[] objectArray5;
        Object[] objectArray6;
        String string = aMat.getLocal() + " Item Pipe";
        byte by = aMat.mToolQuality;
        NBTTagCompound nBTTagCompound = UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(2.0f), "gt.resistance", Float.valueOf(6.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PX_P[8]), "gt.pipesize", aStepSize, "gt.invsize", aInvSize, "gt.opaque", aBlocking);
        if (aRecipe) {
            Object[] objectArray7 = new Object[4];
            objectArray7[0] = "PPP";
            objectArray7[1] = "wzh";
            objectArray7[2] = Character.valueOf('P');
            objectArray6 = objectArray7;
            objectArray7[3] = OP.plateCurved.dat(aMat);
        } else {
            objectArray6 = CS.ZL;
        }
        OreDictManager.INSTANCE.setTarget_(OP.pipeMedium, aMat, aRegistry.add(string, "Item Pipes", aID + 2, aCreativeTabID, aClass, by, 64, aBlock, nBTTagCompound, objectArray6), true, false, true);
        String string2 = "Large " + aMat.getLocal() + " Item Pipe";
        byte by2 = aMat.mToolQuality;
        NBTTagCompound nBTTagCompound2 = UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(2.0f), "gt.resistance", Float.valueOf(6.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PX_P[12]), "gt.pipesize", aStepSize / 2L, "gt.invsize", aInvSize * 2, "gt.opaque", aBlocking);
        if (aRecipe) {
            Object[] objectArray8 = new Object[5];
            objectArray8[0] = "PPP";
            objectArray8[1] = "wzh";
            objectArray8[2] = "PPP";
            objectArray8[3] = Character.valueOf('P');
            objectArray5 = objectArray8;
            objectArray8[4] = OP.plateCurved.dat(aMat);
        } else {
            objectArray5 = CS.ZL;
        }
        OreDictManager.INSTANCE.setTarget_(OP.pipeLarge, aMat, aRegistry.add(string2, "Item Pipes", aID + 3, aCreativeTabID, aClass, by2, 32, aBlock, nBTTagCompound2, objectArray5), true, false, true);
        String string3 = "Huge " + aMat.getLocal() + " Item Pipe";
        byte by3 = aMat.mToolQuality;
        NBTTagCompound nBTTagCompound3 = UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(2.0f), "gt.resistance", Float.valueOf(6.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PX_P[16]), "gt.pipesize", aStepSize / 4L, "gt.invsize", aInvSize * 4, "gt.opaque", aBlocking);
        if (aRecipe) {
            Object[] objectArray9 = new Object[5];
            objectArray9[0] = "PPP";
            objectArray9[1] = "wzh";
            objectArray9[2] = "PPP";
            objectArray9[3] = Character.valueOf('P');
            objectArray4 = objectArray9;
            objectArray9[4] = OP.plateDouble.dat(aMat);
        } else {
            objectArray4 = CS.ZL;
        }
        OreDictManager.INSTANCE.setTarget_(OP.pipeHuge, aMat, aRegistry.add(string3, "Item Pipes", aID + 4, aCreativeTabID, aClass, by3, 16, aBlock, nBTTagCompound3, objectArray4), true, false, true);
        String string4 = "Restrictive " + aMat.getLocal() + " Item Pipe";
        byte by4 = aMat.mToolQuality;
        NBTTagCompound nBTTagCompound4 = UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(2.0f), "gt.resistance", Float.valueOf(6.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 1, "gt.diameter", Float.valueOf(CS.PX_P[8]), "gt.pipesize", aStepSize * 100L, "gt.invsize", aInvSize, "gt.opaque", aBlocking);
        if (aRecipe) {
            Object[] objectArray10 = new Object[7];
            objectArray10[0] = " h ";
            objectArray10[1] = "RPR";
            objectArray10[2] = " R ";
            objectArray10[3] = Character.valueOf('P');
            objectArray10[4] = OP.pipeMedium.dat(aMat);
            objectArray10[5] = Character.valueOf('R');
            objectArray3 = objectArray10;
            objectArray10[6] = OP.ring.dat(ANY.Steel);
        } else {
            objectArray3 = CS.ZL;
        }
        OreDictManager.INSTANCE.setTarget_(OP.pipeRestrictiveMedium, aMat, aRegistry.add(string4, "Item Pipes", aID + 5, aCreativeTabID, aClass, by4, 64, aBlock, nBTTagCompound4, objectArray3), true, false, true);
        String string5 = "Restrictive Large " + aMat.getLocal() + " Item Pipe";
        byte by5 = aMat.mToolQuality;
        NBTTagCompound nBTTagCompound5 = UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(2.0f), "gt.resistance", Float.valueOf(6.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 1, "gt.diameter", Float.valueOf(CS.PX_P[12]), "gt.pipesize", aStepSize * 50L, "gt.invsize", aInvSize * 2, "gt.opaque", aBlocking);
        if (aRecipe) {
            Object[] objectArray11 = new Object[7];
            objectArray11[0] = "hR ";
            objectArray11[1] = "RPR";
            objectArray11[2] = " R ";
            objectArray11[3] = Character.valueOf('P');
            objectArray11[4] = OP.pipeLarge.dat(aMat);
            objectArray11[5] = Character.valueOf('R');
            objectArray2 = objectArray11;
            objectArray11[6] = OP.ring.dat(ANY.Steel);
        } else {
            objectArray2 = CS.ZL;
        }
        OreDictManager.INSTANCE.setTarget_(OP.pipeRestrictiveLarge, aMat, aRegistry.add(string5, "Item Pipes", aID + 6, aCreativeTabID, aClass, by5, 32, aBlock, nBTTagCompound5, objectArray2), true, false, true);
        String string6 = "Restrictive Huge " + aMat.getLocal() + " Item Pipe";
        byte by6 = aMat.mToolQuality;
        NBTTagCompound nBTTagCompound6 = UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(2.0f), "gt.resistance", Float.valueOf(6.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 1, "gt.diameter", Float.valueOf(CS.PX_P[16]), "gt.pipesize", aStepSize * 25L, "gt.invsize", aInvSize * 4, "gt.opaque", aBlocking);
        if (aRecipe) {
            Object[] objectArray12 = new Object[7];
            objectArray12[0] = " h ";
            objectArray12[1] = "RPR";
            objectArray12[2] = "RRR";
            objectArray12[3] = Character.valueOf('P');
            objectArray12[4] = OP.pipeHuge.dat(aMat);
            objectArray12[5] = Character.valueOf('R');
            objectArray = objectArray12;
            objectArray12[6] = OP.ring.dat(ANY.Steel);
        } else {
            objectArray = CS.ZL;
        }
        OreDictManager.INSTANCE.setTarget_(OP.pipeRestrictiveHuge, aMat, aRegistry.add(string6, "Item Pipes", aID + 7, aCreativeTabID, aClass, by6, 16, aBlock, nBTTagCompound6, objectArray), true, false, true);
    }

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.opaque")) {
            this.mBlocking = aNBT.func_74767_n("gt.opaque");
        }
        if (aNBT.func_74764_b("gt.olast")) {
            this.oLastReceivedFrom = aNBT.func_74771_c("gt.olast");
        }
        if (aNBT.func_74764_b("gt.mlast")) {
            this.mLastReceivedFrom = aNBT.func_74771_c("gt.mlast");
        }
        if (aNBT.func_74764_b("gt.input")) {
            this.mDisabledInputs = aNBT.func_74771_c("gt.input");
        }
        if (aNBT.func_74764_b("gt.output")) {
            this.mDisabledOutputs = aNBT.func_74771_c("gt.output");
        }
        if (aNBT.func_74764_b("gt.mtransfer")) {
            this.mTransferredItems = aNBT.func_74763_f("gt.mtransfer");
        }
        if (aNBT.func_74764_b("gt.pipesize")) {
            this.mStepSize = aNBT.func_74763_f("gt.pipesize");
        }
        if (aNBT.func_74764_b("gt.piperender")) {
            this.mRenderType = aNBT.func_74771_c("gt.piperender");
        }
        if (this.field_145850_b != null && this.isServerSide() && this.mHasToAddTimer) {
            GT_API_Proxy.SERVER_TICK_PRE.add(this);
            GT_API_Proxy.SERVER_TICK_PR2.add(this);
            this.mHasToAddTimer = false;
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        aNBT.func_74774_a("gt.olast", this.oLastReceivedFrom);
        aNBT.func_74774_a("gt.mlast", this.mLastReceivedFrom);
        aNBT.func_74774_a("gt.input", this.mDisabledInputs);
        aNBT.func_74774_a("gt.output", this.mDisabledOutputs);
        UT.NBT.setNumber(aNBT, "gt.mtransfer", this.mTransferredItems);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.pipe.stats.stepsize") + UT.Code.makeString(this.mStepSize));
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.pipe.stats.bandwidth") + LH.Chat.WHITE + UT.Code.makeString(this.getPipeCapacity()) + "/s");
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.monkey.wrench.to.set.input.side"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.monkey.wrench.to.set.output.side"));
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        byte aTargetSide;
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("monkeywrench")) {
            byte aTargetSide2 = UT.Code.getSideWrenching(aSide, aHitX, aHitY, aHitZ);
            if (this.getAdjacentTileEntity((byte)aTargetSide2).mTileEntity instanceof ITileEntityItemPipe) {
                if (aChatReturn != null) {
                    aChatReturn.add("Will not work between two Item Pipes!");
                }
                return 0L;
            }
            if (CS.FACE_CONNECTED[aTargetSide2][this.mDisabledInputs]) {
                if (CS.FACE_CONNECTED[aTargetSide2][this.mDisabledOutputs]) {
                    this.mDisabledInputs = (byte)(this.mDisabledInputs ^ CS.B[aTargetSide2]);
                    this.mDisabledOutputs = (byte)(this.mDisabledOutputs ^ CS.B[aTargetSide2]);
                } else {
                    this.mDisabledOutputs = (byte)(this.mDisabledOutputs ^ CS.B[aTargetSide2]);
                }
            } else if (CS.FACE_CONNECTED[aTargetSide2][this.mDisabledOutputs]) {
                this.mDisabledInputs = (byte)(this.mDisabledInputs ^ CS.B[aTargetSide2]);
                this.mDisabledOutputs = (byte)(this.mDisabledOutputs ^ CS.B[aTargetSide2]);
            } else {
                this.mDisabledOutputs = (byte)(this.mDisabledOutputs ^ CS.B[aTargetSide2]);
            }
            if (aChatReturn != null) {
                aChatReturn.add(CS.FACE_CONNECTED[aTargetSide2][this.mDisabledInputs] ? "Accepting from selected Side disabled" : "Accepting from selected Side enabled");
                aChatReturn.add(CS.FACE_CONNECTED[aTargetSide2][this.mDisabledOutputs] ? "Emitting to selected Side disabled" : "Emitting to selected Side enabled");
            }
            return 2500L;
        }
        if (aTool.equals("magnifyingglass") && !this.isCovered(aTargetSide = UT.Code.getSideWrenching(aSide, aHitX, aHitY, aHitZ))) {
            if (aChatReturn != null) {
                aChatReturn.add(CS.FACE_CONNECTED[aTargetSide][this.mDisabledInputs] ? "Accepting from selected Side disabled" : "Accepting from selected Side enabled");
                aChatReturn.add(CS.FACE_CONNECTED[aTargetSide][this.mDisabledOutputs] ? "Emitting to selected Side disabled" : "Emitting to selected Side enabled");
            }
            return 1L;
        }
        return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public void onUnregisterPre() {
        this.mHasToAddTimer = true;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide && this.mHasToAddTimer) {
            GT_API_Proxy.SERVER_TICK_PRE.add(this);
            GT_API_Proxy.SERVER_TICK_PR2.add(this);
            this.mHasToAddTimer = false;
        }
    }

    @Override
    public void onCoordinateChange() {
        super.onCoordinateChange();
        GT_API_Proxy.SERVER_TICK_PRE.remove(this);
        GT_API_Proxy.SERVER_TICK_PR2.remove(this);
        this.onUnregisterPre();
    }

    @Override
    public void onServerTickPre(boolean aFirst) {
        if (aFirst) {
            if (CS.SERVER_TIME % 20L == 0L) {
                this.mTransferredItems = 0L;
            }
        } else if (CS.SERVER_TIME % 10L == 0L) {
            if (this.oLastReceivedFrom == this.mLastReceivedFrom) {
                boolean tUpdate = false;
                ArrayListNoNulls<ITileEntityItemPipe> tPipeList = new ArrayListNoNulls<ITileEntityItemPipe>();
                boolean temp = true;
                block0: while (temp && UT.Code.containsSomething(this.getInventory()) && this.pipeCapacityCheck()) {
                    temp = false;
                    tPipeList.clear();
                    for (ITileEntityItemPipe tTileEntity : UT.Code.sortByValuesAcending(ITileEntityItemPipe.Util.scanPipes(this, new HashMap<ITileEntityItemPipe, Long>(), 0L, false, false)).keySet()) {
                        if (temp) continue block0;
                        ((ArrayList)tPipeList).add(tTileEntity);
                        while (!temp && UT.Code.containsSomething(this.getInventory()) && tTileEntity.sendItemStack(this)) {
                            tUpdate = true;
                            for (ITileEntityItemPipe tPipe : tPipeList) {
                                if (tPipe.incrementTransferCounter(1L)) continue;
                                temp = true;
                            }
                        }
                    }
                }
                if (tUpdate) {
                    DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(this.mLastReceivedFrom);
                    if (tDelegator.mTileEntity instanceof ITileEntityAdjacentInventoryUpdatable) {
                        ((ITileEntityAdjacentInventoryUpdatable)tDelegator.mTileEntity).adjacentInventoryUpdated(tDelegator.mSideOfTileEntity, this);
                    }
                }
            }
            if (!UT.Code.containsSomething(this.getInventory())) {
                this.mLastReceivedFrom = (byte)6;
            }
            this.oLastReceivedFrom = this.mLastReceivedFrom;
        }
    }

    @Override
    public boolean insertItemStackIntoTileEntity(Object aSender, byte aSide) {
        DelegatorTileEntity<TileEntity> tDelegator;
        if (!CS.FACE_CONNECTED[aSide][this.mDisabledOutputs] && this.canEmitItemsTo(aSide, aSender) && ST.canConnect(tDelegator = this.getAdjacentTileEntity(aSide)) && !(tDelegator.mTileEntity instanceof TileEntityBase09Connector) && (!(tDelegator.mTileEntity instanceof TileEntityHopper) && !(tDelegator.mTileEntity instanceof TileEntityDispenser) || this.getMetaDataAtSide(aSide) != tDelegator.mSideOfTileEntity)) {
            CoverData tCovers = this.getCoverData();
            if (tCovers != null && tCovers.mBehaviours[aSide] instanceof CoverFilterItem && tCovers.mNBTs[aSide] != null) {
                ItemStack tStack = ST.load(tCovers.mNBTs[aSide], "gt.filter.item");
                return ST.valid(tStack) && ST.move(new DelegatorTileEntity<TileEntity>((TileEntity)aSender, 6), tDelegator, ST.hashset(tStack), false, false, tCovers.mVisuals[aSide] != 0, true, 64, 1, 64, 1) > 0;
            }
            return ST.move(new DelegatorTileEntity<TileEntity>((TileEntity)aSender, 6), tDelegator) > 0;
        }
        return false;
    }

    @Override
    public boolean incrementTransferCounter(long aIncrement) {
        this.mTransferredItems += aIncrement;
        return this.pipeCapacityCheck();
    }

    @Override
    public boolean sendItemStack(Object aSender) {
        if (this.pipeCapacityCheck()) {
            byte j = (byte)this.rng(6);
            for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                if (!this.insertItemStackIntoTileEntity(aSender, (byte)((i + j) % 6))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean pipeCapacityCheck() {
        return this.mTransferredItems <= 0L || this.getPipeContent() < this.getMaxPipeCapacity();
    }

    @Override
    public long getStepSize() {
        return this.mStepSize;
    }

    protected long getPipeContent() {
        return this.mTransferredItems;
    }

    protected long getMaxPipeCapacity() {
        return Math.max(1L, this.getPipeCapacity());
    }

    protected long getPipeCapacity() {
        return this.invsize();
    }

    @Override
    public void onConnectionChange(byte aPreviousConnections) {
        for (byte tSide : CS.ALL_SIDES_VALID) {
            DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(tSide);
            if (!(tDelegator.mTileEntity instanceof ITileEntityAdjacentInventoryUpdatable)) continue;
            ((ITileEntityAdjacentInventoryUpdatable)tDelegator.mTileEntity).adjacentInventoryUpdated(tDelegator.mSideOfTileEntity, this);
        }
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return this.ACCESSIBLE_SLOTS;
    }

    @Override
    public int getMinimumInventorySize() {
        return 1;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public boolean isObstructingBlockAt(byte aSide) {
        return this.mBlocking;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        if (!this.connected(aSide) || CS.FACE_CONNECTED[aSide][this.mDisabledInputs]) {
            return false;
        }
        if (!UT.Code.containsSomething(this.getInventory())) {
            this.mLastReceivedFrom = aSide;
        }
        return this.mLastReceivedFrom == aSide && !this.slotHas(aSlot);
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return CS.SIDES_INVALID[aSide] || this.connected(aSide);
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        ItemStack[] rStack = super.getDefaultInventory(aNBT);
        this.ACCESSIBLE_SLOTS = new int[rStack.length];
        for (int i = 0; i < this.ACCESSIBLE_SLOTS.length; ++i) {
            this.ACCESSIBLE_SLOTS[i] = i;
        }
        return rStack;
    }

    @Override
    public boolean canEmitItemsTo(byte aSide, Object aSender) {
        return (aSender != this || aSide != this.mLastReceivedFrom) && this.connected(aSide);
    }

    @Override
    public boolean canAcceptItemsFrom(byte aSide, Object aSender) {
        return this.connected(aSide);
    }

    @Override
    public boolean canConnect(byte aSide, DelegatorTileEntity<TileEntity> aDelegator) {
        return aDelegator.mTileEntity instanceof ISidedInventory ? aDelegator.mTileEntity instanceof ITileEntityCanDelegate || ((ISidedInventory)aDelegator.mTileEntity).func_94128_d((int)aDelegator.mSideOfTileEntity).length > 0 : ST.canConnect(aDelegator);
    }

    @Override
    public long getProgressValue(byte aSide) {
        return this.getPipeContent() * 64L;
    }

    @Override
    public long getProgressMax(byte aSide) {
        return this.getMaxPipeCapacity() * 64L;
    }

    @Override
    public ITexture getTextureSide(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        BlockTextureDefault tBase = BlockTextureDefault.get(this.mMaterial, this.getIconIndexSide(aSide, aConnections, aDiameter, aRenderPass), this.mIsGlowing, this.mRGBa);
        switch (this.mRenderType) {
            case 1: {
                return BlockTextureMulti.get(tBase, BlockTextureDefault.get(Textures.BlockIcons.PIPE_RESTRICTOR));
            }
        }
        return tBase;
    }

    @Override
    public ITexture getTextureConnected(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        BlockTextureDefault tBase = BlockTextureDefault.get(this.mMaterial, this.getIconIndexConnected(aSide, aConnections, aDiameter, aRenderPass), this.mIsGlowing, this.mRGBa);
        switch (this.mRenderType) {
            case 1: {
                return BlockTextureMulti.get(tBase, BlockTextureDefault.get(Textures.BlockIcons.PIPE_RESTRICTOR));
            }
        }
        return tBase;
    }

    @Override
    public int getIconIndexSide(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return CS.IconsGT.INDEX_BLOCK_PIPE_SIDE;
    }

    @Override
    public int getIconIndexConnected(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return aDiameter < 0.37f ? OP.pipeTiny.mIconIndexBlock : (aDiameter < 0.49f ? OP.pipeSmall.mIconIndexBlock : (aDiameter < 0.74f ? OP.pipeMedium.mIconIndexBlock : (aDiameter < 0.99f ? OP.pipeLarge.mIconIndexBlock : OP.pipeHuge.mIconIndexBlock)));
    }

    @Override
    public Collection<TagData> getConnectorTypes(byte aSide) {
        return TD.Connectors.PNEUMATIC_ITEM.AS_LIST;
    }

    @Override
    public String getFacingTool() {
        return "wrench";
    }

    @Override
    public boolean isUsingWrenchingOverlay(ItemStack aStack, byte aSide) {
        return super.isUsingWrenchingOverlay(aStack, aSide) || CS.ToolsGT.contains("monkeywrench", aStack);
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.connector.pipe.item";
    }
}

