/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes.maps;

import gregapi.data.CS;
import gregapi.data.TD;
import gregapi.oredict.OreDictItemData;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraftforge.fluids.FluidStack;

public class RecipeMapScannerMolecular
extends Recipe.RecipeMap {
    public RecipeMapScannerMolecular(Collection<Recipe> aRecipeList, String aUnlocalizedName, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aMinimalInputs, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed, boolean aNeedsOutputs, boolean aCombinePower, boolean aUseBucketSizeIn, boolean aUseBucketSizeOut) {
        super(aRecipeList, aUnlocalizedName, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, aMinimalInputs, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, false, aShowVoltageAmperageInNEI, aNEIAllowed, aConfigAllowed, aNeedsOutputs, aCombinePower, aUseBucketSizeIn, aUseBucketSizeOut);
    }

    @Override
    public Recipe findRecipe(IHasWorldAndCoords aTileEntity, Recipe aRecipe, boolean aNotUnificated, long aSize, ItemStack aSpecialSlot, FluidStack[] aFluids, ItemStack ... aInputs) {
        Recipe rRecipe = super.findRecipe(aTileEntity, aRecipe, aNotUnificated, aSize, aSpecialSlot, aFluids, aInputs);
        if (rRecipe != null || aInputs == null || aInputs.length < 2 || aInputs[0] == null || aInputs[1] == null || CS.GAPI_POST.mFinishedServerStarted <= 0) {
            return rRecipe;
        }
        ItemStack tUSB = null;
        ItemStack tScanned = null;
        for (ItemStack aInput : aInputs) {
            if (!ST.valid(aInput)) continue;
            if (ST.invalid(tUSB) && OM.is_(CS.OD_USB_STICKS[3], aInput)) {
                tUSB = aInput;
            } else {
                tScanned = aInput;
            }
            if (!ST.valid(tUSB) || !ST.valid(tScanned)) continue;
            assert (tScanned != null);
            OreDictItemData aData = OM.anydata_(tScanned);
            if (aData.mPrefix != null && aData.mMaterial != null && aData.mMaterial.mMaterial.mID > 0 && aData.mPrefix.contains(TD.Prefix.SCANNABLE)) {
                rRecipe = new Recipe(false, false, false, ST.array(ST.amount(1L, tScanned), ST.amount(1L, tUSB)), ST.array(ST.amount(1L, tUSB)), null, null, null, null, (aData.mMaterial.mMaterial.mProtons + aData.mMaterial.mMaterial.mNeutrons) * 512L, 512L, 0L);
                if (!rRecipe.mOutputs[0].func_77942_o()) {
                    rRecipe.mOutputs[0].func_77982_d(UT.NBT.make());
                }
                rRecipe.mOutputs[0].func_77978_p().func_74782_a("gt.usb.data", (NBTBase)UT.NBT.makeShort("gt.replicator.data", aData.mMaterial.mMaterial.mID));
                rRecipe.mOutputs[0].func_77978_p().func_74774_a("gt.usb.tier", (byte)3);
                return rRecipe;
            }
            return rRecipe;
        }
        return rRecipe;
    }

    @Override
    public boolean containsInput(ItemStack aStack, IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
        return super.containsInput(aStack, aTileEntity, aSpecialSlot) || OM.is(CS.OD_USB_STICKS[3], aStack) || OM.prefixcontains(aStack, TD.Prefix.SCANNABLE);
    }
}

