/*
 * Decompiled with CFR 0.152.
 */
package gregapi.player;

import gregapi.code.ArrayListNoNulls;
import gregapi.damage.DamageSources;
import gregapi.data.CS;
import gregapi.util.UT;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class EntityFoodTracker
implements IExtendedEntityProperties {
    public static ArrayListNoNulls<EntityFoodTracker> TICK_LIST = new ArrayListNoNulls();
    public byte mAlcohol = 0;
    public byte mCaffeine = 0;
    public byte mDehydration = 0;
    public byte mSugar = 0;
    public byte mFat = 0;
    public byte mRadiation = 0;
    public final EntityLivingBase mEntity;

    public EntityFoodTracker(EntityLivingBase aEntity) {
        this.mEntity = aEntity;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        NBTTagCompound tNBT = UT.NBT.make();
        if (this.mAlcohol != 0) {
            tNBT.func_74774_a("a", this.mAlcohol);
        }
        if (this.mCaffeine != 0) {
            tNBT.func_74774_a("c", this.mCaffeine);
        }
        if (this.mSugar != 0) {
            tNBT.func_74774_a("s", this.mSugar);
        }
        if (this.mDehydration != 0) {
            tNBT.func_74774_a("d", this.mDehydration);
        }
        if (this.mFat != 0) {
            tNBT.func_74774_a("f", this.mFat);
        }
        if (this.mRadiation != 0) {
            tNBT.func_74774_a("r", this.mRadiation);
        }
        if (tNBT.func_82582_d()) {
            aNBT.func_82580_o("gt.props.food");
        } else {
            aNBT.func_74782_a("gt.props.food", (NBTBase)tNBT);
        }
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        NBTTagCompound tNBT = aNBT.func_74775_l("gt.props.food");
        if (tNBT == null) {
            return;
        }
        this.mAlcohol = tNBT.func_74771_c("a");
        this.mCaffeine = tNBT.func_74771_c("c");
        this.mDehydration = tNBT.func_74771_c("d");
        this.mSugar = tNBT.func_74771_c("s");
        this.mFat = tNBT.func_74771_c("f");
        this.mRadiation = tNBT.func_74771_c("r");
    }

    public void init(Entity aEntity, World aWorld) {
        TICK_LIST.add(this);
    }

    public void changeAlcohol(long aAmount) {
        this.mAlcohol = UT.Code.bind7((long)this.mAlcohol + aAmount);
    }

    public void changeCaffeine(long aAmount) {
        this.mCaffeine = UT.Code.bind7((long)this.mCaffeine + aAmount);
    }

    public void changeDehydration(long aAmount) {
        this.mDehydration = UT.Code.bind7((long)this.mDehydration + aAmount);
    }

    public void changeSugar(long aAmount) {
        this.mSugar = UT.Code.bind7((long)this.mSugar + aAmount);
    }

    public void changeFat(long aAmount) {
        this.mFat = UT.Code.bind7((long)this.mFat + aAmount);
    }

    public void changeRadiation(long aAmount) {
        this.mRadiation = UT.Code.bind7((long)this.mRadiation + aAmount);
    }

    public static void tick() {
        if (CS.SERVER_TIME % 50L == 0L) {
            for (int i = 0; i < TICK_LIST.size(); ++i) {
                EntityFoodTracker tTracker = (EntityFoodTracker)TICK_LIST.get(i);
                if (tTracker.mEntity.field_70128_L) {
                    TICK_LIST.remove(i--);
                    continue;
                }
                if (tTracker.mAlcohol >= 100) {
                    if (CS.FOOD_OVERDOSE_DEATH || tTracker.mEntity.func_110143_aJ() >= 2.0f) {
                        tTracker.mEntity.func_70097_a(DamageSources.getAlcoholDamage(), CS.FOOD_OVERDOSE_DEATH ? 2.0f : 1.0f);
                    }
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76431_k, 1200, 2, false);
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76420_g, 300, 3, false);
                } else if (tTracker.mAlcohol >= 75) {
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76431_k, 1200, 1, false);
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76420_g, 300, 2, false);
                } else if (tTracker.mAlcohol >= 50) {
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76431_k, 1200, 0, false);
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76420_g, 300, 1, false);
                } else if (tTracker.mAlcohol >= 25) {
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76420_g, 300, 0, false);
                }
                if (tTracker.mCaffeine >= 100) {
                    if (CS.FOOD_OVERDOSE_DEATH || tTracker.mEntity.func_110143_aJ() >= 2.0f) {
                        tTracker.mEntity.func_70097_a(DamageSources.getCaffeineDamage(), CS.FOOD_OVERDOSE_DEATH ? 2.0f : 1.0f);
                    }
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76437_t, 1200, 2, false);
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76422_e, 300, 3, false);
                } else if (tTracker.mCaffeine >= 75) {
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76437_t, 1200, 1, false);
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76422_e, 300, 2, false);
                } else if (tTracker.mCaffeine >= 50) {
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76437_t, 1200, 0, false);
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76422_e, 300, 1, false);
                } else if (tTracker.mCaffeine >= 25) {
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76422_e, 300, 0, false);
                }
                if (tTracker.mRadiation >= 100) {
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, CS.PotionsGT.ID_RADIATION >= 0 ? CS.PotionsGT.ID_RADIATION : Potion.field_82731_v.field_76415_H, 100, 0, false);
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76431_k, 100, 2, false);
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76438_s, 100, 2, false);
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76421_d, 100, 2, false);
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76419_f, 100, 2, false);
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76437_t, 100, 2, false);
                } else if (tTracker.mRadiation >= 75) {
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, CS.PotionsGT.ID_RADIATION >= 0 ? CS.PotionsGT.ID_RADIATION : Potion.field_76436_u.field_76415_H, 100, 0, false);
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76431_k, 100, 1, false);
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76438_s, 100, 1, false);
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76421_d, 100, 1, false);
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76419_f, 100, 1, false);
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76437_t, 100, 1, false);
                } else if (tTracker.mRadiation >= 50) {
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, CS.PotionsGT.ID_RADIATION >= 0 ? CS.PotionsGT.ID_RADIATION : Potion.field_76436_u.field_76415_H, 100, 0, false);
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76431_k, 100, 0, false);
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76438_s, 100, 0, false);
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76421_d, 100, 0, false);
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76419_f, 100, 0, false);
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76437_t, 100, 0, false);
                } else if (tTracker.mRadiation >= 25) {
                    UT.Entities.applyPotion((Entity)tTracker.mEntity, CS.PotionsGT.ID_RADIATION >= 0 ? CS.PotionsGT.ID_RADIATION : Potion.field_76436_u.field_76415_H, 100, 0, false);
                }
                if (CS.NUTRITION_SYSTEM) {
                    if (tTracker.mFat >= 100) {
                        if (CS.FOOD_OVERDOSE_DEATH || tTracker.mEntity.func_110143_aJ() >= 2.0f) {
                            tTracker.mEntity.func_70097_a(DamageSources.getFatDamage(), CS.FOOD_OVERDOSE_DEATH ? 2.0f : 1.0f);
                        }
                        UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76421_d, 1200, 2, false);
                        UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76429_m, 300, 3, false);
                    } else if (tTracker.mFat >= 75) {
                        UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76421_d, 1200, 1, false);
                        UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76429_m, 300, 2, false);
                    } else if (tTracker.mFat >= 50) {
                        UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76421_d, 1200, 0, false);
                        UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76429_m, 300, 1, false);
                    } else if (tTracker.mFat >= 25) {
                        UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76429_m, 300, 0, false);
                    }
                    if (tTracker.mSugar >= 100) {
                        if (CS.FOOD_OVERDOSE_DEATH || tTracker.mEntity.func_110143_aJ() >= 2.0f) {
                            tTracker.mEntity.func_70097_a(DamageSources.getSugarDamage(), CS.FOOD_OVERDOSE_DEATH ? 2.0f : 1.0f);
                        }
                        UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76419_f, 1200, 2, false);
                        UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76424_c, 300, 3, false);
                        UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76430_j, 300, 3, false);
                    } else if (tTracker.mSugar >= 75) {
                        UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76419_f, 1200, 1, false);
                        UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76424_c, 300, 2, false);
                        UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76430_j, 300, 2, false);
                    } else if (tTracker.mSugar >= 50) {
                        UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76419_f, 1200, 0, false);
                        UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76424_c, 300, 1, false);
                        UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76430_j, 300, 1, false);
                    } else if (tTracker.mSugar >= 25) {
                        UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76424_c, 300, 0, false);
                        UT.Entities.applyPotion((Entity)tTracker.mEntity, Potion.field_76430_j, 300, 0, false);
                    }
                    if (tTracker.mDehydration >= 100) {
                        if (CS.FOOD_OVERDOSE_DEATH || tTracker.mEntity.func_110143_aJ() >= 2.0f) {
                            tTracker.mEntity.func_70097_a(DamageSources.getDehydrationDamage(), CS.FOOD_OVERDOSE_DEATH ? 2.0f : 1.0f);
                        }
                        UT.Entities.applyPotion((Entity)tTracker.mEntity, CS.PotionsGT.ID_DEHYDRATION >= 0 ? CS.PotionsGT.ID_DEHYDRATION : Potion.field_76438_s.field_76415_H, 1200, 3, false);
                    } else if (tTracker.mDehydration >= 75) {
                        UT.Entities.applyPotion((Entity)tTracker.mEntity, CS.PotionsGT.ID_DEHYDRATION >= 0 ? CS.PotionsGT.ID_DEHYDRATION : Potion.field_76438_s.field_76415_H, 1200, 2, false);
                    } else if (tTracker.mDehydration >= 50) {
                        UT.Entities.applyPotion((Entity)tTracker.mEntity, CS.PotionsGT.ID_DEHYDRATION >= 0 ? CS.PotionsGT.ID_DEHYDRATION : Potion.field_76438_s.field_76415_H, 1200, 1, false);
                    } else if (tTracker.mDehydration >= 25) {
                        UT.Entities.applyPotion((Entity)tTracker.mEntity, CS.PotionsGT.ID_DEHYDRATION >= 0 ? CS.PotionsGT.ID_DEHYDRATION : Potion.field_76438_s.field_76415_H, 1200, 0, false);
                    }
                }
                if (CS.SERVER_TIME % 100L != 0L) continue;
                if (tTracker.mAlcohol > 0) {
                    tTracker.mAlcohol = (byte)(tTracker.mAlcohol - 1);
                }
                if (tTracker.mCaffeine > 0) {
                    tTracker.mCaffeine = (byte)(tTracker.mCaffeine - 1);
                }
                if (tTracker.mDehydration > 0) {
                    tTracker.mDehydration = (byte)(tTracker.mDehydration - 1);
                }
                if (tTracker.mSugar > 0) {
                    tTracker.mSugar = (byte)(tTracker.mSugar - 1);
                }
                if (tTracker.mFat <= 0) continue;
                tTracker.mFat = (byte)(tTracker.mFat - 1);
            }
        }
    }

    public static void add(EntityLivingBase aEntity) {
        if (aEntity == null || aEntity.field_70170_p.field_72995_K) {
            return;
        }
        aEntity.registerExtendedProperties("gt.props.food", (IExtendedEntityProperties)new EntityFoodTracker(aEntity));
    }

    public static EntityFoodTracker get(Entity aEntity) {
        if (aEntity == null || aEntity.field_70170_p.field_72995_K) {
            return null;
        }
        IExtendedEntityProperties rTracker = aEntity.getExtendedProperties("gt.props.food");
        return rTracker instanceof EntityFoodTracker ? (EntityFoodTracker)rTracker : null;
    }
}

