/*
 * Decompiled with CFR 0.152.
 */
package gregapi.network.packets.data;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import gregapi.block.IBlockSyncData;
import gregapi.network.INetworkHandler;
import gregapi.network.packets.PacketCoordinates;
import gregapi.util.UT;
import net.minecraft.block.Block;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;

public class PacketSyncDataByteArray
extends PacketCoordinates {
    public byte[] mData;

    public PacketSyncDataByteArray(int aDecoderType) {
        super(aDecoderType);
    }

    public PacketSyncDataByteArray(int aX, int aY, int aZ, byte ... aData) {
        super(aX, aY, aZ);
        this.mData = aData;
    }

    public PacketSyncDataByteArray(ChunkCoordinates aCoords, byte ... aData) {
        super(aCoords);
        this.mData = aData;
    }

    @Override
    public byte getPacketIDOffset() {
        return -56;
    }

    @Override
    public ByteArrayDataOutput encode2(ByteArrayDataOutput aData) {
        aData.writeByte(this.mData.length);
        aData.write(this.mData);
        return aData;
    }

    @Override
    public PacketCoordinates decode2(int aX, int aY, int aZ, ByteArrayDataInput aData) {
        byte[] tData = new byte[UT.Code.unsignB(aData.readByte())];
        aData.readFully(tData);
        return new PacketSyncDataByteArray(aX, aY, aZ, tData);
    }

    @Override
    public void process(IBlockAccess aWorld, INetworkHandler aNetworkHandler) {
        Block tBlock;
        if (aWorld != null && (tBlock = aWorld.func_147439_a(this.mX, this.mY, this.mZ)) instanceof IBlockSyncData) {
            ((IBlockSyncData)tBlock).receiveDataByteArray(aWorld, this.mX, this.mY, this.mZ, this.mData, aNetworkHandler);
        }
    }
}

