/*
 * Decompiled with CFR 0.152.
 */
package gregapi.network.packets.covers;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import gregapi.block.IBlockSyncData;
import gregapi.cover.CoverData;
import gregapi.network.INetworkHandler;
import gregapi.network.packets.PacketCoordinates;
import gregapi.network.packets.ids.PacketSyncDataLongAndIDs;
import net.minecraft.block.Block;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;

public class PacketSyncDataLongAndIDsAndCovers
extends PacketSyncDataLongAndIDs {
    public short[] mCoverIDs;
    public short[] mCoverMetas;
    public short[] mCoverVisuals;

    public PacketSyncDataLongAndIDsAndCovers(int aDecoderType) {
        super(aDecoderType);
    }

    public PacketSyncDataLongAndIDsAndCovers(int aX, int aY, int aZ, short aID1, short aID2, long aData, CoverData aCoverData) {
        super(aX, aY, aZ, aID1, aID2, aData);
        this.mCoverIDs = aCoverData.mIDs;
        this.mCoverMetas = aCoverData.mMetas;
        this.mCoverVisuals = aCoverData.mVisuals;
    }

    public PacketSyncDataLongAndIDsAndCovers(ChunkCoordinates aCoords, short aID1, short aID2, long aData, CoverData aCoverData) {
        super(aCoords, aID1, aID2, aData);
        this.mCoverIDs = aCoverData.mIDs;
        this.mCoverMetas = aCoverData.mMetas;
        this.mCoverVisuals = aCoverData.mVisuals;
    }

    private PacketSyncDataLongAndIDsAndCovers(int aX, int aY, int aZ, short aID1, short aID2, long aData, ByteArrayDataInput aCovers) {
        super(aX, aY, aZ, aID1, aID2, aData);
        int i;
        this.mCoverIDs = new short[]{0, 0, 0, 0, 0, 0};
        this.mCoverMetas = new short[]{0, 0, 0, 0, 0, 0};
        this.mCoverVisuals = new short[]{0, 0, 0, 0, 0, 0};
        byte j = aCovers.readByte();
        for (i = 0; i < 6; i = (int)((byte)(i + 1))) {
            if ((j & 1 << i) == 0) continue;
            this.mCoverIDs[i] = aCovers.readShort();
            this.mCoverMetas[i] = aCovers.readShort();
            this.mCoverVisuals[i] = aCovers.readShort();
        }
        for (i = 0; i < 6; i = (int)((byte)(i + 1))) {
            if (this.mCoverIDs[i] == 0) continue;
            return;
        }
        this.mCoverIDs = null;
        this.mCoverMetas = null;
        this.mCoverVisuals = null;
    }

    @Override
    public byte getPacketIDOffset() {
        return 0;
    }

    @Override
    public ByteArrayDataOutput encode2(ByteArrayDataOutput aData) {
        int i;
        aData = super.encode2(aData);
        int tCoverBits = 0;
        if (this.mCoverIDs != null) {
            for (i = 0; i < 6; i = (int)((byte)(i + 1))) {
                if (this.mCoverIDs[i] <= 0) continue;
                tCoverBits = (byte)(tCoverBits | 1 << i);
            }
        }
        aData.writeByte(tCoverBits);
        if (this.mCoverIDs != null) {
            for (i = 0; i < 6; i = (int)((byte)(i + 1))) {
                if (this.mCoverIDs[i] <= 0) continue;
                aData.writeShort((int)this.mCoverIDs[i]);
                aData.writeShort((int)this.mCoverMetas[i]);
                aData.writeShort((int)this.mCoverVisuals[i]);
            }
        }
        return aData;
    }

    @Override
    public PacketCoordinates decode2(int aX, int aY, int aZ, ByteArrayDataInput aData) {
        return new PacketSyncDataLongAndIDsAndCovers(aX, aY, aZ, aData.readShort(), aData.readShort(), aData.readLong(), aData);
    }

    @Override
    public void process(IBlockAccess aWorld, INetworkHandler aNetworkHandler) {
        Block tBlock;
        if (aWorld != null && (tBlock = aWorld.func_147439_a(this.mX, this.mY, this.mZ)) instanceof IBlockSyncData.IBlockSyncDataAndCoversAndIDs) {
            ((IBlockSyncData.IBlockSyncDataAndCoversAndIDs)tBlock).receiveDataLong(aWorld, this.mX, this.mY, this.mZ, this.mData, aNetworkHandler, this.mID1, this.mID2, this.mCoverIDs, this.mCoverMetas, this.mCoverVisuals);
        }
    }
}

