/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.cover.CoverData;
import gregapi.cover.covers.AbstractCoverAttachment;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.ITexture;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class CoverRedstoneEmitter
extends AbstractCoverAttachment {
    public static final ITexture[] sTextures = new ITexture[]{BlockTextureDefault.get("machines/covers/redstoneemitter/0", true), BlockTextureDefault.get("machines/covers/redstoneemitter/1", true), BlockTextureDefault.get("machines/covers/redstoneemitter/2", true), BlockTextureDefault.get("machines/covers/redstoneemitter/3", true), BlockTextureDefault.get("machines/covers/redstoneemitter/4", true), BlockTextureDefault.get("machines/covers/redstoneemitter/5", true), BlockTextureDefault.get("machines/covers/redstoneemitter/6", true), BlockTextureDefault.get("machines/covers/redstoneemitter/7", true), BlockTextureDefault.get("machines/covers/redstoneemitter/8", true), BlockTextureDefault.get("machines/covers/redstoneemitter/9", true), BlockTextureDefault.get("machines/covers/redstoneemitter/10", true), BlockTextureDefault.get("machines/covers/redstoneemitter/11", true), BlockTextureDefault.get("machines/covers/redstoneemitter/12", true), BlockTextureDefault.get("machines/covers/redstoneemitter/13", true), BlockTextureDefault.get("machines/covers/redstoneemitter/14", true), BlockTextureDefault.get("machines/covers/redstoneemitter/15", true)};
    public static final ITexture sTexturesBase = BlockTextureDefault.get("machines/covers/redstoneemitter/underlay");

    @Override
    public long onToolClick(byte aSide, CoverData aData, String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        if (aTool.equals("cutter")) {
            aData.value(aSide, (short)(aData.mValues[aSide] ^ CS.B[0]), true);
            if (aChatReturn != null) {
                aChatReturn.add(aData.mValues[aSide] != 0 ? "Emits strong Redstone" : "Emits weak Redstone");
            }
            return 1000L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                aChatReturn.add(aData.mValues[aSide] != 0 ? "Emits strong Redstone" : "Emits weak Redstone");
            }
            return 1L;
        }
        return aData.mTileEntity.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSideClicked, aHitX, aHitY, aHitZ);
    }

    @Override
    public byte getRedstoneOutStrong(byte aCoverSide, CoverData aData, byte aDefaultRedstone) {
        return aData.mValues[aCoverSide] != 0 ? this.getRedstoneOutWeak(aCoverSide, aData, aDefaultRedstone) : (byte)0;
    }

    @Override
    public byte getRedstoneOutWeak(byte aCoverSide, CoverData aData, byte aDefaultRedstone) {
        return UT.Code.bind4(aData.mVisuals[aCoverSide]);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.cutter.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
    }

    @Override
    public boolean onCoverClickedRight(byte aSide, CoverData aData, Entity aPlayer, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        if (aSide == aSideClicked) {
            boolean rReturn = false;
            int tMode = UT.Code.bind4(aData.mVisuals[aSide]);
            float[] tCoords = UT.Code.getFacingCoordsClicked(aSideClicked, aHitX, aHitY, aHitZ);
            if (tCoords[1] >= CS.PX_P[1] && tCoords[1] <= CS.PX_P[4]) {
                if (tCoords[0] >= CS.PX_P[1] && tCoords[0] <= CS.PX_P[4]) {
                    if ((tMode = (byte)(tMode - 1)) < 0) {
                        tMode = 15;
                    }
                    rReturn = true;
                } else if (tCoords[0] >= CS.PX_N[4] && tCoords[0] <= CS.PX_N[1]) {
                    if ((tMode = (int)((byte)(tMode + 1))) > 15) {
                        tMode = 0;
                    }
                    rReturn = true;
                }
            } else if (tCoords[1] >= CS.PX_N[7] && tCoords[1] <= CS.PX_N[4] && tCoords[0] >= CS.PX_P[2] && tCoords[0] <= CS.PX_N[2]) {
                tMode = tCoords[0] <= CS.PX_P[5] ? (int)((byte)(tMode ^ 8)) : (tCoords[0] <= CS.PX_P[8] ? (int)((byte)(tMode ^ 4)) : (tCoords[0] <= CS.PX_N[5] ? (int)((byte)(tMode ^ 2)) : (int)((byte)(tMode ^ 1))));
                rReturn = true;
            }
            if (aData.mTileEntity.isServerSide()) {
                aData.visual(aSide, (short)tMode, true);
            }
            return rReturn;
        }
        return false;
    }

    @Override
    public ITexture getCoverTextureSurface(byte aSide, CoverData aData) {
        return BlockTextureMulti.get(sTexturesBase, sTextures[UT.Code.bind4(aData.mVisuals[aSide])]);
    }

    @Override
    public ITexture getCoverTextureAttachment(byte aSide, CoverData aData, byte aTextureSide) {
        return aSide != aTextureSide ? BACKGROUND_COVER : BlockTextureMulti.get(BACKGROUND_COVER, this.getCoverTextureSurface(aSide, aData));
    }

    @Override
    public ITexture getCoverTextureHolder(byte aSide, CoverData aData, byte aTextureSide) {
        return BACKGROUND_COVER;
    }

    @Override
    public boolean needsVisualsSaved(byte aSide, CoverData aData) {
        return true;
    }
}

