/*
 * Decompiled with CFR 0.152.
 */
package gregapi.code;

import gregapi.data.CS;
import gregapi.util.ST;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemStackContainer {
    public final Item mItem;
    public final Block mBlock;
    public final byte mStackSize;
    public final short mMetaData;

    public ItemStackContainer(Item aItem, long aStackSize, long aMetaData) {
        this.mItem = aItem;
        this.mBlock = ST.block(this.mItem);
        this.mStackSize = (byte)aStackSize;
        this.mMetaData = (short)aMetaData;
    }

    public ItemStackContainer(Block aBlock, long aStackSize, long aMetaData) {
        this.mBlock = aBlock;
        this.mItem = ST.item(this.mBlock);
        this.mStackSize = (byte)aStackSize;
        this.mMetaData = (short)aMetaData;
    }

    public ItemStackContainer(long aID, long aStackSize, long aMetaData) {
        this.mItem = ST.item(aID);
        this.mBlock = ST.block(this.mItem);
        this.mStackSize = (byte)aStackSize;
        this.mMetaData = (short)aMetaData;
    }

    public ItemStackContainer(ItemStack aStack) {
        if (aStack == null) {
            this.mItem = null;
            this.mBlock = CS.NB;
            this.mStackSize = 0;
            this.mMetaData = 0;
        } else {
            this.mItem = ST.item_(aStack);
            this.mBlock = ST.block_(this.mItem);
            this.mStackSize = (byte)aStack.field_77994_a;
            this.mMetaData = ST.meta_(aStack);
        }
    }

    public ItemStackContainer(ItemStack aStack, long aMetaData) {
        if (aStack == null) {
            this.mItem = null;
            this.mBlock = CS.NB;
            this.mStackSize = 0;
            this.mMetaData = 0;
        } else {
            this.mItem = ST.item_(aStack);
            this.mBlock = ST.block_(this.mItem);
            this.mStackSize = (byte)aStack.field_77994_a;
            this.mMetaData = (short)aMetaData;
        }
    }

    public ItemStackContainer(ItemStack aStack, long aStackSize, long aMetaData) {
        if (aStack == null) {
            this.mItem = null;
            this.mBlock = CS.NB;
            this.mStackSize = 0;
            this.mMetaData = 0;
        } else {
            this.mItem = ST.item_(aStack);
            this.mBlock = ST.block_(this.mItem);
            this.mStackSize = (byte)aStackSize;
            this.mMetaData = (short)aMetaData;
        }
    }

    public ItemStackContainer(int aHashCode) {
        this(ST.toItem(aHashCode), 0L, (long)ST.toMeta(aHashCode));
    }

    public ItemStack toStack() {
        return this.mItem == null ? null : ST.make(this.mItem, 1L, (long)this.mMetaData);
    }

    public boolean isStackEqual(ItemStack aStack) {
        return ST.equal(aStack, this.mItem, (long)this.mMetaData);
    }

    public boolean isStackEqual(ItemStackContainer aStack) {
        return aStack.mItem == this.mItem && ST.equal(aStack.mMetaData, this.mMetaData);
    }

    public boolean equals(Object aStack) {
        return aStack == this || aStack instanceof ItemStackContainer && ((ItemStackContainer)aStack).mItem == this.mItem && ((ItemStackContainer)aStack).mMetaData == this.mMetaData;
    }

    public int hashCode() {
        return ST.toInt(this.mItem, (long)this.mMetaData);
    }
}

