/*
 * Decompiled with CFR 0.152.
 */
package gregtech.worldgen.overworld;

import gregapi.data.CS;
import gregapi.data.MT;
import gregapi.util.WD;
import gregapi.worldgen.WorldgenObject;
import gregapi.worldgen.WorldgenOresBedrock;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class WorldgenColtan
extends WorldgenObject {
    public final short mMinY;
    public final short mMaxY;
    public final short mAmount;
    public final int mRange;

    @SafeVarargs
    public WorldgenColtan(String aName, boolean aDefault, int aMinY, int aMaxY, int aAmount, int aRange, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aLists);
        this.mMinY = (short)this.getConfigFile().get((Object)this.mCategory, "MinHeight", (long)aMinY);
        this.mMaxY = (short)Math.max(this.mMinY + 1, this.getConfigFile().get((Object)this.mCategory, "MaxHeight", (long)aMaxY));
        this.mAmount = (short)Math.max(1, this.getConfigFile().get((Object)this.mCategory, "Amount", (long)aAmount));
        this.mRange = Math.max(16, this.getConfigFile().get((Object)this.mCategory, "Range", (long)aRange));
    }

    @Override
    public boolean generate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        int i;
        Random tRandom = new Random(aWorld.getSeed() + 5L);
        int tX = (int)(tRandom.nextGaussian() * 1500.0);
        int tZ = (int)(tRandom.nextGaussian() * 1500.0);
        if (tX >> 4 == aMinX >> 4 && tZ >> 4 == aMinZ >> 4) {
            WorldgenOresBedrock.generateVein(MT.OREMATS.Coltan, aWorld, aDimType, aMinX, aMinZ, aRandom);
        }
        if (CS.GENERATING_SPECIAL) {
            return false;
        }
        int tDistance = (tX - aMinX) * (tX - aMinX) + (tZ - aMinZ) * (tZ - aMinZ);
        if (tDistance > this.mRange * this.mRange) {
            return false;
        }
        int j = Math.max(1, this.mAmount / 2 + aRandom.nextInt(1 + this.mAmount) / 2);
        block8: for (i = 0; i < j; ++i) {
            switch (aRandom.nextInt(5)) {
                default: {
                    WD.setSmallOre(aWorld, aMinX + aRandom.nextInt(16), this.mMinY + aRandom.nextInt(Math.max(1, this.mMaxY - this.mMinY)), aMinZ + aRandom.nextInt(16), MT.OREMATS.Coltan.mID);
                    continue block8;
                }
                case 0: {
                    WD.setSmallOre(aWorld, aMinX + aRandom.nextInt(16), this.mMinY + aRandom.nextInt(Math.max(1, this.mMaxY - this.mMinY)), aMinZ + aRandom.nextInt(16), MT.OREMATS.Columbite.mID);
                    continue block8;
                }
                case 1: {
                    WD.setSmallOre(aWorld, aMinX + aRandom.nextInt(16), this.mMinY + aRandom.nextInt(Math.max(1, this.mMaxY - this.mMinY)), aMinZ + aRandom.nextInt(16), MT.OREMATS.Tantalite.mID);
                }
            }
        }
        if (tDistance > 4096) {
            return true;
        }
        j = Math.max(1, this.mAmount / 2 + aRandom.nextInt(1 + this.mAmount) / 2);
        block9: for (i = 0; i < j; ++i) {
            switch (aRandom.nextInt(5)) {
                default: {
                    WD.setOre(aWorld, aMinX + aRandom.nextInt(16), this.mMinY + aRandom.nextInt(Math.max(1, this.mMaxY - this.mMinY)), aMinZ + aRandom.nextInt(16), MT.OREMATS.Coltan.mID);
                    continue block9;
                }
                case 0: {
                    WD.setOre(aWorld, aMinX + aRandom.nextInt(16), this.mMinY + aRandom.nextInt(Math.max(1, this.mMaxY - this.mMinY)), aMinZ + aRandom.nextInt(16), MT.OREMATS.Columbite.mID);
                    continue block9;
                }
                case 1: {
                    WD.setOre(aWorld, aMinX + aRandom.nextInt(16), this.mMinY + aRandom.nextInt(Math.max(1, this.mMaxY - this.mMinY)), aMinZ + aRandom.nextInt(16), MT.OREMATS.Tantalite.mID);
                }
            }
        }
        return true;
    }
}

