/*
 * Decompiled with CFR 0.152.
 */
package gregtech.worldgen.nether;

import gregapi.data.CS;
import gregapi.util.WD;
import gregapi.worldgen.WorldgenObject;
import gregtech.worldgen.NoiseGenerator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class WorldgenNetherCrystals
extends WorldgenObject {
    @SafeVarargs
    public WorldgenNetherCrystals(String aName, boolean aDefault, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aLists);
    }

    @Override
    public boolean generate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        if (aRandom.nextBoolean() || aBiomeNames.contains("Crystalline Crag")) {
            return false;
        }
        int aX = aMinX + aRandom.nextInt(16);
        int aY = WD.waterLevel(aWorld);
        int aZ = aMinZ + aRandom.nextInt(16);
        int aMeta = new NoiseGenerator(aWorld).get(aX / 2, 360.0f, aZ / 2, CS.BlocksGT.CrystalOres.maxMeta());
        while (WD.air(aWorld, aX, ++aY, aZ) && aY < aWorld.getHeight()) {
        }
        Block tBlock = WD.block((IBlockAccess)aWorld, aX, aY, aZ);
        if (tBlock == Blocks.nether_brick || tBlock.getMaterial() != Material.rock) {
            return false;
        }
        if (--aY - 10 < WD.waterLevel(aWorld)) {
            return false;
        }
        aWorld.setBlock(aX, aY, aZ, (Block)CS.BlocksGT.CrystalOres, aMeta, 2);
        for (int i = 0; i < 1500; ++i) {
            int tZ;
            int tY;
            int tX = aX + aRandom.nextInt(8) - aRandom.nextInt(8);
            if (!WD.air(aWorld, tX, tY = aY - aRandom.nextInt(12), tZ = aZ + aRandom.nextInt(8) - aRandom.nextInt(8))) continue;
            int tCount = 0;
            for (byte tSide : CS.ALL_SIDES_VALID) {
                Block block = aWorld.getBlock(tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide]);
                if (block != CS.BlocksGT.CrystalOres) continue;
                ++tCount;
            }
            if (tCount != true) continue;
            aWorld.setBlock(tX, tY, tZ, (Block)CS.BlocksGT.CrystalOres, aMeta, 2);
        }
        return true;
    }
}

