/*
 * Decompiled with CFR 0.152.
 */
package gregtech.worldgen;

import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import gregapi.worldgen.WorldgenObject;
import gregapi.worldgen.WorldgenOresBedrock;
import gregtech.tileentity.misc.MultiTileEntityFluidSpring;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.FluidStack;

public class WorldgenFluidSpring
extends WorldgenObject {
    public final int mMeta;
    public final int mProbability;
    public final int mIndicatorType;
    public final FluidStack mSpringFluid;
    public final Block mBlock;

    @SafeVarargs
    public WorldgenFluidSpring(String aName, boolean aDefault, Block aBlock, int aMeta, int aProbability, FluidStack aSpringFluid, List<WorldgenObject> ... aLists) {
        this(aName, aDefault, aBlock, aMeta, aProbability, 0, aSpringFluid, aLists);
    }

    @SafeVarargs
    public WorldgenFluidSpring(String aName, boolean aDefault, Block aBlock, int aMeta, int aProbability, int aIndicatorType, FluidStack aSpringFluid, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aLists);
        this.mSpringFluid = aSpringFluid;
        this.mBlock = ST.valid(aBlock) ? aBlock : Blocks.water;
        this.mMeta = UT.Code.bind4(aMeta);
        this.mIndicatorType = aIndicatorType;
        this.mProbability = this.getConfigFile().get((Object)this.mCategory, "Probability", (long)aProbability);
    }

    @Override
    public boolean generate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        if (CS.GENERATING_SPECIAL || !WorldgenOresBedrock.GENERATED_NO_BEDROCK_ORE || !WorldgenOresBedrock.CAN_GENERATE_BEDROCK_ORE || aRandom.nextInt(this.mProbability) != 0) {
            return false;
        }
        WorldgenOresBedrock.CAN_GENERATE_BEDROCK_ORE = false;
        Block tBlock = WD.block((IBlockAccess)aWorld, aMinX + 8, 0, aMinZ + 8);
        if (tBlock != CS.BlocksGT.oreBedrock && tBlock != CS.BlocksGT.oreSmallBedrock && !WD.bedrock(tBlock)) {
            return false;
        }
        Block block = tBlock = aDimType == -1 ? Blocks.netherrack : IL.EtFu_Deepslate.block();
        if (ST.invalid(tBlock)) {
            tBlock = Blocks.stone;
        }
        for (int i = 0; i <= 6; ++i) {
            for (int tX = aMinX + i; tX <= aMaxX - i; ++tX) {
                for (int tZ = aMinZ + i; tZ <= aMaxZ - i; ++tZ) {
                    if (!WD.opq(aWorld, tX, i + 1, tZ, false, true)) {
                        aWorld.setBlock(tX, i + 1, tZ, tBlock, 0, 0);
                    }
                    if (i > 0) {
                        aWorld.setBlock(tX, i, tZ, this.mBlock, this.mMeta, 0);
                    }
                    if (this.mSpringFluid == null || i <= 2 || aRandom.nextInt(16) != 0 || !WD.bedrock(aWorld, tX, 0, tZ)) continue;
                    MultiTileEntityFluidSpring.setBlock(aWorld, tX, 0, tZ, this.mSpringFluid);
                }
            }
        }
        switch (this.mIndicatorType) {
            case 1: 
            case 2: 
            case 3: {
                int tMinHeight = Math.min(aWorld.getHeight() - 2, WD.waterLevel(aWorld) - 1);
                int tMaxHeight = Math.min(aWorld.getHeight() - 1, tMinHeight * 2 + 16);
                block6: for (int i = 0; i < 6; ++i) {
                    Block tContact;
                    int tX = aMinX + 4 + aRandom.nextInt(8);
                    int tZ = aMinZ + 4 + aRandom.nextInt(8);
                    for (int tY = tMaxHeight; tY > tMinHeight && !(tContact = aWorld.getBlock(tX, tY, tZ)).getMaterial().isLiquid() && tContact != Blocks.farmland; --tY) {
                        if (!tContact.isOpaqueCube() || tContact.isWood((IBlockAccess)aWorld, tX, tY, tZ) || tContact.isLeaves((IBlockAccess)aWorld, tX, tY, tZ)) continue;
                        if (!CS.BlocksGT.plantableGrass.contains(tContact)) continue block6;
                        for (int a = -1; a <= 1; ++a) {
                            for (int b = -1; b <= 1; ++b) {
                                if (!aRandom.nextBoolean() || !CS.BlocksGT.plantableGrass.contains(aWorld.getBlock(tX + a, tY, tZ + b))) continue;
                                WD.set(aWorld, tX + a, tY, tZ + b, (Block)CS.BlocksGT.Grass, this.mIndicatorType == 3 ? 0L : (long)(3 + this.mIndicatorType), 0L);
                            }
                        }
                        continue block6;
                    }
                }
                break;
            }
        }
        return true;
    }
}

