/*
 * Decompiled with CFR 0.152.
 */
package gregtech.worldgen;

import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.data.CS;
import gregapi.util.UT;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;

public class ChestGenHooksChestReplacer
extends ChestGenHooks {
    public final ChestGenHooks mHookToReplaceChestsOf;
    public final String mCategory;
    public final short mChestID;
    public ArrayList contents;

    public ChestGenHooksChestReplacer(String aCategory) {
        this(aCategory, 32745L);
    }

    public ChestGenHooksChestReplacer(String aCategory, long aChestID) {
        super(aCategory);
        Field tField;
        this.mCategory = aCategory;
        this.mChestID = (short)aChestID;
        this.mHookToReplaceChestsOf = ChestGenHooks.getInfo((String)aCategory);
        super.setMin(this.mHookToReplaceChestsOf.getMin());
        super.setMax(this.mHookToReplaceChestsOf.getMax());
        try {
            tField = ChestGenHooks.class.getDeclaredField("chestInfo");
            tField.setAccessible(true);
            ((HashMap)tField.get(null)).put(aCategory, this);
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
        try {
            tField = ChestGenHooks.class.getDeclaredField("contents");
            tField.setAccessible(true);
            this.contents = (ArrayList)tField.get(this.mHookToReplaceChestsOf);
            tField.set((Object)this, this.contents);
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
    }

    public WeightedRandomChestContent[] getItems(Random aRandom) {
        WeightedRandomChestContent[] rReturn = this.mHookToReplaceChestsOf.getItems(aRandom);
        if (CS.GAPI.mStartedServerStarted < 1 || aRandom == CS.RNGSUS) {
            return rReturn;
        }
        for (int i = 0; i < rReturn.length; ++i) {
            rReturn[i] = new WeightedRandomChestContentChestReplacer(rReturn[i], this.mCategory, this.mChestID);
        }
        return rReturn;
    }

    public void addItem(WeightedRandomChestContent aItem) {
        this.mHookToReplaceChestsOf.addItem(aItem);
    }

    public void removeItem(ItemStack aStack) {
        this.mHookToReplaceChestsOf.removeItem(aStack);
    }

    public int getCount(Random aRandom) {
        return this.mHookToReplaceChestsOf.getCount(aRandom);
    }

    public ItemStack getOneItem(Random aRandom) {
        return this.mHookToReplaceChestsOf.getOneItem(aRandom);
    }

    public int getMin() {
        return this.mHookToReplaceChestsOf.getMin();
    }

    public int getMax() {
        return this.mHookToReplaceChestsOf.getMax();
    }

    public void setMin(int aValue) {
        this.mHookToReplaceChestsOf.setMin(aValue);
        super.setMin(aValue);
    }

    public void setMax(int aValue) {
        this.mHookToReplaceChestsOf.setMax(aValue);
        super.setMax(aValue);
    }

    public static class WeightedRandomChestContentChestReplacer
    extends WeightedRandomChestContent {
        public final WeightedRandomChestContent mContent;
        public final String mCategory;
        public final short mChestID;

        public WeightedRandomChestContentChestReplacer(WeightedRandomChestContent aContent, String aCategory, short aChestID) {
            super(aContent.theItemId, aContent.theMinimumChanceToGenerateItem, aContent.theMaximumChanceToGenerateItem, aContent.itemWeight);
            this.mCategory = aCategory;
            this.mContent = aContent;
            this.mChestID = aChestID;
        }

        protected ItemStack[] generateChestContent(Random aRandom, IInventory aInventory) {
            if (aInventory.getClass() != TileEntityChest.class) {
                return this.generateChestContent2(aRandom, aInventory);
            }
            World aWorld = ((TileEntityChest)aInventory).getWorldObj();
            if (aWorld == null) {
                return this.generateChestContent2(aRandom, aInventory);
            }
            int aX = ((TileEntityChest)aInventory).xCoord;
            int aY = ((TileEntityChest)aInventory).yCoord;
            int aZ = ((TileEntityChest)aInventory).zCoord;
            if (Blocks.chest != aWorld.getBlock(aX, aY, aZ)) {
                return this.generateChestContent2(aRandom, aInventory);
            }
            MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry("gt.multitileentity");
            if (tRegistry == null) {
                return this.generateChestContent2(aRandom, aInventory);
            }
            byte tFacing = CS.VALIDATE_HORIZONTAL[aWorld.getBlockMetadata(aX, aY, aZ)];
            aWorld.setBlock(aX, aY, aZ, CS.NB, 0, 1);
            aWorld.setBlock(aX, aY, aZ, CS.NB, 0, 1);
            tRegistry.mBlock.placeBlock(aWorld, aX, aY, aZ, (byte)6, this.mChestID, UT.NBT.make("gt.facing", (Object)tFacing, "gt.trapped", true, "gt.dungeonloot", this.mCategory), false, true);
            return CS.ZL_IS;
        }

        protected ItemStack[] generateChestContent2(Random aRandom, IInventory aInventory) {
            try {
                Method tMethod = this.mContent.getClass().getDeclaredMethod("generateChestContent", Random.class, IInventory.class);
                tMethod.setAccessible(true);
                return (ItemStack[])tMethod.invoke((Object)this.mContent, aRandom, aInventory);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
                return super.generateChestContent(aRandom, aInventory);
            }
        }
    }
}

