/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.CS;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityQuickObstructionCheck;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class MultiTileEntityScaffold
extends TileEntityBase09FacingSingle
implements ITileEntityQuickObstructionCheck,
IMultiTileEntity.IMTE_IgnorePlayerCollisionWhenPlacing,
IMultiTileEntity.IMTE_IsLadder,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool {
    protected byte mDesign = 1;
    protected boolean mBlockUpdatedLastTime = true;
    protected ITexture mTexturePlate;
    protected ITexture mTextureHatch;
    protected ITexture mTextureRod;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.design")) {
            this.mDesign = aNBT.getByte("gt.design");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        aNBT.setByte("gt.design", this.mDesign);
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            if (this.mBlockUpdatedLastTime) {
                this.onFacingChange((byte)6);
            }
            this.mBlockUpdatedLastTime = this.mBlockUpdated;
        }
    }

    @Override
    public void onFacingChange(byte aPreviousFacing) {
        if (this.isServerSide()) {
            if (this.isConnectedVertically()) {
                this.setDesign(this.getAdjacentTileEntity((byte)1).mTileEntity instanceof MultiTileEntityScaffold ? 2L : (this.getAdjacentTileEntity((byte)0).mTileEntity instanceof MultiTileEntityScaffold ? 1L : 3L));
            } else {
                this.setDesign(0L);
                if (!this.isConnectedToGround()) {
                    this.popOff();
                    return;
                }
            }
        }
    }

    public boolean setDesign(long aDesign) {
        if ((long)this.mDesign == aDesign) {
            return false;
        }
        this.mDesign = (byte)aDesign;
        this.checkCoverValidity();
        this.updateClientData();
        this.causeBlockUpdate();
        return true;
    }

    public boolean isConnectedVertically() {
        return this.worldObj == null || WD.opq(this.worldObj, this.xCoord, this.yCoord - 1, this.zCoord, true, true) || this.getAdjacentTileEntity((byte)0).mTileEntity instanceof MultiTileEntityScaffold;
    }

    public boolean isConnectedToGround() {
        if (this.isConnectedVertically()) {
            return true;
        }
        Block tBlock = this.getBlock(this.getCoords());
        for (byte tSide : CS.SIDES_AXIS_X[this.mFacing] ? CS.ALL_SIDES_X : CS.ALL_SIDES_Z) {
            TileEntity tTileEntity;
            for (int i = 1; i < 256 && tBlock == this.getBlockAtSideAndDistance(tSide, i) && (tTileEntity = this.getTileEntityAtSideAndDistance(tSide, i)) instanceof MultiTileEntityScaffold; ++i) {
                if (!((MultiTileEntityScaffold)tTileEntity).isConnectedVertically()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        this.mTextureHatch = this.mTextureRod = BlockTextureDefault.get((IIconContainer)Textures.BlockIcons.PLATE, this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING));
        this.mTexturePlate = this.mTextureRod;
        if (this.mDesign == 3) {
            return 1;
        }
        this.mTextureRod = BlockTextureDefault.get(this.mMaterial, OP.blockSolid, UT.Code.getRGBaArray(this.mRGBa), this.mMaterial.contains(TD.Properties.GLOWING), false);
        if (this.mDesign == 0) {
            return 4;
        }
        if (this.mDesign == 2) {
            return 7;
        }
        this.mTextureHatch = BlockTextureMulti.get(this.mTexturePlate, BlockTextureDefault.get((IIconContainer)Textures.BlockIcons.HATCH, this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)));
        return 7;
    }

    @Override
    public boolean usesRenderPass2(int aRenderPass, boolean[] aShouldSideBeRendered) {
        return aRenderPass != 0 || this.mDesign != 2;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return this.mDesign == 3 ? (aShouldSideBeRendered[aSide] ? this.mTexturePlate : null) : (aRenderPass == 0 || aRenderPass > 4 ? (this.mDesign == 1 && CS.SIDES_VERTICAL[aSide] ? this.mTextureHatch : this.mTexturePlate) : this.mTextureRod);
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        if (this.mDesign == 3) {
            return false;
        }
        if (this.mDesign != 0) {
            switch (aRenderPass) {
                default: {
                    return this.box(aBlock, CS.PX_P[0], CS.PX_P[10], CS.PX_P[0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]);
                }
                case 1: {
                    return this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[14], CS.PX_N[this.mDesign == 2 ? 0 : 6], CS.PX_N[14]);
                }
                case 2: {
                    return this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[14], CS.PX_N[14], CS.PX_N[this.mDesign == 2 ? 0 : 6], CS.PX_N[0]);
                }
                case 3: {
                    return this.box(aBlock, CS.PX_P[14], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[this.mDesign == 2 ? 0 : 6], CS.PX_N[14]);
                }
                case 4: {
                    return this.box(aBlock, CS.PX_P[14], CS.PX_P[0], CS.PX_P[14], CS.PX_N[0], CS.PX_N[this.mDesign == 2 ? 0 : 6], CS.PX_N[0]);
                }
                case 5: {
                    switch (this.mFacing) {
                        default: {
                            return this.box(aBlock, CS.PX_P[2], CS.PX_P[4], CS.PX_P[0], CS.PX_N[2], CS.PX_N[11], CS.PX_N[12]);
                        }
                        case 2: {
                            return this.box(aBlock, CS.PX_P[2], CS.PX_P[4], CS.PX_P[12], CS.PX_N[2], CS.PX_N[11], CS.PX_N[0]);
                        }
                        case 5: {
                            return this.box(aBlock, CS.PX_P[0], CS.PX_P[4], CS.PX_P[2], CS.PX_N[12], CS.PX_N[11], CS.PX_N[2]);
                        }
                        case 4: 
                    }
                    return this.box(aBlock, CS.PX_P[12], CS.PX_P[4], CS.PX_P[2], CS.PX_N[0], CS.PX_N[11], CS.PX_N[2]);
                }
                case 6: 
            }
            switch (this.mFacing) {
                default: {
                    return this.box(aBlock, CS.PX_P[2], CS.PX_P[12], CS.PX_P[0], CS.PX_N[2], CS.PX_N[3], CS.PX_N[12]);
                }
                case 2: {
                    return this.box(aBlock, CS.PX_P[2], CS.PX_P[12], CS.PX_P[12], CS.PX_N[2], CS.PX_N[3], CS.PX_N[0]);
                }
                case 5: {
                    return this.box(aBlock, CS.PX_P[0], CS.PX_P[12], CS.PX_P[2], CS.PX_N[12], CS.PX_N[3], CS.PX_N[2]);
                }
                case 4: 
            }
            return this.box(aBlock, CS.PX_P[12], CS.PX_P[12], CS.PX_P[2], CS.PX_N[0], CS.PX_N[3], CS.PX_N[2]);
        }
        switch (aRenderPass) {
            default: {
                return this.box(aBlock, CS.PX_P[0], CS.PX_P[14], CS.PX_P[0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]);
            }
            case 1: {
                if (CS.SIDES_AXIS_X[this.mFacing]) {
                    return this.box(aBlock, CS.PX_P[0], CS.PX_P[12], CS.PX_P[2], CS.PX_N[0], CS.PX_N[2], CS.PX_N[12]);
                }
                return this.box(aBlock, CS.PX_P[2], CS.PX_P[12], CS.PX_P[0], CS.PX_N[12], CS.PX_N[2], CS.PX_N[0]);
            }
            case 2: {
                if (CS.SIDES_AXIS_X[this.mFacing]) {
                    return this.box(aBlock, CS.PX_P[0], CS.PX_P[10], CS.PX_P[6], CS.PX_N[0], CS.PX_N[2], CS.PX_N[6]);
                }
                return this.box(aBlock, CS.PX_P[6], CS.PX_P[10], CS.PX_P[0], CS.PX_N[6], CS.PX_N[2], CS.PX_N[0]);
            }
            case 3: 
        }
        if (CS.SIDES_AXIS_X[this.mFacing]) {
            return this.box(aBlock, CS.PX_P[0], CS.PX_P[12], CS.PX_P[12], CS.PX_N[0], CS.PX_N[2], CS.PX_N[2]);
        }
        return this.box(aBlock, CS.PX_P[12], CS.PX_P[12], CS.PX_P[0], CS.PX_N[2], CS.PX_N[2], CS.PX_N[0]);
    }

    @Override
    public void addCollisionBoxesToList2(AxisAlignedBB aAABB, List<AxisAlignedBB> aList, Entity aEntity) {
        switch (this.mDesign) {
            default: {
                this.box(aAABB, aList);
                return;
            }
            case 0: {
                this.box(aAABB, aList, CS.PX_P[0], CS.PX_P[14], CS.PX_P[0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]);
                return;
            }
            case 1: {
                if (aEntity != null && (aEntity.isSneaking() || !(aEntity.posY >= (double)(this.yCoord + 1)))) break;
                this.box(aAABB, aList, CS.PX_P[0], CS.PX_P[14], CS.PX_P[0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]);
            }
            case 2: 
        }
        this.box(aAABB, aList, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[15], CS.PX_N[0], CS.PX_N[15]);
        this.box(aAABB, aList, CS.PX_P[0], CS.PX_P[0], CS.PX_P[15], CS.PX_N[15], CS.PX_N[0], CS.PX_N[0]);
        this.box(aAABB, aList, CS.PX_P[15], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[15]);
        this.box(aAABB, aList, CS.PX_P[15], CS.PX_P[0], CS.PX_P[15], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]);
        switch (this.mFacing) {
            default: {
                this.box(aAABB, aList, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[14]);
                break;
            }
            case 2: {
                this.box(aAABB, aList, CS.PX_P[0], CS.PX_P[0], CS.PX_P[14], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]);
                break;
            }
            case 5: {
                this.box(aAABB, aList, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[14], CS.PX_N[0], CS.PX_N[0]);
                break;
            }
            case 4: {
                this.box(aAABB, aList, CS.PX_P[14], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]);
            }
        }
    }

    @Override
    public byte getVisualData() {
        return this.mDesign;
    }

    @Override
    public void setVisualData(byte aData) {
        this.mDesign = aData;
    }

    @Override
    public boolean addDefaultCollisionBoxToList() {
        return false;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.box(0.0, this.mDesign == 0 ? (double)CS.PX_P[14] : 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return this.box(0.0, this.mDesign == 0 ? (double)CS.PX_P[14] : 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        this.box(aBlock, 0.0, this.mDesign == 0 ? (double)CS.PX_P[14] : 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return CS.SIDES_TOP[aSide] || this.mDesign == 3 ? 1.0f : 0.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return CS.SIDES_TOP[aSide] || this.mDesign == 3 ? 1.0f : 0.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return CS.SIDES_TOP[aSide] || this.mDesign == 3;
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return CS.SIDES_TOP[aSide] || this.mDesign == 3;
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return CS.SIDES_TOP[aSide] || this.mDesign == 3;
    }

    @Override
    public boolean isCoverSurface(byte aSide) {
        return CS.SIDES_TOP[aSide] || this.mDesign == 3;
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return this.mDesign == 3;
    }

    @Override
    public boolean allowCoverHolders(byte aSide) {
        return false;
    }

    @Override
    public boolean attachCoversFirst(byte aSide) {
        return false;
    }

    @Override
    public boolean isObstructingBlockAt(byte aSide) {
        return this.mDesign == 3;
    }

    @Override
    public boolean isLadder(EntityLivingBase aEntity) {
        return this.mDesign != 3;
    }

    @Override
    public boolean ignorePlayerCollisionWhenPlacing() {
        return true;
    }

    @Override
    public boolean useSidePlacementRotation() {
        return false;
    }

    @Override
    public boolean ignorePlayerCollisionWhenPlacing(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return aPlayer == null || !aPlayer.isSneaking();
    }

    @Override
    public boolean useSidePlacementRotation(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return aPlayer != null && aPlayer.isSneaking();
    }

    @Override
    public boolean checkObstruction(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return false;
    }

    @Override
    public int getLightOpacity() {
        return 0;
    }

    @Override
    public byte getDefaultSide() {
        return 3;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_HORIZONTAL;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.scaffold";
    }
}

