/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.fluid.FluidTankGT;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityQuickObstructionCheck;
import gregapi.tileentity.ITileEntityTreeHole;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class MultiTileEntitySapBag
extends TileEntityBase09FacingSingle
implements ITileEntityQuickObstructionCheck,
IMultiTileEntity.IMTE_IgnorePlayerCollisionWhenPlacing,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool {
    public boolean mFull = false;
    public FluidTankGT mTank = new FluidTankGT(8000L);
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/tools/sapbag/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/tools/sapbag/colored/top"), new Textures.BlockIcons.CustomIcon("machines/tools/sapbag/colored/side")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/tools/sapbag/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/tools/sapbag/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/tools/sapbag/overlay/side")};
    public static IIconContainer[] sOverlaysFull = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/tools/sapbag/overlay_full/bottom"), new Textures.BlockIcons.CustomIcon("machines/tools/sapbag/overlay_full/top"), new Textures.BlockIcons.CustomIcon("machines/tools/sapbag/overlay_full/side")};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.active")) {
            this.mFull = aNBT.getBoolean("gt.active");
        }
        this.mTank.setCapacity(aNBT.getLong("gt.tankcap"));
        this.mTank.readFromNBT(aNBT, "gt.tank");
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.active", this.mFull);
        this.mTank.writeToNBT(aNBT, "gt.tank");
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.inventory"));
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide) {
            DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(this.mFacing);
            if (tDelegator.mTileEntity instanceof ITileEntityTreeHole && ((ITileEntityTreeHole)tDelegator.mTileEntity).hasResin(tDelegator.mSideOfTileEntity) && ((ITileEntityTreeHole)tDelegator.mTileEntity).extractResin(tDelegator.mSideOfTileEntity)) {
                this.mTank.fill(((ITileEntityTreeHole)tDelegator.mTileEntity).getResinFluid(tDelegator.mSideOfTileEntity), true);
                this.addStackToSlot(0, ((ITileEntityTreeHole)tDelegator.mTileEntity).getResinItem(tDelegator.mSideOfTileEntity));
            }
            boolean tFull = this.mFull;
            boolean bl = this.mFull = this.mTank.has() || this.slotHas(0);
            if (tFull != this.mFull) {
                this.updateClientData();
            }
        }
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide()) {
            ItemStack tStack;
            if (ST.add((Entity)aPlayer, this.slot(0), true)) {
                this.slotKill(0);
                return true;
            }
            ItemStack aStack = aPlayer.getCurrentEquippedItem();
            if (aStack != null && (tStack = FL.fill(this.mTank, ST.amount(1L, aStack), true, true, true, true)) != null) {
                --aStack.stackSize;
                ST.give((Entity)aPlayer, tStack, true);
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean breakBlock() {
        CS.GarbageGT.trash(this.mTank);
        return super.breakBlock();
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (this.mFacing) {
            case 2: {
                this.box(aBlock, CS.PX_P[5], CS.PX_P[0], CS.PX_P[0], CS.PX_N[5], CS.PX_N[9], CS.PX_N[10]);
                return true;
            }
            case 3: {
                this.box(aBlock, CS.PX_P[5], CS.PX_P[0], CS.PX_P[10], CS.PX_N[5], CS.PX_N[9], CS.PX_N[0]);
                return true;
            }
            case 4: {
                this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[5], CS.PX_N[10], CS.PX_N[9], CS.PX_N[5]);
                return true;
            }
        }
        this.box(aBlock, CS.PX_P[10], CS.PX_P[0], CS.PX_P[5], CS.PX_N[0], CS.PX_N[9], CS.PX_N[5]);
        return true;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aSide != this.mFacing && CS.SIDES_TOP_HORIZONTAL[aSide] || aShouldSideBeRendered[aSide] ? BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[CS.FACES_TBS[aSide]], this.mRGBa), BlockTextureDefault.get((this.mFull ? sOverlaysFull : sOverlays)[CS.FACES_TBS[aSide]])) : null;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return null;
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        switch (this.mFacing) {
            case 2: {
                return this.box(CS.PX_P[5], CS.PX_P[0], CS.PX_P[0], CS.PX_N[5], CS.PX_N[9], CS.PX_N[10]);
            }
            case 3: {
                return this.box(CS.PX_P[5], CS.PX_P[0], CS.PX_P[10], CS.PX_N[5], CS.PX_N[9], CS.PX_N[0]);
            }
            case 4: {
                return this.box(CS.PX_P[0], CS.PX_P[0], CS.PX_P[5], CS.PX_N[10], CS.PX_N[9], CS.PX_N[5]);
            }
        }
        return this.box(CS.PX_P[10], CS.PX_P[0], CS.PX_P[5], CS.PX_N[0], CS.PX_N[9], CS.PX_N[5]);
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        switch (this.mFacing) {
            case 2: {
                this.box(aBlock, CS.PX_P[5], CS.PX_P[0], CS.PX_P[0], CS.PX_N[5], CS.PX_N[9], CS.PX_N[10]);
                break;
            }
            case 3: {
                this.box(aBlock, CS.PX_P[5], CS.PX_P[0], CS.PX_P[10], CS.PX_N[5], CS.PX_N[9], CS.PX_N[0]);
                break;
            }
            case 4: {
                this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[5], CS.PX_N[10], CS.PX_N[9], CS.PX_N[5]);
                break;
            }
            default: {
                this.box(aBlock, CS.PX_P[10], CS.PX_P[0], CS.PX_P[5], CS.PX_N[0], CS.PX_N[9], CS.PX_N[5]);
            }
        }
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[1];
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return CS.ZL_INTEGER;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        return false;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return false;
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return 0.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return 0.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return false;
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return false;
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return false;
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public boolean attachCoversFirst(byte aSide) {
        return false;
    }

    @Override
    public boolean isObstructingBlockAt(byte aSide) {
        return aSide == this.mFacing;
    }

    @Override
    public boolean checkObstruction(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return false;
    }

    @Override
    public boolean useSidePlacementRotation() {
        return true;
    }

    @Override
    public boolean useInversePlacementRotation() {
        return true;
    }

    @Override
    public int getLightOpacity() {
        return 0;
    }

    @Override
    public byte getDefaultSide() {
        return 3;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_HORIZONTAL;
    }

    @Override
    public boolean isUsingWrenchingOverlay(ItemStack aStack, byte aSide) {
        return false;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public byte getVisualData() {
        return (byte)(this.mFull ? 1 : 0);
    }

    @Override
    public void setVisualData(byte aData) {
        this.mFull = aData != 0;
    }

    @Override
    public boolean ignorePlayerCollisionWhenPlacing() {
        return true;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.sapbag";
    }
}

