/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.old.Textures;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.oredict.OreDictPrefix;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityAdjacentInventoryUpdatable;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class MultiTileEntityDustFunnel
extends TileEntityBase07Paintable
implements ITileEntityAdjacentInventoryUpdatable,
IMultiTileEntity.IMTE_AddToolTips,
IMultiTileEntity.IMTE_SyncDataShort {
    public static final OreDictPrefix[] DUST_TYPES = new OreDictPrefix[]{OP.blockDust, OP.dust, OP.dustSmall, OP.dustTiny, OP.dustDiv72};
    protected byte mMode = 0;
    protected short mDust = 0;
    protected short oDust = (short)-1;
    protected OreDictMaterialStack mContent = null;
    public static IIconContainer sTextureTop = new Textures.BlockIcons.CustomIcon("machines/tools/dust_funnel/colored/top");
    public static IIconContainer sTextureSides = new Textures.BlockIcons.CustomIcon("machines/tools/dust_funnel/colored/sides");
    public static IIconContainer sTextureBottom = new Textures.BlockIcons.CustomIcon("machines/tools/dust_funnel/colored/bottom");
    public static IIconContainer sTextureHole = new Textures.BlockIcons.CustomIcon("machines/tools/dust_funnel/colored/hole");
    public static IIconContainer sOverlayTop = new Textures.BlockIcons.CustomIcon("machines/tools/dust_funnel/overlay/top");
    public static IIconContainer sOverlaySides = new Textures.BlockIcons.CustomIcon("machines/tools/dust_funnel/overlay/sides");
    public static IIconContainer sOverlayBottom = new Textures.BlockIcons.CustomIcon("machines/tools/dust_funnel/overlay/bottom");
    public static IIconContainer sOverlayHole = new Textures.BlockIcons.CustomIcon("machines/tools/dust_funnel/overlay/hole");
    private ITexture mTextureSides;
    private ITexture mTextureBottom;
    private ITexture mTextureInput;
    private static final int[] ACCESSIBLE_SLOTS = new int[]{0, 1};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.mode")) {
            this.mMode = aNBT.getByte("gt.mode");
        }
        if (aNBT.hasKey("gt.materials")) {
            this.mContent = OreDictMaterialStack.load("gt.materials", aNBT);
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        aNBT.setByte("gt.mode", this.mMode);
        if (this.mContent != null) {
            this.mContent.save("gt.materials", aNBT);
        }
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        aNBT.setByte("gt.mode", this.mMode);
        return aNBT;
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes.dustfunnel"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.interact") + " (" + LH.get("gt.lang.face.top") + ")");
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.pincers.to.take"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.monkey.wrench.to.toggle.outputs"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            ItemStack tStack;
            OreDictItemData tData;
            boolean temp = this.mInventoryChanged || aTimer % 100L == 0L;
            this.slotNull(0);
            if (temp && !this.slotHas(0)) {
                ST.move(this.getAdjacentInventory((byte)1), this.delegator((byte)1));
            }
            if (this.slotHas(0) && (this.mContent == null || this.mContent.mAmount < MultiTileEntityDustFunnel.DUST_TYPES[this.mMode].mAmount) && OM.prefixcontainsmaterialmatches(tData = OM.anydata(this.slot(0)), this.mContent == null || this.mContent.mMaterial == MT.NULL ? null : this.mContent.mMaterial, TD.Prefix.DUST_BASED)) {
                int tSize = (int)Math.min((long)this.slot((int)0).stackSize, UT.Code.divup(MultiTileEntityDustFunnel.DUST_TYPES[this.mMode].mAmount - (this.mContent == null ? 0L : this.mContent.mAmount), tData.mMaterial.mAmount));
                this.mContent = OM.stack(tData.mMaterial.mMaterial, tData.mMaterial.mAmount * (long)tSize + (this.mContent == null ? 0L : this.mContent.mAmount));
                this.decrStackSize(0, tSize);
                temp = true;
            }
            short s = this.mDust = this.mContent != null && (this.mContent.mAmount > 0L || this.slotHas(1)) ? this.mContent.mMaterial.mID : (short)0;
            if (this.mContent != null && !this.slotHas(1) && this.mContent.mAmount >= MultiTileEntityDustFunnel.DUST_TYPES[this.mMode].mAmount && (tStack = DUST_TYPES[this.mMode].mat(this.mContent.mMaterial, 1L)) != null) {
                this.slot(1, tStack);
                this.mContent.mAmount -= MultiTileEntityDustFunnel.DUST_TYPES[this.mMode].mAmount;
                if (this.mContent.mAmount <= 0L) {
                    this.mContent = null;
                }
                temp = true;
            }
            if (temp && this.slotHas(1)) {
                ST.move(this.delegator((byte)0), this.getAdjacentInventory((byte)0));
            }
        }
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide() && CS.SIDES_TOP[aSide] && this.canInsertItem2(0, aPlayer.inventory.getCurrentItem(), aSide)) {
            ST.move((IInventory)aPlayer.inventory, this, aPlayer.inventory.currentItem, 0);
        }
        return true;
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        }
        if (aTool.equals("pincers")) {
            ST.drop(this.worldObj, this.getCoords(), OM.dust(this.mContent));
            this.mContent = null;
            this.updateClientData();
            return 10L;
        }
        if (aTool.equals("monkeywrench")) {
            this.mMode = (byte)((DUST_TYPES.length + this.mMode + (aSneaking ? -1 : 1)) % DUST_TYPES.length);
            if (aChatReturn != null) {
                aChatReturn.add("Outputs in the Size of " + MultiTileEntityDustFunnel.DUST_TYPES[this.mMode].mNameLocal);
            }
            this.updateClientData();
            return 10000L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                aChatReturn.add("Outputs in the Size of " + MultiTileEntityDustFunnel.DUST_TYPES[this.mMode].mNameLocal);
                if (this.mContent != null && this.mContent.mAmount > 0L) {
                    aChatReturn.add("Contains a Fraction of " + this.mContent.mMaterial.mNameLocal);
                }
            }
            return 1L;
        }
        return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return super.onTickCheck(aTimer) || CS.SYNC_SECOND && this.mDust != this.oDust && this.isTopVisible();
    }

    @Override
    public void onTickChecked(long aTimer) {
        super.onTickChecked(aTimer);
        this.oDust = this.mDust;
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        if (aSendAll) {
            return this.getClientDataPacketByteArray(aSendAll, UT.Code.toByteS(this.mDust, 0), UT.Code.toByteS(this.mDust, 1), this.mMode, (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa));
        }
        return this.getClientDataPacketShort(aSendAll, this.mDust);
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        this.mDust = UT.Code.combine(aData[0], aData[1]);
        this.mMode = aData[2];
        this.mRGBa = UT.Code.getRGBInt(new short[]{UT.Code.unsignB(aData[3]), UT.Code.unsignB(aData[4]), UT.Code.unsignB(aData[5])});
        return true;
    }

    @Override
    public boolean receiveDataShort(short aData, INetworkHandler aNetworkHandler) {
        this.mDust = aData;
        return true;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 6;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                this.box(aBlock, CS.PX_P[0], CS.PX_P[8], CS.PX_P[0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]);
                return true;
            }
            case 1: {
                this.box(aBlock, CS.PX_P[2 + this.mMode], CS.PX_P[0], CS.PX_P[2 + this.mMode], CS.PX_N[2 + this.mMode], CS.PX_N[8], CS.PX_N[2 + this.mMode]);
                return true;
            }
            case 2: {
                this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_P[2], CS.PX_P[8], CS.PX_P[2]);
                return true;
            }
            case 3: {
                this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_N[2], CS.PX_P[2], CS.PX_P[8], CS.PX_N[0]);
                return true;
            }
            case 4: {
                this.box(aBlock, CS.PX_N[2], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_P[8], CS.PX_P[2]);
                return true;
            }
            case 5: {
                this.box(aBlock, CS.PX_N[2], CS.PX_P[0], CS.PX_N[2], CS.PX_N[0], CS.PX_P[8], CS.PX_N[0]);
                return true;
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (aRenderPass == 0 && aSide == 0) {
            boolean tGlow = this.mMaterial.contains(TD.Properties.GLOWING);
            this.mTextureSides = BlockTextureMulti.get(BlockTextureDefault.get(sTextureSides, this.mRGBa, false, tGlow, false, false), BlockTextureDefault.get(sOverlaySides));
            this.mTextureBottom = BlockTextureMulti.get(BlockTextureDefault.get(sTextureBottom, this.mRGBa, false, tGlow, false, false), BlockTextureDefault.get(sOverlayBottom));
            this.mTextureInput = this.mDust == 0 ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa, false, tGlow, false, false), BlockTextureDefault.get(sOverlayTop), BlockTextureDefault.get(sTextureHole, this.mRGBa, false, tGlow, false, false), BlockTextureDefault.get(sOverlayHole)) : (UT.Code.exists(this.mDust, OreDictMaterial.MATERIAL_ARRAY) ? BlockTextureMulti.get(OreDictMaterial.MATERIAL_ARRAY[this.mDust].getTextureDust(), BlockTextureDefault.get(sTextureHole, this.mRGBa, false, tGlow, false, false), BlockTextureDefault.get(sOverlayHole)) : BlockTextureMulti.get(BlockTextureDefault.get(MT.NULL, OP.blockDust, CS.CA_GRAY_64, false), BlockTextureDefault.get(sTextureHole, this.mRGBa, false, tGlow, false, false), BlockTextureDefault.get(sOverlayHole)));
        }
        return CS.SIDES_TOP[aSide] ? (aRenderPass == 0 ? this.mTextureInput : null) : (CS.SIDES_BOTTOM[aSide] ? this.mTextureBottom : this.mTextureSides);
    }

    public boolean isTopVisible() {
        return !this.hasCovers() || this.mCovers.mBehaviours[1] == null || !this.mCovers.mBehaviours[1].isOpaque((byte)1, this.mCovers);
    }

    @Override
    public int getLightOpacity() {
        return 3;
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return CS.SIDES_TOP[aSide] ? CS.PX_P[16] : (CS.SIDES_BOTTOM[aSide] ? CS.PX_P[12 - 2 * this.mMode] : 0.0f);
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return CS.SIDES_TOP[aSide] ? CS.PX_P[12] : CS.PX_P[12 - 2 * this.mMode];
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return CS.SIDES_HORIZONTAL[aSide] ? CS.PX_P[2 + this.mMode] : 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return CS.SIDES_TOP[aSide];
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return CS.SIDES_TOP[aSide];
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return CS.SIDES_TOP[aSide];
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return CS.SIDES_TOP[aSide];
    }

    @Override
    public void adjacentInventoryUpdated(byte aSide, IInventory aTileEntity) {
        if (CS.SIDES_VERTICAL[aSide]) {
            this.updateInventory();
        }
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[2];
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return ACCESSIBLE_SLOTS;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        if (aSlot == 0 && !this.slotHas(0) && CS.SIDES_TOP_HORIZONTAL[aSide]) {
            OreDictItemData tData = OM.anydata(aStack);
            return OM.prefixcontainsmaterialmatches(tData, this.mContent == null ? null : this.mContent.mMaterial, TD.Prefix.DUST_BASED) && DUST_TYPES[this.mMode].mat(tData.mMaterial.mMaterial, 1L) != null;
        }
        return false;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return aSlot == 1;
    }

    @Override
    public boolean breakBlock() {
        if (this.isServerSide()) {
            ST.drop(this.worldObj, this.getCoords(), OM.dust(this.mContent));
            this.mContent = null;
        }
        return super.breakBlock();
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.funnel.dust";
    }
}

