/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.sensors;

import gregapi.data.BI;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.render.IIconContainer;
import gregapi.tileentity.connectors.MultiTileEntityWireLaser;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.machines.MultiTileEntitySensorTE;
import net.minecraft.tileentity.TileEntity;

public class MultiTileEntityLaserometer
extends MultiTileEntitySensorTE {
    public static IIconContainer sTextureFront;
    public static IIconContainer sTextureBack;
    public static IIconContainer sTextureSide;
    public static IIconContainer sOverlayFront;
    public static IIconContainer sOverlayBack;
    public static IIconContainer sOverlaySide;

    @Override
    public String getSensorDescription() {
        return LH.get("gt.tooltip.sensor.laserometer");
    }

    @Override
    public long getCurrentValue(DelegatorTileEntity<TileEntity> aDelegator) {
        if (aDelegator.mTileEntity instanceof MultiTileEntityWireLaser) {
            return ((MultiTileEntityWireLaser)aDelegator.mTileEntity).mTransferredLast;
        }
        return 0L;
    }

    @Override
    public long getCurrentMax(DelegatorTileEntity<TileEntity> aDelegator) {
        if (aDelegator.mTileEntity instanceof MultiTileEntityWireLaser) {
            return 65535L;
        }
        return 0L;
    }

    @Override
    public short[] getSymbolColor() {
        return CS.CA_YELLOW_255;
    }

    @Override
    public IIconContainer getSymbolIcon() {
        return BI.CHAR_LU;
    }

    @Override
    public IIconContainer getTextureFront() {
        return sTextureFront;
    }

    @Override
    public IIconContainer getTextureBack() {
        return sTextureBack;
    }

    @Override
    public IIconContainer getTextureSide() {
        return sTextureSide;
    }

    @Override
    public IIconContainer getOverlayFront() {
        return sOverlayFront;
    }

    @Override
    public IIconContainer getOverlayBack() {
        return sOverlayBack;
    }

    @Override
    public IIconContainer getOverlaySide() {
        return sOverlaySide;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.redstone.sensors.laserometer";
    }

    static {
        LH.add("gt.tooltip.sensor.laserometer", "Measures Power transmitted through Laser Fiber (In LU)");
        sTextureFront = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/laserometer/colored/front");
        sTextureBack = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/laserometer/colored/back");
        sTextureSide = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/laserometer/colored/side");
        sOverlayFront = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/laserometer/overlay/front");
        sOverlayBack = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/laserometer/overlay/back");
        sOverlaySide = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/laserometer/overlay/side");
    }
}

