/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.plants;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityContainer;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.OP;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.old.Textures;
import gregapi.oredict.OreDictItemData;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityQuickObstructionCheck;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class MultiTileEntityBush
extends TileEntityBase09FacingSingle
implements IMultiTileEntity.IMTE_CanPlaceSnowLayerOnRemoval,
ITileEntityQuickObstructionCheck,
IMultiTileEntity.IMTE_OnOxygenRemoved,
IMultiTileEntity.IMTE_CanPlace,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState {
    public ItemStack mBerry;
    public byte oStage = 0;
    public byte mStage = 0;
    public byte mGrowth = 0;
    public byte mSpeed = 0;
    public static final IIconContainer sTextureBush = new Textures.BlockIcons.CustomIcon("machines/plants/bush/colored/bush");
    public static final IIconContainer sTextureBerry = new Textures.BlockIcons.CustomIcon("machines/plants/bush/colored/berries");
    public static final IIconContainer sTextureImmature = new Textures.BlockIcons.CustomIcon("machines/plants/bush/colored/berries_immature");
    public static final IIconContainer sOverlayBush = new Textures.BlockIcons.CustomIcon("machines/plants/bush/overlay/bush");
    public static final IIconContainer sOverlayBerry = new Textures.BlockIcons.CustomIcon("machines/plants/bush/overlay/berries");
    public static final IIconContainer sOverlayImmature = new Textures.BlockIcons.CustomIcon("machines/plants/bush/overlay/berries_immature");
    private ITexture mTexture;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        this.mBerry = ST.load(aNBT, "gt.value");
        this.mStage = aNBT.getByte("gt.state");
        this.mGrowth = aNBT.getByte("gt.progress");
        super.readFromNBT2(aNBT);
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        aNBT.setByte("gt.state", this.mStage);
        aNBT.setByte("gt.progress", this.mGrowth);
        ST.save(aNBT, "gt.value", this.mBerry);
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        ST.save(aNBT, "gt.value", this.mBerry);
        return super.writeItemNBT2(aNBT);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + (ST.valid(this.mBerry) ? LH.get(this.mBerry.getUnlocalizedName(), this.mBerry.getDisplayName()) : "Rightclick with a Berry to set Output"));
    }

    @Override
    public void onOxygenRemoved() {
        if (this.isServerSide() && !WD.oxygen(this.worldObj, this.xCoord, this.yCoord, this.zCoord)) {
            this.setToAir();
        }
    }

    @Override
    public void onTickFirst2(boolean aIsServerSide) {
        super.onTickFirst2(aIsServerSide);
        if (this.getBlockAtSide((byte)1) == Blocks.snow_layer) {
            this.worldObj.setBlockToAir(this.xCoord, this.yCoord + 1, this.zCoord);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        block13: {
            super.onTick2(aTimer, aIsServerSide);
            if (!aIsServerSide) return;
            if (this.mBlockUpdated || CS.SERVER_TIME % 128L == 64L) {
                if (!WD.oxygen(this.worldObj, this.xCoord, this.yCoord, this.zCoord)) {
                    this.setToAir();
                    return;
                }
                if (this.getBlockAtSide((byte)1) == Blocks.snow_layer) {
                    this.worldObj.setBlockToAir(this.xCoord, this.yCoord + 1, this.zCoord);
                }
                if (CS.SIDES_VALID[this.mFacing]) {
                    TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(this.mFacing, 1);
                    if (tTileEntity instanceof MultiTileEntityBush) {
                        if (!ST.equal(((MultiTileEntityBush)tTileEntity).mBerry, this.mBerry, false)) {
                            this.mBerry = ((MultiTileEntityBush)tTileEntity).mBerry;
                            this.updateClientData();
                        }
                        this.mSpeed = ((MultiTileEntityBush)tTileEntity).mSpeed;
                        break block13;
                    } else {
                        this.mSpeed = 0;
                        this.mIgnoreUnloadedChunks = false;
                        if (this.getBlockAtSide(this.mFacing) != this.getBlockOffset(0, 0, 0)) {
                            this.popOff();
                        }
                        this.mIgnoreUnloadedChunks = true;
                        return;
                    }
                }
                Block tBlock = this.getBlockAtSide((byte)0);
                this.mSpeed = (byte)(IL.AETHER_Grass_Enchanted.equal(tBlock) || IL.AETHER_Grass_Enchanted_Vanilla.equal(tBlock) ? 2 : (CS.BlocksGT.plantableGreens.contains(tBlock) || tBlock.canSustainPlant((IBlockAccess)this.worldObj, this.xCoord, this.yCoord - 1, this.zCoord, CS.FORGE_DIR[1], (IPlantable)Blocks.yellow_flower) ? 1 : 0));
            }
        }
        if (this.mStage >= 3 || this.mSpeed <= 0 || CS.SERVER_TIME % 128L != 0L || !ST.valid(this.mBerry)) return;
        if (this.getSkyOffset(0, 1, 0)) {
            int i;
            for (i = 0; i < this.mSpeed; ++i) {
                this.mGrowth = (byte)(this.mGrowth + 1);
                if (this.mGrowth != 0) continue;
                this.mStage = (byte)(this.mStage + 1);
            }
            if (!this.worldObj.isRaining() || !this.getRainOffset(CS.OFFX[this.mFacing], CS.SIDES_TOP[this.mFacing] ? 1 : 2, CS.OFFZ[this.mFacing])) return;
            for (i = 0; i < this.mSpeed; ++i) {
                this.mGrowth = (byte)(this.mGrowth + 1);
                if (this.mGrowth != 0) continue;
                this.mStage = (byte)(this.mStage + 1);
            }
            return;
        }
        if (this.getLightLevelOffset(CS.OFFX[this.mFacing], CS.SIDES_TOP[this.mFacing] ? 1 : 2, CS.OFFZ[this.mFacing]) <= 9) return;
        for (int i = 0; i < this.mSpeed; ++i) {
            this.mGrowth = (byte)(this.mGrowth + 1);
            if (this.mGrowth != 0) continue;
            this.mStage = (byte)(this.mStage + 1);
        }
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return super.onTickCheck(aTimer) || this.mStage != this.oStage;
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oStage = this.mStage;
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null && ST.valid(this.mBerry)) {
                aChatReturn.add("Grows " + (CS.CODE_CLIENT ? this.mBerry.getDisplayName() : LH.get(this.mBerry.getDisplayName())));
            }
            return 1L;
        }
        return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return true;
        }
        if (ST.valid(this.mBerry)) {
            if (this.mStage < 3) {
                return false;
            }
            ST.give((Entity)aPlayer, ST.amount(1 + this.rng(2), this.mBerry), true, this.worldObj, this.getOffsetX(aSide), this.getOffsetY(aSide), this.getOffsetZ(aSide));
            this.mStage = 0;
            return true;
        }
        ItemStack aStack = aPlayer.getCurrentEquippedItem();
        if (OP.plantGtBerry.contains(aStack) || CS.BushesGT.get(aStack) != null) {
            this.mBerry = ST.amount(1L, aStack);
            this.updateClientData();
            return true;
        }
        return false;
    }

    @Override
    public boolean canPlace(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        TileEntity tTileEntity = aWorld.getTileEntity(aX - CS.OFFX[aSide], aY - CS.OFFY[aSide], aZ - CS.OFFZ[aSide]);
        if (tTileEntity instanceof MultiTileEntityBush && CS.SIDES_INVALID[((MultiTileEntityBush)tTileEntity).mFacing] && (ST.invalid(this.mBerry) || ST.equal(((MultiTileEntityBush)tTileEntity).mBerry, this.mBerry, false))) {
            this.mFacing = CS.OPOS[aSide];
            this.mBerry = ((MultiTileEntityBush)tTileEntity).mBerry;
            this.updateClientData();
            return true;
        }
        Block tBlock = aWorld.getBlock(aX, aY - 1, aZ);
        if (CS.BlocksGT.plantableGreens.contains(tBlock) || tBlock.canSustainPlant((IBlockAccess)aWorld, aX, aY - 1, aZ, CS.FORGE_DIR[1], (IPlantable)Blocks.yellow_flower)) {
            this.mFacing = (byte)6;
            this.mSpeed = 1;
            return true;
        }
        return false;
    }

    @Override
    public boolean onPlaced(ItemStack aStack, EntityPlayer aPlayer, MultiTileEntityContainer aMTEContainer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return true;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        if (ST.valid(this.mBerry)) {
            OreDictItemData tData = OM.anydata(this.mBerry);
            if (tData != null && tData.mPrefix == OP.plantGtBerry) {
                if (aShouldSideBeRendered == CS.SIDES_ITEM_RENDER) {
                    this.mTexture = BlockTextureMulti.get(BlockTextureDefault.get(sTextureBush, 36864), BlockTextureDefault.get(sOverlayBush), BlockTextureDefault.get(sTextureBerry, tData.mMaterial.mMaterial.fRGBaSolid), BlockTextureDefault.get(sOverlayBerry));
                } else {
                    switch (this.mStage) {
                        case 0: {
                            this.mTexture = BlockTextureMulti.get(BlockTextureDefault.get(sTextureBush, 36864), BlockTextureDefault.get(sOverlayBush));
                            break;
                        }
                        case 1: {
                            this.mTexture = BlockTextureMulti.get(BlockTextureDefault.get(sTextureBush, 36864), BlockTextureDefault.get(sOverlayBush), BlockTextureDefault.get(sTextureImmature, 0xFF9090), BlockTextureDefault.get(sOverlayImmature));
                            break;
                        }
                        case 2: {
                            this.mTexture = BlockTextureMulti.get(BlockTextureDefault.get(sTextureBush, 36864), BlockTextureDefault.get(sOverlayBush), BlockTextureDefault.get(sTextureBerry, 0x80FF80), BlockTextureDefault.get(sOverlayBerry));
                            break;
                        }
                        case 3: {
                            this.mTexture = BlockTextureMulti.get(BlockTextureDefault.get(sTextureBush, 36864), BlockTextureDefault.get(sOverlayBush), BlockTextureDefault.get(sTextureBerry, tData.mMaterial.mMaterial.fRGBaSolid), BlockTextureDefault.get(sOverlayBerry));
                        }
                    }
                }
            } else {
                int[] tBerryColor = CS.BushesGT.get(this.mBerry);
                if (tBerryColor == null) {
                    tBerryColor = new int[]{255, 0xFF00FF, 0xFF00FF, 0xFF00FF};
                }
                if (aShouldSideBeRendered == CS.SIDES_ITEM_RENDER) {
                    this.mTexture = BlockTextureMulti.get(BlockTextureDefault.get(sTextureBush, tBerryColor[0]), BlockTextureDefault.get(sOverlayBush), BlockTextureDefault.get(sTextureBerry, tBerryColor[2]), BlockTextureDefault.get(sOverlayBerry));
                } else {
                    switch (this.mStage) {
                        case 0: {
                            this.mTexture = BlockTextureMulti.get(BlockTextureDefault.get(sTextureBush, tBerryColor[0]), BlockTextureDefault.get(sOverlayBush));
                            break;
                        }
                        case 1: {
                            this.mTexture = BlockTextureMulti.get(BlockTextureDefault.get(sTextureBush, tBerryColor[0]), BlockTextureDefault.get(sOverlayBush), BlockTextureDefault.get(sTextureImmature, tBerryColor[1]), BlockTextureDefault.get(sOverlayImmature));
                            break;
                        }
                        case 2: {
                            this.mTexture = BlockTextureMulti.get(BlockTextureDefault.get(sTextureBush, tBerryColor[0]), BlockTextureDefault.get(sOverlayBush), BlockTextureDefault.get(sTextureBerry, tBerryColor[2]), BlockTextureDefault.get(sOverlayBerry));
                            break;
                        }
                        case 3: {
                            this.mTexture = BlockTextureMulti.get(BlockTextureDefault.get(sTextureBush, tBerryColor[0]), BlockTextureDefault.get(sOverlayBush), BlockTextureDefault.get(sTextureBerry, tBerryColor[3]), BlockTextureDefault.get(sOverlayBerry));
                        }
                    }
                }
            }
        } else {
            this.mTexture = BlockTextureMulti.get(BlockTextureDefault.get(sTextureBush, 0xFF00FF), BlockTextureDefault.get(sOverlayBush));
        }
        return this.hasSnow() ? 2 : 1;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        if (aRenderPass == 1) {
            this.box(aBlock, 0.0, 0.0, 0.0, 1.0, CS.PX_P[1], 1.0);
            return true;
        }
        switch (this.mFacing) {
            case 5: {
                this.box(aBlock, CS.PX_P[12], CS.PX_P[2], CS.PX_P[2], CS.PX_N[0], CS.PX_N[2], CS.PX_N[2]);
                return true;
            }
            case 1: {
                this.box(aBlock, CS.PX_P[2], CS.PX_P[12], CS.PX_P[2], CS.PX_N[2], CS.PX_N[0], CS.PX_N[2]);
                return true;
            }
            case 3: {
                this.box(aBlock, CS.PX_P[2], CS.PX_P[2], CS.PX_P[12], CS.PX_N[2], CS.PX_N[2], CS.PX_N[0]);
                return true;
            }
            case 4: {
                this.box(aBlock, CS.PX_P[0], CS.PX_P[2], CS.PX_P[2], CS.PX_N[12], CS.PX_N[2], CS.PX_N[2]);
                return true;
            }
            case 0: {
                this.box(aBlock, CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[12], CS.PX_N[2]);
                return true;
            }
            case 2: {
                this.box(aBlock, CS.PX_P[2], CS.PX_P[2], CS.PX_P[0], CS.PX_N[2], CS.PX_N[2], CS.PX_N[12]);
                return true;
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aRenderPass == 0 ? (aShouldSideBeRendered[aSide] || CS.SIDES_VALID[this.mFacing] ? this.mTexture : null) : (aShouldSideBeRendered[aSide] ? SNOW_TEXTURE : null);
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        short tID = ST.id(this.mBerry);
        short tMeta = tID > 0 ? ST.meta_(this.mBerry) : (short)0;
        return aSendAll ? this.getClientDataPacketByteArray(aSendAll, this.getDirectionData(), this.getVisualData(), UT.Code.toByteS(tID, 0), UT.Code.toByteS(tID, 1), UT.Code.toByteS(tMeta, 0), UT.Code.toByteS(tMeta, 1)) : this.getClientDataPacketByte(aSendAll, this.getVisualData());
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        this.setDirectionData(aData[0]);
        this.setVisualData(aData[1]);
        this.mBerry = ST.make(UT.Code.combine(aData[2], aData[3]), 1L, (long)UT.Code.combine(aData[4], aData[5]));
        return true;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        switch (this.mFacing) {
            case 5: {
                return this.box(CS.PX_P[14], CS.PX_P[2], CS.PX_P[2], CS.PX_N[0], CS.PX_N[2], CS.PX_N[2]);
            }
            case 1: {
                return this.box(CS.PX_P[2], CS.PX_P[14], CS.PX_P[2], CS.PX_N[2], CS.PX_N[0], CS.PX_N[2]);
            }
            case 3: {
                return this.box(CS.PX_P[2], CS.PX_P[2], CS.PX_P[14], CS.PX_N[2], CS.PX_N[2], CS.PX_N[0]);
            }
            case 4: {
                return this.box(CS.PX_P[0], CS.PX_P[2], CS.PX_P[2], CS.PX_N[14], CS.PX_N[2], CS.PX_N[2]);
            }
            case 0: {
                return this.box(CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[14], CS.PX_N[2]);
            }
            case 2: {
                return this.box(CS.PX_P[2], CS.PX_P[2], CS.PX_P[0], CS.PX_N[2], CS.PX_N[2], CS.PX_N[14]);
            }
        }
        return this.box();
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        switch (this.mFacing) {
            case 5: {
                return this.box(CS.PX_P[12], CS.PX_P[2], CS.PX_P[2], CS.PX_N[0], CS.PX_N[2], CS.PX_N[2]);
            }
            case 1: {
                return this.box(CS.PX_P[2], CS.PX_P[12], CS.PX_P[2], CS.PX_N[2], CS.PX_N[0], CS.PX_N[2]);
            }
            case 3: {
                return this.box(CS.PX_P[2], CS.PX_P[2], CS.PX_P[12], CS.PX_N[2], CS.PX_N[2], CS.PX_N[0]);
            }
            case 4: {
                return this.box(CS.PX_P[0], CS.PX_P[2], CS.PX_P[2], CS.PX_N[12], CS.PX_N[2], CS.PX_N[2]);
            }
            case 0: {
                return this.box(CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[12], CS.PX_N[2]);
            }
            case 2: {
                return this.box(CS.PX_P[2], CS.PX_P[2], CS.PX_P[0], CS.PX_N[2], CS.PX_N[2], CS.PX_N[12]);
            }
        }
        return this.box();
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        switch (this.mFacing) {
            case 5: {
                this.box(aBlock, CS.PX_P[12], CS.PX_P[2], CS.PX_P[2], CS.PX_N[0], CS.PX_N[2], CS.PX_N[2]);
                return;
            }
            case 1: {
                this.box(aBlock, CS.PX_P[2], CS.PX_P[12], CS.PX_P[2], CS.PX_N[2], CS.PX_N[0], CS.PX_N[2]);
                return;
            }
            case 3: {
                this.box(aBlock, CS.PX_P[2], CS.PX_P[2], CS.PX_P[12], CS.PX_N[2], CS.PX_N[2], CS.PX_N[0]);
                return;
            }
            case 4: {
                this.box(aBlock, CS.PX_P[0], CS.PX_P[2], CS.PX_P[2], CS.PX_N[12], CS.PX_N[2], CS.PX_N[2]);
                return;
            }
            case 0: {
                this.box(aBlock, CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[12], CS.PX_N[2]);
                return;
            }
            case 2: {
                this.box(aBlock, CS.PX_P[2], CS.PX_P[2], CS.PX_P[0], CS.PX_N[2], CS.PX_N[2], CS.PX_N[12]);
                return;
            }
        }
        this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]);
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return false;
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return false;
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return false;
    }

    @Override
    public boolean isSealable2(byte aSide) {
        return false;
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public boolean attachCoversFirst(byte aSide) {
        return false;
    }

    @Override
    public boolean isObstructingBlockAt(byte aSide) {
        return CS.SIDES_INVALID[this.mFacing];
    }

    @Override
    public boolean checkObstruction(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return false;
    }

    @Override
    public int getLightOpacity() {
        return CS.SIDES_INVALID[this.mFacing] ? 1 : 0;
    }

    @Override
    public byte getVisualData() {
        return this.mStage;
    }

    @Override
    public void setVisualData(byte aData) {
        this.mStage = (byte)(aData & 3);
    }

    @Override
    public boolean unpaint() {
        return false;
    }

    @Override
    public boolean isPainted() {
        return false;
    }

    @Override
    public boolean paint(int aRGB) {
        return false;
    }

    @Override
    public int getPaint() {
        return 0xFFFFFF;
    }

    @Override
    public boolean canRecolorItem(ItemStack aStack) {
        return false;
    }

    @Override
    public boolean canDecolorItem(ItemStack aStack) {
        return false;
    }

    @Override
    public boolean recolorItem(ItemStack aStack, int aRGB) {
        return false;
    }

    @Override
    public boolean decolorItem(ItemStack aStack) {
        return false;
    }

    @Override
    public String getFacingTool() {
        return null;
    }

    @Override
    public byte getDefaultSide() {
        return 6;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_ALL;
    }

    @Override
    public boolean isUsingWrenchingOverlay(ItemStack aStack, byte aSide) {
        return false;
    }

    @Override
    public float getExplosionResistance2() {
        return 0.2f;
    }

    @Override
    public int getFireSpreadSpeed(byte aSide, boolean aDefault) {
        return 300;
    }

    @Override
    public int getFlammability(byte aSide, boolean aDefault) {
        return 300;
    }

    @Override
    public boolean canDrop(int aSlot) {
        return false;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.plant.bush";
    }
}

