/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.multiblocks;

import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.fluid.FluidTankGT;
import gregapi.tileentity.multiblocks.ITileEntityMultiBlockController;
import gregapi.util.UT;
import gregtech.tileentity.multiblocks.MultiTileEntityLargeTurbine;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class MultiTileEntityLargeTurbineSteam
extends MultiTileEntityLargeTurbine {
    public FluidTankGT[] mTanks = new FluidTankGT[]{new FluidTankGT(), new FluidTankGT()};
    public long mSteamCounter = 0L;
    public long mEnergyProducedNextTick = 0L;
    public static final int STEAM_PER_WATER = 170;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.energy.su")) {
            this.mSteamCounter = aNBT.getLong("gt.energy.su");
        }
        if (aNBT.hasKey("gt.output.su")) {
            this.mEnergyProducedNextTick = aNBT.getLong("gt.output.su");
        }
        for (int i = 0; i < this.mTanks.length; ++i) {
            this.mTanks[i].readFromNBT(aNBT, "gt.tank." + i);
        }
        this.mTanks[0].setCapacity(this.mEnergyIN.mMax * 4L);
        this.mTanks[1].setCapacity(this.mEnergyIN.mMax * 4L).setVoidExcess();
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.energy.su", this.mSteamCounter);
        UT.NBT.setNumber(aNBT, "gt.output.su", this.mEnergyProducedNextTick);
        for (int i = 0; i < this.mTanks.length; ++i) {
            this.mTanks[i].writeToNBT(aNBT, "gt.tank." + i);
        }
    }

    @Override
    public boolean checkStructure2(ChunkCoordinates aCoordinates, Entity aPlayer, IInventory aInventory) {
        int tMinX = this.xCoord - (4 == this.mFacing ? 0 : (5 == this.mFacing ? 3 : 1));
        int tMinY = this.yCoord - (0 == this.mFacing ? 0 : (1 == this.mFacing ? 3 : 1));
        int tMinZ = this.zCoord - (2 == this.mFacing ? 0 : (3 == this.mFacing ? 3 : 1));
        int tMaxX = this.xCoord + (5 == this.mFacing ? 0 : (4 == this.mFacing ? 3 : 1));
        int tMaxY = this.yCoord + (1 == this.mFacing ? 0 : (0 == this.mFacing ? 3 : 1));
        int tMaxZ = this.zCoord + (3 == this.mFacing ? 0 : (2 == this.mFacing ? 3 : 1));
        int tOutX = this.getOffsetXN(this.mFacing, 3);
        int tOutY = this.getOffsetYN(this.mFacing, 3);
        int tOutZ = this.getOffsetZN(this.mFacing, 3);
        if (this.worldObj.blockExists(tMinX, tMinY, tMinZ) && this.worldObj.blockExists(tMaxX, tMaxY, tMaxZ)) {
            this.mEmitter = null;
            boolean tSuccess = true;
            for (int tX = tMinX; tX <= tMaxX; ++tX) {
                for (int tY = tMinY; tY <= tMaxY; ++tY) {
                    for (int tZ = tMinZ; tZ <= tMaxZ; ++tZ) {
                        int tBits = 0;
                        tBits = tX == tOutX && tY == tOutY && tZ == tOutZ ? -2 : (CS.SIDES_AXIS_X[this.mFacing] && tX == this.xCoord || CS.SIDES_AXIS_Y[this.mFacing] && tY == this.yCoord || CS.SIDES_AXIS_Z[this.mFacing] && tZ == this.zCoord ? (tY == tMinY ? -13 : -9) : (tY == tMinY ? -5 : -1));
                        if (ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX, tY, tZ, this.mTurbineWalls, this.getMultiTileEntityRegistryID(), tX == tOutX && tY == tOutY && tZ == tOutZ ? 3 : 0, tBits, aCoordinates, aPlayer, aInventory)) continue;
                        tSuccess = false;
                    }
                }
            }
            return tSuccess;
        }
        return this.mStructureOkay;
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.structure") + ":");
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.steamturbine.1") + MultiTileEntityRegistry.getRegistry(this.getMultiTileEntityRegistryID()).getLocal(this.mTurbineWalls));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.steamturbine.2"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.steamturbine.3"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.steamturbine.4"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public void addToolTipsEnergy(List<String> aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTipsEnergy(aList, aStack, aF3_H);
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.emits.used.steam") + " (" + LH.get("gt.lang.face.sides") + ", 95%)");
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("plunger")) {
            if (this.mTanks[0].has()) {
                return CS.GarbageGT.trash(this.mTanks[0]);
            }
            return CS.GarbageGT.trash(this.mTanks[1]);
        }
        return 0L;
    }

    @Override
    public void doConversion(long aTimer) {
        if (this.mEnergyProducedNextTick > 0L) {
            this.mStorage.mEnergy += this.mEnergyProducedNextTick;
            this.mEnergyProducedNextTick = 0L;
        } else if (!this.mStopped && this.mTanks[0].has(this.getEnergySizeInputMin(this.mEnergyIN.mType, (byte)6) * 2L)) {
            long tSteam = this.mTanks[0].amount();
            this.mSteamCounter += tSteam;
            this.mStorage.mEnergy += tSteam / 2L;
            this.mEnergyProducedNextTick += tSteam / 2L;
            this.mTanks[0].setEmpty();
            if (this.mSteamCounter >= 170L) {
                this.mTanks[1].fillAll(FL.DistW.make(this.mSteamCounter / 170L));
                this.mSteamCounter %= 170L;
            }
        }
        super.doConversion(aTimer);
    }

    @Override
    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        return !this.mStopped && FL.steam(aFluidToFill) ? this.mTanks[0] : null;
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        return this.mTanks[1];
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        return this.mTanks;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.multiblock.turbine.steam";
    }

    static {
        LH.add("gt.tooltip.multiblock.steamturbine.1", "3x3x4 of 35 ");
        LH.add("gt.tooltip.multiblock.steamturbine.2", "Main centered on the 3x3 facing outwards");
        LH.add("gt.tooltip.multiblock.steamturbine.3", "Input only possible at frontal 3x3");
        LH.add("gt.tooltip.multiblock.steamturbine.4", "Distilled Water can be pumped out at Bottom Layer");
    }
}

