/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.multiblocks;

import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.FM;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.fluid.FluidTankGT;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.tileentity.behavior.TE_Behavior_Active_Trinary;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.machines.ITileEntityRunningActively;
import gregapi.tileentity.multiblocks.IMultiBlockEnergy;
import gregapi.tileentity.multiblocks.IMultiBlockFluidHandler;
import gregapi.tileentity.multiblocks.ITileEntityMultiBlockController;
import gregapi.tileentity.multiblocks.TileEntityBase10MultiBlockBase;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class MultiTileEntityLargeHeatExchanger
extends TileEntityBase10MultiBlockBase
implements IFluidHandler,
ITileEntityRunningActively,
ITileEntityEnergy,
IMultiBlockFluidHandler,
IMultiBlockEnergy {
    public short mEfficiency = (short)10000;
    public long mEnergy = 0L;
    public long mRate = 8L;
    public TagData mEnergyTypeEmitted = TD.Energy.HU;
    public Recipe.RecipeMap mRecipes = FM.Hot;
    public Recipe mLastRecipe = null;
    public FluidTankGT[] mTanks = new FluidTankGT[]{new FluidTankGT(10000L), new FluidTankGT()};
    public TE_Behavior_Active_Trinary mActivity = null;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mEnergy = aNBT.getLong("gt.energy");
        this.mActivity = new TE_Behavior_Active_Trinary(this, aNBT);
        if (aNBT.hasKey("gt.output")) {
            this.mRate = aNBT.getLong("gt.output");
        }
        if (aNBT.hasKey("gt.fuelmap")) {
            this.mRecipes = Recipe.RecipeMap.RECIPE_MAPS.get(aNBT.getString("gt.fuelmap"));
        }
        if (aNBT.hasKey("gt.eff")) {
            this.mEfficiency = (short)UT.Code.bind_(0L, 10000L, aNBT.getShort("gt.eff"));
        }
        if (aNBT.hasKey("gt.energy.emitted")) {
            this.mEnergyTypeEmitted = TagData.createTagData(aNBT.getString("gt.energy.emitted"));
        }
        this.mTanks[0].setCapacity(this.mRate * 10L);
        this.mTanks[0].readFromNBT(aNBT, "gt.tank.0");
        this.mTanks[1].readFromNBT(aNBT, "gt.tank.1");
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.energy", this.mEnergy);
        this.mActivity.save(aNBT);
        this.mTanks[0].writeToNBT(aNBT, "gt.tank.0");
        this.mTanks[1].writeToNBT(aNBT, "gt.tank.1");
    }

    @Override
    public boolean checkStructure2(ChunkCoordinates aCoordinates, Entity aPlayer, IInventory aInventory) {
        int tX = this.xCoord - 1;
        int tY = this.yCoord;
        int tZ = this.zCoord - 1;
        if (this.worldObj.blockExists(tX - 1, tY, tZ - 1) && this.worldObj.blockExists(tX + 1, tY, tZ - 1) && this.worldObj.blockExists(tX - 1, tY, tZ + 1) && this.worldObj.blockExists(tX + 1, tY, tZ + 1)) {
            boolean tSuccess = true;
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX, tY, tZ, 18024, this.getMultiTileEntityRegistryID(), 0, -43, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + 1, tY, tZ, 18024, this.getMultiTileEntityRegistryID(), 0, -43, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + 2, tY, tZ, 18024, this.getMultiTileEntityRegistryID(), 0, -43, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX, tY, tZ + 1, 18024, this.getMultiTileEntityRegistryID(), 0, -43, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + 2, tY, tZ + 1, 18024, this.getMultiTileEntityRegistryID(), 0, -43, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX, tY, tZ + 2, 18024, this.getMultiTileEntityRegistryID(), 0, -43, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + 1, tY, tZ + 2, 18024, this.getMultiTileEntityRegistryID(), 0, -43, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + 2, tY, tZ + 2, 18024, this.getMultiTileEntityRegistryID(), 0, -43, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX, tY + 1, tZ, 18101, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + 1, tY + 1, tZ, 18101, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + 2, tY + 1, tZ, 18101, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX, tY + 1, tZ + 1, 18101, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + 1, tY + 1, tZ + 1, 18024, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + 2, tY + 1, tZ + 1, 18101, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX, tY + 1, tZ + 2, 18101, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + 1, tY + 1, tZ + 2, 18101, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + 2, tY + 1, tZ + 2, 18101, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            return tSuccess;
        }
        return this.mStructureOkay;
    }

    @Override
    public boolean isInsideStructure(int aX, int aY, int aZ) {
        int tX = this.xCoord;
        int tY = this.yCoord;
        int tZ = this.zCoord;
        return aX >= tX - 1 && aY >= tY && aZ >= tZ - 1 && aX <= tX + 1 && aY <= tY + 1 && aZ <= tZ + 1;
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.structure") + ":");
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.heatexchanger.1"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.heatexchanger.2"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.heatexchanger.3"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.heatexchanger.4"));
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes") + ": " + LH.Chat.WHITE + LH.get(this.mRecipes.mNameInternal));
        aList.add(LH.getToolTipEfficiency(this.mEfficiency));
        LH.addEnergyToolTips(this, aList, null, this.mEnergyTypeEmitted, null, LH.get("gt.lang.face.top"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.funnel.tap.tank"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide) {
            if (this.mEnergy >= 8L) {
                long tTransferred = Math.min(this.mRate / 8L, this.mEnergy / 8L);
                this.mEnergy -= tTransferred * 8L;
                ITileEntityEnergy.Util.insertEnergyInto(this.mEnergyTypeEmitted, 1L, tTransferred, this, WD.te(this.worldObj, this.xCoord, this.yCoord + 2, this.zCoord - 1, (byte)0, true));
                ITileEntityEnergy.Util.insertEnergyInto(this.mEnergyTypeEmitted, 1L, tTransferred, this, WD.te(this.worldObj, this.xCoord - 1, this.yCoord + 2, this.zCoord, (byte)0, true));
                ITileEntityEnergy.Util.insertEnergyInto(this.mEnergyTypeEmitted, 1L, tTransferred, this, WD.te(this.worldObj, this.xCoord, this.yCoord + 2, this.zCoord + 1, (byte)0, true));
                ITileEntityEnergy.Util.insertEnergyInto(this.mEnergyTypeEmitted, 1L, tTransferred, this, WD.te(this.worldObj, this.xCoord + 1, this.yCoord + 2, this.zCoord, (byte)0, true));
                ITileEntityEnergy.Util.insertEnergyInto(this.mEnergyTypeEmitted, 1L, tTransferred, this, WD.te(this.worldObj, this.xCoord + 1, this.yCoord + 2, this.zCoord - 1, (byte)0, true));
                ITileEntityEnergy.Util.insertEnergyInto(this.mEnergyTypeEmitted, 1L, tTransferred, this, WD.te(this.worldObj, this.xCoord - 1, this.yCoord + 2, this.zCoord - 1, (byte)0, true));
                ITileEntityEnergy.Util.insertEnergyInto(this.mEnergyTypeEmitted, 1L, tTransferred, this, WD.te(this.worldObj, this.xCoord - 1, this.yCoord + 2, this.zCoord + 1, (byte)0, true));
                ITileEntityEnergy.Util.insertEnergyInto(this.mEnergyTypeEmitted, 1L, tTransferred, this, WD.te(this.worldObj, this.xCoord + 1, this.yCoord + 2, this.zCoord + 1, (byte)0, true));
            }
            if (this.mEnergy < this.mRate * 2L) {
                this.mActivity.mActive = false;
                if (!this.mTanks[1].has(this.mRate * 20L)) {
                    Recipe tRecipe = this.mRecipes.findRecipe((IHasWorldAndCoords)this, this.mLastRecipe, true, Long.MAX_VALUE, CS.NI, this.mTanks[0].AS_ARRAY, CS.ZL_IS);
                    if (tRecipe != null) {
                        if (tRecipe.mFluidOutputs.length <= 0 || this.mTanks[1].canFillAll(tRecipe.mFluidOutputs[0])) {
                            if (tRecipe.isRecipeInputEqual(true, false, this.mTanks[0].AS_ARRAY, CS.ZL_IS)) {
                                this.mActivity.mActive = true;
                                this.mLastRecipe = tRecipe;
                                this.mEnergy += UT.Code.units(tRecipe.getAbsoluteTotalPower(), 10000L, this.mEfficiency, false);
                                if (tRecipe.mFluidOutputs.length > 0) {
                                    this.mTanks[1].fill(tRecipe.mFluidOutputs[0]);
                                }
                                while (this.mEnergy < this.mRate * 2L && (tRecipe.mFluidOutputs.length <= 0 || this.mTanks[1].canFillAll(tRecipe.mFluidOutputs[0])) && tRecipe.isRecipeInputEqual(true, false, this.mTanks[0].AS_ARRAY, CS.ZL_IS)) {
                                    this.mEnergy += UT.Code.units(tRecipe.getAbsoluteTotalPower(), 10000L, this.mEfficiency, false);
                                    if (tRecipe.mFluidOutputs.length > 0) {
                                        this.mTanks[1].fill(tRecipe.mFluidOutputs[0]);
                                    }
                                    if (!this.mTanks[0].isEmpty()) continue;
                                    break;
                                }
                            } else if (this.mActivity.mData == 0L) {
                                this.mTanks[0].setEmpty();
                            }
                        }
                    } else {
                        this.mTanks[0].setEmpty();
                    }
                }
            }
            if (this.mEnergy < 8L) {
                this.mEnergy = 0L;
            }
            if (this.mTanks[1].has()) {
                FL.move(this.mTanks[1], this.getAdjacentTank((byte)0));
            }
        }
    }

    @Override
    public void onMagnifyingGlass2(List<String> aChatReturn) {
        aChatReturn.add("Structure is formed already!");
        aChatReturn.add("Input: " + this.mTanks[0].content());
        aChatReturn.add("Output: " + this.mTanks[1].content());
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return this.mActivity.check(false) || super.onTickCheck(aTimer);
    }

    @Override
    public void setVisualData(byte aData) {
        this.mActivity.mState = (byte)(aData & 0x7F);
    }

    @Override
    public byte getVisualData() {
        return this.mActivity.mState;
    }

    @Override
    public byte getDefaultSide() {
        return 0;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_BOTTOM;
    }

    @Override
    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        return this.mRecipes.containsInput(aFluidToFill, (IHasWorldAndCoords)this, CS.NI) ? this.mTanks[0] : null;
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        return this.mTanks[1];
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        return this.mTanks;
    }

    @Override
    public int funnelFill(byte aSide, FluidStack aFluid, boolean aDoFill) {
        if (!this.mRecipes.containsInput(aFluid, (IHasWorldAndCoords)this, CS.NI)) {
            return 0;
        }
        this.updateInventory();
        return this.mTanks[0].fill(aFluid, aDoFill);
    }

    @Override
    public FluidStack tapDrain(byte aSide, int aMaxDrain, boolean aDoDrain) {
        this.updateInventory();
        return this.mTanks[this.mTanks[1].has() ? 1 : 0].drain(aMaxDrain, aDoDrain);
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return CS.ZL_IS;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return aEmitting && aEnergyType == this.mEnergyTypeEmitted;
    }

    @Override
    public boolean isEnergyEmittingTo(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return CS.SIDES_TOP[aSide] && super.isEnergyEmittingTo(aEnergyType, aSide, aTheoretical);
    }

    @Override
    public long getEnergyOffered(TagData aEnergyType, byte aSide, long aSize) {
        return Math.min(this.mRate, this.mEnergy);
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, byte aSide) {
        return this.mRate;
    }

    @Override
    public long getEnergySizeOutputMin(TagData aEnergyType, byte aSide) {
        return this.mRate;
    }

    @Override
    public long getEnergySizeOutputMax(TagData aEnergyType, byte aSide) {
        return this.mRate;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return this.mEnergyTypeEmitted.AS_LIST;
    }

    @Override
    public boolean getStateRunningPassively() {
        return this.mActivity.mActive;
    }

    @Override
    public boolean getStateRunningPossible() {
        return this.mActivity.mActive;
    }

    @Override
    public boolean getStateRunningActively() {
        return this.mActivity.mActive;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.multiblock.heatexchanger";
    }

    static {
        LH.add("gt.tooltip.multiblock.heatexchanger.1", "3x3 Ring of 8 Heat Transmitters with Dense Tungsten Wall inside");
        LH.add("gt.tooltip.multiblock.heatexchanger.2", "3x3 Ring of 8 Dense Tungsten Walls with Main inside");
        LH.add("gt.tooltip.multiblock.heatexchanger.3", "Energy Output split over the 8 Heat Transmitters (Top)");
        LH.add("gt.tooltip.multiblock.heatexchanger.4", "Input at Bottom Layer, Fluid Output at Main Block");
    }
}

