/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.energy.generators;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.FM;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.fluid.FluidTankGT;
import gregapi.old.Textures;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityFunnelAccessible;
import gregapi.tileentity.ITileEntityTapAccessible;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.behavior.TE_Behavior_Active_Trinary;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.machines.ITileEntityRunningActively;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class MultiTileEntityGeneratorHotFluid
extends TileEntityBase09FacingSingle
implements IFluidHandler,
ITileEntityTapAccessible,
ITileEntityFunnelAccessible,
ITileEntityEnergy,
ITileEntityRunningActively,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_OnEntityCollidedWithBlock {
    private static int FLAME_RANGE = 2;
    public short mEfficiency = (short)10000;
    public long mEnergy = 0L;
    public long mRate = 1L;
    public TagData mEnergyTypeEmitted = TD.Energy.HU;
    public Recipe.RecipeMap mRecipes = FM.Hot;
    public Recipe mLastRecipe = null;
    public FluidTankGT[] mTanks = new FluidTankGT[]{new FluidTankGT(1000L), new FluidTankGT()};
    public TE_Behavior_Active_Trinary mActivity = null;
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/generators/hot_fluid/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/generators/hot_fluid/colored/top"), new Textures.BlockIcons.CustomIcon("machines/generators/hot_fluid/colored/left"), new Textures.BlockIcons.CustomIcon("machines/generators/hot_fluid/colored/front"), new Textures.BlockIcons.CustomIcon("machines/generators/hot_fluid/colored/right"), new Textures.BlockIcons.CustomIcon("machines/generators/hot_fluid/colored/back")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/generators/hot_fluid/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/generators/hot_fluid/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/generators/hot_fluid/overlay/left"), new Textures.BlockIcons.CustomIcon("machines/generators/hot_fluid/overlay/front"), new Textures.BlockIcons.CustomIcon("machines/generators/hot_fluid/overlay/right"), new Textures.BlockIcons.CustomIcon("machines/generators/hot_fluid/overlay/back")};
    public static IIconContainer[] sOverlaysActive = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/generators/hot_fluid/overlay_active/bottom"), new Textures.BlockIcons.CustomIcon("machines/generators/hot_fluid/overlay_active/top"), new Textures.BlockIcons.CustomIcon("machines/generators/hot_fluid/overlay_active/left"), new Textures.BlockIcons.CustomIcon("machines/generators/hot_fluid/overlay_active/front"), new Textures.BlockIcons.CustomIcon("machines/generators/hot_fluid/overlay_active/right"), new Textures.BlockIcons.CustomIcon("machines/generators/hot_fluid/overlay_active/back")};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mEnergy = aNBT.getLong("gt.energy");
        this.mActivity = new TE_Behavior_Active_Trinary(this, aNBT);
        if (aNBT.hasKey("gt.output")) {
            this.mRate = aNBT.getLong("gt.output");
        }
        if (aNBT.hasKey("gt.fuelmap")) {
            this.mRecipes = Recipe.RecipeMap.RECIPE_MAPS.get(aNBT.getString("gt.fuelmap"));
        }
        if (aNBT.hasKey("gt.eff")) {
            this.mEfficiency = (short)UT.Code.bind_(0L, 10000L, aNBT.getShort("gt.eff"));
        }
        if (aNBT.hasKey("gt.energy.emitted")) {
            this.mEnergyTypeEmitted = TagData.createTagData(aNBT.getString("gt.energy.emitted"));
        }
        this.mTanks[0].setCapacity(this.mRate * 10L);
        this.mTanks[0].readFromNBT(aNBT, "gt.tank.0");
        this.mTanks[1].readFromNBT(aNBT, "gt.tank.1");
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.energy", this.mEnergy);
        this.mActivity.save(aNBT);
        this.mTanks[0].writeToNBT(aNBT, "gt.tank.0");
        this.mTanks[1].writeToNBT(aNBT, "gt.tank.1");
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes") + ": " + LH.Chat.WHITE + LH.get(this.mRecipes.mNameInternal));
        aList.add(LH.getToolTipEfficiency(this.mEfficiency));
        LH.addEnergyToolTips(this, aList, null, this.mEnergyTypeEmitted, null, LH.get("gt.lang.face.top"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.funnel.tap.tank"));
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.fire") + " (" + (FLAME_RANGE + 1) + "m)");
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.contact") + " (" + LH.get("gt.lang.face.top") + ")");
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            if (this.mEnergy > 0L) {
                ITileEntityEnergy.Util.emitEnergyToNetwork(this.mEnergyTypeEmitted, 1L, Math.min(this.mRate, this.mEnergy), this);
                this.mEnergy -= Math.min(this.mRate, this.mEnergy);
                if (this.mEfficiency < 1 || this.rng(this.mEfficiency) == 0) {
                    WD.fire(this.worldObj, this.xCoord - FLAME_RANGE + this.rng(2 * FLAME_RANGE + 1), this.yCoord - 1 + this.rng(2 + FLAME_RANGE), this.zCoord - FLAME_RANGE + this.rng(2 * FLAME_RANGE + 1), true);
                }
            }
            if (this.mEnergy < this.mRate * 2L) {
                this.mActivity.mActive = false;
                if (!this.mTanks[1].has(this.mRate * 20L)) {
                    Recipe tRecipe = this.mRecipes.findRecipe((IHasWorldAndCoords)this, this.mLastRecipe, true, Long.MAX_VALUE, CS.NI, this.mTanks[0].AS_ARRAY, CS.ZL_IS);
                    if (tRecipe != null) {
                        if (tRecipe.mFluidOutputs.length <= 0 || this.mTanks[1].canFillAll(tRecipe.mFluidOutputs[0])) {
                            if (tRecipe.isRecipeInputEqual(true, false, this.mTanks[0].AS_ARRAY, CS.ZL_IS)) {
                                this.mActivity.mActive = true;
                                this.mLastRecipe = tRecipe;
                                this.mEnergy += UT.Code.units(tRecipe.getAbsoluteTotalPower(), 10000L, this.mEfficiency, false);
                                if (tRecipe.mFluidOutputs.length > 0) {
                                    this.mTanks[1].fill(tRecipe.mFluidOutputs[0]);
                                }
                                while (this.mEnergy < this.mRate * 2L && (tRecipe.mFluidOutputs.length <= 0 || this.mTanks[1].canFillAll(tRecipe.mFluidOutputs[0])) && tRecipe.isRecipeInputEqual(true, false, this.mTanks[0].AS_ARRAY, CS.ZL_IS)) {
                                    this.mEnergy += UT.Code.units(tRecipe.getAbsoluteTotalPower(), 10000L, this.mEfficiency, false);
                                    if (tRecipe.mFluidOutputs.length > 0) {
                                        this.mTanks[1].fill(tRecipe.mFluidOutputs[0]);
                                    }
                                    if (!this.mTanks[0].isEmpty()) continue;
                                    break;
                                }
                            } else if (this.mActivity.mData == 0L) {
                                this.mTanks[0].setEmpty();
                            }
                        }
                    } else {
                        this.mTanks[0].setEmpty();
                    }
                }
            }
            if (this.mEnergy < 0L) {
                this.mEnergy = 0L;
            }
            if (this.mTanks[1].has()) {
                FL.move(this.mTanks[1], this.getAdjacentTank(this.mFacing));
            }
        }
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("plunger")) {
            if (this.mTanks[1].has()) {
                return CS.GarbageGT.trash(this.mTanks[1]);
            }
            return CS.GarbageGT.trash(this.mTanks[0]);
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                aChatReturn.add("Input: " + this.mTanks[0].content());
                aChatReturn.add("Output: " + this.mTanks[1].content());
            }
            return 1L;
        }
        return 0L;
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return this.mActivity.check(false) || super.onTickCheck(aTimer);
    }

    @Override
    public void setVisualData(byte aData) {
        this.mActivity.mState = (byte)(aData & 0x7F);
    }

    @Override
    public byte getVisualData() {
        return this.mActivity.mState;
    }

    @Override
    public byte getDefaultSide() {
        return 3;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_BOTTOM_HORIZONTAL;
    }

    @Override
    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        return this.mRecipes.containsInput(aFluidToFill, (IHasWorldAndCoords)this, CS.NI) ? this.mTanks[0] : null;
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        return this.mTanks[1];
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        return this.mTanks;
    }

    @Override
    public int funnelFill(byte aSide, FluidStack aFluid, boolean aDoFill) {
        if (!this.mRecipes.containsInput(aFluid, (IHasWorldAndCoords)this, CS.NI)) {
            return 0;
        }
        this.updateInventory();
        return this.mTanks[0].fill(aFluid, aDoFill);
    }

    @Override
    public FluidStack tapDrain(byte aSide, int aMaxDrain, boolean aDoDrain) {
        this.updateInventory();
        return this.mTanks[this.mTanks[1].has() ? 1 : 0].drain(aMaxDrain, aDoDrain);
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aShouldSideBeRendered[aSide] ? (CS.SIDES_TOP[aSide] ? BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[1], this.mRGBa), BlockTextureDefault.get((this.mActivity.mState > 0 ? sOverlaysActive : sOverlays)[1])) : (aSide == this.mFacing ? BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[3], this.mRGBa), BlockTextureDefault.get((this.mActivity.mState > 0 ? sOverlaysActive : sOverlays)[3])) : BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[2], this.mRGBa), BlockTextureDefault.get((this.mActivity.mState > 0 ? sOverlaysActive : sOverlays)[2])))) : null;
    }

    @Override
    public void onEntityCollidedWithBlock(Entity aEntity) {
        if (this.mActivity.mState > 0) {
            UT.Entities.applyHeatDamage(aEntity, Math.min(10.0f, (float)this.mRate / 10.0f));
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.box(0.0, 0.0, 0.0, 1.0, 0.875, 1.0);
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return CS.ZL_IS;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return aEmitting && aEnergyType == this.mEnergyTypeEmitted;
    }

    @Override
    public boolean isEnergyEmittingTo(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return CS.SIDES_TOP[aSide] && super.isEnergyEmittingTo(aEnergyType, aSide, aTheoretical);
    }

    @Override
    public long getEnergyOffered(TagData aEnergyType, byte aSide, long aSize) {
        return Math.min(this.mRate, this.mEnergy);
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, byte aSide) {
        return this.mRate;
    }

    @Override
    public long getEnergySizeOutputMin(TagData aEnergyType, byte aSide) {
        return this.mRate;
    }

    @Override
    public long getEnergySizeOutputMax(TagData aEnergyType, byte aSide) {
        return this.mRate;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return this.mEnergyTypeEmitted.AS_LIST;
    }

    @Override
    public boolean getStateRunningPassively() {
        return this.mActivity.mActive;
    }

    @Override
    public boolean getStateRunningPossible() {
        return this.mActivity.mActive || this.mTanks[0].has();
    }

    @Override
    public boolean getStateRunningActively() {
        return this.mActivity.mActive;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.generator.hot_fluid";
    }
}

