/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.c;

import gregapi.code.ArrayListNoNulls;
import gregapi.data.ANY;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.OP;
import gregapi.data.RM;
import gregapi.data.TD;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.oredict.configurations.IOreDictConfigurationComponent;
import gregapi.recipes.Recipe;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class Loader_Recipes_Decomp
implements Runnable {
    @Override
    public void run() {
        try {
            for (OreDictMaterial aMaterial : OreDictMaterial.MATERIAL_MAP.values()) {
                IOreDictConfigurationComponent tComponents;
                if (aMaterial.mTargetRegistration != aMaterial || (tComponents = aMaterial.mComponents) == null || tComponents.getCommonDivider() > 64L || !aMaterial.contains(TD.Compounds.DECOMPOSABLE)) continue;
                ArrayListNoNulls<Recipe.RecipeMap> tRecipeMaps = new ArrayListNoNulls<Recipe.RecipeMap>();
                if (aMaterial.contains(TD.Processing.CENTRIFUGE)) {
                    tRecipeMaps.add(RM.Centrifuge);
                }
                if (aMaterial.contains(TD.Processing.ELECTROLYSER)) {
                    tRecipeMaps.add(RM.Electrolyzer);
                }
                if (tRecipeMaps.isEmpty()) continue;
                ArrayListNoNulls<ItemStack> tStackOutputs = ST.arraylist(new ItemStack[0]);
                ArrayListNoNulls<FluidStack> tFluidOutputs = FL.arraylist(new FluidStack[0]);
                long tAmount = 0L;
                for (OreDictMaterialStack tMaterial : tComponents.getUndividedComponents()) {
                    tAmount += tMaterial.mAmount;
                    if ((tMaterial.mMaterial.mMeltingPoint > 293L || !tFluidOutputs.add(tMaterial.mMaterial.fluid(tMaterial.mAmount, false))) && !tStackOutputs.add(OM.dust(tMaterial.mMaterial.mTargetPulver.mMaterial, UT.Code.units(tMaterial.mAmount, 648648000L, tMaterial.mMaterial.mTargetPulver.mAmount, false)))) continue;
                }
                if (tStackOutputs.size() <= 0 && tFluidOutputs.size() <= 0) continue;
                for (Recipe.RecipeMap tRecipeMap : tRecipeMaps) {
                    boolean temp = true;
                    if (temp && tRecipeMap.mInputFluidCount > 0) {
                        FluidStack aFluid = aMaterial.liquid(tComponents.getCommonDivider() * 648648000L, true);
                        if (FL.nonzero(aFluid)) {
                            temp = false;
                            if (tRecipeMap == RM.Electrolyzer) {
                                tRecipeMap.addRecipe1(true, true, false, false, false, Math.max(16L, tAmount * 14L / 648648000L), UT.Code.units(tAmount, 648648000L, 292L, true), ST.tag(0L), FL.array(aFluid), UT.Code.makeArray(new FluidStack[tRecipeMap.mOutputFluidCount], tFluidOutputs.toArray(CS.ZL_FS)), UT.Code.makeArray(new ItemStack[tRecipeMap.mOutputItemsCount], tStackOutputs.toArray(CS.ZL_IS)));
                            } else {
                                tRecipeMap.addRecipe0(true, true, false, false, false, Math.max(16L, tAmount * 14L / 648648000L), UT.Code.units(tAmount, 648648000L, 292L, true), FL.array(aFluid), UT.Code.makeArray(new FluidStack[tRecipeMap.mOutputFluidCount], tFluidOutputs.toArray(CS.ZL_FS)), UT.Code.makeArray(new ItemStack[tRecipeMap.mOutputItemsCount], tStackOutputs.toArray(CS.ZL_IS)));
                            }
                        }
                        if (FL.nonzero(aFluid = aMaterial.gas(tComponents.getCommonDivider() * 648648000L, true))) {
                            temp = false;
                            if (tRecipeMap == RM.Electrolyzer) {
                                tRecipeMap.addRecipe1(true, true, false, false, false, Math.max(16L, tAmount * 14L / 648648000L), UT.Code.units(tAmount, 648648000L, 292L, true), ST.tag(0L), FL.array(aFluid), UT.Code.makeArray(new FluidStack[tRecipeMap.mOutputFluidCount], tFluidOutputs.toArray(CS.ZL_FS)), UT.Code.makeArray(new ItemStack[tRecipeMap.mOutputItemsCount], tStackOutputs.toArray(CS.ZL_IS)));
                            } else {
                                tRecipeMap.addRecipe0(true, true, false, false, false, Math.max(16L, tAmount * 14L / 648648000L), UT.Code.units(tAmount, 648648000L, 292L, true), FL.array(aFluid), UT.Code.makeArray(new FluidStack[tRecipeMap.mOutputFluidCount], tFluidOutputs.toArray(CS.ZL_FS)), UT.Code.makeArray(new ItemStack[tRecipeMap.mOutputItemsCount], tStackOutputs.toArray(CS.ZL_IS)));
                            }
                        }
                    }
                    if (!temp && !aMaterial.mReRegistrations.contains(ANY.Glowstone) || tRecipeMap.mInputItemsCount <= 0) continue;
                    ItemStack aStack = OP.dust.mat(aMaterial, tComponents.getCommonDivider());
                    if (aStack != null) {
                        temp = false;
                        if (tRecipeMap == RM.Electrolyzer) {
                            tRecipeMap.addRecipe2(true, true, false, false, false, Math.max(16L, tAmount * 14L / 648648000L), UT.Code.units(tAmount, 648648000L, 292L, true), ST.tag(0L), aStack, CS.ZL_FS, UT.Code.makeArray(new FluidStack[tRecipeMap.mOutputFluidCount], tFluidOutputs.toArray(CS.ZL_FS)), UT.Code.makeArray(new ItemStack[tRecipeMap.mOutputItemsCount], tStackOutputs.toArray(CS.ZL_IS)));
                        } else {
                            tRecipeMap.addRecipe1(true, true, false, false, false, Math.max(16L, tAmount * 14L / 648648000L), UT.Code.units(tAmount, 648648000L, 292L, true), aStack, CS.ZL_FS, UT.Code.makeArray(new FluidStack[tRecipeMap.mOutputFluidCount], tFluidOutputs.toArray(CS.ZL_FS)), UT.Code.makeArray(new ItemStack[tRecipeMap.mOutputItemsCount], tStackOutputs.toArray(CS.ZL_IS)));
                        }
                    }
                    if (tComponents.getCommonDivider() % 9L != 0L || (aStack = OP.blockDust.mat(aMaterial, tComponents.getCommonDivider() / 9L)) == null) continue;
                    temp = false;
                    if (tRecipeMap == RM.Electrolyzer) {
                        tRecipeMap.addRecipe2(true, true, false, false, false, Math.max(16L, tAmount * 14L / 648648000L), UT.Code.units(tAmount, 648648000L, 292L, true), ST.tag(0L), aStack, CS.ZL_FS, UT.Code.makeArray(new FluidStack[tRecipeMap.mOutputFluidCount], tFluidOutputs.toArray(CS.ZL_FS)), UT.Code.makeArray(new ItemStack[tRecipeMap.mOutputItemsCount], tStackOutputs.toArray(CS.ZL_IS)));
                        continue;
                    }
                    tRecipeMap.addRecipe1(true, true, false, false, false, Math.max(16L, tAmount * 14L / 648648000L), UT.Code.units(tAmount, 648648000L, 292L, true), aStack, CS.ZL_FS, UT.Code.makeArray(new FluidStack[tRecipeMap.mOutputFluidCount], tFluidOutputs.toArray(CS.ZL_FS)), UT.Code.makeArray(new ItemStack[tRecipeMap.mOutputItemsCount], tStackOutputs.toArray(CS.ZL_IS)));
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
    }
}

