/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.tools.machine;

import gregapi.block.misc.BlockBaseBars;
import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.MD;
import gregapi.data.MT;
import gregapi.item.multiitem.MultiItemTool;
import gregapi.item.multiitem.behaviors.Behavior_Tool;
import gregapi.item.multiitem.tools.ToolStats;
import gregapi.old.Textures;
import gregapi.oredict.OreDictMaterial;
import gregapi.render.IIconContainer;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class GT_Tool_Wrench
extends ToolStats {
    public static final List<String> mEffectiveList = Arrays.asList("EntityTowerGuardian");
    public List<String> mRegistryNamePrefixes;

    public GT_Tool_Wrench() {
        this.mRegistryNamePrefixes = new ArrayListNoNulls<String>(false, "BuildCraft|", "Forestry:core", "Forestry:mail", "Forestry:alveary", "Forestry:factory", "Forestry:engine", "Forestry:ffarm", "Railcraft:machine", "progressiveautomation", "MineFactoryReloaded:machine", "MineFactoryReloaded:rednet", "MCFrames:", MD.FUNK.mID, MD.WARPDRIVE.mID);
    }

    @Override
    public float getNormalDamageAgainstEntity(float aOriginalDamage, Entity aEntity, ItemStack aStack, EntityPlayer aPlayer) {
        String tName = aEntity.getClass().getName();
        tName = tName.substring(tName.lastIndexOf(".") + 1);
        return aEntity instanceof EntityIronGolem || mEffectiveList.contains(tName) || tName.contains("Golem") ? aOriginalDamage * 2.0f : aOriginalDamage;
    }

    @Override
    public int getToolDamagePerBlockBreak() {
        return 50;
    }

    @Override
    public int getToolDamagePerContainerCraft() {
        return 800;
    }

    @Override
    public int getToolDamagePerEntityAttack() {
        return 200;
    }

    @Override
    public int getHurtResistanceTime(int aOriginalHurtResistance, Entity aEntity) {
        return aOriginalHurtResistance * 2;
    }

    @Override
    public float getBaseDamage() {
        return 5.0f;
    }

    @Override
    public float getExhaustionPerAttack(Entity aEntity) {
        return 0.6f;
    }

    @Override
    public String getCraftingSound() {
        return CS.SFX.GT_WRENCH;
    }

    @Override
    public String getMiningSound() {
        return CS.SFX.GT_WRENCH;
    }

    @Override
    public boolean canCollect() {
        return true;
    }

    @Override
    public boolean isWrench() {
        return true;
    }

    @Override
    public boolean isMinableBlock(Block aBlock, byte aMetaData) {
        if (aBlock.getMaterial() == Material.piston || aBlock.getMaterial() == Material.redstoneLight || aBlock instanceof BlockBaseBars || aBlock == Blocks.hopper || aBlock == Blocks.dispenser || aBlock == Blocks.dropper) {
            return true;
        }
        if ("wrench".equalsIgnoreCase(aBlock.getHarvestTool((int)aMetaData))) {
            return true;
        }
        if (aBlock.getMaterial().isLiquid()) {
            return false;
        }
        String tName = ST.regName(aBlock);
        if (UT.Code.stringInvalid(tName)) {
            return false;
        }
        if (MD.AE.owns_(tName)) {
            return aBlock.getMaterial() == Material.iron || aBlock.getMaterial() == Material.anvil;
        }
        for (String tPrefix : this.mRegistryNamePrefixes) {
            if (!tName.startsWith(tPrefix)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IIconContainer getIcon(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? Textures.ItemIcons.WRENCH : Textures.ItemIcons.VOID;
    }

    @Override
    public short[] getRGBa(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? MultiItemTool.getPrimaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.Steel).mRGBaSolid : CS.UNCOLOURED;
    }

    @Override
    public void onStatsAddedToTool(MultiItemTool aItem, int aID) {
        aItem.addItemBehavior(aID, new Behavior_Tool("wrench", CS.SFX.GT_WRENCH, 100L, !this.canBlock(), CS.SFX.RANDOM_PITCH));
    }

    @Override
    public String getDeathMessage() {
        return "[KILLER] gave [VICTIM] a whack with the Wrench!";
    }
}

