/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.tools.early;

import gregapi.block.MaterialAdventure;
import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.data.RM;
import gregapi.item.multiitem.MultiItemTool;
import gregapi.item.multiitem.behaviors.Behavior_Place_Paddy;
import gregapi.item.multiitem.behaviors.Behavior_Place_Path;
import gregapi.item.multiitem.behaviors.Behavior_Place_Torch;
import gregapi.item.multiitem.behaviors.Behavior_Plug_Leak;
import gregapi.item.multiitem.behaviors.Behavior_Tool;
import gregapi.item.multiitem.tools.ToolStats;
import gregapi.oredict.OreDictMaterial;
import gregapi.recipes.Recipe;
import gregapi.render.IIconContainer;
import gregapi.util.ST;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraftforge.event.world.BlockEvent;

public class GT_Tool_UniversalSpade
extends ToolStats {
    @Override
    public int getToolDamagePerBlockBreak() {
        return 100;
    }

    @Override
    public int getToolDamagePerDropConversion() {
        return 100;
    }

    @Override
    public int getToolDamagePerContainerCraft() {
        return 400;
    }

    @Override
    public int getToolDamagePerEntityAttack() {
        return 100;
    }

    @Override
    public int getBaseQuality() {
        return 0;
    }

    @Override
    public float getBaseDamage() {
        return 3.0f;
    }

    @Override
    public float getSpeedMultiplier() {
        return 0.75f;
    }

    @Override
    public float getMaxDurabilityMultiplier() {
        return 1.0f;
    }

    @Override
    public boolean canCollect() {
        return true;
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    @Override
    public boolean isCrowbar() {
        return true;
    }

    @Override
    public boolean isWeapon() {
        return true;
    }

    @Override
    public boolean isMinableBlock(Block aBlock, byte aMetaData) {
        if (aBlock instanceof BlockRailBase || CS.BlocksGT.openableCrowbar.contains(aBlock)) {
            return true;
        }
        String tTool = aBlock.getHarvestTool((int)aMetaData);
        return tTool != null && (tTool.equalsIgnoreCase("shovel") || tTool.equalsIgnoreCase("axe") || tTool.equalsIgnoreCase("saw") || tTool.equalsIgnoreCase("sword") || tTool.equalsIgnoreCase("crowbar")) || aBlock.getMaterial() == Material.sand || aBlock.getMaterial() == Material.grass || aBlock.getMaterial() == Material.ground || aBlock.getMaterial() == Material.snow || aBlock.getMaterial() == Material.craftedSnow || aBlock.getMaterial() == Material.clay || aBlock.getMaterial() == Material.leaves || aBlock.getMaterial() == Material.vine || aBlock.getMaterial() == Material.wood || aBlock.getMaterial() == MaterialAdventure.WOOD || aBlock.getMaterial() == Material.cactus || aBlock.getMaterial() == Material.circuits || aBlock.getMaterial() == Material.gourd || aBlock.getMaterial() == Material.web || aBlock.getMaterial() == Material.cloth || aBlock.getMaterial() == Material.carpet || aBlock.getMaterial() == Material.plants || aBlock.getMaterial() == Material.cake || aBlock.getMaterial() == Material.tnt || aBlock.getMaterial() == Material.fire || aBlock.getMaterial() == Material.sponge;
    }

    @Override
    public int convertBlockDrops(List<ItemStack> aDrops, ItemStack aStack, EntityPlayer aPlayer, Block aBlock, long aAvailableDurability, int aX, int aY, int aZ, byte aMetaData, int aFortune, boolean aSilkTouch, BlockEvent.HarvestDropsEvent aEvent) {
        if (CS.BlocksGT.openableCrowbar.contains(aBlock)) {
            ArrayListNoNulls<ItemStack> tDrops = ST.arraylist(new ItemStack[0]);
            for (int i = 0; i < aDrops.size(); ++i) {
                Recipe tRecipe = RM.Unboxinator.findRecipe(null, null, true, Integer.MAX_VALUE, CS.NI, CS.ZL_FS, ST.amount(1L, aDrops.get(i)));
                if (tRecipe == null) continue;
                int tStackSize = aDrops.get((int)i).stackSize;
                aDrops.remove(i--);
                if (tRecipe.mOutputs.length <= 0) continue;
                for (int j = 0; j < tStackSize; ++j) {
                    ItemStack[] tOutput = tRecipe.getOutputs();
                    for (int k = 0; k < tOutput.length; ++k) {
                        tDrops.add(tOutput[k]);
                    }
                }
            }
            aDrops.addAll(tDrops);
        }
        return 0;
    }

    @Override
    public IIconContainer getIcon(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? MultiItemTool.getPrimaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.Steel).mTextureSetsItems.get(OP.toolHeadUniversalSpade.mIconIndexItem) : MultiItemTool.getSecondaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.Steel).mTextureSetsItems.get(OP.stick.mIconIndexItem);
    }

    @Override
    public short[] getRGBa(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? MultiItemTool.getPrimaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.Steel).mRGBaSolid : MultiItemTool.getSecondaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.Steel).mRGBaSolid;
    }

    @Override
    public void onStatsAddedToTool(MultiItemTool aItem, int aID) {
        aItem.addItemBehavior(aID, Behavior_Plug_Leak.INSTANCE);
        aItem.addItemBehavior(aID, new Behavior_Place_Path(50));
        aItem.addItemBehavior(aID, new Behavior_Place_Paddy(50));
        aItem.addItemBehavior(aID, new Behavior_Tool("crowbar", "random.break", 200L, false, CS.SFX.RANDOM_PITCH));
        aItem.addItemBehavior(aID, new Behavior_Tool("shovel", "dig.gravel", 100L, false, CS.SFX.RANDOM_PITCH));
        aItem.addItemBehavior(aID, Behavior_Place_Torch.INSTANCE);
    }

    @Override
    public void onToolCrafted(ItemStack aStack, EntityPlayer aPlayer) {
        super.onToolCrafted(aStack, aPlayer);
        aPlayer.triggerAchievement((StatBase)AchievementList.buildSword);
    }

    @Override
    public String getDeathMessage() {
        return "[VICTIM] has been digged by [KILLER]";
    }
}

