/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.behaviors;

import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.util.ST;
import gregapi.util.UT;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class Behavior_Sonictron
extends IBehavior.AbstractBehaviorDefault {
    public static final IBehavior<MultiItem> INSTANCE = new Behavior_Sonictron();

    @Override
    public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float hitX, float hitY, float hitZ) {
        Behavior_Sonictron.setCurrentIndex(aStack, -1);
        return false;
    }

    @Override
    public ItemStack onItemRightClick(MultiItem aItem, ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        Behavior_Sonictron.setCurrentIndex(aStack, 0);
        return aStack;
    }

    @Override
    public void onUpdate(MultiItem aItem, ItemStack aStack, World aWorld, Entity aPlayer, int aTimer, boolean aIsInHand) {
        int tTickTimer = Behavior_Sonictron.getTickTimer(aStack);
        int tCurrentIndex = Behavior_Sonictron.getCurrentIndex(aStack);
        if (tTickTimer++ % 2 == 0 && tCurrentIndex > -1 && ++tCurrentIndex > 63) {
            tCurrentIndex = -1;
        }
        Behavior_Sonictron.setTickTimer(aStack, tTickTimer);
        Behavior_Sonictron.setCurrentIndex(aStack, tCurrentIndex);
    }

    public static int getCurrentIndex(ItemStack aStack) {
        NBTTagCompound tNBTTagCompound = aStack.getTagCompound();
        if (tNBTTagCompound == null) {
            tNBTTagCompound = UT.NBT.make();
        }
        return tNBTTagCompound.getInteger("mCurrentIndex");
    }

    public static int getTickTimer(ItemStack aStack) {
        NBTTagCompound tNBTTagCompound = aStack.getTagCompound();
        if (tNBTTagCompound == null) {
            tNBTTagCompound = UT.NBT.make();
        }
        return tNBTTagCompound.getInteger("mTickTimer");
    }

    public static NBTTagCompound setCurrentIndex(ItemStack aStack, int aIndex) {
        NBTTagCompound tNBTTagCompound = aStack.getTagCompound();
        if (tNBTTagCompound == null) {
            tNBTTagCompound = UT.NBT.make();
        }
        tNBTTagCompound.setInteger("mCurrentIndex", aIndex);
        return tNBTTagCompound;
    }

    public static NBTTagCompound setTickTimer(ItemStack aStack, int aTime) {
        NBTTagCompound tNBTTagCompound = aStack.getTagCompound();
        if (tNBTTagCompound == null) {
            tNBTTagCompound = UT.NBT.make();
        }
        tNBTTagCompound.setInteger("mTickTimer", aTime);
        return tNBTTagCompound;
    }

    public static ItemStack[] getNBTInventory(ItemStack aStack) {
        ItemStack[] tInventory = new ItemStack[64];
        NBTTagCompound tNBT = aStack.getTagCompound();
        if (tNBT == null) {
            return tInventory;
        }
        NBTTagList tNBT_ItemList = tNBT.getTagList("Inventory", 10);
        for (int i = 0; i < tNBT_ItemList.tagCount(); ++i) {
            NBTTagCompound tag = tNBT_ItemList.getCompoundTagAt(i);
            byte slot = tag.getByte("Slot");
            if (slot < 0 || slot >= tInventory.length) continue;
            tInventory[slot] = ST.load(tag);
        }
        return tInventory;
    }

    public static NBTTagCompound setNBTInventory(ItemStack aStack, ItemStack[] aInventory) {
        NBTTagCompound tNBT = aStack.getTagCompound();
        if (tNBT == null) {
            tNBT = UT.NBT.make();
        }
        NBTTagList tNBT_ItemList = new NBTTagList();
        for (int i = 0; i < aInventory.length; ++i) {
            ItemStack stack = aInventory[i];
            if (stack == null) continue;
            NBTTagCompound tag = UT.NBT.make();
            tag.setByte("Slot", (byte)i);
            tNBT_ItemList.appendTag((NBTBase)ST.save(stack));
        }
        tNBT.setTag("Inventory", (NBTBase)tNBT_ItemList);
        UT.NBT.set(aStack, tNBT);
        return tNBT;
    }

    public static void copyInventory(ItemStack[] aInventory, ItemStack[] aNewContent, int aIndexlength) {
        for (int i = 0; i < aIndexlength; ++i) {
            aInventory[i] = aNewContent[i] == null ? null : ST.copy(aNewContent[i]);
        }
    }
}

