/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.behaviors;

import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.tileentity.ITileEntityKeyInteractable;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class Behavior_Key
extends IBehavior.AbstractBehaviorDefault {
    public static final IBehavior<MultiItem> INSTANCE = new Behavior_Key();

    @Override
    public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float hitX, float hitY, float hitZ) {
        if (aWorld.isRemote) {
            return false;
        }
        DelegatorTileEntity<TileEntity> aTileEntity = WD.te(aWorld, aX, aY, aZ, aSide, true);
        if (aTileEntity.mTileEntity instanceof ITileEntityKeyInteractable) {
            NBTTagCompound tNBT = UT.NBT.getNBT(aStack);
            long tKeyID = tNBT.getLong("gt.key");
            if (tKeyID != 0L) {
                return ((ITileEntityKeyInteractable)aTileEntity.mTileEntity).useKey(aPlayer, aSide, hitX, hitY, hitZ, tKeyID);
            }
            tKeyID = ((ITileEntityKeyInteractable)aTileEntity.mTileEntity).getKeyID();
            if (tKeyID == 0L) {
                tKeyID = 1L + Math.max((long)CS.RNGSUS.nextInt(1000000), System.nanoTime());
                UT.NBT.set(aStack, UT.NBT.setNumber(tNBT, "gt.key", tKeyID));
                return ((ITileEntityKeyInteractable)aTileEntity.mTileEntity).useKey(aPlayer, aSide, hitX, hitY, hitZ, tKeyID);
            }
            if (((ITileEntityKeyInteractable)aTileEntity.mTileEntity).canCloneKey(aPlayer, aSide, hitX, hitY, hitZ)) {
                UT.NBT.set(aStack, UT.NBT.setNumber(tNBT, "gt.key", tKeyID));
                return true;
            }
        }
        return false;
    }

    @Override
    public List<String> getAdditionalToolTips(MultiItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(LH.get("gt.behaviour.key"));
        NBTTagCompound tNBT = aStack.getTagCompound();
        if (tNBT != null && tNBT.hasKey("gt.key")) {
            aList.add("Key ID: " + UT.Code.makeString(tNBT.getLong("gt.key")));
        } else {
            aList.add("*BLANK*");
        }
        return aList;
    }

    static {
        LH.add("gt.behaviour.key", "Can open certain regular Locks");
    }
}

