/*
 * Decompiled with CFR 0.152.
 */
package gregtech.entities.projectiles;

import gregapi.data.CS;
import gregapi.util.UT;
import gregtech.entities.projectiles.EntityArrow_Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EntityArrow_Potion
extends EntityArrow_Material {
    private int[] mPotions = new int[0];

    public EntityArrow_Potion(World aWorld) {
        super(aWorld);
    }

    public EntityArrow_Potion(World aWorld, double aX, double aY, double aZ) {
        super(aWorld, aX, aY, aZ);
    }

    public EntityArrow_Potion(World aWorld, EntityLivingBase aEntity, float aSpeed) {
        super(aWorld, aEntity, aSpeed);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound aNBT) {
        super.writeEntityToNBT(aNBT);
        aNBT.setIntArray("mPotions", this.mPotions);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound aNBT) {
        super.readEntityFromNBT(aNBT);
        this.setPotions(aNBT.getIntArray("mPotions"));
    }

    @Override
    public boolean breaksOnImpact() {
        return true;
    }

    public void setPotions(int ... aPotions) {
        if (aPotions != null) {
            this.mPotions = aPotions;
        }
    }

    public int[] getPotions() {
        return this.mPotions;
    }

    @Override
    public int[] onHitEntity(Entity aHitEntity, Entity aShootingEntity, ItemStack aArrow, int aRegularDamage, int aMagicDamage, int aKnockback, int aFireDamage, int aHitTimer) {
        if (aHitEntity instanceof EntityLivingBase) {
            for (int i = 3; i < this.mPotions.length; i += 4) {
                if (CS.RNGSUS.nextInt(100) >= this.mPotions[i]) continue;
                UT.Entities.applyPotion(aHitEntity, this.mPotions[i - 3], this.mPotions[i - 2], this.mPotions[i - 1], false);
            }
        }
        return super.onHitEntity(aHitEntity, aShootingEntity, aArrow, 1, aMagicDamage, aKnockback, aFireDamage, aHitTimer);
    }
}

