/*
 * Decompiled with CFR 0.152.
 */
package gregtech.blocks.tree;

import gregapi.block.tree.BlockBaseSapling;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.OP;
import gregapi.old.Textures;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.WD;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class BlockTreeSaplingCD
extends BlockBaseSapling {
    public BlockTreeSaplingCD(String aUnlocalised) {
        super(null, aUnlocalised, Material.plants, soundTypeGrass, 1L, Textures.BlockIcons.SAPLINGS_CD);
        LH.add(this.getUnlocalizedName() + ".0", "Blue Spruce Sapling");
        LH.add(this.getUnlocalizedName() + ".8", "Blue Spruce Sapling");
        for (int i = 0; i < this.maxMeta(); ++i) {
            OM.reg(ST.make(this, 1L, (long)i), OP.treeSapling);
            OM.reg(ST.make(this, 1L, (long)(i + 8)), OP.treeSapling);
        }
    }

    @Override
    public boolean grow(World aWorld, int aX, int aY, int aZ, byte aMeta, Random aRandom) {
        int tMaxHeight = 0;
        switch (aMeta & 7) {
            case 0: {
                int j;
                int i;
                tMaxHeight = this.getMaxHeight(aWorld, aX, aY, aZ, 16);
                if (tMaxHeight < 16) {
                    return false;
                }
                tMaxHeight = aY + tMaxHeight - aRandom.nextInt(3);
                for (i = -3; i <= 3; ++i) {
                    for (j = -3; j <= 3; ++j) {
                        if (i == 0 && j == 0 || this.canPlaceTree(aWorld, aX + i, tMaxHeight - 5, aZ + j)) continue;
                        return false;
                    }
                }
                if (aWorld.isRemote) {
                    return true;
                }
                WD.set(aWorld, aX, aY, aZ, (Block)CS.BlocksGT.LogC, 0L, 3L);
                for (int tY = aY + 1; tY < tMaxHeight; ++tY) {
                    this.placeTree(aWorld, aX, tY, aZ, CS.BlocksGT.LogC, 0);
                }
                this.placeTree(aWorld, aX, tMaxHeight, aZ, CS.BlocksGT.Leaves_CD, 8);
                this.placeTree(aWorld, aX, tMaxHeight + 1, aZ, CS.BlocksGT.Leaves_CD, 8);
                this.placeTree(aWorld, aX + 1, tMaxHeight - 1, aZ, CS.BlocksGT.Leaves_CD, 8);
                this.placeTree(aWorld, aX - 1, tMaxHeight - 1, aZ, CS.BlocksGT.Leaves_CD, 8);
                this.placeTree(aWorld, aX, tMaxHeight - 1, aZ + 1, CS.BlocksGT.Leaves_CD, 8);
                this.placeTree(aWorld, aX, tMaxHeight - 1, aZ - 1, CS.BlocksGT.Leaves_CD, 8);
                for (i = -6; i <= 6; ++i) {
                    block7: for (j = -6; j <= 6; ++j) {
                        int k;
                        if (i == 0 && j == 0) continue;
                        for (k = 1; k <= 14; ++k) {
                            if (!((double)(i * i + j * j) < (double)(k * k) * 0.2)) continue;
                            this.placeTree(aWorld, aX + i, tMaxHeight + 1 - k, aZ + j, CS.BlocksGT.Leaves_CD, 8);
                        }
                        if (i * i + j * j > 30) continue;
                        for (k = 0; k <= 3; ++k) {
                            Block tBlock = WD.block(aWorld, aX + i, aY - k, aZ + j, true);
                            if (WD.air(aWorld, aX + i, aY - k, aZ + j, tBlock)) continue;
                            if (tBlock != Blocks.dirt && tBlock != Blocks.grass) continue block7;
                            WD.set(aWorld, aX + i, aY - k, aZ + j, Blocks.dirt, 2L, 3L, false);
                            continue block7;
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void addInformation(ItemStack aStack, byte aMeta, EntityPlayer aPlayer, List<String> aList, boolean aF3_H) {
        super.addInformation(aStack, aMeta, aPlayer, aList, aF3_H);
        if (CS.XMAS_IN_JULY && (aMeta & 7) == 0) {
            aList.add(LH.Chat.RAINBOW_SLOW + "Save on everything at Christmas in July!");
        }
    }
}

