/*
 * Decompiled with CFR 0.152.
 */
package gregtech.blocks.fluids;

import gregapi.block.IBlockExtendedMetaData;
import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.util.WD;
import gregtech.blocks.fluids.BlockOcean;
import gregtech.blocks.fluids.BlockWaterlike;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fluids.Fluid;

public class BlockSwamp
extends BlockWaterlike {
    public static boolean PLACEMENT_ALLOWED = false;
    public static boolean FLOWS_OUT = true;

    public BlockSwamp(String aName, Fluid aFluid) {
        super(aName, aFluid, FLOWS_OUT, true);
        this.tickRate = 10;
    }

    public void onBlockAdded(World aWorld, int aX, int aY, int aZ) {
        if (PLACEMENT_ALLOWED) {
            aWorld.scheduleBlockUpdate(aX, aY, aZ, (Block)this, 10 + CS.RNGSUS.nextInt(90));
        } else {
            aWorld.setBlockToAir(aX, aY, aZ);
        }
    }

    public void updateTick(World aWorld, int aX, int aY, int aZ, Random aRandom) {
        int j;
        Block tBlock;
        PLACEMENT_ALLOWED = true;
        if (aWorld.doChunksNearChunkExist(aX, aY, aZ, 33)) {
            aWorld.func_147451_t(aX, aY, aZ);
            WD.update((IBlockAccess)aWorld, aX, aY, aZ);
            if (aY > 0) {
                if (aWorld.getBlock(aX, aY - 1, aZ) == this) {
                    aWorld.scheduleBlockUpdate(aX, aY - 1, aZ, (Block)this, this.tickRate);
                } else {
                    aWorld.func_147451_t(aX, aY - 1, aZ);
                    WD.update((IBlockAccess)aWorld, aX, aY - 1, aZ);
                }
            }
        } else {
            aWorld.scheduleBlockUpdate(aX, aY, aZ, (Block)this, Math.max(600, this.tickRate));
            PLACEMENT_ALLOWED = false;
            return;
        }
        if (aY <= 0) {
            this.updateFlow(aWorld, aX, aY, aZ, aRandom);
            PLACEMENT_ALLOWED = false;
            return;
        }
        BiomeGenBase tBiome = aWorld.getBiomeGenForCoords(aX, aZ);
        boolean tDirt = false;
        int tSwampCounter = 0;
        ArrayListNoNulls<ChunkCoordinates> tList = new ArrayListNoNulls<ChunkCoordinates>();
        for (byte tSide : CS.ALL_SIDES_BUT_TOP) {
            tBlock = WD.block(aWorld, aX, aY, aZ, tSide);
            if (tBlock == CS.NB) continue;
            byte tMeta = WD.meta(aWorld, aX, aY, aZ, tSide);
            if (tBlock == this) {
                if (tMeta != 0) continue;
                tSwampCounter = (byte)(tSwampCounter + 1);
                continue;
            }
            if (tBlock instanceof BlockWaterlike) {
                if (tMeta != 0 && !(tBlock instanceof BlockOcean)) continue;
                tSwampCounter = (byte)(tSwampCounter + 1);
                continue;
            }
            if (tBlock == Blocks.water || tBlock == Blocks.flowing_water) {
                tList.add(new ChunkCoordinates(aX + CS.OFFX[tSide], aY + CS.OFFY[tSide], aZ + CS.OFFZ[tSide]));
                if (tMeta != 0) continue;
                tSwampCounter = (byte)(tSwampCounter + 1);
                continue;
            }
            if (tBlock == Blocks.sand || tBlock == Blocks.dirt || tBlock == Blocks.grass || tBlock == Blocks.mycelium || tBlock == CS.BlocksGT.Grass || tBlock == CS.BlocksGT.Diggables || tBlock == CS.BlocksGT.Sands || tBlock == CS.BlocksGT.oreSand || tBlock == CS.BlocksGT.oreRedSand || tBlock == CS.BlocksGT.oreMud || tBlock == CS.BlocksGT.oreSmallSand || tBlock == CS.BlocksGT.oreSmallRedSand || tBlock == CS.BlocksGT.oreSmallMud || IL.EtFu_Dirt.equal(tBlock)) {
                tDirt = true;
                continue;
            }
            if (!IL.TF_Mazestone.equal(tBlock)) continue;
            if (WD.air(aWorld, aX, aY + 1, aZ)) {
                aWorld.setBlock(aX, aY + 1, aZ, Blocks.brown_mushroom_block, 10, 3);
            } else if (WD.anywater((IBlockAccess)aWorld, aX, aY + 1, aZ)) {
                aWorld.setBlock(aX, aY + 1, aZ, Blocks.brown_mushroom_block, 10, 3);
            }
            if (WD.air(aWorld, aX, aY + 2, aZ)) {
                aWorld.setBlock(aX, aY + 2, aZ, Blocks.brown_mushroom_block, 10, 3);
            } else if (WD.anywater((IBlockAccess)aWorld, aX, aY + 2, aZ)) {
                aWorld.setBlock(aX, aY + 2, aZ, Blocks.brown_mushroom_block, 10, 3);
            }
            if (WD.air(aWorld, aX, aY + 3, aZ)) {
                aWorld.setBlock(aX, aY + 3, aZ, Blocks.brown_mushroom_block, 10, 3);
            } else if (WD.anywater((IBlockAccess)aWorld, aX, aY + 3, aZ)) {
                aWorld.setBlock(aX, aY + 3, aZ, Blocks.brown_mushroom_block, 10, 3);
            }
            if (WD.air(aWorld, aX, aY + 4, aZ)) {
                aWorld.setBlock(aX, aY + 4, aZ, Blocks.brown_mushroom_block, 10, 3);
            } else if (WD.anywater((IBlockAccess)aWorld, aX, aY + 4, aZ)) {
                aWorld.setBlock(aX, aY + 4, aZ, Blocks.brown_mushroom_block, 10, 3);
            }
            for (int i = -2; i <= 2; ++i) {
                for (int j2 = -2; j2 <= 2; ++j2) {
                    if (Math.abs(i * j2) < 4) {
                        if (WD.air(aWorld, aX + i, aY, aZ + j2)) {
                            aWorld.setBlock(aX + i, aY, aZ + j2, Blocks.brown_mushroom_block, 5, 3);
                        } else if (WD.anywater((IBlockAccess)aWorld, aX + i, aY, aZ + j2)) {
                            aWorld.setBlock(aX + i, aY, aZ + j2, Blocks.brown_mushroom_block, 5, 3);
                        }
                        if (WD.air(aWorld, aX + i, aY + 5, aZ + j2)) {
                            aWorld.setBlock(aX + i, aY + 5, aZ + j2, Blocks.brown_mushroom_block, 5, 3);
                        } else if (WD.anywater((IBlockAccess)aWorld, aX + i, aY + 5, aZ + j2)) {
                            aWorld.setBlock(aX + i, aY + 5, aZ + j2, Blocks.brown_mushroom_block, 5, 3);
                        }
                    } else {
                        if (WD.anywater((IBlockAccess)aWorld, aX + i, aY, aZ + j2)) {
                            aWorld.setBlock(aX + i, aY, aZ + j2, CS.NB, 0, 3);
                        }
                        if (WD.anywater((IBlockAccess)aWorld, aX + i, aY + 5, aZ + j2)) {
                            aWorld.setBlock(aX + i, aY + 5, aZ + j2, CS.NB, 0, 3);
                        }
                    }
                    if (WD.anywater((IBlockAccess)aWorld, aX + i, aY + 4, aZ + j2)) {
                        aWorld.setBlock(aX + i, aY + 4, aZ + j2, CS.NB, 0, 3);
                    }
                    if (WD.anywater((IBlockAccess)aWorld, aX + i, aY + 3, aZ + j2)) {
                        aWorld.setBlock(aX + i, aY + 3, aZ + j2, CS.NB, 0, 3);
                    }
                    if (WD.anywater((IBlockAccess)aWorld, aX + i, aY + 2, aZ + j2)) {
                        aWorld.setBlock(aX + i, aY + 2, aZ + j2, CS.NB, 0, 3);
                    }
                    if (WD.anywater((IBlockAccess)aWorld, aX + i, aY + 1, aZ + j2)) {
                        aWorld.setBlock(aX + i, aY + 1, aZ + j2, CS.NB, 0, 3);
                    }
                    if (WD.anywater((IBlockAccess)aWorld, aX + i, aY - 1, aZ + j2)) {
                        aWorld.setBlock(aX + i, aY - 1, aZ + j2, CS.NB, 0, 3);
                    }
                    if (!WD.anywater((IBlockAccess)aWorld, aX + i, aY - 2, aZ + j2)) continue;
                    aWorld.setBlock(aX + i, aY - 1, aZ + j2, CS.NB, 0, 3);
                }
            }
            PLACEMENT_ALLOWED = false;
            return;
        }
        if (tDirt) {
            for (int i = -1; i <= 1; ++i) {
                for (j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        tBlock = aWorld.getBlock(aX + i, aY + j, aZ + k);
                        if (tBlock == Blocks.sand || tBlock == Blocks.dirt || tBlock == Blocks.grass || tBlock == Blocks.mycelium || IL.EtFu_Dirt.equal(tBlock)) {
                            aWorld.setBlock(aX + i, aY + j, aZ + k, (Block)CS.BlocksGT.Diggables, 0, 2);
                            continue;
                        }
                        if (tBlock == CS.BlocksGT.oreSand || tBlock == CS.BlocksGT.oreRedSand) {
                            CS.BlocksGT.oreMud.placeBlock(aWorld, aX + i, aY + j, aZ + k, (byte)6, ((IBlockExtendedMetaData)tBlock).getExtendedMetaData((IBlockAccess)aWorld, aX + i, aY + j, aZ + k), null, true, true);
                            continue;
                        }
                        if (tBlock != CS.BlocksGT.oreSmallSand && tBlock != CS.BlocksGT.oreSmallRedSand) continue;
                        CS.BlocksGT.oreSmallMud.placeBlock(aWorld, aX + i, aY + j, aZ + k, (byte)6, ((IBlockExtendedMetaData)tBlock).getExtendedMetaData((IBlockAccess)aWorld, aX + i, aY + j, aZ + k), null, true, true);
                    }
                }
            }
        }
        if (aWorld.getBlockMetadata(aX, aY, aZ) == 0) {
            if (tSwampCounter <= 0 && !(aWorld.getBlock(aX, aY + 1, aZ) instanceof BlockSwamp)) {
                aWorld.setBlockToAir(aX, aY, aZ);
                PLACEMENT_ALLOWED = false;
                return;
            }
        } else if (tSwampCounter >= 2) {
            aWorld.setBlock(aX, aY, aZ, (Block)this, 0, WATER_UPDATE_FLAGS);
        }
        if (CS.BIOMES_INFINITE_WATER.contains(tBiome.biomeName)) {
            tSwampCounter = 0;
            for (int i = -1; i < 2; ++i) {
                for (j = -1; j < 2; ++j) {
                    if (i == 0 || j == 0 || !(aWorld.getBlock(aX + i, aY, aZ + j) instanceof BlockSwamp) || aWorld.getBlockMetadata(aX + i, aY, aZ + j) != 0) continue;
                    tSwampCounter = (byte)(tSwampCounter + 1);
                }
            }
            if (tSwampCounter < 3) {
                this.updateFlow(aWorld, aX, aY, aZ, aRandom);
                PLACEMENT_ALLOWED = false;
                return;
            }
        }
        Object object = tList.iterator();
        while (object.hasNext()) {
            ChunkCoordinates tCoords = (ChunkCoordinates)object.next();
            if (!aWorld.setBlock(tCoords.posX, tCoords.posY, tCoords.posZ, (Block)this, 0, WATER_UPDATE_FLAGS)) continue;
            for (int i = -1; i < 2; ++i) {
                for (int j3 = -1; j3 < 2; ++j3) {
                    if (!aWorld.blockExists(tCoords.posX + i, tCoords.posY, tCoords.posZ + j3) || !((tBlock = aWorld.getBlock(tCoords.posX + i, tCoords.posY, tCoords.posZ + j3)) instanceof BlockSwamp)) continue;
                    aWorld.scheduleBlockUpdate(tCoords.posX + i, tCoords.posY, tCoords.posZ + j3, (Block)this, this.tickRate);
                }
            }
        }
        this.updateFlow(aWorld, aX, aY, aZ, aRandom);
        PLACEMENT_ALLOWED = false;
    }

    @Override
    public void onHeadInside(EntityLivingBase aEntity, World aWorld, int aX, int aY, int aZ) {
        if (aEntity instanceof EntitySlime) {
            return;
        }
        super.onHeadInside(aEntity, aWorld, aX, aY, aZ);
    }

    public int getLightOpacity(IBlockAccess aWorld, int aX, int aY, int aZ) {
        if (aWorld.getBlock(aX, aY + 1, aZ) != this || aWorld.getBlockMetadata(aX, aY, aZ) > 0) {
            return 3;
        }
        return 255;
    }

    @Override
    public IIcon getIcon(int aSide, int aMeta) {
        return Blocks.water.getIcon(aSide, aMeta);
    }

    @Override
    public int getRenderColor(int aMeta) {
        return 65280;
    }

    @Override
    public int colorMultiplier(IBlockAccess aWorld, int aX, int aY, int aZ) {
        if (aWorld.getBlock(aX, aY + 1, aZ) == this) {
            return 65280;
        }
        if (BlockSwamp.water(aWorld.getBlock(aX + 1, aY, aZ))) {
            return 0x60FF60;
        }
        if (BlockSwamp.water(aWorld.getBlock(aX - 1, aY, aZ))) {
            return 0x60FF60;
        }
        if (BlockSwamp.water(aWorld.getBlock(aX, aY, aZ + 1))) {
            return 0x60FF60;
        }
        if (BlockSwamp.water(aWorld.getBlock(aX, aY, aZ - 1))) {
            return 0x60FF60;
        }
        return 65280;
    }

    public static boolean water(Block aBlock) {
        return aBlock == Blocks.water || aBlock == Blocks.flowing_water || aBlock == CS.BlocksGT.Ocean || aBlock == CS.BlocksGT.River;
    }
}

