/*
 * Decompiled with CFR 0.152.
 */
package gregapi.worldgen;

import gregapi.data.CS;
import gregapi.util.WD;
import gregapi.worldgen.WorldgenBlob;
import gregapi.worldgen.WorldgenObject;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class WorldgenFluid
extends WorldgenBlob {
    @SafeVarargs
    public WorldgenFluid(String aName, boolean aDefault, Block aBlock, int aBlockMeta, int aAmount, int aSize, int aProbability, int aMinY, int aMaxY, Collection<String> aBiomeList, boolean aAllowToGenerateinVoid, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aBlock, aBlockMeta, aAmount, aSize, aProbability, aMinY, aMaxY, aBiomeList, aAllowToGenerateinVoid, aLists);
    }

    @Override
    public boolean tryPlaceStuff(World aWorld, int aX, int aY, int aZ, Random aRandom) {
        Block tTargetedBlock = aWorld.getBlock(aX, aY, aZ);
        if (tTargetedBlock == this.mBlock && aWorld.getBlockMetadata(aX, aY, aZ) == this.mBlockMeta) {
            return true;
        }
        if (WD.bedrock(aWorld, aX, aY, aZ, tTargetedBlock)) {
            return aY >= 1 && aY <= 4 ? aWorld.setBlock(aX, aY, aZ, this.mBlock, this.mBlockMeta, 0) : this.doBedrockStuff(aWorld, aX, aY, aZ, aRandom);
        }
        if (tTargetedBlock == CS.NB || tTargetedBlock.isAir((IBlockAccess)aWorld, aX, aY, aZ)) {
            return this.mAllowToGenerateinVoid && aWorld.setBlock(aX, aY, aZ, this.mBlock, this.mBlockMeta, 0);
        }
        if (tTargetedBlock == Blocks.dirt || tTargetedBlock == Blocks.soul_sand || WD.ore_stone(tTargetedBlock, (byte)aWorld.getBlockMetadata(aX, aY, aZ))) {
            return aWorld.setBlock(aX, aY, aZ, this.mBlock, this.mBlockMeta, 0);
        }
        return false;
    }

    public boolean doBedrockStuff(World aWorld, int aX, int aY, int aZ, Random aRandom) {
        return false;
    }
}

