/*
 * Decompiled with CFR 0.152.
 */
package gregapi.worldgen;

import gregapi.util.UT;
import gregapi.worldgen.WorldgenObject;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public abstract class WorldgenBlob
extends WorldgenObject {
    public final int mBlockMeta;
    public final int mAmount;
    public final int mSize;
    public final int mMinY;
    public final int mMaxY;
    public final int mProbability;
    public final Block mBlock;
    public final Collection<String> mBiomeList;
    public final boolean mAllowToGenerateinVoid;

    @SafeVarargs
    public WorldgenBlob(String aName, boolean aDefault, Block aBlock, int aBlockMeta, int aAmount, int aSize, int aProbability, int aMinY, int aMaxY, Collection<String> aBiomeList, boolean aAllowToGenerateinVoid, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aLists);
        this.mBlock = aBlock == null ? Blocks.cobblestone : aBlock;
        this.mBlockMeta = UT.Code.bind4(aBlockMeta);
        this.mProbability = Math.max(1, this.getConfigFile().get((Object)this.mCategory, "Probability", (long)aProbability));
        this.mAmount = (int)UT.Code.bind(1L, 16L, this.getConfigFile().get((Object)this.mCategory, "Amount", (long)aAmount));
        this.mSize = (int)UT.Code.bind(4L, 250L, this.getConfigFile().get((Object)this.mCategory, "Size", (long)aSize));
        this.mMinY = this.getConfigFile().get((Object)this.mCategory, "MinHeight", (long)aMinY);
        this.mMaxY = this.getConfigFile().get((Object)this.mCategory, "MaxHeight", (long)aMaxY);
        this.mBiomeList = aBiomeList;
        this.mAllowToGenerateinVoid = aAllowToGenerateinVoid;
    }

    @Override
    public boolean generate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        if (this.mBiomeList != null) {
            boolean temp = true;
            for (String tName : aBiomeNames) {
                if (!this.mBiomeList.contains(tName)) continue;
                temp = false;
                break;
            }
            if (temp) {
                return false;
            }
        }
        if (aRandom.nextInt(this.mProbability) == 0) {
            for (int i = 0; i < this.mAmount; ++i) {
                int j;
                int tX = aMinX + aRandom.nextInt(16);
                int tY = this.mMinY + aRandom.nextInt(this.mMaxY - this.mMinY);
                int tZ = aMinZ + aRandom.nextInt(16);
                if (!this.mAllowToGenerateinVoid && aWorld.getBlock(tX, tY, tZ).isAir((IBlockAccess)aWorld, tX, tY, tZ)) continue;
                float var6 = aRandom.nextFloat() * (float)Math.PI;
                double aX1 = (float)(tX + 8) + MathHelper.sin((float)var6) * (float)this.mSize / 8.0f;
                double aX2 = (float)(tX + 8) - MathHelper.sin((float)var6) * (float)this.mSize / 8.0f;
                double aZ1 = (float)(tZ + 8) + MathHelper.cos((float)var6) * (float)this.mSize / 8.0f;
                double aZ2 = (float)(tZ + 8) - MathHelper.cos((float)var6) * (float)this.mSize / 8.0f;
                double aY1 = tY + aRandom.nextInt(3) - 2;
                double aY2 = tY + aRandom.nextInt(3) - 2;
                int bMinX = Integer.MAX_VALUE;
                int bMinY = Integer.MAX_VALUE;
                int bMinZ = Integer.MAX_VALUE;
                int bMaxX = Integer.MIN_VALUE;
                int bMaxY = Integer.MIN_VALUE;
                int bMaxZ = Integer.MIN_VALUE;
                double[] tRandoms = new double[this.mSize + 1];
                for (j = 0; j < tRandoms.length; ++j) {
                    tRandoms[j] = aRandom.nextDouble() * (double)this.mSize / 16.0;
                }
                for (j = 0; j <= this.mSize; ++j) {
                    double bX = aX1 + (aX2 - aX1) * (double)j / (double)this.mSize;
                    double bY = aY1 + (aY2 - aY1) * (double)j / (double)this.mSize;
                    double bZ = aZ1 + (aZ2 - aZ1) * (double)j / (double)this.mSize;
                    double b = ((double)(MathHelper.sin((float)((float)j * (float)Math.PI / (float)this.mSize)) + 1.0f) * tRandoms[j] + 1.0) / 2.0;
                    bMinX = Math.min(bMinX, UT.Code.roundDown(bX - b));
                    bMinY = Math.min(bMinY, Math.max(0, UT.Code.roundDown(bY - b)));
                    bMinZ = Math.min(bMinZ, UT.Code.roundDown(bZ - b));
                    bMaxX = Math.max(bMaxX, UT.Code.roundDown(bX + b));
                    bMaxY = Math.max(bMaxY, Math.min(aWorld.getHeight(), UT.Code.roundDown(bY + b)));
                    bMaxZ = Math.max(bMaxZ, UT.Code.roundDown(bZ + b));
                }
                boolean[][][] tCheck = new boolean[Math.max(4, bMaxX - bMinX + 1)][Math.max(4, bMaxY - bMinY + 1)][Math.max(4, bMaxZ - bMinZ + 1)];
                for (int j2 = 0; j2 <= this.mSize; ++j2) {
                    double bX = aX1 + (aX2 - aX1) * (double)j2 / (double)this.mSize;
                    double bY = aY1 + (aY2 - aY1) * (double)j2 / (double)this.mSize;
                    double bZ = aZ1 + (aZ2 - aZ1) * (double)j2 / (double)this.mSize;
                    double b = ((double)(MathHelper.sin((float)((float)j2 * (float)Math.PI / (float)this.mSize)) + 1.0f) * tRandoms[j2] + 1.0) / 2.0;
                    int tMinX = UT.Code.roundDown(bX - b);
                    int tMinY = Math.max(0, UT.Code.roundDown(bY - b));
                    int tMinZ = UT.Code.roundDown(bZ - b);
                    int tMaxX = UT.Code.roundDown(bX + b);
                    int tMaxY = Math.min(aWorld.getHeight(), UT.Code.roundDown(bY + b));
                    int tMaxZ = UT.Code.roundDown(bZ + b);
                    for (int eX = tMinX; eX <= tMaxX; ++eX) {
                        double cX = ((double)eX + 0.5 - bX) / b;
                        if (!(cX * cX < 1.0)) continue;
                        for (int eY = tMinY; eY <= tMaxY; ++eY) {
                            double cY = ((double)eY + 0.5 - bY) / b;
                            if (!(cX * cX + cY * cY < 1.0)) continue;
                            for (int eZ = tMinZ; eZ <= tMaxZ; ++eZ) {
                                double cZ;
                                if (tCheck[eX - bMinX][eY - bMinY][eZ - bMinZ] || !(cX * cX + cY * cY + (cZ = ((double)eZ + 0.5 - bZ) / b) * cZ < 1.0)) continue;
                                tCheck[eX - bMinX][eY - bMinY][eZ - bMinZ] = true;
                            }
                        }
                    }
                }
                for (int a = 0; a < tCheck.length; ++a) {
                    for (int b = 0; b < tCheck[a].length; ++b) {
                        for (int c = 0; c < tCheck[a][b].length; ++c) {
                            if (!tCheck[a][b][c]) continue;
                            this.tryPlaceStuff(aWorld, bMinX + a, bMinY + b, bMinZ + c, aRandom);
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    public abstract boolean tryPlaceStuff(World var1, int var2, int var3, int var4, Random var5);
}

