/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.multiblocks;

import gregapi.GT_API;
import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityAdjacentInventoryUpdatable;
import gregapi.tileentity.ITileEntityFunnelAccessible;
import gregapi.tileentity.ITileEntityTapAccessible;
import gregapi.tileentity.data.ITileEntityGibbl;
import gregapi.tileentity.data.ITileEntityProgress;
import gregapi.tileentity.data.ITileEntityTemperature;
import gregapi.tileentity.data.ITileEntityWeight;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.energy.ITileEntityEnergyDataCapacitor;
import gregapi.tileentity.logistics.ITileEntityLogistics;
import gregapi.tileentity.machines.ITileEntityCrucible;
import gregapi.tileentity.machines.ITileEntityMold;
import gregapi.tileentity.machines.ITileEntityRunningActively;
import gregapi.tileentity.machines.ITileEntityRunningPassively;
import gregapi.tileentity.machines.ITileEntityRunningPossible;
import gregapi.tileentity.machines.ITileEntityRunningSuccessfully;
import gregapi.tileentity.machines.ITileEntitySwitchableMode;
import gregapi.tileentity.machines.ITileEntitySwitchableOnOff;
import gregapi.tileentity.multiblocks.IMultiBlockEnergy;
import gregapi.tileentity.multiblocks.IMultiBlockEnergyDataCapacitor;
import gregapi.tileentity.multiblocks.IMultiBlockFluidHandler;
import gregapi.tileentity.multiblocks.IMultiBlockInventory;
import gregapi.tileentity.multiblocks.ITileEntityMultiBlockController;
import gregapi.tileentity.notick.TileEntityBase05Paintable;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class MultiTileEntityMultiBlockPart
extends TileEntityBase05Paintable
implements ITileEntityEnergy,
ITileEntityCrucible,
ITileEntityLogistics,
IMultiTileEntity.IMTE_OnWalkOver,
ITileEntityTemperature,
ITileEntityGibbl,
ITileEntityProgress,
ITileEntityWeight,
ITileEntityTapAccessible,
ITileEntityFunnelAccessible,
ITileEntityEnergyDataCapacitor,
ITileEntityAdjacentInventoryUpdatable,
IFluidHandler,
IMultiTileEntity.IMTE_OnBlockAdded,
IMultiTileEntity.IMTE_BreakBlock,
IMultiTileEntity.IMTE_AddToolTips,
ITileEntityRunningSuccessfully,
ITileEntitySwitchableMode,
ITileEntitySwitchableOnOff {
    public ChunkCoordinates mTargetPos = null;
    public ITileEntityMultiBlockController mTarget = null;
    protected IIconContainer[][] mTextures = CS.L1L6_IICONCONTAINER;
    public short mDesign = 0;
    public int mMode = 0;
    public static final int EVERYTHING = 0;
    public static final int NO_ENERGY_OUT = 1;
    public static final int NO_ENERGY_IN = 2;
    public static final int NO_FLUID_OUT = 4;
    public static final int NO_FLUID_IN = 8;
    public static final int NO_ITEM_OUT = 16;
    public static final int NO_ITEM_IN = 32;
    public static final int NO_LOGISTICS = 64;
    public static final int NO_CRUCIBLE = 128;
    public static final int NO_ENERGY = 3;
    public static final int NO_FLUID = 12;
    public static final int NO_ITEM = 48;
    public static final int ONLY_IN = 213;
    public static final int ONLY_OUT = 234;
    public static final int ONLY_ENERGY_OUT = -2;
    public static final int ONLY_ENERGY_IN = -3;
    public static final int ONLY_FLUID_OUT = -5;
    public static final int ONLY_FLUID_IN = -9;
    public static final int ONLY_ITEM_OUT = -17;
    public static final int ONLY_ITEM_IN = -33;
    public static final int ONLY_ITEM_FLUID_OUT = -21;
    public static final int ONLY_ITEM_FLUID_IN = -41;
    public static final int ONLY_ITEM_FLUID_ENERGY_OUT = -22;
    public static final int ONLY_ITEM_FLUID_ENERGY_IN = -43;
    public static final int ONLY_CRUCIBLE = -129;
    public static final int ONLY_LOGISTICS = -65;
    public static final int ONLY_ENERGY = -4;
    public static final int ONLY_FLUID = -13;
    public static final int ONLY_ITEM = -49;
    public static final int ONLY_ITEM_FLUID = -61;
    public static final int ONLY_ITEM_FLUID_ENERGY = -64;
    public static final int ONLY_ITEM_ENERGY = -52;
    public static final int ONLY_FLUID_ENERGY = -16;
    public static final int NOTHING = -1;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.target")) {
            this.mTargetPos = new ChunkCoordinates(UT.Code.bindInt(aNBT.getLong("gt.target.x")), UT.Code.bindInt(aNBT.getLong("gt.target.y")), UT.Code.bindInt(aNBT.getLong("gt.target.z")));
        }
        if (aNBT.hasKey("gt.design")) {
            this.mDesign = UT.Code.unsignB(aNBT.getByte("gt.design"));
        }
        if (aNBT.hasKey("gt.mode")) {
            this.mMode = aNBT.getInteger("gt.mode");
        }
        if (CS.CODE_CLIENT) {
            if (GT_API.sBlockIcons == null && aNBT.hasKey("gt.texture")) {
                String tTextureName = aNBT.getString("gt.texture");
                this.mTextures = new IIconContainer[UT.Code.bind8(aNBT.getShort("gt.designs")) + 1][6];
                for (int i = 0; i < this.mTextures.length; i = (int)((short)(i + 1))) {
                    this.mTextures[i] = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/multiblockparts/" + tTextureName + "/" + i + "/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/multiblockparts/" + tTextureName + "/" + i + "/colored/top"), new Textures.BlockIcons.CustomIcon("machines/multiblockparts/" + tTextureName + "/" + i + "/colored/side"), new Textures.BlockIcons.CustomIcon("machines/multiblockparts/" + tTextureName + "/" + i + "/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/multiblockparts/" + tTextureName + "/" + i + "/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/multiblockparts/" + tTextureName + "/" + i + "/overlay/side")};
                }
            } else {
                TileEntity tCanonicalTileEntity = MultiTileEntityRegistry.getCanonicalTileEntity(this.getMultiTileEntityRegistryID(), (int)this.getMultiTileEntityID());
                if (tCanonicalTileEntity instanceof MultiTileEntityMultiBlockPart) {
                    this.mTextures = ((MultiTileEntityMultiBlockPart)tCanonicalTileEntity).mTextures;
                }
            }
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        if (this.mDesign != 0) {
            aNBT.setByte("gt.design", (byte)this.mDesign);
        }
        if (this.mMode != 0) {
            aNBT.setInteger("gt.mode", this.mMode);
        }
        if (this.mTargetPos != null) {
            UT.NBT.setBoolean(aNBT, "gt.target", true);
            UT.NBT.setNumber(aNBT, "gt.target.x", this.mTargetPos.posX);
            UT.NBT.setNumber(aNBT, "gt.target.y", this.mTargetPos.posY);
            UT.NBT.setNumber(aNBT, "gt.target.z", this.mTargetPos.posZ);
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.builder.wand.to.ease.building"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
    }

    @Override
    public boolean breakBlock() {
        ITileEntityMultiBlockController tTarget = this.getTarget(false);
        if (tTarget != null) {
            this.mTargetPos = null;
            this.mTarget = null;
            tTarget.onStructureChange();
        }
        return false;
    }

    @Override
    public void onBlockAdded() {
        for (byte tSide : CS.ALL_SIDES_VALID) {
            DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(tSide);
            if (tDelegator.mTileEntity instanceof MultiTileEntityMultiBlockPart) {
                ITileEntityMultiBlockController tController = ((MultiTileEntityMultiBlockPart)tDelegator.mTileEntity).getTarget(false);
                if (tController == null) continue;
                tController.onStructureChange();
                continue;
            }
            if (!(tDelegator.mTileEntity instanceof ITileEntityMultiBlockController)) continue;
            ((ITileEntityMultiBlockController)tDelegator.mTileEntity).onStructureChange();
        }
    }

    public ITileEntityMultiBlockController getTarget(boolean aCheckValidity) {
        if (this.mTargetPos == null) {
            return null;
        }
        if (this.mTarget == null || this.mTarget.isDead()) {
            this.mTarget = null;
            if (this.worldObj.blockExists(this.mTargetPos.posX, this.mTargetPos.posY, this.mTargetPos.posZ)) {
                TileEntity tTarget = WD.te(this.worldObj, this.mTargetPos, true);
                if (tTarget instanceof ITileEntityMultiBlockController && ((ITileEntityMultiBlockController)tTarget).isInsideStructure(this.xCoord, this.yCoord, this.zCoord)) {
                    this.mTarget = (ITileEntityMultiBlockController)tTarget;
                } else {
                    this.mTargetPos = null;
                    this.setDesign(0);
                }
            }
        }
        return aCheckValidity && this.mTarget != null && !this.mTarget.checkStructure(false) ? null : this.mTarget;
    }

    public void setTarget(ITileEntityMultiBlockController aTarget, int aDesign, int aMode) {
        this.mTarget = aTarget;
        this.mTargetPos = this.mTarget == null ? null : this.mTarget.getCoords();
        this.mMode = aMode;
        this.setDesign(aDesign);
    }

    public boolean setDesign(int aDesign) {
        if ((aDesign = (int)UT.Code.bind8(aDesign)) != this.mDesign) {
            this.mDesign = (short)aDesign;
            this.updateClientData();
            return true;
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aShouldSideBeRendered[aSide] ? BlockTextureMulti.get(BlockTextureDefault.get(this.mTextures[this.mDesign][CS.FACES_TBS[aSide]], this.mRGBa), BlockTextureDefault.get(this.mTextures[this.mDesign][CS.FACES_TBS[aSide] + 3])) : null;
    }

    @Override
    public void adjacentInventoryUpdated(byte aSide, IInventory aTileEntity) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntityAdjacentInventoryUpdatable) {
            ((ITileEntityAdjacentInventoryUpdatable)((Object)tTileEntity)).adjacentInventoryUpdated(aSide, aTileEntity);
        }
    }

    @Override
    public byte getVisualData() {
        return (byte)this.mDesign;
    }

    @Override
    public void setVisualData(byte aData) {
        this.mDesign = UT.Code.unsignB(aData);
        if (this.mDesign >= this.mTextures.length) {
            this.mDesign = 0;
        }
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.multiblock.part";
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (aTool.equals("wrench") || aTool.equals("crowbar")) {
            return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(false);
        if (tTileEntity == null) {
            if (aTool.equals("magnifyingglass") || aTool.equals("builderwand")) {
                aChatReturn.add("There is no Multiblock Controller for this Block.");
                return 1L;
            }
        } else {
            if (tTileEntity.isInsideStructure(this.xCoord, this.yCoord, this.zCoord)) {
                return tTileEntity.onToolClickMultiBlock(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ, this.getCoords());
            }
            this.mTargetPos = null;
            this.mTarget = null;
        }
        return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public ItemStack decrStackSize(int aSlot, int aDecrement) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockInventory) {
            return ((IMultiBlockInventory)tTileEntity).decrStackSize(this, aSlot, aDecrement);
        }
        return null;
    }

    @Override
    public ItemStack getStackInSlotOnClosing(int aSlot) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockInventory) {
            return ((IMultiBlockInventory)tTileEntity).getStackInSlotOnClosing(this, aSlot);
        }
        return null;
    }

    @Override
    public ItemStack getStackInSlot(int aSlot) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockInventory) {
            return ((IMultiBlockInventory)tTileEntity).getStackInSlot(this, aSlot);
        }
        return null;
    }

    @Override
    public String getInventoryName() {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockInventory) {
            return ((IMultiBlockInventory)tTileEntity).getInventoryName(this);
        }
        return this.getCustomName();
    }

    @Override
    public int getSizeInventory() {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockInventory) {
            return ((IMultiBlockInventory)tTileEntity).getSizeInventory(this);
        }
        return 0;
    }

    @Override
    public int getInventoryStackLimit() {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockInventory) {
            return ((IMultiBlockInventory)tTileEntity).getInventoryStackLimit(this);
        }
        return 0;
    }

    @Override
    public void setInventorySlotContents(int aSlot, ItemStack aStack) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockInventory) {
            ((IMultiBlockInventory)tTileEntity).setInventorySlotContents(this, aSlot, aStack);
        }
    }

    @Override
    public boolean hasCustomInventoryName() {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockInventory) {
            return ((IMultiBlockInventory)tTileEntity).hasCustomInventoryName(this);
        }
        return this.getCustomName() != null;
    }

    @Override
    public boolean isItemValidForSlot(int aSlot, ItemStack aStack) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockInventory) {
            return ((IMultiBlockInventory)tTileEntity).isItemValidForSlot(this, aSlot, aStack);
        }
        return false;
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        if ((this.mMode & 0x30) == 48) {
            return CS.ZL_INTEGER;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockInventory) {
            return ((IMultiBlockInventory)tTileEntity).getAccessibleSlotsFromSide(this, aSide);
        }
        return CS.ZL_INTEGER;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        if ((this.mMode & 0x20) != 0) {
            return false;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockInventory) {
            return ((IMultiBlockInventory)tTileEntity).canInsertItem(this, aSlot, aStack, aSide);
        }
        return false;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        if ((this.mMode & 0x10) != 0) {
            return false;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockInventory) {
            return ((IMultiBlockInventory)tTileEntity).canExtractItem(this, aSlot, aStack, aSide);
        }
        return false;
    }

    @Override
    public int fill(ForgeDirection aDirection, FluidStack aFluid, boolean aDoFill) {
        if ((this.mMode & 8) != 0) {
            return 0;
        }
        byte aSide = UT.Code.side(aDirection);
        if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].interceptFluidFill(aSide, this.mCovers, aSide, aFluid)) {
            return 0;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockFluidHandler) {
            return ((IMultiBlockFluidHandler)tTileEntity).fill(this, aSide, aFluid, aDoFill);
        }
        return 0;
    }

    @Override
    public FluidStack drain(ForgeDirection aDirection, FluidStack aFluid, boolean aDoDrain) {
        if ((this.mMode & 4) != 0) {
            return CS.NF;
        }
        byte aSide = UT.Code.side(aDirection);
        if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].interceptFluidDrain(aSide, this.mCovers, aSide, aFluid)) {
            return null;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockFluidHandler) {
            return ((IMultiBlockFluidHandler)tTileEntity).drain(this, aSide, aFluid, aDoDrain);
        }
        return CS.NF;
    }

    @Override
    public FluidStack drain(ForgeDirection aDirection, int aMaxDrain, boolean aDoDrain) {
        if ((this.mMode & 4) != 0) {
            return CS.NF;
        }
        byte aSide = UT.Code.side(aDirection);
        if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].interceptFluidDrain(aSide, this.mCovers, aSide, null)) {
            return null;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockFluidHandler) {
            return ((IMultiBlockFluidHandler)tTileEntity).drain(this, aSide, aMaxDrain, aDoDrain);
        }
        return CS.NF;
    }

    @Override
    public boolean canFill(ForgeDirection aDirection, Fluid aFluid) {
        if ((this.mMode & 8) != 0) {
            return false;
        }
        byte aSide = UT.Code.side(aDirection);
        if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].interceptFluidFill(aSide, this.mCovers, aSide, FL.make(aFluid, 1L))) {
            return false;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockFluidHandler) {
            return ((IMultiBlockFluidHandler)tTileEntity).canFill(this, UT.Code.side(aDirection), aFluid);
        }
        return false;
    }

    @Override
    public boolean canDrain(ForgeDirection aDirection, Fluid aFluid) {
        if ((this.mMode & 4) != 0) {
            return false;
        }
        byte aSide = UT.Code.side(aDirection);
        if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].interceptFluidDrain(aSide, this.mCovers, aSide, FL.make(aFluid, 1L))) {
            return false;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockFluidHandler) {
            return ((IMultiBlockFluidHandler)tTileEntity).canDrain(this, UT.Code.side(aDirection), aFluid);
        }
        return false;
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection aDirection) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockFluidHandler) {
            return ((IMultiBlockFluidHandler)tTileEntity).getTankInfo(this, UT.Code.side(aDirection));
        }
        return CS.ZL_FLUIDTANKINFO;
    }

    @Override
    public int funnelFill(byte aSide, FluidStack aFluid, boolean aDoFill) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntityFunnelAccessible) {
            return ((ITileEntityFunnelAccessible)((Object)tTileEntity)).funnelFill(aSide, aFluid, aDoFill);
        }
        return 0;
    }

    @Override
    public FluidStack tapDrain(byte aSide, int aMaxDrain, boolean aDoDrain) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntityTapAccessible) {
            return ((ITileEntityTapAccessible)((Object)tTileEntity)).tapDrain(aSide, aMaxDrain, aDoDrain);
        }
        return null;
    }

    @Override
    public FluidStack nozzleDrain(byte aSide, int aMaxDrain, boolean aDoDrain) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntityTapAccessible) {
            return ((ITileEntityTapAccessible)((Object)tTileEntity)).nozzleDrain(aSide, aMaxDrain, aDoDrain);
        }
        return null;
    }

    @Override
    public boolean getStateRunningPossible() {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntityRunningPossible) {
            return ((ITileEntityRunningPossible)((Object)tTileEntity)).getStateRunningPossible();
        }
        return false;
    }

    @Override
    public boolean getStateRunningPassively() {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntityRunningPassively) {
            return ((ITileEntityRunningPassively)((Object)tTileEntity)).getStateRunningPassively();
        }
        return false;
    }

    @Override
    public boolean getStateRunningActively() {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntityRunningActively) {
            return ((ITileEntityRunningActively)((Object)tTileEntity)).getStateRunningActively();
        }
        return false;
    }

    @Override
    public boolean getStateRunningSuccessfully() {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntityRunningSuccessfully) {
            return ((ITileEntityRunningSuccessfully)((Object)tTileEntity)).getStateRunningSuccessfully();
        }
        return false;
    }

    @Override
    public boolean getStateOnOff() {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntitySwitchableOnOff) {
            return ((ITileEntitySwitchableOnOff)((Object)tTileEntity)).getStateOnOff();
        }
        return false;
    }

    @Override
    public byte getStateMode() {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntitySwitchableMode) {
            return ((ITileEntitySwitchableMode)((Object)tTileEntity)).getStateMode();
        }
        return 0;
    }

    @Override
    public boolean setStateOnOff(boolean aOnOff) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntitySwitchableOnOff) {
            return ((ITileEntitySwitchableOnOff)((Object)tTileEntity)).setStateOnOff(aOnOff);
        }
        return false;
    }

    @Override
    public byte setStateMode(byte aMode) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntitySwitchableMode) {
            return ((ITileEntitySwitchableMode)((Object)tTileEntity)).setStateMode(aMode);
        }
        return 0;
    }

    @Override
    public long getProgressValue(byte aSide) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntityProgress) {
            return ((ITileEntityProgress)((Object)tTileEntity)).getProgressValue(aSide);
        }
        return 0L;
    }

    @Override
    public long getProgressMax(byte aSide) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntityProgress) {
            return ((ITileEntityProgress)((Object)tTileEntity)).getProgressMax(aSide);
        }
        return 0L;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        if (aEmitting ? (this.mMode & 1) != 0 : (this.mMode & 2) != 0) {
            return false;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergy) {
            return ((IMultiBlockEnergy)tTileEntity).isEnergyType(this, aEnergyType, aSide, aEmitting);
        }
        return false;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        if ((this.mMode & 3) == 3) {
            return Collections.emptyList();
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergy) {
            return ((IMultiBlockEnergy)tTileEntity).getEnergyTypes(this, aSide);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isEnergyAcceptingFrom(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        if ((this.mMode & 2) != 0) {
            return false;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergy) {
            return ((IMultiBlockEnergy)tTileEntity).isEnergyAcceptingFrom(this, aEnergyType, aSide, aTheoretical);
        }
        return false;
    }

    @Override
    public boolean isEnergyEmittingTo(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        if ((this.mMode & 1) != 0) {
            return false;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergy) {
            return ((IMultiBlockEnergy)tTileEntity).isEnergyEmittingTo(this, aEnergyType, aSide, aTheoretical);
        }
        return false;
    }

    @Override
    public synchronized long doEnergyInjection(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        if ((this.mMode & 2) != 0) {
            return 0L;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergy) {
            return ((IMultiBlockEnergy)tTileEntity).doEnergyInjection(this, aEnergyType, aSide, aSize, aAmount, aDoInject);
        }
        return 0L;
    }

    @Override
    public long getEnergyDemanded(TagData aEnergyType, byte aSide, long aSize) {
        if ((this.mMode & 2) != 0) {
            return 0L;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergy) {
            return ((IMultiBlockEnergy)tTileEntity).getEnergyDemanded(this, aEnergyType, aSide, aSize);
        }
        return 0L;
    }

    @Override
    public synchronized long doEnergyExtraction(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoExtract) {
        if ((this.mMode & 1) != 0) {
            return 0L;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergy) {
            return ((IMultiBlockEnergy)tTileEntity).doEnergyExtraction(this, aEnergyType, aSide, aSize, aAmount, aDoExtract);
        }
        return 0L;
    }

    @Override
    public long getEnergyOffered(TagData aEnergyType, byte aSide, long aSize) {
        if ((this.mMode & 1) != 0) {
            return 0L;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergy) {
            return ((IMultiBlockEnergy)tTileEntity).getEnergyOffered(this, aEnergyType, aSide, aSize);
        }
        return 0L;
    }

    @Override
    public long getEnergySizeInputMin(TagData aEnergyType, byte aSide) {
        if ((this.mMode & 2) != 0) {
            return 0L;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergy) {
            return ((IMultiBlockEnergy)tTileEntity).getEnergySizeInputMin(this, aEnergyType, aSide);
        }
        return 0L;
    }

    @Override
    public long getEnergySizeOutputMin(TagData aEnergyType, byte aSide) {
        if ((this.mMode & 1) != 0) {
            return 0L;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergy) {
            return ((IMultiBlockEnergy)tTileEntity).getEnergySizeOutputMin(this, aEnergyType, aSide);
        }
        return 0L;
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, byte aSide) {
        if ((this.mMode & 2) != 0) {
            return 0L;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergy) {
            return ((IMultiBlockEnergy)tTileEntity).getEnergySizeInputRecommended(this, aEnergyType, aSide);
        }
        return 0L;
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, byte aSide) {
        if ((this.mMode & 1) != 0) {
            return 0L;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergy) {
            return ((IMultiBlockEnergy)tTileEntity).getEnergySizeOutputRecommended(this, aEnergyType, aSide);
        }
        return 0L;
    }

    @Override
    public long getEnergySizeInputMax(TagData aEnergyType, byte aSide) {
        if ((this.mMode & 2) != 0) {
            return 0L;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergy) {
            return ((IMultiBlockEnergy)tTileEntity).getEnergySizeInputMax(this, aEnergyType, aSide);
        }
        return 0L;
    }

    @Override
    public long getEnergySizeOutputMax(TagData aEnergyType, byte aSide) {
        if ((this.mMode & 1) != 0) {
            return 0L;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergy) {
            return ((IMultiBlockEnergy)tTileEntity).getEnergySizeOutputMax(this, aEnergyType, aSide);
        }
        return 0L;
    }

    @Override
    public long getEnergyStored(TagData aEnergyType, byte aSide) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergyDataCapacitor) {
            return ((IMultiBlockEnergyDataCapacitor)tTileEntity).getEnergyStored(this, aEnergyType, aSide);
        }
        return 0L;
    }

    @Override
    public long getEnergyCapacity(TagData aEnergyType, byte aSide) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergyDataCapacitor) {
            return ((IMultiBlockEnergyDataCapacitor)tTileEntity).getEnergyCapacity(this, aEnergyType, aSide);
        }
        return 0L;
    }

    @Override
    public boolean isEnergyCapacitorType(TagData aEnergyType, byte aSide) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergyDataCapacitor) {
            return ((IMultiBlockEnergyDataCapacitor)tTileEntity).isEnergyCapacitorType(this, aEnergyType, aSide);
        }
        return false;
    }

    @Override
    public Collection<TagData> getEnergyCapacitorTypes(byte aSide) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergyDataCapacitor) {
            return ((IMultiBlockEnergyDataCapacitor)tTileEntity).getEnergyCapacitorTypes(this, aSide);
        }
        return Collections.emptyList();
    }

    @Override
    public double getWeightValue(byte aSide) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntityWeight) {
            return ((ITileEntityWeight)((Object)tTileEntity)).getWeightValue(aSide);
        }
        return 0.0;
    }

    @Override
    public long getGibblValue(byte aSide) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntityGibbl) {
            return ((ITileEntityGibbl)((Object)tTileEntity)).getGibblValue(aSide);
        }
        return 0L;
    }

    @Override
    public long getGibblMax(byte aSide) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntityGibbl) {
            return ((ITileEntityGibbl)((Object)tTileEntity)).getGibblMax(aSide);
        }
        return 0L;
    }

    @Override
    public long getTemperatureValue(byte aSide) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntityTemperature) {
            return ((ITileEntityTemperature)((Object)tTileEntity)).getTemperatureValue(aSide);
        }
        return 0L;
    }

    @Override
    public long getTemperatureMax(byte aSide) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntityTemperature) {
            return ((ITileEntityTemperature)((Object)tTileEntity)).getTemperatureMax(aSide);
        }
        return 0L;
    }

    @Override
    public void onWalkOver(EntityLivingBase aEntity) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(false);
        if (tTileEntity instanceof IMultiTileEntity.IMTE_OnWalkOver) {
            ((IMultiTileEntity.IMTE_OnWalkOver)((Object)tTileEntity)).onWalkOver(aEntity);
        }
    }

    @Override
    public boolean canLogistics(byte aSide) {
        if ((this.mMode & 0x40) != 0) {
            return false;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntityLogistics) {
            return ((ITileEntityLogistics)((Object)tTileEntity)).canLogistics(aSide);
        }
        return false;
    }

    @Override
    public boolean fillMoldAtSide(ITileEntityMold aMold, byte aSide, byte aSideOfMold) {
        if ((this.mMode & 0x80) != 0) {
            return false;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntityCrucible) {
            return ((ITileEntityCrucible)((Object)tTileEntity)).fillMoldAtSide(aMold, aSide, aSideOfMold);
        }
        return false;
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer aPlayer) {
        return aPlayer.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    @Override
    public void openInventory() {
    }

    @Override
    public void closeInventory() {
    }
}

