/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.multiblocks;

import gregapi.random.IHasWorldAndCoords;
import gregapi.tileentity.ITileEntityUnloadable;
import gregapi.tileentity.multiblocks.MultiTileEntityMultiBlockPart;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;

public interface ITileEntityMultiBlockController
extends ITileEntityUnloadable,
IHasWorldAndCoords {
    public boolean isInsideStructure(int var1, int var2, int var3);

    public boolean checkStructure(boolean var1);

    public void onStructureChange();

    public long onToolClickMultiBlock(String var1, long var2, long var4, Entity var6, List<String> var7, IInventory var8, boolean var9, ItemStack var10, byte var11, float var12, float var13, float var14, ChunkCoordinates var15);

    public static class Util {
        public static boolean checkAndSetTarget(ITileEntityMultiBlockController aController, int aX, int aY, int aZ, int aRegistryMeta, int aRegistryID, int aDesign, int aMode, ChunkCoordinates aClickedAt, Entity aPlayer, IInventory aInventory) {
            TileEntity tTileEntity;
            block4: {
                ItemStack aStack;
                block5: {
                    tTileEntity = aController.getTileEntity(aX, aY, aZ);
                    if (tTileEntity == aController) {
                        return true;
                    }
                    if (aInventory == null && aPlayer == null || aClickedAt != null && (Math.abs(aX - aClickedAt.posX) >= 2 || Math.abs(aY - aClickedAt.posY) >= 2 || Math.abs(aZ - aClickedAt.posZ) >= 2)) break block4;
                    aStack = ST.make(aRegistryID, 1L, (long)aRegistryMeta);
                    if (!WD.easyRep(aController.getWorld(), aX, aY, aZ) || !UT.Entities.canEdit(aPlayer, aX, aY, aZ, aStack)) break block4;
                    if (aInventory != null && !UT.Entities.hasInfiniteItems(aPlayer)) break block5;
                    if (!WD.set(aController.getWorld(), aX, aY, aZ, ST.make(aRegistryID, 1L, (long)aRegistryMeta)) || aPlayer == null) break block4;
                    UT.Sounds.send("random.orb", aController.getWorld(), aX, aY, aZ);
                    break block4;
                }
                for (int i = aInventory.getSizeInventory() - 1; i >= 0; --i) {
                    ItemStack tStack = aInventory.getStackInSlot(i);
                    if (!ST.equal(aStack, tStack, true) || !ST.use(aPlayer, true, true, tStack, 1L)) continue;
                    if (!WD.set(aController.getWorld(), aX, aY, aZ, tStack) || aPlayer == null) break;
                    UT.Sounds.send("random.orb", aController.getWorld(), aX, aY, aZ);
                    break;
                }
            }
            if (tTileEntity instanceof MultiTileEntityMultiBlockPart && ((MultiTileEntityMultiBlockPart)tTileEntity).getMultiTileEntityID() == aRegistryMeta && ((MultiTileEntityMultiBlockPart)tTileEntity).getMultiTileEntityRegistryID() == aRegistryID) {
                ITileEntityMultiBlockController tTarget = ((MultiTileEntityMultiBlockPart)tTileEntity).getTarget(false);
                if (tTarget != aController && tTarget != null && tTarget.isInsideStructure(aX, aY, aZ)) {
                    return false;
                }
                ((MultiTileEntityMultiBlockPart)tTileEntity).setTarget(aController, aDesign, aMode);
                return true;
            }
            return false;
        }

        public static boolean checkAndSetTargetOffset(ITileEntityMultiBlockController aController, int aX, int aY, int aZ, int aRegistryMeta, int aRegistryID, int aDesign, int aMode, ChunkCoordinates aClickedAt, Entity aPlayer, IInventory aInventory) {
            return Util.checkAndSetTarget(aController, aX + aController.getX(), aY + aController.getY(), aZ + aController.getZ(), aRegistryMeta, aRegistryID, aDesign, aMode, aClickedAt, aPlayer, aInventory);
        }

        @Deprecated
        public static boolean checkAndSetTarget(ITileEntityMultiBlockController aController, int aX, int aY, int aZ, int aRegistryMeta, int aRegistryID, int aDesign, int aMode) {
            return Util.checkAndSetTarget(aController, aX, aY, aZ, aRegistryMeta, aRegistryID, aDesign, aMode, null, null, null);
        }

        @Deprecated
        public static boolean checkAndSetTargetOffset(ITileEntityMultiBlockController aController, int aX, int aY, int aZ, int aRegistryMeta, int aRegistryID, int aDesign, int aMode) {
            return Util.checkAndSetTarget(aController, aX + aController.getX(), aY + aController.getY(), aZ + aController.getZ(), aRegistryMeta, aRegistryID, aDesign, aMode, null, null, null);
        }
    }
}

