/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.machines;

import gregapi.GT_API_Proxy;
import gregapi.computer.ITileEntityComputerizable;
import gregapi.data.BI;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.render.IIconContainer;
import gregapi.tileentity.ITileEntityServerTickPost;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.machines.MultiTileEntitySensor;
import gregapi.tileentity.multiblocks.MultiTileEntityMultiBlockPart;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public abstract class MultiTileEntitySensorTE
extends MultiTileEntitySensor
implements ITileEntityComputerizable,
ITileEntityServerTickPost {
    public static final byte MODE_COUNT = 8;
    public static final byte MODE_DISPLAY = 0;
    public static final byte MODE_PERCENT = 1;
    public static final byte MODE_GREATER = 2;
    public static final byte MODE_EQUAL = 3;
    public static final byte MODE_SMALLER = 4;
    public static final byte MODE_SCALE = 5;
    public static final byte MODE_FULL = 6;
    public static final byte MODE_NOT_FULL = 7;
    public static final int MAX_AVERAGING_VALUES = Short.MAX_VALUE;
    public int[] mValues = new int[1];
    public int mIndex = 0;
    public int mCurrentValue = 0;
    public int mCurrentMax = 0;
    private boolean mHasToAddTimer = true;
    public static final String[] METHODS = new String[]{"getval", "getmax"};
    public static final String[] ARGS = new String[]{"void", "void"};
    public static final String[] HELPS = new String[]{"gets the value the sensor is reading for the object it is connected to", "gets the maximum value the sensor has for the object it is connected to"};
    public static final Class<?>[] RETURNS = new Class[]{Integer.TYPE, Integer.TYPE};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mCurrentMax = aNBT.getInteger("gt.sensor.max");
        this.mCurrentValue = aNBT.getInteger("gt.sensor.value");
        this.mIndex = aNBT.getInteger("gt.sensor.index");
        this.mValues = aNBT.getIntArray("gt.sensor.array");
        if (this.mValues.length < 1) {
            this.mValues = new int[1];
        }
        if (this.worldObj != null && this.isServerSide() && this.mHasToAddTimer) {
            GT_API_Proxy.SERVER_TICK_PO2T.add(this);
            this.mHasToAddTimer = false;
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.sensor.max", this.mCurrentMax);
        UT.NBT.setNumber(aNBT, "gt.sensor.value", this.mCurrentValue);
        UT.NBT.setNumber(aNBT, "gt.sensor.index", this.mIndex);
        aNBT.setIntArray("gt.sensor.array", this.mValues);
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        aNBT = super.writeItemNBT2(aNBT);
        if (this.mIndex != 0) {
            aNBT.setInteger("gt.sensor.index", this.mIndex);
        }
        if (this.mValues.length > 1) {
            aNBT.setIntArray("gt.sensor.array", new int[this.mValues.length]);
        }
        return aNBT;
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.soft.hammer.to.reset"));
    }

    @Override
    public void onUnregisterPost() {
        this.mHasToAddTimer = true;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide && this.mHasToAddTimer) {
            GT_API_Proxy.SERVER_TICK_PO2T.add(this);
            this.mHasToAddTimer = false;
        }
    }

    @Override
    public void onCoordinateChange() {
        super.onCoordinateChange();
        GT_API_Proxy.SERVER_TICK_PO2T.remove(this);
        this.onUnregisterPost();
    }

    @Override
    public void onServerTickPost(boolean aFirst) {
        if (this.getTickRate() < 2L || CS.SERVER_TIME % this.getTickRate() == 0L) {
            this.mIndex = (this.mIndex + 1) % this.mValues.length;
            this.mDisplayedNumber = this.mSetNumber = UT.Code.bind16(this.mSetNumber);
            DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(this.mSecondFacing);
            if (tDelegator.mTileEntity instanceof MultiTileEntityMultiBlockPart && ((MultiTileEntityMultiBlockPart)tDelegator.mTileEntity).mTarget != null) {
                tDelegator = new DelegatorTileEntity<TileEntity>((TileEntity)((MultiTileEntityMultiBlockPart)tDelegator.mTileEntity).mTarget, tDelegator.mSideOfTileEntity);
            }
            this.mValues[this.mIndex] = UT.Code.bindInt(this.getCurrentValue(tDelegator));
            this.mCurrentValue = this.mValues.length == 1 ? this.mValues[0] : UT.Code.averageInts(this.mValues);
            this.mCurrentMax = UT.Code.bindInt(this.getCurrentMax(tDelegator));
            byte tRedstone = this.mRedstone;
            switch (this.mMode & 0x7F) {
                case 0: {
                    this.mDisplayedNumber = UT.Code.bindInt(this.mCurrentValue);
                    break;
                }
                case 2: {
                    tRedstone = (byte)(this.mCurrentValue > this.mSetNumber ? 15 : 0);
                    break;
                }
                case 3: {
                    tRedstone = (byte)(this.mCurrentValue == this.mSetNumber ? 15 : 0);
                    break;
                }
                case 4: {
                    tRedstone = (byte)(this.mCurrentValue < this.mSetNumber ? 15 : 0);
                    break;
                }
                case 5: {
                    tRedstone = (byte)UT.Code.scale(this.mCurrentValue, this.mSetNumber, 15L, false);
                    break;
                }
                case 1: {
                    this.mDisplayedNumber = this.mCurrentMax > 0 ? UT.Code.bindInt((long)this.mCurrentValue * 100L / (long)this.mCurrentMax) : 0;
                    tRedstone = (byte)UT.Code.scale(this.mDisplayedNumber, 100L, 15L, false);
                    break;
                }
                case 6: {
                    tRedstone = (byte)(this.mCurrentValue >= this.mCurrentMax ? 15 : 0);
                    break;
                }
                case 7: {
                    tRedstone = (byte)(this.mCurrentValue >= this.mCurrentMax ? 0 : 15);
                }
            }
            tRedstone = UT.Code.bind4(tRedstone);
            if (tRedstone != this.mRedstone) {
                this.mRedstone = tRedstone;
                this.causeBlockUpdate();
            }
            this.mDisplayedNumber = UT.Code.unsignS((short)this.mDisplayedNumber);
        }
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (aSide == this.mFacing) {
            if (this.isServerSide() && (this.mMode & 0x7F) != 0 && (this.mMode & 0x7F) != 1 && (this.mMode & 0x7F) != 6 && (this.mMode & 0x7F) != 7) {
                float[] tCoords = UT.Code.getFacingCoordsClicked(aSide, aHitX, aHitY, aHitZ);
                if (this.mMode < 0) {
                    if (tCoords[1] >= CS.PX_P[6] && tCoords[1] <= CS.PX_P[8]) {
                        if (tCoords[0] >= CS.PX_P[9] && tCoords[0] <= CS.PX_P[11]) {
                            this.oDisplayedNumber = Short.MIN_VALUE;
                            this.mSetNumber -= 256;
                            this.playClick();
                            this.mSetNumber = UT.Code.bind16(this.mSetNumber);
                            return true;
                        }
                        if (tCoords[0] >= CS.PX_P[12] && tCoords[0] <= CS.PX_P[14]) {
                            this.oDisplayedNumber = Short.MIN_VALUE;
                            this.mSetNumber += 256;
                            this.playClick();
                            this.mSetNumber = UT.Code.bind16(this.mSetNumber);
                            return true;
                        }
                    }
                    if (tCoords[1] >= CS.PX_P[9] && tCoords[1] <= CS.PX_P[11]) {
                        if (tCoords[0] >= CS.PX_P[9] && tCoords[0] <= CS.PX_P[11]) {
                            this.oDisplayedNumber = Short.MIN_VALUE;
                            this.mSetNumber -= 16;
                            this.playClick();
                            this.mSetNumber = UT.Code.bind16(this.mSetNumber);
                            return true;
                        }
                        if (tCoords[0] >= CS.PX_P[12] && tCoords[0] <= CS.PX_P[14]) {
                            this.oDisplayedNumber = Short.MIN_VALUE;
                            this.mSetNumber += 16;
                            this.playClick();
                            this.mSetNumber = UT.Code.bind16(this.mSetNumber);
                            return true;
                        }
                    }
                    if (tCoords[1] >= CS.PX_P[12] && tCoords[1] <= CS.PX_P[14]) {
                        if (tCoords[0] >= CS.PX_P[9] && tCoords[0] <= CS.PX_P[11]) {
                            this.oDisplayedNumber = Short.MIN_VALUE;
                            --this.mSetNumber;
                            this.playClick();
                            this.mSetNumber = UT.Code.bind16(this.mSetNumber);
                            return true;
                        }
                        if (tCoords[0] >= CS.PX_P[12] && tCoords[0] <= CS.PX_P[14]) {
                            this.oDisplayedNumber = Short.MIN_VALUE;
                            ++this.mSetNumber;
                            this.playClick();
                            this.mSetNumber = UT.Code.bind16(this.mSetNumber);
                            return true;
                        }
                    }
                } else {
                    if (tCoords[1] >= CS.PX_P[6] && tCoords[1] <= CS.PX_P[8]) {
                        if (tCoords[0] >= CS.PX_P[9] && tCoords[0] <= CS.PX_P[11]) {
                            this.oDisplayedNumber = Short.MIN_VALUE;
                            this.mSetNumber -= 100;
                            this.playClick();
                            this.mSetNumber = (int)UT.Code.bind(0L, 9999L, this.mSetNumber);
                            return true;
                        }
                        if (tCoords[0] >= CS.PX_P[12] && tCoords[0] <= CS.PX_P[14]) {
                            this.oDisplayedNumber = Short.MIN_VALUE;
                            this.mSetNumber += 100;
                            this.playClick();
                            this.mSetNumber = (int)UT.Code.bind(0L, 9999L, this.mSetNumber);
                            return true;
                        }
                    }
                    if (tCoords[1] >= CS.PX_P[9] && tCoords[1] <= CS.PX_P[11]) {
                        if (tCoords[0] >= CS.PX_P[9] && tCoords[0] <= CS.PX_P[11]) {
                            this.oDisplayedNumber = Short.MIN_VALUE;
                            this.mSetNumber -= 10;
                            this.playClick();
                            this.mSetNumber = (int)UT.Code.bind(0L, 9999L, this.mSetNumber);
                            return true;
                        }
                        if (tCoords[0] >= CS.PX_P[12] && tCoords[0] <= CS.PX_P[14]) {
                            this.oDisplayedNumber = Short.MIN_VALUE;
                            this.mSetNumber += 10;
                            this.playClick();
                            this.mSetNumber = (int)UT.Code.bind(0L, 9999L, this.mSetNumber);
                            return true;
                        }
                    }
                    if (tCoords[1] >= CS.PX_P[12] && tCoords[1] <= CS.PX_P[14]) {
                        if (tCoords[0] >= CS.PX_P[9] && tCoords[0] <= CS.PX_P[11]) {
                            this.oDisplayedNumber = Short.MIN_VALUE;
                            --this.mSetNumber;
                            this.playClick();
                            this.mSetNumber = (int)UT.Code.bind(0L, 9999L, this.mSetNumber);
                            return true;
                        }
                        if (tCoords[0] >= CS.PX_P[12] && tCoords[0] <= CS.PX_P[14]) {
                            this.oDisplayedNumber = Short.MIN_VALUE;
                            ++this.mSetNumber;
                            this.playClick();
                            this.mSetNumber = (int)UT.Code.bind(0L, 9999L, this.mSetNumber);
                            return true;
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return 0L;
        }
        long tDamage = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (tDamage > 0L) {
            return tDamage;
        }
        if (aTool.equals("screwdriver")) {
            if (this.hasHitDisplay(aSide, aHitX, aHitY, aHitZ)) {
                this.mMode = (byte)(this.mMode ^ CS.B[7]);
                this.updateClientData();
                return 10000L;
            }
            float[] tCoords = UT.Code.getFacingCoordsClicked(aSide, aHitX, aHitY, aHitZ);
            if (tCoords[1] >= CS.PX_P[6] && tCoords[1] <= CS.PX_P[8]) {
                if (tCoords[0] >= CS.PX_P[9] && tCoords[0] <= CS.PX_P[11]) {
                    this.mValues = this.mMode < 0 ? new int[(int)UT.Code.bind_(1L, 32767L, this.mValues.length - 256)] : new int[(int)UT.Code.bind_(1L, 32767L, this.mValues.length - 100)];
                    this.playClick();
                    if (aChatReturn != null) {
                        aChatReturn.add("Averaging over: " + this.mValues.length + " Values");
                    }
                    return 1000L;
                }
                if (tCoords[0] >= CS.PX_P[12] && tCoords[0] <= CS.PX_P[14]) {
                    this.mValues = this.mMode < 0 ? new int[(int)UT.Code.bind_(1L, 32767L, this.mValues.length + 256)] : new int[(int)UT.Code.bind_(1L, 32767L, this.mValues.length + 100)];
                    this.playClick();
                    if (aChatReturn != null) {
                        aChatReturn.add("Averaging over: " + this.mValues.length + " Values");
                    }
                    return 1000L;
                }
            }
            if (tCoords[1] >= CS.PX_P[9] && tCoords[1] <= CS.PX_P[11]) {
                if (tCoords[0] >= CS.PX_P[9] && tCoords[0] <= CS.PX_P[11]) {
                    this.mValues = this.mMode < 0 ? new int[(int)UT.Code.bind_(1L, 32767L, this.mValues.length - 16)] : new int[(int)UT.Code.bind_(1L, 32767L, this.mValues.length - 10)];
                    this.playClick();
                    if (aChatReturn != null) {
                        aChatReturn.add("Averaging over: " + this.mValues.length + " Values");
                    }
                    return 1000L;
                }
                if (tCoords[0] >= CS.PX_P[12] && tCoords[0] <= CS.PX_P[14]) {
                    this.mValues = this.mMode < 0 ? new int[(int)UT.Code.bind_(1L, 32767L, this.mValues.length + 16)] : new int[(int)UT.Code.bind_(1L, 32767L, this.mValues.length + 10)];
                    this.playClick();
                    if (aChatReturn != null) {
                        aChatReturn.add("Averaging over: " + this.mValues.length + " Values");
                    }
                    return 1000L;
                }
            }
            if (tCoords[1] >= CS.PX_P[12] && tCoords[1] <= CS.PX_P[14]) {
                if (tCoords[0] >= CS.PX_P[9] && tCoords[0] <= CS.PX_P[11]) {
                    this.mValues = new int[(int)UT.Code.bind_(1L, 32767L, this.mValues.length - 1)];
                    this.playClick();
                    if (aChatReturn != null) {
                        aChatReturn.add(this.mValues.length < 2 ? "Averaging Disabled" : "Averaging over: " + this.mValues.length + " Values");
                    }
                    return 1000L;
                }
                if (tCoords[0] >= CS.PX_P[12] && tCoords[0] <= CS.PX_P[14]) {
                    this.mValues = new int[(int)UT.Code.bind_(1L, 32767L, this.mValues.length + 1)];
                    this.playClick();
                    if (aChatReturn != null) {
                        aChatReturn.add(this.mValues.length < 2 ? "Averaging Disabled" : "Averaging over: " + this.mValues.length + " Values");
                    }
                    return 1000L;
                }
            }
            if (this.mMode < 0) {
                this.mMode = (byte)(this.mMode & ~CS.B[7]);
                this.mMode = (byte)((this.mMode + 1) % 8);
                this.mMode = (byte)(this.mMode | CS.B[7]);
            } else {
                this.mMode = (byte)((this.mMode + 1) % 8);
            }
            if (this.mRedstone != 0) {
                this.mRedstone = 0;
                this.causeBlockUpdate();
            }
            this.updateClientData();
            return 10000L;
        }
        if (aTool.equals("softhammer")) {
            this.mRedstone = 0;
            this.mMode = 0;
            this.mSetNumber = 0;
            this.mDisplayedNumber = 0;
            this.mIndex = 0;
            this.mCurrentMax = 0;
            this.mCurrentValue = 0;
            this.mValues = new int[]{0};
            this.causeBlockUpdate();
            this.updateClientData();
            return 10000L;
        }
        return 0L;
    }

    @Override
    public IIconContainer getCharacterIcon(int aIndex) {
        if (aIndex == 0) {
            switch (this.mMode & 0x7F) {
                case 6: {
                    return BI.CHAR_EQUAL;
                }
                case 7: {
                    return BI.CHAR_SMALLER;
                }
                case 2: {
                    return BI.CHAR_GREATER;
                }
                case 3: {
                    return BI.CHAR_EQUAL;
                }
                case 4: {
                    return BI.CHAR_SMALLER;
                }
                case 5: {
                    return BI.CHAR_SCALE;
                }
            }
            return this.mMode < 0 ? BI.CHAR_HEX : BI.decimalDigit(this.mDisplayedNumber, 4L);
        }
        if ((this.mMode & 0x7F) == 6 || (this.mMode & 0x7F) == 7) {
            switch (aIndex) {
                case 1: {
                    return BI.CHAR_1;
                }
                case 2: {
                    return BI.CHAR_0;
                }
                case 3: {
                    return BI.CHAR_0;
                }
                case 4: {
                    return BI.CHAR_PERCENT;
                }
            }
        }
        if (aIndex == 5) {
            return (this.mMode & 0x7F) == 1 ? BI.CHAR_PERCENT : this.getSymbolIcon();
        }
        return this.mMode < 0 ? BI.hexadecimalDigit(this.mDisplayedNumber, 4 - aIndex) : BI.decimalDigit(this.mDisplayedNumber, 4 - aIndex);
    }

    @Override
    public short[] getCharacterColor(int aIndex) {
        return aIndex == 5 && (this.mMode & 0x7F) != 1 ? this.getSymbolColor() : ((this.mMode & 0x7F) == 6 || (this.mMode & 0x7F) == 7 ? CS.CA_RED_192 : CS.CA_WHITE);
    }

    public long getTickRate() {
        return 1L;
    }

    public abstract IIconContainer getSymbolIcon();

    public abstract short[] getSymbolColor();

    public abstract long getCurrentValue(DelegatorTileEntity<TileEntity> var1);

    public abstract long getCurrentMax(DelegatorTileEntity<TileEntity> var1);

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public String getComputerizableName(DelegatorTileEntity<TileEntity> aDelegator) {
        return "gt_sensor";
    }

    @Override
    public String[] allComputerizableArgs(DelegatorTileEntity<TileEntity> aDelegator) {
        return ARGS;
    }

    @Override
    public String[] allComputerizableHelps(DelegatorTileEntity<TileEntity> aDelegator) {
        return HELPS;
    }

    @Override
    public String[] allComputerizableMethods(DelegatorTileEntity<TileEntity> aDelegator) {
        return METHODS;
    }

    @Override
    public Class<?>[] allComputerizableReturns(DelegatorTileEntity<TileEntity> aDelegator) {
        return RETURNS;
    }

    @Override
    public String getComputerizableArgs(DelegatorTileEntity<TileEntity> aDelegator, int aFunctionIndex) {
        return ARGS[aFunctionIndex];
    }

    @Override
    public String getComputerizableHelp(DelegatorTileEntity<TileEntity> aDelegator, int aFunctionIndex) {
        return HELPS[aFunctionIndex];
    }

    @Override
    public String getComputerizableMethod(DelegatorTileEntity<TileEntity> aDelegator, int aFunctionIndex) {
        return METHODS[aFunctionIndex];
    }

    @Override
    public Class<?> getComputerizableReturn(DelegatorTileEntity<TileEntity> aDelegator, int aFunctionIndex) {
        return RETURNS[aFunctionIndex];
    }

    @Override
    public Object[] callComputerizableMethod(DelegatorTileEntity<TileEntity> aDelegator, int aFunctionIndex, Object[] aArguments) {
        return new Object[]{aFunctionIndex == 1 ? this.mCurrentMax : this.mCurrentValue};
    }
}

