/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.energy;

import gregapi.data.LH;
import gregapi.tileentity.behavior.TE_Behavior_Energy_Converter;
import gregapi.tileentity.energy.TileEntityBase10EnergyConverter;
import gregapi.tileentity.machines.ITileEntityAdjacentOnOff;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileEntityBase11Motor
extends TileEntityBase10EnergyConverter
implements ITileEntityAdjacentOnOff {
    protected boolean mCounterClockwise = false;
    protected boolean oCounterClockwise = false;
    protected boolean oFast = false;
    public TE_Behavior_Energy_Converter mConRevert = null;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.visual")) {
            this.mConverter.mFast = aNBT.getBoolean("gt.visual");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.reversed", this.mCounterClockwise);
        UT.NBT.setBoolean(aNBT, "gt.visual", this.mConverter.mFast);
    }

    @Override
    public void readEnergyConverter(NBTTagCompound aNBT) {
        long tMultiplier;
        if (aNBT.hasKey("gt.reversed")) {
            this.mCounterClockwise = aNBT.getBoolean("gt.reversed");
        }
        long l = tMultiplier = aNBT.hasKey("gt.multiplier") ? aNBT.getLong("gt.multiplier") : 1L;
        if (this.mCounterClockwise) {
            this.mConRevert = new TE_Behavior_Energy_Converter(this, aNBT, this.mStorage, this.mEnergyIN, this.mEnergyOUT, tMultiplier, aNBT.getBoolean("gt.wasteenergy"), false, aNBT.getBoolean("gt.limit.consumption"));
            this.mConverter = new TE_Behavior_Energy_Converter(this, aNBT, this.mStorage, this.mEnergyIN, this.mEnergyOUT, tMultiplier, aNBT.getBoolean("gt.wasteenergy"), true, aNBT.getBoolean("gt.limit.consumption"));
        } else {
            this.mConverter = new TE_Behavior_Energy_Converter(this, aNBT, this.mStorage, this.mEnergyIN, this.mEnergyOUT, tMultiplier, aNBT.getBoolean("gt.wasteenergy"), false, aNBT.getBoolean("gt.limit.consumption"));
            this.mConRevert = new TE_Behavior_Energy_Converter(this, aNBT, this.mStorage, this.mEnergyIN, this.mEnergyOUT, tMultiplier, aNBT.getBoolean("gt.wasteenergy"), true, aNBT.getBoolean("gt.limit.consumption"));
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.monkey.wrench.to.toggle.direction"));
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("monkeywrench")) {
            this.mStorage.mEnergy = 0L;
            this.mCounterClockwise = !this.mCounterClockwise;
            TE_Behavior_Energy_Converter tConverter = this.mConverter;
            this.mConverter = this.mConRevert;
            this.mConRevert = tConverter;
            if (aChatReturn != null) {
                aChatReturn.add(this.mCounterClockwise ? "Counterclockwise" : "Clockwise");
            }
            this.causeBlockUpdate();
            this.doEnetUpdate();
            return 10000L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                aChatReturn.add(this.mCounterClockwise ? "Counterclockwise" : "Clockwise");
            }
            return 1L;
        }
        return 0L;
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return super.onTickCheck(aTimer) || this.mCounterClockwise != this.oCounterClockwise || this.mConverter.mFast != this.oFast;
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oCounterClockwise = this.mCounterClockwise;
        this.oFast = this.mConverter.mFast;
    }

    @Override
    public byte getVisualData() {
        return (byte)(super.getVisualData() | (this.mCounterClockwise ? 4 : 0) | (this.mConverter.mFast ? 8 : 0));
    }

    @Override
    public void setVisualData(byte aData) {
        super.setVisualData((byte)(aData & 3));
        this.mCounterClockwise = (aData & 4) != 0;
        this.mConverter.mFast = (aData & 8) != 0;
    }
}

