/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.base;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.data.CS;
import gregapi.tileentity.ITileEntityInventoryGUI;
import gregapi.tileentity.base.TileEntityBase04MultiTileEntities;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.Explosion;

public abstract class TileEntityBase05Inventories
extends TileEntityBase04MultiTileEntities
implements IInventory,
ITileEntityInventoryGUI,
IMultiTileEntity.IMTE_OnBlockExploded,
IMultiTileEntity.IMTE_BreakBlock {
    private ItemStack[] mInventory = CS.ZL_IS;
    public boolean mInventoryChanged = false;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        this.mInventory = this.getDefaultInventory(aNBT);
        if (this.mInventory != null && this.mInventory.length > 0) {
            NBTTagList tList = aNBT.getTagList("gt.invlist", 10);
            for (int i = 0; i < tList.tagCount(); ++i) {
                NBTTagCompound tNBT = tList.getCompoundTagAt(i);
                short tSlot = tNBT.getShort("s");
                if (tSlot < 0 || tSlot >= this.mInventory.length) continue;
                this.mInventory[tSlot] = ST.load(tNBT, this.getDefaultStack(tSlot));
            }
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        if (this.mInventory != null && this.mInventory.length > 0) {
            NBTTagList tList = new NBTTagList();
            for (short tSlot = 0; tSlot < this.mInventory.length; tSlot = (short)((short)(tSlot + 1))) {
                if (!ST.valid(this.mInventory[tSlot]) || !this.canSave(tSlot)) continue;
                tList.appendTag((NBTBase)UT.NBT.makeShort(ST.save(this.mInventory[tSlot]), "s", tSlot));
            }
            if (tList.tagCount() > 0) {
                aNBT.setTag("gt.invlist", (NBTBase)tList);
            }
        }
    }

    @Override
    public NBTTagCompound writeItemNBT(NBTTagCompound aNBT) {
        aNBT = super.writeItemNBT(aNBT);
        if (this.mInventory != null && this.mInventory.length > 0) {
            NBTTagList tList = new NBTTagList();
            for (short tSlot = 0; tSlot < this.mInventory.length; tSlot = (short)((short)(tSlot + 1))) {
                if (!ST.valid(this.mInventory[tSlot]) || !this.keepSlot(tSlot)) continue;
                tList.appendTag((NBTBase)UT.NBT.makeShort(ST.save(this.mInventory[tSlot]), "s", tSlot));
            }
            if (tList.tagCount() > 0) {
                aNBT.setTag("gt.invlist", (NBTBase)tList);
            }
        }
        return aNBT;
    }

    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        int tSize = Math.max(this.getMinimumInventorySize(), aNBT.getShort("gt.invsize"));
        return tSize > 0 ? new ItemStack[tSize] : CS.ZL_IS;
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.mInventoryChanged = false;
    }

    @Override
    public final ItemStack slot(int aIndex, ItemStack aStack) {
        this.mInventory[aIndex] = aStack;
        return this.mInventory[aIndex];
    }

    @Override
    public final ItemStack slot(int aIndex) {
        return this.mInventory[aIndex];
    }

    @Override
    public final ItemStack slotTake(int aIndex) {
        ItemStack rStack = this.mInventory[aIndex];
        this.mInventory[aIndex] = null;
        return rStack;
    }

    @Override
    public final boolean slotTrash(int aIndex) {
        return CS.GarbageGT.trash(this.slotTake(aIndex)) > 0;
    }

    @Override
    public final boolean slotNull(int aIndex) {
        if (this.mInventory[aIndex] != null && this.mInventory[aIndex].stackSize <= 0) {
            return this.slotKill(aIndex);
        }
        return false;
    }

    @Override
    public final boolean slotKill(int aIndex) {
        this.mInventory[aIndex] = null;
        return true;
    }

    @Override
    public final boolean slotHas(int aIndex) {
        return this.mInventory[aIndex] != null;
    }

    @Override
    public final boolean invempty() {
        for (int i = 0; i < this.mInventory.length; ++i) {
            if (this.mInventory[i] == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int invsize() {
        return this.mInventory.length;
    }

    @Override
    public final NBTTagCompound slotNBT(int aIndex) {
        return this.mInventory[aIndex] != null ? this.mInventory[aIndex].getTagCompound() : null;
    }

    @Override
    public void updateTanks() {
        this.mInventoryChanged = true;
    }

    @Override
    public void updateInventory() {
        this.mInventoryChanged = true;
    }

    public boolean isUseableByPlayer(EntityPlayer aPlayer) {
        return !this.isDead() && this.allowInteraction((Entity)aPlayer) && aPlayer.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public void markDirty() {
        super.markDirty();
        this.updateInventory();
    }

    public ItemStack decrStackSize(int aSlot, int aDecrement) {
        this.updateInventory();
        if (this.mInventory[aSlot] == null || aDecrement <= 0) {
            return CS.NI;
        }
        if (this.mInventory[aSlot].stackSize <= aDecrement) {
            ItemStack tStack = ST.copy(this.mInventory[aSlot]);
            if (this.allowZeroStacks(aSlot)) {
                this.mInventory[aSlot].stackSize = 0;
            } else {
                this.mInventory[aSlot] = CS.NI;
            }
            return tStack;
        }
        ItemStack rStack = this.mInventory[aSlot].splitStack(aDecrement);
        if (this.mInventory[aSlot].stackSize <= 0 && !this.allowZeroStacks(aSlot)) {
            this.mInventory[aSlot] = CS.NI;
        }
        return rStack;
    }

    public ItemStack getStackInSlotOnClosing(int aSlot) {
        ItemStack rStack = this.mInventory[aSlot];
        this.mInventory[aSlot] = null;
        return rStack;
    }

    public ItemStack getStackInSlot(int aSlot) {
        return this.mInventory[aSlot];
    }

    public String getInventoryName() {
        String rName = this.getCustomName();
        if (UT.Code.stringValid(rName)) {
            return rName;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(this.getMultiTileEntityRegistryID());
        return tRegistry == null ? this.getClass().getName() : tRegistry.getLocal(this.getMultiTileEntityID());
    }

    public int getSizeInventory() {
        return this.mInventory == null ? 0 : this.mInventory.length;
    }

    public void setInventorySlotContents(int aSlot, ItemStack aStack) {
        this.updateInventory();
        this.mInventory[aSlot] = OM.get(aStack);
    }

    public boolean hasCustomInventoryName() {
        return this.getCustomName() != null;
    }

    public boolean isItemValidForSlot(int aSlot, ItemStack aStack) {
        return true;
    }

    public int getMinimumInventorySize() {
        return 0;
    }

    public boolean allowZeroStacks(int aSlot) {
        return false;
    }

    public ItemStack[] getInventory() {
        return this.mInventory;
    }

    public void setInventory(ItemStack[] aInventory) {
        this.mInventory = aInventory;
    }

    public void removeAllDroppableNullStacks() {
        for (int i = 0; i < this.mInventory.length; ++i) {
            if (!this.canDrop(i) || this.mInventory[i] == null || this.mInventory[i].stackSize > 0) continue;
            this.mInventory[i] = CS.NI;
        }
    }

    public abstract boolean canDrop(int var1);

    public boolean keepSlot(int aSlot) {
        return false;
    }

    public boolean breakDrop(int aSlot) {
        return true;
    }

    public boolean canSave(int aSlot) {
        return true;
    }

    public ItemStack getDefaultStack(int aSlot) {
        return null;
    }

    @Override
    public int getSizeInventoryGUI() {
        return this.mInventory == null ? 0 : this.mInventory.length;
    }

    @Override
    public ItemStack getStackInSlotGUI(int aSlot) {
        return this.mInventory[aSlot];
    }

    @Override
    public ItemStack decrStackSizeGUI(int aSlot, int aDecrement) {
        this.updateInventory();
        if (this.mInventory[aSlot] == null || aDecrement <= 0) {
            return CS.NI;
        }
        if (this.mInventory[aSlot].stackSize <= aDecrement) {
            ItemStack tStack = ST.copy(this.mInventory[aSlot]);
            if (this.allowZeroStacks(aSlot)) {
                this.mInventory[aSlot].stackSize = 0;
            } else {
                this.mInventory[aSlot] = CS.NI;
            }
            return tStack;
        }
        ItemStack rStack = this.mInventory[aSlot].splitStack(aDecrement);
        if (this.mInventory[aSlot].stackSize <= 0 && !this.allowZeroStacks(aSlot)) {
            this.mInventory[aSlot] = CS.NI;
        }
        return rStack;
    }

    @Override
    public ItemStack getStackInSlotOnClosingGUI(int aSlot) {
        ItemStack rStack = this.mInventory[aSlot];
        this.mInventory[aSlot] = null;
        return rStack;
    }

    @Override
    public void setInventorySlotContentsGUI(int aSlot, ItemStack aStack) {
        this.updateInventory();
        this.mInventory[aSlot] = OM.get(aStack);
    }

    @Override
    public String getInventoryNameGUI() {
        String rName = this.getCustomName();
        if (UT.Code.stringValid(rName)) {
            return rName;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(this.getMultiTileEntityRegistryID());
        return tRegistry == null ? this.getClass().getName() : tRegistry.getLocal(this.getMultiTileEntityID());
    }

    @Override
    public boolean hasCustomInventoryNameGUI() {
        return this.getCustomName() != null;
    }

    @Override
    public int getInventoryStackLimitGUI(int aSlot) {
        return this.getInventoryStackLimit();
    }

    @Override
    public void markDirtyGUI() {
        this.markDirty();
    }

    @Override
    public boolean isUseableByPlayerGUI(EntityPlayer aPlayer) {
        return !this.isDead() && this.allowInteraction((Entity)aPlayer) && aPlayer.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    @Override
    public void openInventoryGUI() {
        this.openInventory();
    }

    @Override
    public void closeInventoryGUI() {
        this.closeInventory();
    }

    @Override
    public boolean isItemValidForSlotGUI(int aSlot, ItemStack aStack) {
        return this.isItemValidForSlot(aSlot, aStack);
    }

    @Override
    public boolean canTakeOutOfSlotGUI(int aSlot) {
        return true;
    }

    @Override
    public void onExploded(Explosion aExplosion) {
        for (int i = 0; i < this.mInventory.length; ++i) {
            if (CS.RNGSUS.nextInt(3) == 0) continue;
            CS.GarbageGT.trash(this.mInventory, i);
        }
        this.setToAir();
    }

    @Override
    public boolean breakBlock() {
        if (this.isServerSide()) {
            for (int i = 0; i < this.mInventory.length; i = (int)((short)(i + 1))) {
                if (this.mInventory[i] == null || !this.canDrop(i) || ST.debug(this.mInventory[i]) || !this.breakDrop(i)) continue;
                ItemStack tDumpedStack = ST.amount(UT.Code.bind_(0L, 512L * (long)Math.max(1, this.mInventory[i].getMaxStackSize()), this.mInventory[i].stackSize), this.mInventory[i]);
                int tMaxSize = Math.max(1, this.mInventory[i].getMaxStackSize());
                while (tDumpedStack.stackSize > tMaxSize) {
                    ST.drop(this.worldObj, this.getCoords(), ST.amount(tMaxSize, tDumpedStack));
                    tDumpedStack.stackSize -= tMaxSize;
                    this.mInventory[i].stackSize -= tMaxSize;
                }
                if (tDumpedStack.stackSize > 0) {
                    this.mInventory[i].stackSize -= tDumpedStack.stackSize;
                    ST.drop(this.worldObj, this.getCoords(), ST.copy(tDumpedStack));
                }
                CS.GarbageGT.trash(this.mInventory, i);
            }
        }
        return false;
    }

    public boolean addStackToSlot(int aIndex, ItemStack aStack) {
        if (ST.invalid(aStack)) {
            return true;
        }
        if (aIndex < 0 || aIndex >= this.getSizeInventory()) {
            return false;
        }
        ItemStack tStack = this.getStackInSlot(aIndex);
        if (ST.invalid(tStack)) {
            this.setInventorySlotContents(aIndex, aStack);
            return true;
        }
        if (ST.equal(tStack, aStack = OM.get_(aStack)) && tStack.stackSize + aStack.stackSize <= Math.min(Math.max(1, tStack.getMaxStackSize()), this.getInventoryStackLimit())) {
            tStack.stackSize += aStack.stackSize;
            this.updateInventory();
            return true;
        }
        return false;
    }
}

