/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.base;

import cpw.mods.fml.common.registry.GameRegistry;
import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityClassContainer;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.network.IPacket;
import gregapi.network.packets.data.PacketSyncDataByte;
import gregapi.network.packets.data.PacketSyncDataByteArray;
import gregapi.network.packets.data.PacketSyncDataInteger;
import gregapi.network.packets.data.PacketSyncDataLong;
import gregapi.network.packets.data.PacketSyncDataName;
import gregapi.network.packets.data.PacketSyncDataShort;
import gregapi.network.packets.ids.PacketSyncDataByteAndIDs;
import gregapi.network.packets.ids.PacketSyncDataByteArrayAndIDs;
import gregapi.network.packets.ids.PacketSyncDataIDs;
import gregapi.network.packets.ids.PacketSyncDataIntegerAndIDs;
import gregapi.network.packets.ids.PacketSyncDataLongAndIDs;
import gregapi.network.packets.ids.PacketSyncDataShortAndIDs;
import gregapi.render.IRenderedBlockObject;
import gregapi.render.IRenderedBlockObjectSideCheck;
import gregapi.tileentity.base.TileEntityBase03TicksAndSync;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public abstract class TileEntityBase04MultiTileEntities
extends TileEntityBase03TicksAndSync
implements IRenderedBlockObjectSideCheck,
IRenderedBlockObject,
IMultiTileEntity.IMTE_OnPainting,
IMultiTileEntity.IMTE_OnNeighborBlockChange,
IMultiTileEntity.IMTE_GetPickBlock,
IMultiTileEntity.IMTE_OnRegistrationFirst,
IMultiTileEntity.IMTE_RecolourBlock,
IMultiTileEntity.IMTE_GetDrops,
IMultiTileEntity.IMTE_OnBlockActivated,
IMultiTileEntity.IMTE_ShouldSideBeRendered,
IMultiTileEntity.IMTE_GetFlammability,
IMultiTileEntity.IMTE_GetFireSpreadSpeed {
    private short mMTEID = Short.MAX_VALUE;
    private short mMTERegistry = Short.MAX_VALUE;
    private String mCustomName = null;

    @Override
    public abstract String getTileEntityName();

    @Override
    public void onRegistrationFirst(MultiTileEntityRegistry aRegistry, short aID) {
        GameRegistry.registerTileEntity(this.getClass(), (String)this.getTileEntityName());
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        return aSendAll ? new PacketSyncDataIDs(this.getCoords(), this.getMultiTileEntityRegistryID(), this.getMultiTileEntityID()) : null;
    }

    public IPacket getClientDataPacketByte(boolean aSendAll, byte aByte) {
        return aSendAll ? new PacketSyncDataByteAndIDs(this.getCoords(), this.getMultiTileEntityRegistryID(), this.getMultiTileEntityID(), aByte) : new PacketSyncDataByte(this.getCoords(), aByte);
    }

    public IPacket getClientDataPacketShort(boolean aSendAll, short aShort) {
        return aSendAll ? new PacketSyncDataShortAndIDs(this.getCoords(), this.getMultiTileEntityRegistryID(), this.getMultiTileEntityID(), aShort) : new PacketSyncDataShort(this.getCoords(), aShort);
    }

    public IPacket getClientDataPacketInteger(boolean aSendAll, int aInteger) {
        return aSendAll ? new PacketSyncDataIntegerAndIDs(this.getCoords(), this.getMultiTileEntityRegistryID(), this.getMultiTileEntityID(), aInteger) : new PacketSyncDataInteger(this.getCoords(), aInteger);
    }

    public IPacket getClientDataPacketLong(boolean aSendAll, long aLong) {
        return aSendAll ? new PacketSyncDataLongAndIDs(this.getCoords(), this.getMultiTileEntityRegistryID(), this.getMultiTileEntityID(), aLong) : new PacketSyncDataLong(this.getCoords(), aLong);
    }

    public IPacket getClientDataPacketByteArray(boolean aSendAll, byte ... aByteArray) {
        return aSendAll ? new PacketSyncDataByteArrayAndIDs(this.getCoords(), this.getMultiTileEntityRegistryID(), this.getMultiTileEntityID(), aByteArray) : new PacketSyncDataByteArray(this.getCoords(), aByteArray);
    }

    @Override
    public final void initFromNBT(NBTTagCompound aNBT, short aMTEID, short aMTERegistry) {
        this.mMTEID = aMTEID;
        this.mMTERegistry = aMTERegistry;
        this.readFromNBT(aNBT == null ? UT.NBT.make() : aNBT);
    }

    @Override
    public final void readFromNBT(NBTTagCompound aNBT) {
        if (this.mMTEID == Short.MAX_VALUE || this.mMTERegistry == Short.MAX_VALUE) {
            MultiTileEntityClassContainer tClass;
            this.mMTEID = aNBT.getShort("gt.mte.id");
            this.mMTERegistry = aNBT.getShort("gt.mte.reg");
            MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(this.mMTERegistry);
            if (tRegistry != null && (tClass = tRegistry.getClassContainer(this.mMTEID)) != null) {
                aNBT = UT.NBT.fuse(aNBT, tClass.mParameters);
            }
        }
        if (aNBT.hasKey("x")) {
            this.xCoord = aNBT.getInteger("x");
        }
        if (aNBT.hasKey("y")) {
            this.yCoord = aNBT.getInteger("y");
        }
        if (aNBT.hasKey("z")) {
            this.zCoord = aNBT.getInteger("z");
        }
        if (this.yCoord < 0) {
            WD.invalidateTileEntityWithNegativeYCoord(this.xCoord, this.yCoord, this.zCoord, this);
        }
        if (aNBT.hasKey("display")) {
            this.mCustomName = aNBT.getCompoundTag("display").getString("Name");
        }
        try {
            this.readFromNBT2(aNBT);
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
    }

    public void readFromNBT2(NBTTagCompound aNBT) {
    }

    @Override
    public final void writeToNBT(NBTTagCompound aNBT) {
        super.writeToNBT(aNBT);
        aNBT.setShort("gt.mte.id", this.mMTEID);
        aNBT.setShort("gt.mte.reg", this.mMTERegistry);
        if (UT.Code.stringValid(this.mCustomName)) {
            aNBT.setTag("display", (NBTBase)UT.NBT.makeString(aNBT.getCompoundTag("display"), "Name", this.mCustomName));
        }
        if (this.isPainted()) {
            aNBT.setInteger("gt.color", this.getPaint());
            aNBT.setBoolean("gt.painted", true);
        }
        try {
            this.writeToNBT2(aNBT);
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
    }

    public void writeToNBT2(NBTTagCompound aNBT) {
    }

    @Override
    public NBTTagCompound writeItemNBT(NBTTagCompound aNBT) {
        if (UT.Code.stringValid(this.mCustomName)) {
            aNBT.setTag("display", (NBTBase)UT.NBT.makeString(aNBT.getCompoundTag("display"), "Name", this.mCustomName));
        }
        if (UT.Code.stringValid(this.ERROR_MESSAGE) && this.isClientSide()) {
            aNBT.setTag("display", (NBTBase)UT.NBT.makeString(aNBT.getCompoundTag("display"), "Name", this.ERROR_MESSAGE));
        }
        if (this.isPainted()) {
            aNBT.setInteger("gt.color", this.getPaint());
            aNBT.setBoolean("gt.painted", true);
        }
        return aNBT;
    }

    @Override
    public void sendClientData(boolean aSendAll, EntityPlayerMP aPlayer) {
        super.sendClientData(aSendAll, aPlayer);
        if (aSendAll && UT.Code.stringValid(this.mCustomName)) {
            if (aPlayer == null) {
                this.getNetworkHandler().sendToAllPlayersInRange(new PacketSyncDataName(this.getCoords(), this.mCustomName), this.worldObj, this.getCoords());
            } else {
                this.getNetworkHandler().sendToPlayer(new PacketSyncDataName(this.getCoords(), this.mCustomName), aPlayer);
            }
        }
    }

    @Override
    public final boolean onBlockActivated(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        try {
            return this.allowRightclick((Entity)aPlayer) && (this.checkObstruction(aPlayer, aSide, aHitX, aHitY, aHitZ) || this.onBlockActivated2(aPlayer, aSide, aHitX, aHitY, aHitZ));
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
            return true;
        }
    }

    public boolean onBlockActivated2(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return false;
    }

    public boolean checkObstruction(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return aPlayer != null && !(aPlayer instanceof FakePlayer) && !CS.SIDES_INVALID[aSide] && WD.obstructed(this.worldObj, this.xCoord, this.yCoord, this.zCoord, aSide);
    }

    @Override
    public ArrayListNoNulls<ItemStack> getDrops(int aFortune, boolean aSilkTouch) {
        ArrayListNoNulls<ItemStack> rList = ST.arraylist(new ItemStack[0]);
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(this.mMTERegistry);
        if (tRegistry != null) {
            rList.add(tRegistry.getItem((int)this.mMTEID, this.writeItemNBT(UT.NBT.make())));
        }
        return rList;
    }

    public void popOff() {
        if (this.isDead()) {
            return;
        }
        for (ItemStack tStack : this.getDrops(0, false)) {
            ST.drop(this.worldObj, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord, tStack);
        }
        this.setToAir();
    }

    public void popOff(Entity aEntity) {
        if (this.isDead()) {
            return;
        }
        for (ItemStack tStack : this.getDrops(0, false)) {
            ST.drop(aEntity.worldObj, aEntity.posX, aEntity.posY, aEntity.posZ, tStack);
        }
        this.setToAir();
    }

    public void popOff(World aWorld, double aX, double aY, double aZ) {
        if (this.isDead()) {
            return;
        }
        for (ItemStack tStack : this.getDrops(0, false)) {
            ST.drop(aWorld, aX, aY, aZ, tStack);
        }
        this.setToAir();
    }

    public void popOff(World aWorld, ChunkCoordinates aCoords) {
        if (this.isDead()) {
            return;
        }
        for (ItemStack tStack : this.getDrops(0, false)) {
            ST.drop(aWorld, aCoords, tStack);
        }
        this.setToAir();
    }

    public void burnOff() {
        if (this.isDead()) {
            return;
        }
        for (ItemStack tStack : this.getDrops(0, false)) {
            ST.drop(this.worldObj, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord, tStack);
        }
        this.setToFire();
    }

    public void burnOff(Entity aEntity) {
        if (this.isDead()) {
            return;
        }
        for (ItemStack tStack : this.getDrops(0, false)) {
            ST.drop(aEntity.worldObj, aEntity.posX, aEntity.posY, aEntity.posZ, tStack);
        }
        this.setToFire();
    }

    public void burnOff(World aWorld, double aX, double aY, double aZ) {
        if (this.isDead()) {
            return;
        }
        for (ItemStack tStack : this.getDrops(0, false)) {
            ST.drop(aWorld, aX, aY, aZ, tStack);
        }
        this.setToFire();
    }

    public void burnOff(World aWorld, ChunkCoordinates aCoords) {
        if (this.isDead()) {
            return;
        }
        for (ItemStack tStack : this.getDrops(0, false)) {
            ST.drop(aWorld, aCoords, tStack);
        }
        this.setToFire();
    }

    public ItemStack toStack() {
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(this.mMTERegistry);
        if (tRegistry != null) {
            return tRegistry.getItem((int)this.mMTEID, this.writeItemNBT(UT.NBT.make()));
        }
        return null;
    }

    @Override
    public void onNeighborBlockChange(World aWorld, Block aBlock) {
        this.mBlockUpdated = true;
    }

    @Override
    public boolean recolourBlock(byte aSide, byte aColor) {
        if (UT.Code.exists(aColor, CS.DYES_INVERTED)) {
            int aRGB = (this.isPainted() ? UT.Code.mixRGBInt(CS.DYES_INT_INVERTED[aColor], this.getPaint()) : CS.DYES_INT_INVERTED[aColor]) & 0xFFFFFF;
            if (this.paint(aRGB)) {
                this.updateClientData();
                this.causeBlockUpdate();
                return true;
            }
            return false;
        }
        if (this.unpaint()) {
            this.updateClientData();
            this.causeBlockUpdate();
            return true;
        }
        return false;
    }

    @Override
    public boolean onPainting(byte aSide, int aRGB) {
        if (this.paint(aRGB)) {
            this.updateClientData();
            this.causeBlockUpdate();
            return true;
        }
        return false;
    }

    public boolean unpaint() {
        return false;
    }

    public boolean isPainted() {
        return false;
    }

    public boolean paint(int aRGB) {
        return false;
    }

    public int getPaint() {
        return 0xFFFFFF;
    }

    public boolean removePaint(byte aSide) {
        return this.unpaint();
    }

    @Override
    public String getCustomName() {
        return UT.Code.stringValid(this.mCustomName) ? this.mCustomName : null;
    }

    @Override
    public void setCustomName(String aName) {
        this.mCustomName = aName;
    }

    @Override
    public ItemStack getPickBlock(MovingObjectPosition aTarget) {
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(this.mMTERegistry);
        return tRegistry == null ? null : tRegistry.getItem((int)this.mMTEID, this.writeItemNBT(UT.NBT.make()));
    }

    @Override
    public short getMultiTileEntityID() {
        return this.mMTEID;
    }

    @Override
    public short getMultiTileEntityRegistryID() {
        return this.mMTERegistry;
    }

    @Override
    public void setShouldRefresh(boolean aShouldRefresh) {
        this.mShouldRefresh = aShouldRefresh;
    }
}

