/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.base;

import gregapi.data.CS;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.tileentity.ITileEntitySynchronising;
import gregapi.tileentity.base.TileEntityBase02AdjacentTEBuffer;
import gregapi.util.WD;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;

public abstract class TileEntityBase03TicksAndSync
extends TileEntityBase02AdjacentTEBuffer
implements ITileEntitySynchronising {
    public UUID mOwner = null;
    public boolean mIsRunningTick = false;
    private boolean mSendClientData = false;
    public boolean mBlockUpdated = false;

    public abstract IPacket getClientDataPacket(boolean var1);

    public void sendClientData(boolean aSendAll, EntityPlayerMP aPlayer) {
        if (aPlayer == null) {
            IPacket tPacket = this.getClientDataPacket(aSendAll);
            if (this.mOwner == null) {
                this.getNetworkHandler().sendToAllPlayersInRange(tPacket, this.worldObj, this.getCoords());
            } else {
                this.getNetworkHandler().sendToPlayerIfInRange(tPacket, this.mOwner, this.worldObj, this.getCoords());
                this.getNetworkHandlerNonOwned().sendToAllPlayersInRangeExcept(tPacket, this.mOwner, this.worldObj, this.getCoords());
            }
        } else if (!this.mSendClientData) {
            IPacket tPacket = this.getClientDataPacket(aSendAll);
            if (this.mOwner == null) {
                this.getNetworkHandler().sendToPlayer(tPacket, aPlayer);
            } else if (this.mOwner.equals(aPlayer.getUniqueID())) {
                this.getNetworkHandler().sendToPlayer(tPacket, aPlayer);
            } else {
                this.getNetworkHandlerNonOwned().sendToPlayer(tPacket, aPlayer);
            }
        }
    }

    @Override
    public void processPacket(INetworkHandler aNetworkHandler) {
        if (this.isClientSide()) {
            this.mOwner = aNetworkHandler == this.getNetworkHandlerNonOwned() ? CS.NOT_YOU : null;
        }
    }

    public INetworkHandler getNetworkHandler() {
        return CS.NW_API;
    }

    public INetworkHandler getNetworkHandlerNonOwned() {
        return CS.NW_AP2;
    }

    public void updateClientData() {
        this.mSendClientData = true;
    }

    @Override
    public void onCoordinateChange() {
        super.onCoordinateChange();
        this.updateClientData();
    }

    public final Packet getDescriptionPacket() {
        return null;
    }

    @Override
    public void validate() {
        super.validate();
        this.updateClientData();
    }

    @Override
    public final void sendUpdateToPlayer(EntityPlayerMP aPlayer) {
        this.sendClientData(true, aPlayer);
    }

    @Override
    public boolean allowInteraction(Entity aEntity) {
        return this.mOwner == null || aEntity != null && this.mOwner.equals(aEntity.getUniqueID());
    }

    @Override
    public final void updateEntity() {
        this.mIsRunningTick = true;
        boolean tIsServerSide = this.isServerSide();
        try {
            if (this.mTimer == 0L) {
                this.markDirty();
                WD.mark(this);
                this.onTickFirst(tIsServerSide);
            }
            if (!this.isDead()) {
                this.onTickStart(this.mTimer, tIsServerSide);
            }
            if (!this.isDead()) {
                super.updateEntity();
            }
            if (!this.isDead()) {
                this.onTick(this.mTimer, tIsServerSide);
            }
            if (!this.isDead() && tIsServerSide && this.mTimer > 2L && (this.mSendClientData || this.onTickCheck(this.mTimer))) {
                this.sendClientData(this.mSendClientData, null);
                this.mSendClientData = false;
                this.onTickChecked(this.mTimer);
            }
            if (!this.isDead()) {
                this.onTickResetChecks(this.mTimer, tIsServerSide);
            }
            if (!this.isDead()) {
                this.onTickEnd(this.mTimer, tIsServerSide);
            }
        }
        catch (Throwable e1) {
            e1.printStackTrace(CS.ERR);
            this.setError((tIsServerSide ? "Serverside: " : "Clientside: ") + e1);
            try {
                this.onTickFailed(this.mTimer, tIsServerSide);
            }
            catch (Throwable e2) {
                e2.printStackTrace(CS.ERR);
                this.setError((tIsServerSide ? "Serverside: " : "Clientside: ") + e2);
            }
        }
        this.mIsRunningTick = false;
    }

    public void onTickFirst(boolean aIsServerSide) {
    }

    public void onTickStart(long aTimer, boolean aIsServerSide) {
    }

    public void onTick(long aTimer, boolean aIsServerSide) {
    }

    public boolean onTickCheck(long aTimer) {
        return false;
    }

    public void onTickChecked(long aTimer) {
    }

    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        this.mBlockUpdated = false;
    }

    public void onTickEnd(long aTimer, boolean aIsServerSide) {
    }

    public void onTickFailed(long aTimer, boolean aIsServerSide) {
    }
}

