/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.base;

import gregapi.data.CS;
import gregapi.tileentity.ITileEntityNeedsSaving;
import gregapi.tileentity.ITileEntityUnloadable;
import gregapi.tileentity.base.TileEntityBase01Root;
import gregapi.util.WD;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;

public abstract class TileEntityBase02AdjacentTEBuffer
extends TileEntityBase01Root
implements ITileEntityNeedsSaving {
    protected long mTimer = 0L;
    protected int oX = 0;
    protected int oY = 0;
    protected int oZ = 0;
    private final TileEntity[] mBufferedTileEntities = new TileEntity[6];

    public TileEntityBase02AdjacentTEBuffer() {
        super(true);
    }

    private void clearNullMarkersFromTileEntityBuffer() {
        for (int i = 0; i < this.mBufferedTileEntities.length; ++i) {
            if (this.mBufferedTileEntities[i] != this) continue;
            this.mBufferedTileEntities[i] = null;
        }
    }

    private void clearEverythingFromTileEntityBuffer() {
        for (int i = 0; i < this.mBufferedTileEntities.length; ++i) {
            this.mBufferedTileEntities[i] = null;
        }
    }

    @Override
    public final void onAdjacentBlockChange(int aTileX, int aTileY, int aTileZ) {
        super.onAdjacentBlockChange(aTileX, aTileY, aTileZ);
        this.clearNullMarkersFromTileEntityBuffer();
        this.onAdjacentBlockChange2(aTileX, aTileY, aTileZ);
    }

    public void onAdjacentBlockChange2(int aTileX, int aTileY, int aTileZ) {
    }

    @Override
    public TileEntity getTileEntityAtSideAndDistance(byte aSide, int aDistance) {
        if (this.worldObj == null) {
            return null;
        }
        if (aDistance != 1) {
            return super.getTileEntityAtSideAndDistance(aSide, aDistance);
        }
        if (CS.SIDES_INVALID[aSide] || this.mBufferedTileEntities[aSide] == this) {
            return null;
        }
        ChunkCoordinates tCoords = this.getOffset(aSide, 1);
        boolean tChunksCrossed = this.crossedChunkBorder(tCoords);
        if (tChunksCrossed && (!(this.mBufferedTileEntities[aSide] instanceof ITileEntityUnloadable) || ((ITileEntityUnloadable)this.mBufferedTileEntities[aSide]).isDead())) {
            this.mBufferedTileEntities[aSide] = null;
            if (this.mIgnoreUnloadedChunks && !this.worldObj.blockExists(tCoords.posX, tCoords.posY, tCoords.posZ)) {
                return null;
            }
        }
        if (this.mBufferedTileEntities[aSide] == null) {
            TileEntity tTileEntity = WD.te(this.worldObj, tCoords.posX, tCoords.posY, tCoords.posZ, true);
            if (tTileEntity == null) {
                this.mBufferedTileEntities[aSide] = this;
                return null;
            }
            if (tChunksCrossed) {
                WD.mark(tTileEntity);
            }
            if (tTileEntity.xCoord == tCoords.posX && tTileEntity.yCoord == tCoords.posY && tTileEntity.zCoord == tCoords.posZ) {
                this.mBufferedTileEntities[aSide] = tTileEntity;
                return this.mBufferedTileEntities[aSide];
            }
            this.mBufferedTileEntities[aSide] = null;
            return tTileEntity;
        }
        if (this.mBufferedTileEntities[aSide].xCoord != tCoords.posX || this.mBufferedTileEntities[aSide].yCoord != tCoords.posY || this.mBufferedTileEntities[aSide].zCoord != tCoords.posZ) {
            this.mBufferedTileEntities[aSide] = null;
            return this.getTileEntityAtSideAndDistance(aSide, aDistance);
        }
        if (this.mBufferedTileEntities[aSide] instanceof ITileEntityUnloadable) {
            if (((ITileEntityUnloadable)this.mBufferedTileEntities[aSide]).isDead()) {
                this.mBufferedTileEntities[aSide] = null;
                return this.getTileEntityAtSideAndDistance(aSide, aDistance);
            }
        } else if (this.mBufferedTileEntities[aSide].isInvalid()) {
            this.mBufferedTileEntities[aSide] = null;
            return this.getTileEntityAtSideAndDistance(aSide, aDistance);
        }
        if (tChunksCrossed) {
            WD.mark(this.mBufferedTileEntities[aSide]);
        }
        return this.mBufferedTileEntities[aSide];
    }

    @Override
    public void validate() {
        this.clearNullMarkersFromTileEntityBuffer();
        super.validate();
    }

    @Override
    public void invalidate() {
        this.clearNullMarkersFromTileEntityBuffer();
        super.invalidate();
    }

    @Override
    public void onChunkUnload() {
        this.clearNullMarkersFromTileEntityBuffer();
        super.onChunkUnload();
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.isDead()) {
            ++this.mTimer;
            if (this.isServerSide()) {
                if (this.mTimer == 1L) {
                    this.oX = this.xCoord;
                    this.oY = this.yCoord;
                    this.oZ = this.zCoord;
                    this.mDoesBlockUpdate = true;
                    this.clearEverythingFromTileEntityBuffer();
                }
                if (this.oX != this.xCoord || this.oY != this.yCoord || this.oZ != this.zCoord) {
                    this.clearEverythingFromTileEntityBuffer();
                    this.onCoordinateChange(this.worldObj, this.oX, this.oY, this.oZ);
                    this.oX = this.xCoord;
                    this.oY = this.yCoord;
                    this.oZ = this.zCoord;
                }
            }
        }
    }

    @Override
    public long getTimer() {
        return this.mTimer;
    }

    @Override
    public void doneMoving() {
        this.clearEverythingFromTileEntityBuffer();
        this.onCoordinateChange(this.worldObj, this.oX, this.oY, this.oZ);
        this.oX = this.xCoord;
        this.oY = this.yCoord;
        this.oZ = this.zCoord;
    }
}

