/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.base;

import appeng.api.movable.IMovableTile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.TD;
import gregapi.gui.ContainerCommon;
import gregapi.gui.Slot_Base;
import gregapi.network.packets.PacketBlockError;
import gregapi.network.packets.PacketBlockEvent;
import gregapi.random.ExplosionGT;
import gregapi.render.BlockTextureCopied;
import gregapi.render.IRenderedBlockObject;
import gregapi.render.ITexture;
import gregapi.render.RenderHelper;
import gregapi.tileentity.ITileEntity;
import gregapi.tileentity.ITileEntityAdjacentInventoryUpdatable;
import gregapi.tileentity.ITileEntityGUI;
import gregapi.tileentity.data.ITileEntitySurface;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.delegate.ITileEntityCanDelegate;
import gregapi.tileentity.delegate.ITileEntityDelegating;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.multiblocks.MultiTileEntityMultiBlockPart;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyTile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockRailBase;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

@Optional.InterfaceList(value={@Optional.Interface(iface="appeng.api.movable.IMovableTile", modid="appliedenergistics2")})
public abstract class TileEntityBase01Root
extends TileEntity
implements ITileEntity,
ITileEntityGUI,
IMovableTile {
    public boolean mIgnoreUnloadedChunks = true;
    public boolean mIsDead = false;
    public boolean mShouldRefresh = true;
    public boolean mDoesBlockUpdate = false;
    public boolean mIsAddedToEnet = false;
    public boolean mDoEnetCheck = true;
    public boolean FORCE_FULL_SELECTION_BOXES = false;
    public final boolean mIsTicking;
    private final ChunkCoordinates mReturnedCoordinates = new ChunkCoordinates();
    public float mExplosionStrength = 0.0f;
    private byte mExplodeSpamCooldown = 0;
    public static final ITexture SNOW_TEXTURE = BlockTextureCopied.get(Blocks.snow_layer);
    public String ERROR_MESSAGE = null;

    public TileEntityBase01Root(boolean aIsTicking) {
        this.mIsTicking = aIsTicking;
    }

    @Override
    public void onTileEntityPlaced() {
    }

    @Override
    public void onAdjacentBlockChange(int aTileX, int aTileY, int aTileZ) {
    }

    public void readFromNBT(NBTTagCompound aNBT) {
        if (aNBT.hasKey("x")) {
            this.xCoord = aNBT.getInteger("x");
        }
        if (aNBT.hasKey("y")) {
            this.yCoord = aNBT.getInteger("y");
        }
        if (aNBT.hasKey("z")) {
            this.zCoord = aNBT.getInteger("z");
        }
        if (this.yCoord < 0) {
            WD.invalidateTileEntityWithNegativeYCoord(this.xCoord, this.yCoord, this.zCoord, this);
        }
    }

    public void writeToNBT(NBTTagCompound aNBT) {
        if (this.yCoord < 0) {
            WD.invalidateTileEntityWithNegativeYCoord(this.xCoord, this.yCoord, this.zCoord, this);
        }
        aNBT.setString("id", this.getTileEntityName());
        aNBT.setInteger("x", this.xCoord);
        aNBT.setInteger("y", this.yCoord);
        aNBT.setInteger("z", this.zCoord);
    }

    public abstract String getTileEntityName();

    public void markDirty() {
    }

    @Override
    public World getWorld() {
        return this.worldObj;
    }

    @Override
    public int getX() {
        return this.xCoord;
    }

    @Override
    public int getY() {
        return this.yCoord;
    }

    @Override
    public int getZ() {
        return this.zCoord;
    }

    @Override
    public int getOffsetX(byte aSide) {
        return this.xCoord + CS.OFFX[aSide];
    }

    @Override
    public int getOffsetY(byte aSide) {
        return this.yCoord + CS.OFFY[aSide];
    }

    @Override
    public int getOffsetZ(byte aSide) {
        return this.zCoord + CS.OFFZ[aSide];
    }

    @Override
    public int getOffsetX(byte aSide, int aMultiplier) {
        return this.xCoord + CS.OFFX[aSide] * aMultiplier;
    }

    @Override
    public int getOffsetY(byte aSide, int aMultiplier) {
        return this.yCoord + CS.OFFY[aSide] * aMultiplier;
    }

    @Override
    public int getOffsetZ(byte aSide, int aMultiplier) {
        return this.zCoord + CS.OFFZ[aSide] * aMultiplier;
    }

    @Override
    public int getOffsetXN(byte aSide) {
        return this.xCoord - CS.OFFX[aSide];
    }

    @Override
    public int getOffsetYN(byte aSide) {
        return this.yCoord - CS.OFFY[aSide];
    }

    @Override
    public int getOffsetZN(byte aSide) {
        return this.zCoord - CS.OFFZ[aSide];
    }

    @Override
    public int getOffsetXN(byte aSide, int aMultiplier) {
        return this.xCoord - CS.OFFX[aSide] * aMultiplier;
    }

    @Override
    public int getOffsetYN(byte aSide, int aMultiplier) {
        return this.yCoord - CS.OFFY[aSide] * aMultiplier;
    }

    @Override
    public int getOffsetZN(byte aSide, int aMultiplier) {
        return this.zCoord - CS.OFFZ[aSide] * aMultiplier;
    }

    @Override
    public ChunkCoordinates getCoords() {
        this.mReturnedCoordinates.posX = this.xCoord;
        this.mReturnedCoordinates.posY = this.yCoord;
        this.mReturnedCoordinates.posZ = this.zCoord;
        return this.mReturnedCoordinates;
    }

    @Override
    public ChunkCoordinates getOffset(byte aSide, int aMultiplier) {
        return new ChunkCoordinates(this.getOffsetX(aSide, aMultiplier), this.getOffsetY(aSide, aMultiplier), this.getOffsetZ(aSide, aMultiplier));
    }

    @Override
    public ChunkCoordinates getOffsetN(byte aSide, int aMultiplier) {
        return new ChunkCoordinates(this.getOffsetXN(aSide, aMultiplier), this.getOffsetYN(aSide, aMultiplier), this.getOffsetZN(aSide, aMultiplier));
    }

    @Override
    public boolean isServerSide() {
        return this.worldObj == null ? FMLCommonHandler.instance().getEffectiveSide().isServer() : !this.worldObj.isRemote;
    }

    @Override
    public boolean isClientSide() {
        return this.worldObj == null ? FMLCommonHandler.instance().getEffectiveSide().isClient() : this.worldObj.isRemote;
    }

    @Override
    public boolean openGUI(EntityPlayer aPlayer) {
        return this.openGUI(aPlayer, 0);
    }

    @Override
    public boolean openGUI(EntityPlayer aPlayer, int aID) {
        if (aPlayer == null) {
            return false;
        }
        aPlayer.openGui((Object)CS.GAPI, aID, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        return true;
    }

    @Override
    public int getRandomNumber(int aRange) {
        return CS.RNGSUS.nextInt(aRange);
    }

    @Override
    public int rng(int aRange) {
        return CS.RNGSUS.nextInt(aRange);
    }

    public boolean rng() {
        return CS.RNGSUS.nextBoolean();
    }

    @Override
    public BiomeGenBase getBiome(ChunkCoordinates aCoords) {
        return this.worldObj == null ? BiomeGenBase.plains : this.worldObj.getBiomeGenForCoords(aCoords.posX, aCoords.posZ);
    }

    @Override
    public BiomeGenBase getBiome(int aX, int aZ) {
        return this.worldObj == null ? BiomeGenBase.plains : this.worldObj.getBiomeGenForCoords(aX, aZ);
    }

    @Override
    public BiomeGenBase getBiome() {
        return this.getBiome(this.xCoord, this.zCoord);
    }

    @Override
    public Block getBlockOffset(int aX, int aY, int aZ) {
        return this.getBlock(this.xCoord + aX, this.yCoord + aY, this.zCoord + aZ);
    }

    @Override
    public Block getBlockAtSide(byte aSide) {
        return this.getBlockAtSideAndDistance(aSide, 1);
    }

    @Override
    public Block getBlockAtSideAndDistance(byte aSide, int aDistance) {
        return this.getBlock(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public byte getMetaDataOffset(int aX, int aY, int aZ) {
        return this.getMetaData(this.xCoord + aX, this.yCoord + aY, this.zCoord + aZ);
    }

    @Override
    public byte getMetaDataAtSide(byte aSide) {
        return this.getMetaDataAtSideAndDistance(aSide, 1);
    }

    @Override
    public byte getMetaDataAtSideAndDistance(byte aSide, int aDistance) {
        return this.getMetaData(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public byte getLightLevelOffset(int aX, int aY, int aZ) {
        return this.getLightLevel(this.xCoord + aX, this.yCoord + aY, this.zCoord + aZ);
    }

    @Override
    public byte getLightLevelAtSide(byte aSide) {
        return this.getLightLevelAtSideAndDistance(aSide, 1);
    }

    @Override
    public byte getLightLevelAtSideAndDistance(byte aSide, int aDistance) {
        return this.getLightLevel(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public boolean getOpacityOffset(int aX, int aY, int aZ) {
        return this.getOpacity(this.xCoord + aX, this.yCoord + aY, this.zCoord + aZ);
    }

    @Override
    public boolean getOpacityAtSide(byte aSide) {
        return this.getOpacityAtSideAndDistance(aSide, 1);
    }

    @Override
    public boolean getOpacityAtSideAndDistance(byte aSide, int aDistance) {
        return this.getOpacity(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public boolean getRainOffset(int aX, int aY, int aZ) {
        return this.getRain(this.xCoord + aX, this.yCoord + aY, this.zCoord + aZ);
    }

    @Override
    public boolean getRainAtSide(byte aSide) {
        return this.getRainAtSideAndDistance(aSide, 1);
    }

    @Override
    public boolean getRainAtSideAndDistance(byte aSide, int aDistance) {
        return this.getRain(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public boolean getSkyOffset(int aX, int aY, int aZ) {
        return this.getSky(this.xCoord + aX, this.yCoord + aY, this.zCoord + aZ);
    }

    @Override
    public boolean getSkyAtSide(byte aSide) {
        return this.getSkyAtSideAndDistance(aSide, 1);
    }

    @Override
    public boolean getSkyAtSideAndDistance(byte aSide, int aDistance) {
        return this.getSky(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public boolean getAirOffset(int aX, int aY, int aZ) {
        return this.getAir(this.xCoord + aX, this.yCoord + aY, this.zCoord + aZ);
    }

    @Override
    public boolean getAirAtSide(byte aSide) {
        return this.getAirAtSideAndDistance(aSide, 1);
    }

    @Override
    public boolean getAirAtSideAndDistance(byte aSide, int aDistance) {
        return this.getAir(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public TileEntity getTileEntityOffset(int aX, int aY, int aZ) {
        return this.getTileEntity(this.xCoord + aX, this.yCoord + aY, this.zCoord + aZ);
    }

    @Override
    public TileEntity getTileEntityAtSideAndDistance(byte aSide, int aDistance) {
        return this.getTileEntity(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public DelegatorTileEntity<TileEntity> getAdjacentTileEntity(byte aSide) {
        return this.getAdjacentTileEntity(aSide, true, false);
    }

    @Override
    public DelegatorTileEntity<IInventory> getAdjacentInventory(byte aSide) {
        return this.getAdjacentInventory(aSide, true, false);
    }

    @Override
    public DelegatorTileEntity<ISidedInventory> getAdjacentSidedInventory(byte aSide) {
        return this.getAdjacentSidedInventory(aSide, true, false);
    }

    @Override
    public DelegatorTileEntity<IFluidHandler> getAdjacentTank(byte aSide) {
        return this.getAdjacentTank(aSide, true, false);
    }

    @Override
    public DelegatorTileEntity<IInventory> getAdjacentInventory(byte aSide, boolean aAllowDelegates, boolean aNotConnectToDelegators) {
        DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(aSide, aAllowDelegates, aNotConnectToDelegators);
        return new DelegatorTileEntity<IInventory>(tDelegator.mTileEntity instanceof IInventory ? (IInventory)tDelegator.mTileEntity : null, tDelegator);
    }

    @Override
    public DelegatorTileEntity<ISidedInventory> getAdjacentSidedInventory(byte aSide, boolean aAllowDelegates, boolean aNotConnectToDelegators) {
        DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(aSide, aAllowDelegates, aNotConnectToDelegators);
        return new DelegatorTileEntity<ISidedInventory>(tDelegator.mTileEntity instanceof ISidedInventory ? (ISidedInventory)tDelegator.mTileEntity : null, tDelegator);
    }

    @Override
    public DelegatorTileEntity<IFluidHandler> getAdjacentTank(byte aSide, boolean aAllowDelegates, boolean aNotConnectToDelegators) {
        DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(aSide, aAllowDelegates, aNotConnectToDelegators);
        return new DelegatorTileEntity<IFluidHandler>(tDelegator.mTileEntity instanceof IFluidHandler ? (IFluidHandler)tDelegator.mTileEntity : null, tDelegator);
    }

    @Override
    public DelegatorTileEntity<TileEntity> getAdjacentTileEntity(byte aSide, boolean aAllowDelegates, boolean aNotConnectToDelegators) {
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(aSide, 1);
        if (tTileEntity == null) {
            return new DelegatorTileEntity<Object>(null, this.worldObj, this.getOffsetX(aSide), this.getOffsetY(aSide), this.getOffsetZ(aSide), CS.OPOS[aSide]);
        }
        if (aNotConnectToDelegators && tTileEntity instanceof ITileEntityCanDelegate && ((ITileEntityCanDelegate)tTileEntity).isExtender(aSide)) {
            return new DelegatorTileEntity<Object>(null, this.worldObj, this.getOffsetX(aSide), this.getOffsetY(aSide), this.getOffsetZ(aSide), CS.OPOS[aSide]);
        }
        if (aAllowDelegates && tTileEntity instanceof ITileEntityDelegating) {
            return ((ITileEntityDelegating)tTileEntity).getDelegateTileEntity(CS.OPOS[aSide]);
        }
        return new DelegatorTileEntity<TileEntity>(tTileEntity, tTileEntity.getWorldObj(), tTileEntity.xCoord, tTileEntity.yCoord, tTileEntity.zCoord, CS.OPOS[aSide]);
    }

    public List<DelegatorTileEntity<TileEntity>> allAdjacentTileEntities(boolean aAllowDelegates, boolean aNotConnectToDelegators) {
        ArrayListNoNulls<DelegatorTileEntity<TileEntity>> rDelegates = new ArrayListNoNulls<DelegatorTileEntity<TileEntity>>();
        for (byte tSide : CS.ALL_SIDES_VALID) {
            DelegatorTileEntity<TileEntity> tDelegate = this.getAdjacentTileEntity(tSide, aAllowDelegates, aNotConnectToDelegators);
            if (tDelegate.mTileEntity == null) continue;
            rDelegates.add(tDelegate);
        }
        return rDelegates;
    }

    @Override
    public Block getBlock(int aX, int aY, int aZ) {
        if (this.worldObj == null) {
            return CS.NB;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.worldObj.blockExists(aX, aY, aZ)) {
            return CS.NB;
        }
        return this.worldObj.getBlock(aX, aY, aZ);
    }

    @Override
    public byte getMetaData(int aX, int aY, int aZ) {
        if (this.worldObj == null) {
            return 0;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.worldObj.blockExists(aX, aY, aZ)) {
            return 0;
        }
        return UT.Code.bind4(this.worldObj.getBlockMetadata(aX, aY, aZ));
    }

    @Override
    public byte getLightLevel(int aX, int aY, int aZ) {
        if (this.worldObj == null) {
            return 14;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.worldObj.blockExists(aX, aY, aZ)) {
            return 0;
        }
        return UT.Code.bind4((long)this.worldObj.getLightBrightness(aX, aY, aZ) * 15L);
    }

    @Override
    public boolean getSky(int aX, int aY, int aZ) {
        if (this.worldObj == null) {
            return true;
        }
        if (this.worldObj.provider.hasNoSky) {
            return false;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.worldObj.blockExists(aX, aY, aZ)) {
            return true;
        }
        return this.worldObj.canBlockSeeTheSky(aX, aY, aZ);
    }

    @Override
    public boolean getRain(int aX, int aY, int aZ) {
        if (this.worldObj == null) {
            return true;
        }
        if (this.worldObj.provider.hasNoSky) {
            return false;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.worldObj.blockExists(aX, aY, aZ)) {
            return true;
        }
        return this.worldObj.getPrecipitationHeight(aX, aZ) <= aY;
    }

    @Override
    public boolean getOpacity(int aX, int aY, int aZ) {
        if (this.worldObj == null) {
            return false;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.worldObj.blockExists(aX, aY, aZ)) {
            return false;
        }
        return this.worldObj.getBlock(aX, aY, aZ).isOpaqueCube();
    }

    @Override
    public boolean getAir(int aX, int aY, int aZ) {
        if (this.worldObj == null) {
            return true;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.worldObj.blockExists(aX, aY, aZ)) {
            return true;
        }
        return this.worldObj.getBlock(aX, aY, aZ).isAir((IBlockAccess)this.worldObj, aX, aY, aZ);
    }

    @Override
    public TileEntity getTileEntity(int aX, int aY, int aZ) {
        if (this.worldObj == null) {
            return null;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.worldObj.blockExists(aX, aY, aZ)) {
            return null;
        }
        return WD.te(this.worldObj, aX, aY, aZ, true);
    }

    @Override
    public Block getBlock(ChunkCoordinates aCoords) {
        if (this.worldObj == null) {
            return CS.NB;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aCoords) && !this.worldObj.blockExists(aCoords.posX, aCoords.posY, aCoords.posZ)) {
            return CS.NB;
        }
        return this.worldObj.getBlock(aCoords.posX, aCoords.posY, aCoords.posZ);
    }

    @Override
    public byte getMetaData(ChunkCoordinates aCoords) {
        if (this.worldObj == null) {
            return 0;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aCoords) && !this.worldObj.blockExists(aCoords.posX, aCoords.posY, aCoords.posZ)) {
            return 0;
        }
        return (byte)this.worldObj.getBlockMetadata(aCoords.posX, aCoords.posY, aCoords.posZ);
    }

    @Override
    public byte getLightLevel(ChunkCoordinates aCoords) {
        if (this.worldObj == null) {
            return 14;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aCoords) && !this.worldObj.blockExists(aCoords.posX, aCoords.posY, aCoords.posZ)) {
            return 0;
        }
        return UT.Code.bind4((long)this.worldObj.getLightBrightness(aCoords.posX, aCoords.posY, aCoords.posZ) * 15L);
    }

    @Override
    public boolean getSky(ChunkCoordinates aCoords) {
        if (this.worldObj == null) {
            return true;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aCoords) && !this.worldObj.blockExists(aCoords.posX, aCoords.posY, aCoords.posZ)) {
            return true;
        }
        return this.worldObj.canBlockSeeTheSky(aCoords.posX, aCoords.posY, aCoords.posZ);
    }

    @Override
    public boolean getRain(ChunkCoordinates aCoords) {
        if (this.worldObj == null) {
            return true;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aCoords) && !this.worldObj.blockExists(aCoords.posX, aCoords.posY, aCoords.posZ)) {
            return true;
        }
        return this.worldObj.getPrecipitationHeight(aCoords.posX, aCoords.posZ) <= aCoords.posY;
    }

    @Override
    public boolean getOpacity(ChunkCoordinates aCoords) {
        if (this.worldObj == null) {
            return false;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aCoords) && !this.worldObj.blockExists(aCoords.posX, aCoords.posY, aCoords.posZ)) {
            return false;
        }
        return this.worldObj.getBlock(aCoords.posX, aCoords.posY, aCoords.posZ).isOpaqueCube();
    }

    @Override
    public boolean getAir(ChunkCoordinates aCoords) {
        if (this.worldObj == null) {
            return true;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aCoords) && !this.worldObj.blockExists(aCoords.posX, aCoords.posY, aCoords.posZ)) {
            return true;
        }
        return this.worldObj.getBlock(aCoords.posX, aCoords.posY, aCoords.posZ).isAir((IBlockAccess)this.worldObj, aCoords.posX, aCoords.posY, aCoords.posZ);
    }

    @Override
    public TileEntity getTileEntity(ChunkCoordinates aCoords) {
        if (this.worldObj == null) {
            return null;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aCoords) && !this.worldObj.blockExists(aCoords.posX, aCoords.posY, aCoords.posZ)) {
            return null;
        }
        return WD.te(this.worldObj, aCoords, true);
    }

    public DelegatorTileEntity<TileEntity> delegator(byte aSide) {
        return new DelegatorTileEntity<TileEntity>(this, aSide);
    }

    @Override
    public void sendBlockEvent(byte aID, byte aValue) {
        CS.NW_API.sendToAllPlayersInRange(new PacketBlockEvent(this.getCoords(), aID, aValue), this.worldObj, this.getCoords());
    }

    @Override
    public boolean isDead() {
        return this.mIsDead;
    }

    public void invalidate() {
        super.invalidate();
        this.setDead();
    }

    public void validate() {
        super.validate();
        this.setAlive();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.setDead();
    }

    @Optional.Method(modid="IC2")
    private void loadIntoEnet() {
        if (this instanceof IEnergyTile && (this.isEnergyType(TD.Energy.EU, (byte)6, true) || this.isEnergyType(TD.Energy.EU, (byte)6, false))) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.mIsAddedToEnet = true;
        } else {
            this.mDoEnetCheck = false;
        }
    }

    @Optional.Method(modid="IC2")
    private void unloadFromEnet() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
        this.mIsAddedToEnet = false;
    }

    protected void doEnetUpdate() {
        if (this.isServerSide() && this.mIsAddedToEnet && this.mDoEnetCheck) {
            try {
                this.unloadFromEnet();
                this.loadIntoEnet();
            }
            catch (Throwable e) {
                this.mDoEnetCheck = false;
            }
        }
    }

    protected void setDead() {
        if (!this.mIsDead) {
            this.mIsDead = true;
            if (this.isServerSide() && this.mIsAddedToEnet) {
                try {
                    this.unloadFromEnet();
                }
                catch (Throwable e) {
                    this.mDoEnetCheck = false;
                }
            }
        }
    }

    protected void setAlive() {
        this.mIsDead = false;
    }

    public void updateEntity() {
        if (this.isDead()) {
            this.setAlive();
        }
        if (this.isServerSide() && !this.mIsAddedToEnet && this.mDoEnetCheck) {
            try {
                this.loadIntoEnet();
            }
            catch (Throwable e) {
                this.mDoEnetCheck = false;
            }
        }
        if (this.mExplosionStrength > 0.0f) {
            this.setToAir();
            if (this.mExplosionStrength < 1.0f) {
                UT.Sounds.send("random.explode", this, false);
            } else {
                ExplosionGT.explode(this.worldObj, null, this.xCoord, this.yCoord, this.zCoord, this.mExplosionStrength, false, true);
            }
            this.setDead();
            return;
        }
        if (this.mDoesBlockUpdate) {
            this.doBlockUpdate();
        }
    }

    @Override
    public long getTimer() {
        return 0L;
    }

    public boolean canUpdate() {
        return this.mIsTicking && this.mShouldRefresh;
    }

    public boolean shouldRefresh(Block aOldBlock, Block aNewBlock, int aOldMeta, int aNewMeta, World aWorld, int aX, int aY, int aZ) {
        return this.mShouldRefresh || aOldBlock != aNewBlock;
    }

    public final void causeBlockUpdate() {
        if (this.mIsTicking) {
            this.mDoesBlockUpdate = true;
        } else {
            this.doBlockUpdate();
        }
    }

    public void doBlockUpdate() {
        Block tBlock = this.getBlock(this.getCoords());
        this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, tBlock);
        if (this instanceof IMultiTileEntity.IMTE_IsProvidingStrongPower) {
            for (byte tSide : CS.ALL_SIDES_VALID) {
                if (!this.getBlockAtSide(tSide).isNormalCube((IBlockAccess)this.worldObj, this.xCoord + CS.OFFX[tSide], this.yCoord + CS.OFFY[tSide], this.zCoord + CS.OFFZ[tSide])) continue;
                this.worldObj.notifyBlocksOfNeighborChange(this.xCoord + CS.OFFX[tSide], this.yCoord + CS.OFFY[tSide], this.zCoord + CS.OFFZ[tSide], tBlock, (int)CS.OPOS[tSide]);
            }
        }
        this.mDoesBlockUpdate = false;
    }

    public final boolean crossedChunkBorder(int aX, int aZ) {
        return aX >> 4 != this.xCoord >> 4 || aZ >> 4 != this.zCoord >> 4;
    }

    public final boolean crossedChunkBorder(ChunkCoordinates aCoords) {
        return aCoords.posX >> 4 != this.xCoord >> 4 || aCoords.posZ >> 4 != this.zCoord >> 4;
    }

    public final void explode() {
        this.explode(!this.mIsTicking);
    }

    public final void explode(double aStrength) {
        this.explode(!this.mIsTicking, aStrength);
    }

    public void explode(boolean aInstant) {
        this.explode(aInstant, 4.0);
    }

    public void explode(boolean aInstant, double aStrength) {
        this.mExplosionStrength = (float)Math.max(aStrength, (double)this.mExplosionStrength);
        if (aInstant) {
            this.setToAir();
            this.mExplodeSpamCooldown = 0;
            if (this.mExplosionStrength < 1.0f) {
                UT.Sounds.send("random.explode", this, false);
            } else {
                ExplosionGT.explode(this.worldObj, null, this.xCoord, this.yCoord, this.zCoord, this.mExplosionStrength, false, true);
            }
        }
    }

    public void overcharge(long aVoltage, TagData aEnergyType) {
        if (CS.OVERCHARGE_EXPLOSIONS) {
            if (TD.Energy.ALL_EXPLODING.contains(aEnergyType)) {
                this.explode(UT.Code.tierMax(aVoltage));
            } else {
                this.explode(0.1);
            }
        } else if (CS.OVERCHARGE_BREAKING) {
            this.explode(0.1);
        }
        UT.Sounds.send(TD.Energy.ALL_ELECTRIC.contains(aEnergyType) ? "random.explode" : (TD.Energy.ALL_KINETIC.contains(aEnergyType) ? "random.break" : "random.explode"), this, false);
        CS.DEB.println("Machine overcharged with: " + aVoltage + " " + aEnergyType.getLocalisedNameLong());
    }

    public float getExplosionResistance(Entity aExploder, double aExplosionX, double aExplosionY, double aExplosionZ) {
        return this.mExplosionStrength > 0.0f ? 0.0f : this.getExplosionResistance2(aExploder, aExplosionX, aExplosionY, aExplosionZ);
    }

    public float getExplosionResistance() {
        return this.mExplosionStrength > 0.0f ? 0.0f : this.getExplosionResistance2();
    }

    public float getExplosionResistance2(Entity aExploder, double aExplosionX, double aExplosionY, double aExplosionZ) {
        return this.getExplosionResistance2();
    }

    public float getExplosionResistance2() {
        return 0.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object getGUIClient(int aGUIID, EntityPlayer aPlayer) {
        return null;
    }

    @Override
    public Object getGUIServer(int aGUIID, EntityPlayer aPlayer) {
        return null;
    }

    public boolean interceptClick(int aGUIID, Slot_Base aSlot, int aSlotIndex, int aInvSlot, EntityPlayer aPlayer, boolean aShiftclick, boolean aRightclick, int aMouse, int aShift) {
        return false;
    }

    public ItemStack slotClick(int aGUIID, Slot_Base aSlot, int aSlotIndex, int aInvSlot, EntityPlayer aPlayer, boolean aShiftclick, boolean aRightclick, int aMouse, int aShift) {
        return null;
    }

    public void killGUIs() {
        for (Object tPlayer : this.worldObj.playerEntities) {
            if (!(tPlayer instanceof EntityPlayer) || !(((EntityPlayer)tPlayer).openContainer instanceof ContainerCommon) || ((ContainerCommon)((EntityPlayer)tPlayer).openContainer).mTileEntity != this) continue;
            ((EntityPlayer)tPlayer).closeScreen();
        }
    }

    public void rebootGUIs(int aGUIID) {
        for (Object tPlayer : this.worldObj.playerEntities) {
            if (!(tPlayer instanceof EntityPlayer) || !(((EntityPlayer)tPlayer).openContainer instanceof ContainerCommon) || ((ContainerCommon)((EntityPlayer)tPlayer).openContainer).mTileEntity != this) continue;
            ((EntityPlayer)tPlayer).closeScreen();
            this.openGUI((EntityPlayer)tPlayer, aGUIID);
        }
    }

    public long getOpenGUIs() {
        long rGUIs = 0L;
        for (Object tPlayer : this.worldObj.playerEntities) {
            if (!(tPlayer instanceof EntityPlayer) || !(((EntityPlayer)tPlayer).openContainer instanceof ContainerCommon) || ((ContainerCommon)((EntityPlayer)tPlayer).openContainer).mTileEntity != this) continue;
            ++rGUIs;
        }
        return rGUIs;
    }

    public boolean needsToSyncEverything() {
        return false;
    }

    public boolean shouldSideBeRendered(byte aSide) {
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(aSide, 1);
        return tTileEntity instanceof ITileEntitySurface ? !((ITileEntitySurface)tTileEntity).isSurfaceOpaque(CS.OPOS[aSide]) : !WD.visOpq(this.worldObj, this.getOffsetX(aSide), this.getOffsetY(aSide), this.getOffsetZ(aSide), CS.SIDES_VERTICAL[aSide] || WD.border(this.xCoord, this.zCoord, this.getOffsetX(aSide), this.getOffsetZ(aSide)), false);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderItem(Block aBlock, RenderBlocks aRenderer) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderBlock(Block aBlock, RenderBlocks aRenderer, IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean usesRenderPass(int aRenderPass, boolean[] aShouldSideBeRendered) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderFullBlockSide(Block aBlock, RenderBlocks aRenderer, byte aSide) {
        return this.shouldSideBeRendered(aSide);
    }

    @SideOnly(value=Side.CLIENT)
    public final IRenderedBlockObject passRenderingToObject(ItemStack aStack) {
        return this.ERROR_MESSAGE == null ? this.passRenderingToObject2(aStack) : IRenderedBlockObject.ErrorRenderer.INSTANCE;
    }

    @SideOnly(value=Side.CLIENT)
    public final IRenderedBlockObject passRenderingToObject(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return this.ERROR_MESSAGE == null ? this.passRenderingToObject2(aWorld, aX, aY, aZ) : IRenderedBlockObject.ErrorRenderer.INSTANCE;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderedBlockObject passRenderingToObject2(ItemStack aStack) {
        return (IRenderedBlockObject)((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderedBlockObject passRenderingToObject2(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return (IRenderedBlockObject)((Object)this);
    }

    public void updateTanks() {
    }

    public void updateInventory() {
    }

    public void updateAdjacentInventories() {
        for (byte tSide : CS.ALL_SIDES_VALID) {
            DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(tSide);
            if (!(tDelegator.mTileEntity instanceof ITileEntityAdjacentInventoryUpdatable)) continue;
            ((ITileEntityAdjacentInventoryUpdatable)tDelegator.mTileEntity).adjacentInventoryUpdated(tDelegator.mSideOfTileEntity, (IInventory)this);
        }
    }

    public void playClick() {
        UT.Sounds.send("random.click", this, false);
    }

    public void playCollect() {
        UT.Sounds.send("random.pop", 0.2f, this, false);
    }

    public void updateLightValue() {
        if (this instanceof IMultiTileEntity.IMTE_GetLightValue) {
            this.worldObj.setLightValue(EnumSkyBlock.Block, this.xCoord, this.yCoord, this.zCoord, ((IMultiTileEntity.IMTE_GetLightValue)((Object)this)).getLightValue());
            for (byte tSide : CS.ALL_SIDES_MIDDLE) {
                this.worldObj.updateLightByType(EnumSkyBlock.Block, this.xCoord + CS.OFFX[tSide], this.yCoord + CS.OFFY[tSide], this.zCoord + CS.OFFZ[tSide]);
            }
        }
    }

    public boolean shouldCheckWeakPower(byte aSide) {
        return false;
    }

    @Override
    public boolean hasRedstoneIncoming() {
        return this.hasRedstoneIncoming(CS.ALL_SIDES_VALID);
    }

    public boolean hasRedstoneIncoming(byte[] aSides) {
        for (byte tSide : aSides) {
            if (this.getRedstoneIncoming(tSide) <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasRedstoneIncomingFromNonRail() {
        return this.hasRedstoneIncomingFromNonRail(CS.ALL_SIDES_VALID);
    }

    public boolean hasRedstoneIncomingFromNonRail(byte[] aSides) {
        for (byte tSide : aSides) {
            if (this.getBlockAtSide(tSide) instanceof BlockRailBase || this.getRedstoneIncoming(tSide) <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte getRedstoneIncoming(byte aSide) {
        if (this.worldObj == null) {
            return 0;
        }
        if (CS.SIDES_INVALID[aSide]) {
            byte rRedstone = 0;
            for (byte tSide : CS.ALL_SIDES_VALID) {
                if ((rRedstone = (byte)Math.max(rRedstone, this.worldObj.getIndirectPowerLevelTo(this.getOffsetX(tSide), this.getOffsetY(tSide), this.getOffsetZ(tSide), (int)tSide))) < 15) continue;
                return 15;
            }
            return rRedstone;
        }
        return UT.Code.bind4(this.worldObj.getIndirectPowerLevelTo(this.getOffsetX(aSide), this.getOffsetY(aSide), this.getOffsetZ(aSide), (int)aSide));
    }

    @Override
    public byte getComparatorIncoming(byte aSide) {
        if (this.worldObj == null) {
            return 0;
        }
        Block tBlock = this.getBlockAtSide(aSide);
        return tBlock.hasComparatorInputOverride() ? UT.Code.bind4(tBlock.getComparatorInputOverride(this.worldObj, this.getOffsetX(aSide), this.getOffsetY(aSide), this.getOffsetZ(aSide), (int)CS.OPOS[aSide])) : this.getRedstoneIncoming(aSide);
    }

    protected IFluidTank getFluidTankFillable(byte aSide, FluidStack aFluidToFill) {
        return null;
    }

    protected IFluidTank getFluidTankDrainable(byte aSide, FluidStack aFluidToDrain) {
        return null;
    }

    protected IFluidTank[] getFluidTanks(byte aSide) {
        return CS.ZL_FT;
    }

    public int fill(ForgeDirection aDirection, FluidStack aFluid, boolean aDoFill) {
        if (aFluid == null || aFluid.amount <= 0) {
            return 0;
        }
        IFluidTank tTank = this.getFluidTankFillable(UT.Code.side(aDirection), aFluid);
        if (tTank == null) {
            return 0;
        }
        int rFilledAmount = tTank.fill(aFluid, aDoFill);
        if (rFilledAmount > 0 && aDoFill) {
            this.updateTanks();
        }
        return rFilledAmount;
    }

    public FluidStack drain(ForgeDirection aDirection, FluidStack aFluid, boolean aDoDrain) {
        if (aFluid == null || aFluid.amount <= 0) {
            return null;
        }
        IFluidTank tTank = this.getFluidTankDrainable(UT.Code.side(aDirection), aFluid);
        if (tTank == null || tTank.getFluid() == null || tTank.getFluidAmount() == 0 || !tTank.getFluid().isFluidEqual(aFluid)) {
            return null;
        }
        FluidStack rDrained = tTank.drain(aFluid.amount, aDoDrain);
        if (rDrained != null && aDoDrain) {
            this.updateTanks();
        }
        return rDrained;
    }

    public FluidStack drain(ForgeDirection aDirection, int aAmountToDrain, boolean aDoDrain) {
        if (aAmountToDrain <= 0) {
            return null;
        }
        IFluidTank tTank = this.getFluidTankDrainable(UT.Code.side(aDirection), null);
        if (tTank == null || tTank.getFluid() == null || tTank.getFluidAmount() == 0) {
            return null;
        }
        FluidStack rDrained = tTank.drain(aAmountToDrain, aDoDrain);
        if (rDrained != null && aDoDrain) {
            this.updateTanks();
        }
        return rDrained;
    }

    public boolean canFill(ForgeDirection aDirection, Fluid aFluid) {
        if (aFluid == null) {
            return false;
        }
        IFluidTank tTank = this.getFluidTankFillable(UT.Code.side(aDirection), FL.make(aFluid, 0L));
        return tTank != null && (tTank.getFluid() == null || tTank.getFluid().getFluid() == aFluid);
    }

    public boolean canDrain(ForgeDirection aDirection, Fluid aFluid) {
        if (aFluid == null) {
            return false;
        }
        IFluidTank tTank = this.getFluidTankDrainable(UT.Code.side(aDirection), FL.make(aFluid, 0L));
        return tTank != null && tTank.getFluid() != null && tTank.getFluid().getFluid() == aFluid;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection aDirection) {
        IFluidTank[] tTanks = this.getFluidTanks(UT.Code.side(aDirection));
        if (tTanks == null || tTanks.length <= 0) {
            return CS.ZL_FLUIDTANKINFO;
        }
        FluidTankInfo[] rInfo = new FluidTankInfo[tTanks.length];
        for (int i = 0; i < tTanks.length; ++i) {
            rInfo[i] = new FluidTankInfo(tTanks[i]);
        }
        return rInfo;
    }

    protected IFluidTank getFluidTankFillable(MultiTileEntityMultiBlockPart aPart, byte aSide, FluidStack aFluidToFill) {
        return this.getFluidTankFillable((byte)6, aFluidToFill);
    }

    protected IFluidTank getFluidTankDrainable(MultiTileEntityMultiBlockPart aPart, byte aSide, FluidStack aFluidToDrain) {
        return this.getFluidTankDrainable((byte)6, aFluidToDrain);
    }

    protected IFluidTank[] getFluidTanks(MultiTileEntityMultiBlockPart aPart, byte aSide) {
        return this.getFluidTanks((byte)6);
    }

    public int fill(MultiTileEntityMultiBlockPart aPart, byte aDirection, FluidStack aFluid, boolean aDoFill) {
        if (aFluid == null || aFluid.amount <= 0) {
            return 0;
        }
        IFluidTank tTank = this.getFluidTankFillable(aPart, (byte)6, aFluid);
        if (tTank == null) {
            return 0;
        }
        int rFilledAmount = tTank.fill(aFluid, aDoFill);
        if (rFilledAmount > 0 && aDoFill) {
            this.updateTanks();
        }
        return rFilledAmount;
    }

    public FluidStack drain(MultiTileEntityMultiBlockPart aPart, byte aDirection, FluidStack aFluid, boolean aDoDrain) {
        if (aFluid == null || aFluid.amount <= 0) {
            return null;
        }
        IFluidTank tTank = this.getFluidTankDrainable(aPart, (byte)6, aFluid);
        if (tTank == null || tTank.getFluid() == null || tTank.getFluidAmount() == 0 || !tTank.getFluid().isFluidEqual(aFluid)) {
            return null;
        }
        FluidStack rDrained = tTank.drain(aFluid.amount, aDoDrain);
        if (rDrained != null && aDoDrain) {
            this.updateTanks();
        }
        return rDrained;
    }

    public FluidStack drain(MultiTileEntityMultiBlockPart aPart, byte aDirection, int aAmountToDrain, boolean aDoDrain) {
        if (aAmountToDrain <= 0) {
            return null;
        }
        IFluidTank tTank = this.getFluidTankDrainable(aPart, (byte)6, null);
        if (tTank == null || tTank.getFluid() == null || tTank.getFluidAmount() == 0) {
            return null;
        }
        FluidStack rDrained = tTank.drain(aAmountToDrain, aDoDrain);
        if (rDrained != null && aDoDrain) {
            this.updateTanks();
        }
        return rDrained;
    }

    public boolean canFill(MultiTileEntityMultiBlockPart aPart, byte aDirection, Fluid aFluid) {
        if (aFluid == null) {
            return false;
        }
        IFluidTank tTank = this.getFluidTankFillable(aPart, (byte)6, FL.make(aFluid, 0L));
        return tTank != null && (tTank.getFluid() == null || tTank.getFluid().getFluid() == aFluid);
    }

    public boolean canDrain(MultiTileEntityMultiBlockPart aPart, byte aDirection, Fluid aFluid) {
        if (aFluid == null) {
            return false;
        }
        IFluidTank tTank = this.getFluidTankDrainable(aPart, (byte)6, FL.make(aFluid, 0L));
        return tTank != null && tTank.getFluid() != null && tTank.getFluid().getFluid() == aFluid;
    }

    public FluidTankInfo[] getTankInfo(MultiTileEntityMultiBlockPart aPart, byte aDirection) {
        IFluidTank[] tTanks = this.getFluidTanks(aPart, (byte)6);
        if (tTanks == null || tTanks.length <= 0) {
            return CS.ZL_FLUIDTANKINFO;
        }
        FluidTankInfo[] rInfo = new FluidTankInfo[tTanks.length];
        for (int i = 0; i < tTanks.length; ++i) {
            rInfo[i] = new FluidTankInfo(tTanks[i]);
        }
        return rInfo;
    }

    public long doInject(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        return 0L;
    }

    public long doExtract(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoExtract) {
        return 0L;
    }

    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return false;
    }

    public boolean isEnergyCapacitorType(TagData aEnergyType, byte aSide) {
        return false;
    }

    public long getEnergyStored(TagData aEnergyType, byte aSide) {
        return 0L;
    }

    public long getEnergyCapacity(TagData aEnergyType, byte aSide) {
        return 0L;
    }

    public Collection<TagData> getEnergyTypes(byte aSide) {
        return Collections.emptyList();
    }

    public Collection<TagData> getEnergyCapacitorTypes(byte aSide) {
        return Collections.emptyList();
    }

    public boolean isEnergyEmittingTo(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return this.isEnergyType(aEnergyType, aSide, true) && this.getSurfaceSizeAttachable(aSide) > 0.0f;
    }

    public boolean isEnergyAcceptingFrom(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return this.isEnergyType(aEnergyType, aSide, false) && this.getSurfaceSizeAttachable(aSide) > 0.0f;
    }

    public synchronized long doEnergyExtraction(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoExtract) {
        return aSize != 0L && this.isEnergyEmittingTo(aEnergyType, aSide, false) ? (TD.Energy.ALL_SIZE_IRRELEVANT.contains(aEnergyType) || Math.abs(aSize) >= this.getEnergySizeOutputMin(aEnergyType, aSide) ? this.doExtract(aEnergyType, aSide, aSize, aAmount, aDoExtract) : 0L) : 0L;
    }

    public synchronized long doEnergyInjection(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        return aSize != 0L && this.isEnergyAcceptingFrom(aEnergyType, aSide, false) ? (TD.Energy.ALL_SIZE_IRRELEVANT.contains(aEnergyType) || Math.abs(aSize) >= this.getEnergySizeInputMin(aEnergyType, aSide) ? this.doInject(aEnergyType, aSide, aSize, aAmount, aDoInject) : aAmount) : 0L;
    }

    public long getEnergyOffered(TagData aEnergyType, byte aSide, long aSize) {
        return 0L;
    }

    public long getEnergySizeOutputRecommended(TagData aEnergyType, byte aSide) {
        return 0L;
    }

    public long getEnergySizeOutputMin(TagData aEnergyType, byte aSide) {
        return this.getEnergySizeOutputRecommended(aEnergyType, aSide) / 2L;
    }

    public long getEnergySizeOutputMax(TagData aEnergyType, byte aSide) {
        return this.getEnergySizeOutputRecommended(aEnergyType, aSide) * 2L;
    }

    public long getEnergyDemanded(TagData aEnergyType, byte aSide, long aSize) {
        return 0L;
    }

    public long getEnergySizeInputRecommended(TagData aEnergyType, byte aSide) {
        return 0L;
    }

    public long getEnergySizeInputMin(TagData aEnergyType, byte aSide) {
        return this.getEnergySizeInputRecommended(aEnergyType, aSide) / 2L;
    }

    public long getEnergySizeInputMax(TagData aEnergyType, byte aSide) {
        return this.getEnergySizeInputRecommended(aEnergyType, aSide) * 2L;
    }

    public boolean isEnergyType(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide, boolean aEmitting) {
        return this.isEnergyType(aEnergyType, aSide, aEmitting);
    }

    public boolean isEnergyCapacitorType(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide) {
        return this.isEnergyCapacitorType(aEnergyType, aSide);
    }

    public long getEnergyStored(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide) {
        return this.getEnergyStored(aEnergyType, aSide);
    }

    public long getEnergyCapacity(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide) {
        return this.getEnergyCapacity(aEnergyType, aSide);
    }

    public Collection<TagData> getEnergyTypes(MultiTileEntityMultiBlockPart aPart, byte aSide) {
        return this.getEnergyTypes(aSide);
    }

    public Collection<TagData> getEnergyCapacitorTypes(MultiTileEntityMultiBlockPart aPart, byte aSide) {
        return this.getEnergyCapacitorTypes(aSide);
    }

    public boolean isEnergyAcceptingFrom(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return this.isEnergyAcceptingFrom(aEnergyType, aSide, aTheoretical);
    }

    public boolean isEnergyEmittingTo(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return this.isEnergyEmittingTo(aEnergyType, aSide, aTheoretical);
    }

    public long doEnergyInjection(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        return this.doEnergyInjection(aEnergyType, aSide, aSize, aAmount, aDoInject);
    }

    public long doEnergyExtraction(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoExtract) {
        return this.doEnergyExtraction(aEnergyType, aSide, aSize, aAmount, aDoExtract);
    }

    public long getEnergyOffered(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide, long aSize) {
        return this.getEnergyOffered(aEnergyType, aSide, aSize);
    }

    public long getEnergySizeOutputRecommended(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide) {
        return this.getEnergySizeOutputRecommended(aEnergyType, aSide);
    }

    public long getEnergySizeOutputMin(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide) {
        return this.getEnergySizeOutputMin(aEnergyType, aSide);
    }

    public long getEnergySizeOutputMax(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide) {
        return this.getEnergySizeOutputMax(aEnergyType, aSide);
    }

    public long getEnergyDemanded(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide, long aSize) {
        return this.getEnergyDemanded(aEnergyType, aSide, aSize);
    }

    public long getEnergySizeInputRecommended(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide) {
        return this.getEnergySizeInputRecommended(aEnergyType, aSide);
    }

    public long getEnergySizeInputMin(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide) {
        return this.getEnergySizeInputMin(aEnergyType, aSide);
    }

    public long getEnergySizeInputMax(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide) {
        return this.getEnergySizeInputMax(aEnergyType, aSide);
    }

    public boolean canConnectEnergy(ForgeDirection aDirection) {
        for (TagData tTag : TD.Energy.ALL_RF) {
            if (!this.isEnergyEmittingTo(tTag, UT.Code.side(aDirection), true)) continue;
            return true;
        }
        return this.isEnergyAcceptingFrom(TD.Energy.RF, UT.Code.side(aDirection), true);
    }

    public int receiveEnergy(ForgeDirection aDirection, int aSize, boolean aSimulate) {
        return (int)this.doEnergyInjection(TD.Energy.RF, UT.Code.side(aDirection), 1L, aSize, !aSimulate);
    }

    public int extractEnergy(ForgeDirection aDirection, int aSize, boolean aSimulate) {
        return (int)this.doEnergyExtraction(TD.Energy.RF, UT.Code.side(aDirection), 1L, aSize, !aSimulate);
    }

    public int getEnergyStored(ForgeDirection aDirection) {
        return UT.Code.bindInt(this.getEnergyCapacity(TD.Energy.RF, UT.Code.side(aDirection)));
    }

    public int getMaxEnergyStored(ForgeDirection aDirection) {
        return UT.Code.bindInt(this.getEnergyCapacity(TD.Energy.RF, UT.Code.side(aDirection)));
    }

    public int getSinkTier() {
        return UT.Code.tierMax(this.getEnergySizeInputRecommended(TD.Energy.EU, (byte)6));
    }

    public int getSourceTier() {
        return UT.Code.tierMax(this.getEnergySizeOutputRecommended(TD.Energy.EU, (byte)6));
    }

    public boolean acceptsEnergyFrom(TileEntity aEmitter, ForgeDirection aDirection) {
        return !(aEmitter instanceof ITileEntityEnergy) && this.isEnergyAcceptingFrom(TD.Energy.EU, UT.Code.side(aDirection), true);
    }

    public boolean emitsEnergyTo(TileEntity aReceiver, ForgeDirection aDirection) {
        return !(aReceiver instanceof ITileEntityEnergy) && this.isEnergyEmittingTo(TD.Energy.EU, UT.Code.side(aDirection), true);
    }

    public double getDemandedEnergy() {
        long tSize = this.getEnergySizeInputMax(TD.Energy.EU, (byte)6);
        return tSize * this.doEnergyInjection(TD.Energy.EU, (byte)6, tSize, 256L, false);
    }

    public double injectEnergy(ForgeDirection aDirection, double aAmount, double aSize) {
        return aAmount - ((aSize = Math.min(aSize, aAmount)) <= 0.0 ? aAmount * (double)this.doEnergyInjection(TD.Energy.EU, UT.Code.side(aDirection), (long)aAmount, 1L, true) : aSize * (double)this.doEnergyInjection(TD.Energy.EU, UT.Code.side(aDirection), (long)aSize, (long)(aAmount / aSize), true));
    }

    public boolean doDefaultStructuralChecks() {
        for (TagData tEnergyType : this.getEnergyTypes((byte)6)) {
            if (TD.Energy.ALL_WEAK_TO_FIRE.contains(tEnergyType)) {
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    if (this.isFireProof(tSide) || !(this.getBlockAtSide(tSide) instanceof BlockFire) || this.rng(10) != 0) continue;
                    if (CS.FIRE_EXPLOSIONS) {
                        this.explode(TD.Energy.ALL_EXPLODING.contains(tEnergyType) ? 4.0 : 0.1);
                    } else if (CS.FIRE_BREAKING) {
                        this.explode(0.1);
                    }
                    byte by = this.mExplodeSpamCooldown;
                    this.mExplodeSpamCooldown = (byte)(by + 1);
                    if (by == 0) {
                        UT.Sounds.send(TD.Energy.ALL_ELECTRIC.contains(tEnergyType) ? "random.explode" : (TD.Energy.ALL_KINETIC.contains(tEnergyType) ? "random.break" : "random.explode"), this, false);
                        CS.DEB.println("Machine came into contact with Fire - Energy Type: " + tEnergyType.getLocalisedNameLong());
                    }
                    return false;
                }
            }
            if (TD.Energy.ALL_WEAK_TO_WATER.contains(tEnergyType)) {
                for (byte tSide : CS.ALL_SIDES_BUT_BOTTOM) {
                    if (!this.isWaterProof(tSide) && WD.liquid(this.getBlockAtSide(tSide))) {
                        if (CS.WATER_EXPLOSIONS) {
                            this.explode(TD.Energy.ALL_EXPLODING.contains(tEnergyType) ? 4.0 : 0.1);
                        } else if (CS.WATER_BREAKING) {
                            this.explode(0.1);
                        }
                        byte by = this.mExplodeSpamCooldown;
                        this.mExplodeSpamCooldown = (byte)(by + 1);
                        if (by == 0) {
                            UT.Sounds.send(TD.Energy.ALL_ELECTRIC.contains(tEnergyType) ? "random.explode" : (TD.Energy.ALL_KINETIC.contains(tEnergyType) ? "random.break" : "random.explode"), this, false);
                            CS.DEB.println("Machine came into contact with Water - Energy Type: " + tEnergyType.getLocalisedNameLong());
                        }
                        return false;
                    }
                    if (this.isRainProof(tSide) || !this.worldObj.isRaining() || !(this.getBiome().rainfall > 0.0f) || this.rng(100) != 0 || !this.getRainAtSide(tSide)) continue;
                    if (CS.RAIN_EXPLOSIONS) {
                        this.explode(TD.Energy.ALL_EXPLODING.contains(tEnergyType) ? 4.0 : 0.1);
                    } else if (CS.RAIN_BREAKING) {
                        this.explode(0.1);
                    }
                    byte by = this.mExplodeSpamCooldown;
                    this.mExplodeSpamCooldown = (byte)(by + 1);
                    if (by == 0) {
                        UT.Sounds.send(TD.Energy.ALL_ELECTRIC.contains(tEnergyType) ? "random.explode" : (TD.Energy.ALL_KINETIC.contains(tEnergyType) ? "random.break" : "random.explode"), this, false);
                        CS.DEB.println("Machine came into contact with Rain - Energy Type: " + tEnergyType.getLocalisedNameLong());
                    }
                    return false;
                }
            }
            if (!TD.Energy.ALL_WEAK_TO_THUNDER.contains(tEnergyType)) continue;
            for (byte tSide : CS.ALL_SIDES_BUT_BOTTOM) {
                if (this.isThunderProof(tSide) || !this.worldObj.isThundering() || this.rng(1000) != 0 || !this.getRainAtSide(tSide)) continue;
                if (CS.THUNDER_EXPLOSIONS) {
                    this.explode(TD.Energy.ALL_EXPLODING.contains(tEnergyType) ? 4.0 : 0.1);
                } else if (CS.THUNDER_BREAKING) {
                    this.explode(0.1);
                }
                byte by = this.mExplodeSpamCooldown;
                this.mExplodeSpamCooldown = (byte)(by + 1);
                if (by == 0) {
                    UT.Sounds.send(TD.Energy.ALL_ELECTRIC.contains(tEnergyType) ? "random.explode" : (TD.Energy.ALL_KINETIC.contains(tEnergyType) ? "random.break" : "random.explode"), this, false);
                    CS.DEB.println("Machine came into contact with Thunder - Energy Type: " + tEnergyType.getLocalisedNameLong());
                }
                return false;
            }
        }
        return true;
    }

    public boolean isFireProof(byte aSide) {
        return false;
    }

    public boolean isRainProof(byte aSide) {
        return false;
    }

    public boolean isWaterProof(byte aSide) {
        return false;
    }

    public boolean isThunderProof(byte aSide) {
        return false;
    }

    public float getSurfaceSize(byte aSide) {
        return 1.0f;
    }

    public float getSurfaceSizeAttachable(byte aSide) {
        return this.getSurfaceSize(aSide);
    }

    public float getSurfaceDistance(byte aSide) {
        return 0.0f;
    }

    public boolean isSurfaceSolid(byte aSide) {
        return this.isSurfaceOpaque(aSide);
    }

    public boolean isSurfaceOpaque(byte aSide) {
        return true;
    }

    public boolean isSealable(byte aSide) {
        return false;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.box();
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        if (this.FORCE_FULL_SELECTION_BOXES) {
            return this.box();
        }
        return this.box(this.shrunkBox());
    }

    public void setBlockBoundsBasedOnState(Block aBlock) {
        if (this.FORCE_FULL_SELECTION_BOXES) {
            this.box(aBlock);
        } else {
            this.box(aBlock, this.shrunkBox());
        }
    }

    public boolean ignorePlayerCollisionWhenPlacing(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return this.ignorePlayerCollisionWhenPlacing();
    }

    public boolean ignorePlayerCollisionWhenPlacing() {
        return false;
    }

    public void onCoordinateChange(World aWorld, int aOldX, int aOldY, int aOldZ) {
        this.onCoordinateChange();
    }

    public void onCoordinateChange() {
    }

    public boolean prepareToMove() {
        return true;
    }

    public void doneMoving() {
        this.onCoordinateChange();
    }

    public int getFireSpreadSpeed(byte aSide, boolean aDefault) {
        return aDefault ? 150 : 0;
    }

    public int getFlammability(byte aSide, boolean aDefault) {
        return aDefault ? 150 : 0;
    }

    public void setOnFire() {
        WD.burn(this.worldObj, this.getCoords(), false, false);
    }

    public boolean setToFire() {
        return this.worldObj.setBlock(this.xCoord, this.yCoord, this.zCoord, (Block)Blocks.fire, 0, 3);
    }

    public boolean removedByPlayer(World aWorld, EntityPlayer aPlayer, boolean aWillHarvest) {
        return this.setToAir();
    }

    public boolean hasSnow() {
        for (int i : CS.SCAN_NEG_1) {
            for (int j : CS.SCAN_NEG_1) {
                if (this.getBlockOffset(i, 0, j) != Blocks.snow_layer) continue;
                return true;
            }
        }
        return false;
    }

    public boolean setToSnow() {
        return this.getOpacity(this.xCoord, this.yCoord - 1, this.zCoord) && this.hasSnow() && this.worldObj.setBlock(this.xCoord, this.yCoord, this.zCoord, Blocks.snow_layer, 0, 3);
    }

    public boolean setToAir() {
        if (this.worldObj.setBlock(this.xCoord, this.yCoord, this.zCoord, Blocks.air, 0, 3)) {
            if (this instanceof IMultiTileEntity.IMTE_CanPlaceSnowLayerOnRemoval) {
                this.setToSnow();
            }
            return true;
        }
        return false;
    }

    public ItemStack slot(int aIndex, ItemStack aStack) {
        return CS.NI;
    }

    public ItemStack slot(int aIndex) {
        return CS.NI;
    }

    public ItemStack slotTake(int aIndex) {
        return CS.NI;
    }

    public boolean slotTrash(int aIndex) {
        return CS.GarbageGT.trash(this.slotTake(aIndex)) > 0;
    }

    public boolean slotNull(int aIndex) {
        if (this.slotHas(aIndex) && this.slot((int)aIndex).stackSize < 0) {
            return this.slotKill(aIndex);
        }
        return false;
    }

    public boolean slotKill(int aIndex) {
        this.slot(aIndex, CS.NI);
        return true;
    }

    public boolean slotHas(int aIndex) {
        return false;
    }

    public boolean invempty() {
        return true;
    }

    public int invsize() {
        return 0;
    }

    public NBTTagCompound slotNBT(int aIndex) {
        return null;
    }

    public int[] getAccessibleSlotsOfConnectedInventory() {
        return UT.Code.getAscendingArray(this.invsize());
    }

    public int addStackToConnectedInventory(byte aSide, ItemStack aStack, boolean aOnlyAddIfItAlreadyHasItemsOfThatTypeOrIsDedicated) {
        if (ST.invalid(aStack)) {
            return 0;
        }
        int rCount = 0;
        int aCount = aStack.stackSize;
        for (int tSlot : this.getAccessibleSlotsOfConnectedInventory()) {
            if (!ST.equal(this.slot(tSlot), aStack)) continue;
            aOnlyAddIfItAlreadyHasItemsOfThatTypeOrIsDedicated = false;
            int tChange = Math.min(aCount, this.slot(tSlot).getMaxStackSize() - this.slot((int)tSlot).stackSize);
            this.slot((int)tSlot).stackSize += tChange;
            rCount += tChange;
            if ((aCount -= tChange) > 0) continue;
            this.updateInventory();
            return rCount;
        }
        if (!aOnlyAddIfItAlreadyHasItemsOfThatTypeOrIsDedicated) {
            for (int tSlot : this.getAccessibleSlotsOfConnectedInventory()) {
                if (this.slotHas(tSlot)) continue;
                this.slot(tSlot, ST.amount(aCount, aStack));
                rCount += aCount;
                aCount = 0;
                this.updateInventory();
                return rCount;
            }
        }
        if (rCount > 0) {
            this.updateInventory();
        }
        return rCount;
    }

    public int removeStackFromConnectedInventory(byte aSide, ItemStack aStack, boolean aOnlyRemoveIfItCanRemoveAllAtOnce) {
        if (ST.invalid(aStack)) {
            return 0;
        }
        int rCount = 0;
        if (!aOnlyRemoveIfItCanRemoveAllAtOnce || this.getAmountOfItemsInConnectedInventory(aSide, aStack, aStack.stackSize) >= (long)aStack.stackSize) {
            for (int tSlot : this.getAccessibleSlotsOfConnectedInventory()) {
                if (!ST.equal(this.slot(tSlot), aStack)) continue;
                int tChange = Math.min(aStack.stackSize - rCount, this.slot((int)tSlot).stackSize);
                this.slot((int)tSlot).stackSize -= tChange;
                if (this.slot((int)tSlot).stackSize <= 0) {
                    this.slotKill(tSlot);
                }
                if ((rCount += tChange) < aStack.stackSize) continue;
                this.updateInventory();
                return rCount;
            }
        }
        if (rCount > 0) {
            this.updateInventory();
        }
        return rCount;
    }

    public long getAmountOfItemsInConnectedInventory(byte aSide, ItemStack aStack, long aStopCountingAtThisNumber) {
        int tSlot;
        if (ST.invalid(aStack)) {
            return 0L;
        }
        long rCount = 0L;
        int[] nArray = this.getAccessibleSlotsOfConnectedInventory();
        int n = nArray.length;
        for (int i = 0; !(i >= n || ST.equal(this.slot(tSlot = nArray[i]), aStack) && (rCount += (long)this.slot((int)tSlot).stackSize) >= aStopCountingAtThisNumber); ++i) {
        }
        return rCount;
    }

    public int funnelFill(byte aSide, FluidStack aFluid, boolean aDoFill) {
        return 0;
    }

    public int capnozzleFill(byte aSide, FluidStack aFluid, boolean aDoFill) {
        return this.funnelFill(aSide, aFluid, aDoFill);
    }

    public FluidStack tapDrain(byte aSide, int aMaxDrain, boolean aDoDrain) {
        return null;
    }

    public FluidStack nozzleDrain(byte aSide, int aMaxDrain, boolean aDoDrain) {
        return this.tapDrain(aSide, aMaxDrain, aDoDrain);
    }

    @Override
    public boolean allowInteraction(Entity aEntity) {
        return true;
    }

    public boolean allowRightclick(Entity aEntity) {
        return this.allowInteraction(aEntity);
    }

    public float getPlayerRelativeBlockHardness(EntityPlayer aPlayer, float aOriginal) {
        return this.allowInteraction((Entity)aPlayer) ? Math.max(aOriginal, 1.0E-4f) : 0.0f;
    }

    public boolean hasMultiBlockMachineRelevantData() {
        return false;
    }

    public AxisAlignedBB box(double aMinX, double aMinY, double aMinZ, double aMaxX, double aMaxY, double aMaxZ) {
        return AxisAlignedBB.getBoundingBox((double)((double)this.xCoord + aMinX), (double)((double)this.yCoord + aMinY), (double)((double)this.zCoord + aMinZ), (double)((double)this.xCoord + aMaxX), (double)((double)this.yCoord + aMaxY), (double)((double)this.zCoord + aMaxZ));
    }

    public AxisAlignedBB box(double[] aBox) {
        return AxisAlignedBB.getBoundingBox((double)((double)this.xCoord + aBox[0]), (double)((double)this.yCoord + aBox[1]), (double)((double)this.zCoord + aBox[2]), (double)((double)this.xCoord + aBox[3]), (double)((double)this.yCoord + aBox[4]), (double)((double)this.zCoord + aBox[5]));
    }

    public AxisAlignedBB box(float[] aBox) {
        return AxisAlignedBB.getBoundingBox((double)((float)this.xCoord + aBox[0]), (double)((float)this.yCoord + aBox[1]), (double)((float)this.zCoord + aBox[2]), (double)((float)this.xCoord + aBox[3]), (double)((float)this.yCoord + aBox[4]), (double)((float)this.zCoord + aBox[5]));
    }

    public AxisAlignedBB box() {
        return AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)(this.xCoord + 1), (double)(this.yCoord + 1), (double)(this.zCoord + 1));
    }

    public boolean box(AxisAlignedBB aAABB, List<AxisAlignedBB> aList, double aMinX, double aMinY, double aMinZ, double aMaxX, double aMaxY, double aMaxZ) {
        AxisAlignedBB tBox = this.box(aMinX, aMinY, aMinZ, aMaxX, aMaxY, aMaxZ);
        return tBox.intersectsWith(aAABB) && aList.add(tBox);
    }

    public boolean box(AxisAlignedBB aAABB, List<AxisAlignedBB> aList, double[] aBox) {
        AxisAlignedBB tBox = this.box(aBox[0], aBox[1], aBox[2], aBox[3], aBox[4], aBox[5]);
        return tBox.intersectsWith(aAABB) && aList.add(tBox);
    }

    public boolean box(AxisAlignedBB aAABB, List<AxisAlignedBB> aList, float[] aBox) {
        AxisAlignedBB tBox = this.box(aBox[0], aBox[1], aBox[2], aBox[3], aBox[4], aBox[5]);
        return tBox.intersectsWith(aAABB) && aList.add(tBox);
    }

    public boolean box(AxisAlignedBB aAABB, List<AxisAlignedBB> aList) {
        AxisAlignedBB tBox = this.box(CS.PX_BOX);
        return tBox.intersectsWith(aAABB) && aList.add(tBox);
    }

    public boolean box(AxisAlignedBB aBox, AxisAlignedBB aAABB, List<AxisAlignedBB> aList) {
        return aBox != null && aBox.intersectsWith(aAABB) && aList.add(aBox);
    }

    public boolean box(Block aBlock) {
        aBlock.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return true;
    }

    public boolean box(Block aBlock, double[] aBox) {
        aBlock.setBlockBounds((float)aBox[0], (float)aBox[1], (float)aBox[2], (float)aBox[3], (float)aBox[4], (float)aBox[5]);
        return true;
    }

    public boolean box(Block aBlock, float[] aBox) {
        aBlock.setBlockBounds(aBox[0], aBox[1], aBox[2], aBox[3], aBox[4], aBox[5]);
        return true;
    }

    public boolean box(Block aBlock, double aMinX, double aMinY, double aMinZ, double aMaxX, double aMaxY, double aMaxZ) {
        aBlock.setBlockBounds((float)aMinX, (float)aMinY, (float)aMinZ, (float)aMaxX, (float)aMaxY, (float)aMaxZ);
        return true;
    }

    public float[] shrunkBox() {
        return CS.PX_BOX;
    }

    public boolean isUsingWrenchingOverlay(ItemStack aStack, byte aSide) {
        return false;
    }

    public boolean isConnectedWrenchingOverlay(ItemStack aStack, byte aSide) {
        return false;
    }

    public boolean onDrawBlockHighlight2(DrawBlockHighlightEvent aEvent) {
        return false;
    }

    public final boolean onDrawBlockHighlight(DrawBlockHighlightEvent aEvent) {
        this.FORCE_FULL_SELECTION_BOXES = false;
        if (!CS.SIDES_VALID[aEvent.target.sideHit] || this.onDrawBlockHighlight2(aEvent)) {
            return true;
        }
        if (ST.valid(aEvent.currentItem) && this.isUsingWrenchingOverlay(aEvent.currentItem, (byte)aEvent.target.sideHit)) {
            this.FORCE_FULL_SELECTION_BOXES = true;
            byte tConnections = 0;
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                if (!this.isConnectedWrenchingOverlay(aEvent.currentItem, i)) continue;
                tConnections = (byte)(tConnections | 1 << i);
            }
            RenderHelper.drawWrenchOverlay(aEvent.player, aEvent.target.blockX, aEvent.target.blockY, aEvent.target.blockZ, tConnections, (byte)aEvent.target.sideHit, aEvent.partialTicks);
            return true;
        }
        return true;
    }

    @Override
    public void setError(String aError) {
        this.ERROR_MESSAGE = aError;
        if (this.isServerSide()) {
            CS.NW_API.sendToAllPlayersInRange(new PacketBlockError(this.getCoords(), this.ERROR_MESSAGE), this.worldObj, this.getCoords());
        }
    }
}

