/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes.maps;

import gregapi.data.RM;
import gregapi.data.TD;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.recipes.maps.RecipeMapNonGTRecipes;
import gregapi.tileentity.base.TileEntityBase01Root;
import gregapi.util.OM;
import gregapi.util.ST;
import java.util.Collection;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeMapMicrowave
extends RecipeMapNonGTRecipes {
    public RecipeMapMicrowave(Collection<Recipe> aRecipeList, String aUnlocalizedName, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aMinimalInputs, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed, boolean aNeedsOutputs, boolean aCombinePower, boolean aUseBucketSizeIn, boolean aUseBucketSizeOut) {
        super(aRecipeList, aUnlocalizedName, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, aMinimalInputs, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed, aConfigAllowed, aNeedsOutputs, aCombinePower, aUseBucketSizeIn, aUseBucketSizeOut);
    }

    @Override
    public Recipe findRecipe(IHasWorldAndCoords aTileEntity, Recipe aRecipe, boolean aNotUnificated, long aSize, ItemStack aSpecialSlot, FluidStack[] aFluids, ItemStack ... aInputs) {
        if (aInputs == null || aInputs.length <= 0 || aInputs[0] == null) {
            return null;
        }
        if (aRecipe != null && aRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) {
            return aRecipe;
        }
        ItemStack tOutput = RM.get_smelting(aInputs[0]);
        if (ST.equal(aInputs[0], Items.book)) {
            return new Recipe(false, false, true, ST.array(ST.amount(1L, aInputs[0])), ST.array(ST.book("Manual_Microwave")), null, null, null, null, 32L, 4L, 0L);
        }
        for (ItemStack tStack : ST.array(ST.container(aInputs[0], true), aInputs[0], ST.container(tOutput, true), tOutput)) {
            if (!ST.valid(tStack)) continue;
            if (ST.equal(tStack, Blocks.netherrack) || ST.equal(tStack, Blocks.tnt) || ST.equal(tStack, Items.egg) || ST.equal(tStack, Items.firework_charge) || ST.equal(tStack, Items.fireworks) || ST.equal(tStack, Items.fire_charge)) {
                if (aTileEntity instanceof TileEntityBase01Root) {
                    ((TileEntityBase01Root)aTileEntity).overcharge(aSize * 4L, TD.Energy.EU);
                }
                return null;
            }
            OreDictItemData tData = OM.anydata_(tStack);
            if (tData != null) {
                if (tData.mMaterial != null) {
                    if (tData.mMaterial.mMaterial.containsAny(TD.Atomic.METAL, TD.Properties.EXPLOSIVE)) {
                        if (aTileEntity instanceof TileEntityBase01Root) {
                            ((TileEntityBase01Root)aTileEntity).overcharge(aSize * 4L, TD.Energy.EU);
                        }
                        return null;
                    }
                    if (tData.mMaterial.mMaterial.contains(TD.Properties.FLAMMABLE)) {
                        if (aTileEntity instanceof TileEntityBase01Root) {
                            ((TileEntityBase01Root)aTileEntity).setOnFire();
                        }
                        return null;
                    }
                }
                for (OreDictMaterialStack tMaterial : tData.mByProducts) {
                    if (tMaterial == null) continue;
                    if (tMaterial.mMaterial.containsAny(TD.Atomic.METAL, TD.Properties.EXPLOSIVE)) {
                        if (aTileEntity instanceof TileEntityBase01Root) {
                            ((TileEntityBase01Root)aTileEntity).overcharge(aSize * 4L, TD.Energy.EU);
                        }
                        return null;
                    }
                    if (!tMaterial.mMaterial.contains(TD.Properties.FLAMMABLE)) continue;
                    if (aTileEntity instanceof TileEntityBase01Root) {
                        ((TileEntityBase01Root)aTileEntity).setOnFire();
                    }
                    return null;
                }
            }
            if (ST.fuel(tStack) <= 0L) continue;
            if (aTileEntity instanceof TileEntityBase01Root) {
                ((TileEntityBase01Root)aTileEntity).setOnFire();
            }
            return null;
        }
        return tOutput == null ? null : new Recipe(false, false, true, ST.array(ST.amount(1L, aInputs[0])), ST.array(tOutput), null, null, null, null, 32L, 4L, 0L);
    }

    @Override
    public boolean containsInput(ItemStack aStack, IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
        return RM.get_smelting(aStack) != null;
    }
}

