/*
 * Decompiled with CFR 0.152.
 */
package gregapi.oredict;

import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.oredict.OreDictPrefix;
import gregapi.util.OM;
import gregapi.util.ST;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.item.ItemStack;

public class OreDictItemData {
    public boolean mBlackListed = false;
    public boolean mBlocked = false;
    public boolean mUseVanillaDamage = false;
    public boolean mFurnaceFuel = true;
    public ItemStack mUnificationTarget = null;
    public final OreDictPrefix mPrefix;
    public final OreDictMaterialStack mMaterial;
    public final OreDictMaterialStack[] mByProducts;
    public final String mOreDictName;

    public OreDictItemData(OreDictPrefix aPrefix, OreDictMaterial aMaterial) {
        this.mPrefix = aPrefix;
        this.mMaterial = aMaterial == null ? null : OM.stack(aMaterial, aPrefix.mAmount);
        this.mOreDictName = aMaterial == null ? "" : aPrefix.mNameInternal + aMaterial.mNameInternal;
        this.mByProducts = aPrefix.mByProducts.isEmpty() ? CS.ZL_MS : aPrefix.mByProducts.toArray(CS.ZL_MS);
    }

    public OreDictItemData(OreDictMaterialStack aMaterial, OreDictMaterialStack ... aByProducts) {
        this.mPrefix = null;
        this.mMaterial = aMaterial == null ? null : aMaterial.clone();
        this.mOreDictName = "";
        this.mBlackListed = true;
        if (aByProducts == null) {
            this.mByProducts = CS.ZL_MS;
        } else {
            int i;
            OreDictMaterialStack[] tByProducts = aByProducts.length < 1 ? CS.ZL_MS : new OreDictMaterialStack[aByProducts.length];
            int j = 0;
            for (i = 0; i < aByProducts.length; ++i) {
                if (aByProducts[i] == null) continue;
                tByProducts[j++] = aByProducts[i].clone();
            }
            this.mByProducts = j > 0 ? new OreDictMaterialStack[j] : CS.ZL_MS;
            for (i = 0; i < this.mByProducts.length; ++i) {
                this.mByProducts[i] = tByProducts[i];
            }
        }
    }

    public OreDictItemData(OreDictMaterial aMaterial, OreDictPrefix aAmount, OreDictMaterialStack ... aByProducts) {
        this(OM.stack(aMaterial, aAmount), aByProducts);
    }

    public OreDictItemData(OreDictMaterial aMaterial, long aAmount, OreDictMaterialStack ... aByProducts) {
        this(OM.stack(aMaterial, aAmount), aByProducts);
    }

    public OreDictItemData(OreDictMaterial aMaterial, OreDictPrefix aAmount, OreDictMaterial aByProduct, OreDictPrefix aByProductAmount) {
        this(OM.stack(aMaterial, aAmount), OM.stack(aByProduct, aByProductAmount));
    }

    public OreDictItemData(OreDictMaterial aMaterial, OreDictPrefix aAmount, OreDictMaterial aByProduct, long aByProductAmount) {
        this(OM.stack(aMaterial, aAmount), OM.stack(aByProduct, aByProductAmount));
    }

    public OreDictItemData(OreDictMaterial aMaterial, long aAmount, OreDictMaterial aByProduct, OreDictPrefix aByProductAmount) {
        this(OM.stack(aMaterial, aAmount), OM.stack(aByProduct, aByProductAmount));
    }

    public OreDictItemData(OreDictMaterial aMaterial, long aAmount, OreDictMaterial aByProduct, long aByProductAmount) {
        this(OM.stack(aMaterial, aAmount), OM.stack(aByProduct, aByProductAmount));
    }

    public OreDictItemData(OreDictMaterial aMaterial, long aAmount, OreDictMaterial aByProduct, long aByProductAmount, OreDictMaterial aByProduct2, long aByProductAmount2) {
        this(OM.stack(aMaterial, aAmount), OM.stack(aByProduct, aByProductAmount), OM.stack(aByProduct2, aByProductAmount2));
    }

    public OreDictItemData(Collection<OreDictItemData> aData) {
        this(aData.toArray(CS.ZL_OREDICTITEMDATA));
    }

    public OreDictItemData(OreDictItemData ... aData) {
        this.mPrefix = null;
        this.mOreDictName = "";
        this.mBlackListed = true;
        ArrayListNoNulls<OreDictMaterialStack> aList = new ArrayListNoNulls<OreDictMaterialStack>();
        ArrayListNoNulls<OreDictMaterialStack> rList = new ArrayListNoNulls<OreDictMaterialStack>();
        for (OreDictItemData tData : aData) {
            if (tData == null) continue;
            if (tData.validMaterial() && tData.mMaterial.mAmount > 0L) {
                ((ArrayList)aList).add(OM.stack(tData.mMaterial.mMaterial.mTargetReversing, tData.mMaterial.mAmount));
            }
            for (OreDictMaterialStack tMaterial : tData.mByProducts) {
                if (tMaterial.mAmount <= 0L) continue;
                ((ArrayList)aList).add(OM.stack(tMaterial.mMaterial.mTargetReversing, tMaterial.mAmount));
            }
        }
        for (OreDictMaterialStack aMaterial : aList) {
            boolean temp = true;
            for (OreDictMaterialStack tMaterial : rList) {
                if (aMaterial.mMaterial != tMaterial.mMaterial) continue;
                tMaterial.mAmount += aMaterial.mAmount;
                temp = false;
                break;
            }
            if (!temp) continue;
            ((ArrayList)rList).add(aMaterial.clone());
        }
        Collections.sort(rList, new Comparator<OreDictMaterialStack>(){

            @Override
            public int compare(OreDictMaterialStack a, OreDictMaterialStack b) {
                return a.mAmount == b.mAmount ? 0 : (a.mAmount > b.mAmount ? -1 : 1);
            }
        });
        if (rList.isEmpty()) {
            this.mMaterial = null;
        } else {
            this.mMaterial = (OreDictMaterialStack)rList.get(0);
            rList.remove(0);
        }
        this.mByProducts = rList.toArray(CS.ZL_MS);
    }

    public boolean fullData() {
        return this.validPrefix() && this.fullMaterial();
    }

    public boolean listedData() {
        return this.validPrefix() && this.listedMaterial();
    }

    public boolean nonemptyData() {
        return this.validPrefix() && this.nonemptyMaterial();
    }

    public boolean validData() {
        return this.validPrefix() && this.validMaterial();
    }

    public boolean fullMaterial() {
        return this.nonemptyMaterial() && this.mMaterial.mAmount > 0L;
    }

    public boolean listedMaterial() {
        return this.validMaterial() && this.mMaterial.mMaterial.mID >= 0;
    }

    public boolean nonemptyMaterial() {
        return this.validMaterial() && this.mMaterial.mMaterial.mID > 0;
    }

    public boolean validMaterial() {
        return this.mMaterial != null;
    }

    public boolean validPrefix() {
        return this.mPrefix != null;
    }

    public List<OreDictMaterialStack> getAllMaterialStacks() {
        ArrayListNoNulls<OreDictMaterialStack> rList = new ArrayListNoNulls<OreDictMaterialStack>(this.mByProducts.length + 1);
        if (this.validMaterial()) {
            rList.add(this.mMaterial);
        }
        rList.addAll(Arrays.asList(this.mByProducts));
        return rList;
    }

    public List<OreDictMaterialStack> getAllMaterialWeights() {
        ArrayListNoNulls<OreDictMaterialStack> rList = new ArrayListNoNulls<OreDictMaterialStack>(this.mByProducts.length + 1);
        if (this.validMaterial()) {
            if (this.validPrefix()) {
                rList.add(OM.stack(this.mMaterial.mMaterial, this.mPrefix.mWeight));
            } else {
                rList.add(this.mMaterial);
            }
        }
        rList.addAll(Arrays.asList(this.mByProducts));
        return rList;
    }

    public OreDictMaterialStack getByProduct(int aIndex) {
        return aIndex >= 0 && aIndex < this.mByProducts.length ? this.mByProducts[aIndex] : null;
    }

    public ItemStack getStack(long aAmount) {
        return this.mUnificationTarget == null ? this.mPrefix.mat(this.mMaterial.mMaterial, aAmount) : ST.amount(aAmount, this.mUnificationTarget);
    }

    public OreDictItemData copy() {
        OreDictItemData rData = this.mPrefix == null ? new OreDictItemData(this.mMaterial, this.mByProducts) : new OreDictItemData(this.mPrefix, this.mMaterial.mMaterial);
        rData.mUnificationTarget = this.mUnificationTarget;
        rData.mUseVanillaDamage = this.mUseVanillaDamage;
        rData.mBlackListed = this.mBlackListed;
        rData.mBlocked = this.mBlocked;
        return rData;
    }

    public static OreDictItemData copy(OreDictItemData aData) {
        return aData == null ? null : aData.copy();
    }

    public OreDictItemData setUseVanillaDamage() {
        this.mUseVanillaDamage = true;
        return this;
    }

    public OreDictItemData setNotFurnaceFuel() {
        this.mFurnaceFuel = false;
        return this;
    }

    public String toString() {
        return this.mOreDictName;
    }

    @Deprecated
    public boolean hasValidPrefixMaterialData() {
        return this.mPrefix != null && this.mMaterial != null;
    }

    @Deprecated
    public boolean hasValidPrefixData() {
        return this.mPrefix != null;
    }

    @Deprecated
    public boolean hasValidMaterialData() {
        return this.mMaterial != null;
    }
}

