/*
 * Decompiled with CFR 0.152.
 */
package gregapi.old;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class GT_EnergyArmor_Item
extends ItemArmor {
    public int mCharge;
    public int mTransfer;
    public int mTier;
    public int mDamageEnergyCost;
    public int mSpecials;
    public boolean mChargeProvider;
    public double mArmorAbsorbtionPercentage;

    public GT_EnergyArmor_Item(int aID, String aUnlocalized, String aEnglish, int aCharge, int aTransfer, int aTier, int aDamageEnergyCost, int aSpecials, double aArmorAbsorbtionPercentage, boolean aChargeProvider, int aType, int aArmorIndex) {
        super(ItemArmor.ArmorMaterial.DIAMOND, aArmorIndex, aType);
        this.setMaxStackSize(1);
        this.setMaxDamage(100);
        this.setNoRepair();
        this.setUnlocalizedName(aUnlocalized);
        LH.add(this.getUnlocalizedName(), aEnglish);
        this.mCharge = Math.max(1, aCharge);
        this.mTransfer = Math.max(1, aTransfer);
        this.mTier = Math.max(1, aTier);
        this.mSpecials = aSpecials;
        this.mChargeProvider = aChargeProvider;
        this.mDamageEnergyCost = Math.max(0, aDamageEnergyCost);
        this.mArmorAbsorbtionPercentage = aArmorAbsorbtionPercentage;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public ItemStack onItemRightClick(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        ItemStack tStack = aPlayer.inventory.armorInventory[3 - this.armorType];
        if (tStack != null) {
            for (int i = 0; i < 9; ++i) {
                if (aPlayer.inventory.mainInventory[i] != aStack) continue;
                aPlayer.inventory.armorInventory[3 - this.armorType] = aPlayer.inventory.mainInventory[i];
                aPlayer.inventory.mainInventory[i] = tStack;
                return tStack;
            }
        }
        return super.onItemRightClick(aStack, aWorld, aPlayer);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aIconRegister) {
        this.itemIcon = aIconRegister.registerIcon(CS.RES_PATH_ITEM + this.getUnlocalizedName());
    }

    public void addInformation(ItemStack aStack, EntityPlayer aPlayer, List aList, boolean aF3_H) {
        aList.add("Tier: " + this.mTier);
        if ((this.mSpecials & 1) != 0) {
            aList.add("Rebreather");
        }
        if ((this.mSpecials & 2) != 0) {
            aList.add("Inertia Damper");
        }
        if ((this.mSpecials & 4) != 0) {
            aList.add("Food Replicator");
        }
        if ((this.mSpecials & 8) != 0) {
            aList.add("Medicine Module");
        }
        if ((this.mSpecials & 0x10) != 0) {
            aList.add("Lamp");
        }
        if ((this.mSpecials & 0x20) != 0) {
            aList.add("Solarpanel");
        }
        if ((this.mSpecials & 0x40) != 0) {
            aList.add("Extinguisher Module");
        }
        if ((this.mSpecials & 0x80) != 0) {
            aList.add("Jump Booster");
        }
        if ((this.mSpecials & 0x100) != 0) {
            aList.add("Speed Booster");
        }
        if ((this.mSpecials & 0x200) != 0) {
            aList.add("Invisibility Field");
        }
        if ((this.mSpecials & 0x400) != 0) {
            aList.add("Infinite Charge");
        }
    }

    private static void setCharge(ItemStack aStack) {
        NBTTagCompound tNBT = aStack.getTagCompound();
        if (tNBT == null) {
            tNBT = UT.NBT.make();
        }
        tNBT.setInteger("charge", 1000000000);
        aStack.setTagCompound(tNBT);
    }

    public void onArmorTick(World aWorld, EntityPlayer aPlayer, ItemStack aStack) {
    }

    public boolean getShareTag() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item aItem, CreativeTabs var2, List var3) {
    }

    public boolean canProvideEnergy(ItemStack aStack) {
        if ((this.mSpecials & 0x400) != 0) {
            GT_EnergyArmor_Item.setCharge(aStack);
        }
        return this.mChargeProvider;
    }

    public Item getChargedItem(ItemStack aStack) {
        if ((this.mSpecials & 0x400) != 0) {
            GT_EnergyArmor_Item.setCharge(aStack);
        }
        return this;
    }

    public Item getEmptyItem(ItemStack aStack) {
        if ((this.mSpecials & 0x400) != 0) {
            GT_EnergyArmor_Item.setCharge(aStack);
        }
        return this;
    }

    public int getMaxCharge(ItemStack aStack) {
        if ((this.mSpecials & 0x400) != 0) {
            GT_EnergyArmor_Item.setCharge(aStack);
        }
        return this.mCharge;
    }

    public int getTier(ItemStack aStack) {
        if ((this.mSpecials & 0x400) != 0) {
            GT_EnergyArmor_Item.setCharge(aStack);
        }
        return this.mTier;
    }

    public int getTransferLimit(ItemStack aStack) {
        if ((this.mSpecials & 0x400) != 0) {
            GT_EnergyArmor_Item.setCharge(aStack);
        }
        return this.mTransfer;
    }

    public int getItemEnchantability() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return false;
    }

    public boolean getIsRepairable(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public void onEntityLivingFallEvent(LivingFallEvent var1) {
    }
}

