/*
 * Decompiled with CFR 0.152.
 */
package gregapi.network.packets.data;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import gregapi.block.IBlockSyncData;
import gregapi.network.INetworkHandler;
import gregapi.network.packets.PacketCoordinates;
import net.minecraft.block.Block;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;

public class PacketSyncDataShort
extends PacketCoordinates {
    public short mData = 0;

    public PacketSyncDataShort(int aDecoderType) {
        super(aDecoderType);
    }

    public PacketSyncDataShort(int aX, int aY, int aZ, short aData) {
        super(aX, aY, aZ);
        this.mData = aData;
    }

    public PacketSyncDataShort(ChunkCoordinates aCoords, short aData) {
        super(aCoords);
        this.mData = aData;
    }

    @Override
    public byte getPacketIDOffset() {
        return -120;
    }

    @Override
    public ByteArrayDataOutput encode2(ByteArrayDataOutput aData) {
        aData.writeShort((int)this.mData);
        return aData;
    }

    @Override
    public PacketCoordinates decode2(int aX, int aY, int aZ, ByteArrayDataInput aData) {
        return new PacketSyncDataShort(aX, aY, aZ, aData.readShort());
    }

    @Override
    public void process(IBlockAccess aWorld, INetworkHandler aNetworkHandler) {
        Block tBlock;
        if (aWorld != null && (tBlock = aWorld.getBlock(this.mX, this.mY, this.mZ)) instanceof IBlockSyncData) {
            ((IBlockSyncData)tBlock).receiveDataShort(aWorld, this.mX, this.mY, this.mZ, this.mData, aNetworkHandler);
        }
    }
}

